/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import jnr.constants.Constant;
import jnr.constants.platform.Signal;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubySignalException;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ArraySupport;

@JRubyClass(name={"Interrupt"}, parent="SignalException")
public class RubyInterrupt
extends RubySignalException {
    private static final ObjectAllocator INTERRUPT_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyInterrupt(runtime, klass);
        }
    };

    static RubyClass createInterruptClass(Ruby runtime, RubyClass signalExceptionClass) {
        RubyClass interruptClass = runtime.defineClass("Interrupt", signalExceptionClass, INTERRUPT_ALLOCATOR);
        interruptClass.defineAnnotatedMethods(RubyInterrupt.class);
        return interruptClass;
    }

    protected RubyInterrupt(Ruby runtime, RubyClass exceptionClass) {
        super(runtime, exceptionClass);
    }

    @Override
    @JRubyMethod(optional=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2, Block block) {
        Ruby runtime = context.runtime;
        Arity.checkArgumentCount(runtime, args2, 0, 1);
        RubyFixnum signo2 = runtime.newFixnum((Constant)Signal.SIGINT);
        args2 = args2.length > 0 ? ArraySupport.newCopy(signo2, args2) : new IRubyObject[]{signo2, runtime.newString("Interrupt")};
        super.initialize(args2, block);
        return this;
    }
}

