/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import org.jcodings.Encoding;

public enum KCode {
    NIL(null, "ASCII", 0),
    NONE("NONE", "ASCII", 0),
    UTF8("UTF8", "NonStrictUTF8", 64),
    SJIS("SJIS", "NonStrictSJIS", 48),
    EUC("EUC", "NonStrictEUCJP", 32);

    private final String kcode;
    private final String encodingName;
    private final int code;
    private volatile Encoding encoding;

    private KCode(String kcode, String encodingName, int code) {
        this.kcode = kcode;
        this.encodingName = encodingName;
        this.code = code;
    }

    public static KCode create(String lang) {
        if (lang == null) {
            return NIL;
        }
        if (lang.length() == 0) {
            return NONE;
        }
        switch (lang.charAt(0)) {
            case 'E': 
            case 'e': {
                return EUC;
            }
            case 'S': 
            case 's': {
                return SJIS;
            }
            case 'U': 
            case 'u': {
                return UTF8;
            }
            case 'A': 
            case 'N': 
            case 'a': 
            case 'n': {
                return NONE;
            }
        }
        return NIL;
    }

    public String getKCode() {
        return this.kcode;
    }

    public int bits() {
        return this.code;
    }

    public static KCode fromBits(int bits) {
        if ((bits & 0x40) != 0) {
            return UTF8;
        }
        if ((bits & 0x30) == 48) {
            return SJIS;
        }
        if ((bits & 0x20) != 0) {
            return EUC;
        }
        return NONE;
    }

    public Encoding getEncoding() {
        if (this.encoding == null) {
            this.encoding = Encoding.load((String)this.encodingName);
        }
        return this.encoding;
    }

    public String toString() {
        return this.name();
    }
}

