/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ripper;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyString;
import org.jruby.ext.ripper.HeredocTerm;
import org.jruby.ext.ripper.RipperParserBase;
import org.jruby.ext.ripper.StrTerm;
import org.jruby.ext.ripper.StringTerm;
import org.jruby.lexer.LexerSource;
import org.jruby.lexer.LexingCommon;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.SafeDoubleParser;
import org.jruby.util.StringSupport;
import org.jruby.util.cli.Options;

public class RipperLexer
extends LexingCommon {
    private static final HashMap<String, Keyword> map = new HashMap();
    public boolean ignoreNextScanEvent = false;
    String identValue;
    private RipperParserBase parser = null;
    private StrTerm lex_strterm;
    static final int STR_FUNC_INDENT = 32;
    protected ByteList delayed = null;
    private int delayed_line = 0;
    private int delayed_col = 0;
    private ByteList numberBuffer = new ByteList(10);

    @Override
    protected void ambiguousOperator(String op, String syn) {
        this.warn("`" + op + "' after local variable or literal is interpreted as binary operator");
        this.warn("even though it seems like " + syn);
    }

    private int getFloatToken(String number, int suffix) {
        if ((suffix & 1) != 0) {
            BigDecimal bd = new BigDecimal(number);
            BigDecimal denominator2 = BigDecimal.ONE.scaleByPowerOfTen(bd.scale());
            BigDecimal numerator2 = bd.multiply(denominator2);
            try {
                numerator2.longValueExact();
                denominator2.longValueExact();
            }
            catch (ArithmeticException ae) {
                this.compile_error("Rational (" + numerator2 + "/" + denominator2 + ") out of range.");
            }
            return this.considerComplex(382, suffix);
        }
        try {
            double d = SafeDoubleParser.parseDouble(number);
        }
        catch (NumberFormatException e) {
            this.warn("Float " + number + " out of range.");
            double d = number.startsWith("-") ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        return this.considerComplex(381, suffix);
    }

    private int considerComplex(int token, int suffix) {
        if ((suffix & 2) == 0) {
            return token;
        }
        return 380;
    }

    public boolean isVerbose() {
        return this.parser.getRuntime().isVerbose();
    }

    public void warn(String message2) {
        this.parser.dispatch("warn", this.getRuntime().newString(message2));
    }

    public void warning(String fmt) {
        this.parser.dispatch("warning", this.getRuntime().newString(fmt));
    }

    public void warning(String fmt, String arg2) {
        this.parser.dispatch("warning", this.getRuntime().newString(fmt), this.getRuntime().newString(arg2));
    }

    public static Keyword getKeyword(String str) {
        return map.get(str);
    }

    public RipperLexer(RipperParserBase parser, LexerSource src) {
        super(src);
        this.parser = parser;
        this.setState(0);
        this.lex_strterm = null;
        this.setCurrentEncoding(src.getEncoding());
        this.reset();
    }

    public boolean hasStarted() {
        return this.src != null;
    }

    protected void flush_string_content(Encoding encoding2) {
        if (this.delayed != null) {
            int len = this.lex_p - this.tokp;
            if (len > 0) {
                this.delayed.setEncoding(encoding2);
                this.delayed.append(this.lexb.makeShared(this.tokp, len));
            }
            this.dispatchDelayedToken(378);
            this.tokp = this.lex_p;
        }
    }

    @Override
    public int nextc() {
        if (this.lex_p == this.lex_pend) {
            this.line_offset += this.lex_pend;
            ByteList v = this.lex_nextline;
            this.lex_nextline = null;
            if (v == null) {
                if (this.eofp) {
                    return -1;
                }
                if (this.src == null || (v = this.src.gets()) == null) {
                    this.eofp = true;
                    this.lex_goto_eol();
                    return -1;
                }
            }
            if (this.tokp < this.lex_pend) {
                if (this.delayed == null) {
                    this.delayed = new ByteList();
                    this.delayed.setEncoding(this.getEncoding());
                    this.delayed.append(this.lexb, this.tokp, this.lex_pend - this.tokp);
                    this.delayed_line = this.ruby_sourceline;
                    this.delayed_col = this.tokp - this.lex_pbeg;
                } else {
                    this.delayed.append(this.lexb, this.tokp, this.lex_pend - this.tokp);
                }
            }
            if (this.heredoc_end > 0) {
                this.ruby_sourceline = this.heredoc_end;
                this.heredoc_end = 0;
            }
            ++this.ruby_sourceline;
            ++this.line_count;
            this.lex_p = 0;
            this.lex_pbeg = 0;
            this.lex_pend = this.lex_p + v.length();
            this.lexb = v;
            this.flush();
            this.lex_lastline = v;
        }
        int c = this.p(this.lex_p);
        ++this.lex_p;
        if (c == 13) {
            if (this.peek(10)) {
                ++this.lex_p;
                c = 10;
            } else if (this.ruby_sourceline > this.last_cr_line) {
                this.last_cr_line = this.ruby_sourceline;
                this.warn("encountered \\\\r in middle of line, treated as a mere space");
                c = 32;
            }
        }
        return c;
    }

    public void dispatchHeredocEnd() {
        if (this.delayed != null) {
            this.dispatchDelayedToken(378);
        }
        this.lex_goto_eol();
        this.dispatchIgnoredScanEvent(391);
    }

    @Override
    public void compile_error(String message2) {
        this.parser.error();
        this.parser.dispatch("compile_error", this.getRuntime().newString(message2));
    }

    @Override
    public int tokenize_ident(int result2) {
        String value2 = this.createTokenString();
        if (!RipperLexer.isLexState(this.last_state, 384) && this.parser.getCurrentScope().isDefined(value2) >= 0) {
            this.setState(1026);
        }
        this.identValue = value2.intern();
        return result2;
    }

    public void heredoc_restore(HeredocTerm here) {
        ByteList line;
        this.lex_lastline = line = here.lastLine;
        this.lex_pbeg = 0;
        this.lex_pend = this.lex_pbeg + line.length();
        this.lex_p = this.lex_pbeg + here.nth;
        this.lexb = line;
        this.heredoc_end = this.ruby_sourceline;
        this.ruby_sourceline = here.line;
        this.flush();
    }

    public int nextToken() throws IOException {
        this.token = this.yylex();
        if (this.delayed != null) {
            this.dispatchDelayedToken(this.token);
            return this.token == -1 ? 0 : this.token;
        }
        if (this.token != -1) {
            this.dispatchScanEvent(this.token);
        }
        return this.token == -1 ? 0 : this.token;
    }

    public String getIdent() {
        return this.identValue;
    }

    public Ruby getRuntime() {
        return this.parser.context.getRuntime();
    }

    public void setParser(RipperParserBase parserSupport) {
        this.parser = parserSupport;
    }

    @Override
    protected void setCompileOptionFlag(String name2, ByteList value2) {
        if (this.tokenSeen) {
            this.warning("`%s' is ignored after any tokens", name2);
            return;
        }
    }

    @Override
    protected void setTokenInfo(String name2, ByteList value2) {
    }

    @Override
    protected void setEncoding(ByteList name2) {
        Encoding newEncoding = this.parser.getRuntime().getEncodingService().loadEncoding(name2);
        if (newEncoding == null) {
            this.compile_error("unknown encoding name: " + name2.toString());
            return;
        }
        if (!newEncoding.isAsciiCompatible()) {
            this.compile_error(name2.toString() + " is not ASCII compatible");
            return;
        }
        this.setEncoding(newEncoding);
    }

    public StrTerm getStrTerm() {
        return this.lex_strterm;
    }

    public void setStrTerm(StrTerm strterm) {
        this.lex_strterm = strterm;
    }

    public IRubyObject createStr(ByteList buffer, int flags2) {
        Encoding bufferEncoding = buffer.getEncoding();
        int codeRange = StringSupport.codeRangeScan(bufferEncoding, buffer);
        if ((flags2 & 4) == 0 && bufferEncoding.isAsciiCompatible() && codeRange != 16 && this.getEncoding() == USASCII_ENCODING && bufferEncoding != UTF8_ENCODING) {
            codeRange = RipperParserBase.associateEncoding(buffer, ASCII8BIT_ENCODING, codeRange);
        }
        return this.getRuntime().newString(buffer);
    }

    private int parseQuote(int c) throws IOException {
        int end2;
        int begin2;
        String value2 = "%" + (char)c;
        if (!Character.isLetterOrDigit(c)) {
            begin2 = c;
            c = 81;
        } else {
            begin2 = this.nextc();
            value2 = value2 + (char)begin2;
            if (Character.isLetterOrDigit(begin2) || !this.isASCII()) {
                this.compile_error("unknown type of %string");
                return -1;
            }
        }
        if (c == -1 || begin2 == -1) {
            this.compile_error("unterminated quoted string meets end of file");
            return -1;
        }
        switch (begin2) {
            case 40: {
                end2 = 41;
                break;
            }
            case 91: {
                end2 = 93;
                break;
            }
            case 123: {
                end2 = 125;
                break;
            }
            case 60: {
                end2 = 62;
                break;
            }
            default: {
                end2 = begin2;
                begin2 = 0;
            }
        }
        int w = this.nextc();
        while (Character.isWhitespace(w)) {
            value2 = value2 + (char)w;
            w = this.nextc();
        }
        this.pushback(w);
        switch (c) {
            case 81: {
                this.lex_strterm = new StringTerm(2, begin2, end2);
                return 366;
            }
            case 113: {
                this.lex_strterm = new StringTerm(0, begin2, end2);
                return 366;
            }
            case 87: {
                this.lex_strterm = new StringTerm(10, begin2, end2);
                while (Character.isWhitespace(c = this.nextc())) {
                }
                this.pushback(c);
                return 369;
            }
            case 119: {
                this.lex_strterm = new StringTerm(8, begin2, end2);
                while (Character.isWhitespace(c = this.nextc())) {
                }
                this.pushback(c);
                return 370;
            }
            case 120: {
                this.lex_strterm = new StringTerm(2, begin2, end2);
                return 367;
            }
            case 114: {
                this.lex_strterm = new StringTerm(7, begin2, end2);
                return 368;
            }
            case 115: {
                this.lex_strterm = new StringTerm(16, begin2, end2);
                this.setState(4224);
                return 365;
            }
            case 73: {
                this.lex_strterm = new StringTerm(10, begin2, end2);
                while (Character.isWhitespace(c = this.nextc())) {
                }
                this.pushback(c);
                return 392;
            }
            case 105: {
                this.lex_strterm = new StringTerm(8, begin2, end2);
                while (Character.isWhitespace(c = this.nextc())) {
                }
                this.pushback(c);
                return 393;
            }
        }
        this.compile_error("Unknown type of %string. Expected 'Q', 'q', 'w', 'x', 'r' or any non letter character, but found '" + c + "'.");
        return -1;
    }

    private int hereDocumentIdentifier() throws IOException {
        int term;
        ByteList markerValue;
        int c = this.nextc();
        int func = 0;
        if (c == 45) {
            c = this.nextc();
            func = 32;
        } else if (c == 126) {
            c = this.nextc();
            func = 32;
            this.heredoc_indent = Integer.MAX_VALUE;
            this.heredoc_line_indent = 0;
        }
        if (c == 39 || c == 34 || c == 96) {
            func = c == 39 ? (func |= 0) : (c == 34 ? (func |= 2) : (func |= 2));
            markerValue = new ByteList();
            markerValue.setEncoding(this.getEncoding());
            term = c;
            while ((c = this.nextc()) != -1 && c != term) {
                if (this.tokenAddMBC(c, markerValue)) continue;
                return -1;
            }
            if (c == -1) {
                this.compile_error("unterminated here document identifier");
            }
        } else {
            if (!this.isIdentifierChar(c)) {
                this.pushback(c);
                if ((func & 0x20) != 0) {
                    this.pushback(this.heredoc_indent > 0 ? 126 : 45);
                }
                return 0;
            }
            markerValue = new ByteList();
            markerValue.setEncoding(this.getEncoding());
            term = 34;
            func |= 2;
            do {
                if (this.tokenAddMBC(c, markerValue)) continue;
                return -1;
            } while ((c = this.nextc()) != -1 && this.isIdentifierChar(c));
            this.pushback(c);
        }
        this.dispatchScanEvent(390);
        int len = this.lex_p - this.lex_pbeg;
        this.lex_goto_eol();
        this.lex_strterm = new HeredocTerm(markerValue, func, len, this.ruby_sourceline, this.lex_lastline);
        this.flush();
        return term == 96 ? 367 : 366;
    }

    private boolean arg_ambiguous() {
        this.parser.dispatch("on_arg_ambiguous");
        return true;
    }

    private void printToken(int token) {
        switch (token) {
            case 256: {
                System.err.print("yyErrorCode,");
                break;
            }
            case 257: {
                System.err.print("kClass,");
                break;
            }
            case 258: {
                System.err.print("kModule,");
                break;
            }
            case 259: {
                System.err.print("kDEF,");
                break;
            }
            case 260: {
                System.err.print("kUNDEF,");
                break;
            }
            case 261: {
                System.err.print("kBEGIN,");
                break;
            }
            case 262: {
                System.err.print("kRESCUE,");
                break;
            }
            case 263: {
                System.err.print("kENSURE,");
                break;
            }
            case 264: {
                System.err.print("kEND,");
                break;
            }
            case 265: {
                System.err.print("kIF,");
                break;
            }
            case 266: {
                System.err.print("kUNLESS,");
                break;
            }
            case 267: {
                System.err.print("kTHEN,");
                break;
            }
            case 268: {
                System.err.print("kELSIF,");
                break;
            }
            case 269: {
                System.err.print("kELSE,");
                break;
            }
            case 270: {
                System.err.print("kCASE,");
                break;
            }
            case 271: {
                System.err.print("kWHEN,");
                break;
            }
            case 272: {
                System.err.print("kWHILE,");
                break;
            }
            case 273: {
                System.err.print("kUNTIL,");
                break;
            }
            case 274: {
                System.err.print("kFOR,");
                break;
            }
            case 275: {
                System.err.print("kBREAK,");
                break;
            }
            case 276: {
                System.err.print("kNEXT,");
                break;
            }
            case 277: {
                System.err.print("kREDO,");
                break;
            }
            case 278: {
                System.err.print("kRETRY,");
                break;
            }
            case 279: {
                System.err.print("kIN,");
                break;
            }
            case 280: {
                System.err.print("kDO,");
                break;
            }
            case 281: {
                System.err.print("kDO_COND,");
                break;
            }
            case 282: {
                System.err.print("kDO_BLOCK,");
                break;
            }
            case 283: {
                System.err.print("kRETURN,");
                break;
            }
            case 284: {
                System.err.print("kYIELD,");
                break;
            }
            case 285: {
                System.err.print("kSUPER,");
                break;
            }
            case 286: {
                System.err.print("kSELF,");
                break;
            }
            case 287: {
                System.err.print("kNIL,");
                break;
            }
            case 288: {
                System.err.print("kTRUE,");
                break;
            }
            case 289: {
                System.err.print("kFALSE,");
                break;
            }
            case 290: {
                System.err.print("kAND,");
                break;
            }
            case 291: {
                System.err.print("kOR,");
                break;
            }
            case 292: {
                System.err.print("kNOT,");
                break;
            }
            case 293: {
                System.err.print("kIF_MOD,");
                break;
            }
            case 294: {
                System.err.print("kUNLESS_MOD,");
                break;
            }
            case 295: {
                System.err.print("kWHILE_MOD,");
                break;
            }
            case 296: {
                System.err.print("kUNTIL_MOD,");
                break;
            }
            case 297: {
                System.err.print("kRESCUE_MOD,");
                break;
            }
            case 298: {
                System.err.print("kALIAS,");
                break;
            }
            case 299: {
                System.err.print("kDEFINED,");
                break;
            }
            case 300: {
                System.err.print("klBEGIN,");
                break;
            }
            case 301: {
                System.err.print("klEND,");
                break;
            }
            case 302: {
                System.err.print("k__LINE__,");
                break;
            }
            case 303: {
                System.err.print("k__FILE__,");
                break;
            }
            case 304: {
                System.err.print("k__ENCODING__,");
                break;
            }
            case 305: {
                System.err.print("kDO_LAMBDA,");
                break;
            }
            case 306: {
                System.err.print("tIDENTIFIER[" + this.value() + "],");
                break;
            }
            case 307: {
                System.err.print("tFID[" + this.value() + "],");
                break;
            }
            case 308: {
                System.err.print("tGVAR[" + this.value() + "],");
                break;
            }
            case 309: {
                System.err.print("tIVAR[" + this.value() + "],");
                break;
            }
            case 310: {
                System.err.print("tCONSTANT[" + this.value() + "],");
                break;
            }
            case 311: {
                System.err.print("tCVAR,");
                break;
            }
            case 379: {
                System.err.print("tINTEGER,");
                break;
            }
            case 381: {
                System.err.print("tFLOAT,");
                break;
            }
            case 378: {
                System.err.print("tSTRING_CONTENT[" + this.value() + "],");
                break;
            }
            case 366: {
                System.err.print("tSTRING_BEG,");
                break;
            }
            case 373: {
                System.err.print("tSTRING_END,");
                break;
            }
            case 371: {
                System.err.print("tSTRING_DBEG,");
                break;
            }
            case 372: {
                System.err.print("tSTRING_DVAR,");
                break;
            }
            case 367: {
                System.err.print("tXSTRING_BEG,");
                break;
            }
            case 368: {
                System.err.print("tREGEXP_BEG,");
                break;
            }
            case 383: {
                System.err.print("tREGEXP_END,");
                break;
            }
            case 369: {
                System.err.print("tWORDS_BEG,");
                break;
            }
            case 370: {
                System.err.print("tQWORDS_BEG,");
                break;
            }
            case 377: {
                System.err.print("tBACK_REF,");
                break;
            }
            case 364: {
                System.err.print("tBACK_REF2,");
                break;
            }
            case 376: {
                System.err.print("tNTH_REF,");
                break;
            }
            case 314: {
                System.err.print("tUPLUS");
                break;
            }
            case 315: {
                System.err.print("tUMINUS,");
                break;
            }
            case 317: {
                System.err.print("tPOW,");
                break;
            }
            case 318: {
                System.err.print("tCMP,");
                break;
            }
            case 319: {
                System.err.print("tEQ,");
                break;
            }
            case 320: {
                System.err.print("tEQQ,");
                break;
            }
            case 321: {
                System.err.print("tNEQ,");
                break;
            }
            case 322: {
                System.err.print("tGEQ,");
                break;
            }
            case 323: {
                System.err.print("tLEQ,");
                break;
            }
            case 324: {
                System.err.print("tANDOP,");
                break;
            }
            case 325: {
                System.err.print("tOROP,");
                break;
            }
            case 326: {
                System.err.print("tMATCH,");
                break;
            }
            case 327: {
                System.err.print("tNMATCH,");
                break;
            }
            case 328: {
                System.err.print("tDOT,");
                break;
            }
            case 329: {
                System.err.print("tDOT2,");
                break;
            }
            case 330: {
                System.err.print("tDOT3,");
                break;
            }
            case 331: {
                System.err.print("tAREF,");
                break;
            }
            case 332: {
                System.err.print("tASET,");
                break;
            }
            case 333: {
                System.err.print("tLSHFT,");
                break;
            }
            case 334: {
                System.err.print("tRSHFT,");
                break;
            }
            case 336: {
                System.err.print("tCOLON2,");
                break;
            }
            case 337: {
                System.err.print("tCOLON3,");
                break;
            }
            case 338: {
                System.err.print("tOP_ASGN,");
                break;
            }
            case 339: {
                System.err.print("tASSOC,");
                break;
            }
            case 340: {
                System.err.print("tLPAREN,");
                break;
            }
            case 341: {
                System.err.print("tLPAREN2,");
                break;
            }
            case 343: {
                System.err.print("tLPAREN_ARG,");
                break;
            }
            case 344: {
                System.err.print("tLBRACK,");
                break;
            }
            case 345: {
                System.err.print("tRBRACK,");
                break;
            }
            case 346: {
                System.err.print("tLBRACE,");
                break;
            }
            case 347: {
                System.err.print("tLBRACE_ARG,");
                break;
            }
            case 348: {
                System.err.print("tSTAR,");
                break;
            }
            case 349: {
                System.err.print("tSTAR2,");
                break;
            }
            case 350: {
                System.err.print("tAMPER,");
                break;
            }
            case 351: {
                System.err.print("tAMPER2,");
                break;
            }
            case 365: {
                System.err.print("tSYMBEG,");
                break;
            }
            case 352: {
                System.err.print("tTILDE,");
                break;
            }
            case 353: {
                System.err.print("tPERCENT,");
                break;
            }
            case 354: {
                System.err.print("tDIVIDE,");
                break;
            }
            case 355: {
                System.err.print("tPLUS,");
                break;
            }
            case 356: {
                System.err.print("tMINUS,");
                break;
            }
            case 357: {
                System.err.print("tLT,");
                break;
            }
            case 358: {
                System.err.print("tGT,");
                break;
            }
            case 361: {
                System.err.print("tCARET,");
                break;
            }
            case 360: {
                System.err.print("tBANG,");
                break;
            }
            case 362: {
                System.err.print("tTLCURLY,");
                break;
            }
            case 363: {
                System.err.print("tRCURLY,");
                break;
            }
            case 359: {
                System.err.print("tTPIPE,");
                break;
            }
            case 374: {
                System.err.print("tLAMBDA,");
                break;
            }
            case 375: {
                System.err.print("tLAMBEG,");
                break;
            }
            case 342: {
                System.err.print("tRPAREN,");
                break;
            }
            case 312: {
                System.err.print("tLABEL(" + this.value() + ":),");
                break;
            }
            case 396: {
                System.err.print("tLABEL_END");
                break;
            }
            case 10: {
                System.err.println("NL");
                break;
            }
            case -1: {
                System.out.println("EOF");
                break;
            }
            case 394: {
                System.err.print("tDSTAR");
                break;
            }
            case 395: {
                System.err.print("tDSTRING_DEND,");
                break;
            }
            default: {
                System.err.print("'" + (char)token + "'[" + token + "]");
            }
        }
    }

    public boolean hasScanEvent() {
        if (this.lex_p < this.tokp) {
            throw this.parser.getRuntime().newRuntimeError("lex_p < tokp");
        }
        return this.lex_p > this.tokp;
    }

    public void dispatchDelayedToken(int token) {
        int saved_line = this.ruby_sourceline;
        int saved_tokp = this.tokp;
        this.ruby_sourceline = this.delayed_line;
        this.tokp = this.lex_pbeg + this.delayed_col;
        RubyString value2 = this.parser.getRuntime().newString(this.delayed.dup());
        String event2 = this.tokenToEventId(token);
        this.yaccValue = this.parser.dispatch(event2, value2);
        this.delayed = null;
        this.ruby_sourceline = saved_line;
        this.tokp = saved_tokp;
    }

    public void dispatchIgnoredScanEvent(int token) {
        if (!this.hasScanEvent()) {
            return;
        }
        this.scanEventValue(token);
    }

    public void dispatchScanEvent(int token) {
        if (!this.hasScanEvent()) {
            return;
        }
        this.yaccValue = this.scanEventValue(token);
    }

    private IRubyObject scanEventValue(int token) {
        RubyString value2 = this.parser.getRuntime().newString(this.lexb.makeShared(this.tokp, this.lex_p - this.tokp));
        String event2 = this.tokenToEventId(token);
        IRubyObject returnValue = this.parser.dispatch(event2, value2);
        this.flush();
        return returnValue;
    }

    private String tokenToEventId(int token) {
        switch (token) {
            case 32: {
                return "on_words_sep";
            }
            case 360: {
                return "on_op";
            }
            case 353: {
                return "on_op";
            }
            case 335: {
                return "on_op";
            }
            case 351: {
                return "on_op";
            }
            case 349: {
                return "on_op";
            }
            case 355: {
                return "on_op";
            }
            case 356: {
                return "on_op";
            }
            case 354: {
                return "on_op";
            }
            case 357: {
                return "on_op";
            }
            case 61: {
                return "on_op";
            }
            case 358: {
                return "on_op";
            }
            case 63: {
                return "on_op";
            }
            case 361: {
                return "on_op";
            }
            case 359: {
                return "on_op";
            }
            case 352: {
                return "on_op";
            }
            case 58: {
                return "on_op";
            }
            case 44: {
                return "on_comma";
            }
            case 46: {
                return "on_period";
            }
            case 328: {
                return "on_period";
            }
            case 59: {
                return "on_semicolon";
            }
            case 364: {
                return "on_backtick";
            }
            case 10: {
                return "on_nl";
            }
            case 298: {
                return "on_kw";
            }
            case 290: {
                return "on_kw";
            }
            case 261: {
                return "on_kw";
            }
            case 275: {
                return "on_kw";
            }
            case 270: {
                return "on_kw";
            }
            case 257: {
                return "on_kw";
            }
            case 259: {
                return "on_kw";
            }
            case 299: {
                return "on_kw";
            }
            case 280: {
                return "on_kw";
            }
            case 282: {
                return "on_kw";
            }
            case 281: {
                return "on_kw";
            }
            case 269: {
                return "on_kw";
            }
            case 268: {
                return "on_kw";
            }
            case 264: {
                return "on_kw";
            }
            case 263: {
                return "on_kw";
            }
            case 289: {
                return "on_kw";
            }
            case 274: {
                return "on_kw";
            }
            case 265: {
                return "on_kw";
            }
            case 293: {
                return "on_kw";
            }
            case 279: {
                return "on_kw";
            }
            case 258: {
                return "on_kw";
            }
            case 276: {
                return "on_kw";
            }
            case 287: {
                return "on_kw";
            }
            case 292: {
                return "on_kw";
            }
            case 291: {
                return "on_kw";
            }
            case 277: {
                return "on_kw";
            }
            case 262: {
                return "on_kw";
            }
            case 297: {
                return "on_kw";
            }
            case 278: {
                return "on_kw";
            }
            case 283: {
                return "on_kw";
            }
            case 286: {
                return "on_kw";
            }
            case 285: {
                return "on_kw";
            }
            case 267: {
                return "on_kw";
            }
            case 288: {
                return "on_kw";
            }
            case 260: {
                return "on_kw";
            }
            case 266: {
                return "on_kw";
            }
            case 294: {
                return "on_kw";
            }
            case 273: {
                return "on_kw";
            }
            case 296: {
                return "on_kw";
            }
            case 271: {
                return "on_kw";
            }
            case 272: {
                return "on_kw";
            }
            case 295: {
                return "on_kw";
            }
            case 284: {
                return "on_kw";
            }
            case 303: {
                return "on_kw";
            }
            case 302: {
                return "on_kw";
            }
            case 304: {
                return "on_kw";
            }
            case 300: {
                return "on_kw";
            }
            case 301: {
                return "on_kw";
            }
            case 305: {
                return "on_kw";
            }
            case 350: {
                return "on_op";
            }
            case 324: {
                return "on_op";
            }
            case 331: {
                return "on_op";
            }
            case 332: {
                return "on_op";
            }
            case 339: {
                return "on_op";
            }
            case 377: {
                return "on_backref";
            }
            case 313: {
                return "on_CHAR";
            }
            case 318: {
                return "on_op";
            }
            case 336: {
                return "on_op";
            }
            case 337: {
                return "on_op";
            }
            case 310: {
                return "on_const";
            }
            case 311: {
                return "on_cvar";
            }
            case 329: {
                return "on_op";
            }
            case 330: {
                return "on_op";
            }
            case 319: {
                return "on_op";
            }
            case 320: {
                return "on_op";
            }
            case 307: {
                return "on_ident";
            }
            case 381: {
                return "on_float";
            }
            case 322: {
                return "on_op";
            }
            case 308: {
                return "on_gvar";
            }
            case 306: {
                return "on_ident";
            }
            case 380: {
                return "on_imaginary";
            }
            case 379: {
                return "on_int";
            }
            case 309: {
                return "on_ivar";
            }
            case 346: {
                return "on_lbrace";
            }
            case 347: {
                return "on_lbrace";
            }
            case 362: {
                return "on_lbrace";
            }
            case 363: {
                return "on_rbrace";
            }
            case 344: {
                return "on_lbracket";
            }
            case 91: {
                return "on_lbracket";
            }
            case 345: {
                return "on_rbracket";
            }
            case 323: {
                return "on_op";
            }
            case 340: {
                return "on_lparen";
            }
            case 343: {
                return "on_lparen";
            }
            case 341: {
                return "on_lparen";
            }
            case 41: {
                return "on_rparen";
            }
            case 333: {
                return "on_op";
            }
            case 326: {
                return "on_op";
            }
            case 321: {
                return "on_op";
            }
            case 327: {
                return "on_op";
            }
            case 376: {
                return "on_backref";
            }
            case 338: {
                return "on_op";
            }
            case 325: {
                return "on_op";
            }
            case 317: {
                return "on_op";
            }
            case 393: {
                return "on_qsymbols_beg";
            }
            case 382: {
                return "on_rational";
            }
            case 392: {
                return "on_symbols_beg";
            }
            case 370: {
                return "on_qwords_beg";
            }
            case 368: {
                return "on_regexp_beg";
            }
            case 383: {
                return "on_regexp_end";
            }
            case 342: {
                return "on_rparen";
            }
            case 334: {
                return "on_op";
            }
            case 348: {
                return "on_op";
            }
            case 394: {
                return "on_op";
            }
            case 366: {
                return "on_tstring_beg";
            }
            case 378: {
                return "on_tstring_content";
            }
            case 371: {
                return "on_embexpr_beg";
            }
            case 395: {
                return "on_embexpr_end";
            }
            case 372: {
                return "on_embvar";
            }
            case 373: {
                return "on_tstring_end";
            }
            case 365: {
                return "on_symbeg";
            }
            case 315: {
                return "on_op";
            }
            case 316: {
                return "on_op";
            }
            case 314: {
                return "on_op";
            }
            case 369: {
                return "on_words_beg";
            }
            case 367: {
                return "on_backtick";
            }
            case 312: {
                return "on_label";
            }
            case 396: {
                return "on_label_end";
            }
            case 374: {
                return "on_tlambda";
            }
            case 375: {
                return "on_tlambeg";
            }
            case 384: {
                return "on_ignored_nl";
            }
            case 385: {
                return "on_comment";
            }
            case 386: {
                return "on_embdoc_beg";
            }
            case 387: {
                return "on_embdoc";
            }
            case 388: {
                return "on_embdoc_end";
            }
            case 389: {
                return "on_sp";
            }
            case 390: {
                return "on_heredoc_beg";
            }
            case 391: {
                return "on_heredoc_end";
            }
            case 398: {
                return "on___end__";
            }
        }
        return "on_CHAR";
    }

    private int yylex2() throws IOException {
        try {
            int currentToken = this.yylex2();
            this.printToken(currentToken);
            return currentToken;
        }
        catch (Exception e) {
            System.out.println("FFUFUFUFUFUFUFUF: " + e);
            return -1;
        }
    }

    private int yylex() throws IOException {
        int c;
        boolean spaceSeen = false;
        boolean tokenSeen = this.tokenSeen;
        if (this.lex_strterm != null) {
            int tok = this.lex_strterm.parseString(this, this.src);
            if (tok == 373 && (this.lex_strterm.getFlags() & 0x40) != 0 && (RipperLexer.isLexState(this.lex_state, 9) && !this.conditionState.isInState() || this.isARG()) && this.isLabelSuffix()) {
                this.nextc();
                tok = 396;
                this.setState(1025);
                this.lex_strterm = null;
            }
            if (tok == 373 || tok == 383) {
                this.lex_strterm = null;
                this.setState(2);
            }
            return tok;
        }
        boolean commandState = this.commandStart;
        this.commandStart = false;
        this.tokenSeen = true;
        block46: while (true) {
            boolean fallthru = false;
            this.last_state = this.lex_state;
            c = this.nextc();
            switch (c) {
                case -1: 
                case 0: 
                case 4: 
                case 26: {
                    return -1;
                }
                case 9: 
                case 11: 
                case 12: 
                case 13: 
                case 32: {
                    ByteList whitespaceBuf = new ByteList();
                    whitespaceBuf.append(c);
                    boolean looping = true;
                    spaceSeen = true;
                    block47: while (looping && (c = this.nextc()) != -1) {
                        switch (c) {
                            case 9: 
                            case 11: 
                            case 12: 
                            case 13: 
                            case 32: {
                                whitespaceBuf.append(c);
                                continue block47;
                            }
                        }
                        looping = false;
                    }
                    this.pushback(c);
                    this.dispatchScanEvent(389);
                    continue block46;
                }
                case 35: {
                    this.tokenSeen = tokenSeen;
                    if (!this.parser_magic_comment(this.lexb.makeShared(this.lex_p, this.lex_pend - this.lex_p)) && this.comment_at_top()) {
                        this.set_file_encoding(this.lex_p, this.lex_pend);
                    }
                    this.lex_p = this.lex_pend;
                    this.dispatchScanEvent(385);
                    fallthru = true;
                }
                case 10: {
                    boolean normalArg;
                    this.tokenSeen = tokenSeen;
                    boolean bl = normalArg = RipperLexer.isLexState(this.lex_state, 897) && !RipperLexer.isLexState(this.lex_state, 2048);
                    if (normalArg || this.isLexStateAll(this.lex_state, 2064)) {
                        if (!fallthru) {
                            this.dispatchScanEvent(384);
                        }
                        if (normalArg || !this.inKwarg) continue block46;
                        this.commandStart = true;
                        this.setState(1);
                        return 10;
                    }
                    boolean done = false;
                    block48: while (!done) {
                        c = this.nextc();
                        switch (c) {
                            case 9: 
                            case 11: 
                            case 12: 
                            case 13: 
                            case 32: {
                                spaceSeen = true;
                                continue block48;
                            }
                            case 38: 
                            case 46: {
                                this.dispatchDelayedToken(384);
                                if (this.peek(46) == (c == 38)) {
                                    this.pushback(c);
                                    this.dispatchScanEvent(389);
                                    continue block46;
                                }
                            }
                            default: {
                                --this.ruby_sourceline;
                                this.lex_nextline = this.lex_lastline;
                            }
                            case -1: 
                        }
                        this.lex_goto_eol();
                        if (c != -1) {
                            this.tokp = this.lex_p;
                        }
                        done = true;
                    }
                    this.commandStart = true;
                    this.setState(1);
                    return 10;
                }
                case 42: {
                    return this.star(spaceSeen);
                }
                case 33: {
                    return this.bang();
                }
                case 61: {
                    if (this.was_bol() && this.strncmp(this.lexb.makeShared(this.lex_p, this.lex_pend - this.lex_p), BEGIN_DOC_MARKER, BEGIN_DOC_MARKER.length()) && Character.isWhitespace(this.p(this.lex_p + 5))) {
                        boolean first_p = true;
                        this.lex_goto_eol();
                        this.dispatchScanEvent(386);
                        do {
                            this.lex_goto_eol();
                            if (!first_p) {
                                this.dispatchScanEvent(387);
                            }
                            first_p = false;
                            c = this.nextc();
                            if (c != -1) continue;
                            this.compile_error("embedded document meets end of file");
                            return -1;
                        } while (c != 61 || !this.strncmp(this.lexb.makeShared(this.lex_p, this.lex_pend - this.lex_p), END_DOC_MARKER, END_DOC_MARKER.length()) || this.lex_p + 3 != this.lex_pend && !Character.isWhitespace(this.p(this.lex_p + 3)));
                        this.lex_goto_eol();
                        this.dispatchScanEvent(388);
                        continue block46;
                    }
                    this.setState(this.isAfterOperator() ? 16 : 1);
                    c = this.nextc();
                    if (c == 61) {
                        c = this.nextc();
                        if (c == 61) {
                            return 320;
                        }
                        this.pushback(c);
                        return 319;
                    }
                    if (c == 126) {
                        return 326;
                    }
                    if (c == 62) {
                        return 339;
                    }
                    this.pushback(c);
                    return 61;
                }
                case 60: {
                    return this.lessThan(spaceSeen);
                }
                case 62: {
                    return this.greaterThan();
                }
                case 34: {
                    return this.doubleQuote(commandState);
                }
                case 96: {
                    return this.backtick(commandState);
                }
                case 39: {
                    return this.singleQuote(commandState);
                }
                case 63: {
                    return this.questionMark();
                }
                case 38: {
                    return this.ampersand(spaceSeen);
                }
                case 124: {
                    return this.pipe();
                }
                case 43: {
                    return this.plus(spaceSeen);
                }
                case 45: {
                    return this.minus(spaceSeen);
                }
                case 46: {
                    return this.dot();
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    return this.parseNumber(c);
                }
                case 41: {
                    return this.rightParen();
                }
                case 93: {
                    return this.rightBracket();
                }
                case 125: {
                    return this.rightCurly();
                }
                case 58: {
                    return this.colon(spaceSeen);
                }
                case 47: {
                    return this.slash(spaceSeen);
                }
                case 94: {
                    return this.caret();
                }
                case 59: {
                    this.commandStart = true;
                    this.setState(1);
                    return 59;
                }
                case 44: {
                    return this.comma(c);
                }
                case 126: {
                    return this.tilde();
                }
                case 40: {
                    return this.leftParen(spaceSeen);
                }
                case 91: {
                    return this.leftBracket(spaceSeen);
                }
                case 123: {
                    return this.leftCurly();
                }
                case 92: {
                    c = this.nextc();
                    if (c == 10) {
                        spaceSeen = true;
                        continue block46;
                    }
                    this.pushback(c);
                    return 92;
                }
                case 37: {
                    return this.percent(spaceSeen);
                }
                case 36: {
                    return this.dollar();
                }
                case 64: {
                    return this.at();
                }
                case 95: {
                    if (this.was_bol() && this.whole_match_p(END_MARKER, false)) {
                        this.__end__seen = true;
                        this.eofp = true;
                        this.lex_goto_eol();
                        this.dispatchScanEvent(398);
                        return -1;
                    }
                    return this.identifier(c, commandState);
                }
            }
            break;
        }
        return this.identifier(c, commandState);
    }

    private int identifierToken(int last_state, int result2, String value2) {
        if (result2 == 306 && !RipperLexer.isLexState(last_state, 256) && this.parser.getCurrentScope().isDefined(value2) >= 0) {
            this.setState(2);
        }
        this.identValue = value2.intern();
        return result2;
    }

    private int ampersand(boolean spaceSeen) throws IOException {
        int c = this.nextc();
        switch (c) {
            case 38: {
                this.setState(1);
                c = this.nextc();
                if (c == 61) {
                    this.setState(1);
                    return 338;
                }
                this.pushback(c);
                return 324;
            }
            case 61: {
                this.setState(1);
                return 338;
            }
            case 46: {
                this.setState(256);
                return 335;
            }
        }
        this.pushback(c);
        if (this.isSpaceArg(c, spaceSeen)) {
            if (this.isVerbose()) {
                this.warning("`&' interpreted as argument prefix");
            }
            c = 350;
        } else {
            c = this.isBEG() ? 350 : 351;
        }
        this.setState(this.isAfterOperator() ? 16 : 1);
        return c;
    }

    private int at() throws IOException {
        int result2;
        this.newtok(true);
        int c = this.nextc();
        if (c == 64) {
            c = this.nextc();
            result2 = 311;
        } else {
            result2 = 309;
        }
        if (c == -1 || Character.isSpaceChar(c)) {
            if (result2 == 309) {
                this.compile_error("`@' without identifiers is not allowed as an instance variable name");
            }
            this.compile_error("`@@' without identifiers is not allowed as a class variable name");
        } else if (Character.isDigit(c) || !this.isIdentifierChar(c)) {
            this.pushback(c);
            if (result2 == 309) {
                this.compile_error("`@" + (char)c + "' is not allowed as an instance variable name");
            }
            this.compile_error("`@@" + (char)c + "' is not allowed as a class variable name");
        }
        if (!this.tokadd_ident(c)) {
            return -1;
        }
        this.last_state = this.lex_state;
        this.setState(2);
        return this.tokenize_ident(result2);
    }

    private int backtick(boolean commandState) throws IOException {
        if (RipperLexer.isLexState(this.lex_state, 128)) {
            this.setState(8);
            return 364;
        }
        if (RipperLexer.isLexState(this.lex_state, 256)) {
            this.setState(commandState ? 32 : 16);
            return 364;
        }
        this.lex_strterm = new StringTerm(2, 0, 96);
        return 367;
    }

    private int bang() throws IOException {
        int c = this.nextc();
        if (this.isAfterOperator()) {
            this.setState(16);
            if (c == 64) {
                return 360;
            }
        } else {
            this.setState(1);
        }
        switch (c) {
            case 61: {
                return 321;
            }
            case 126: {
                return 327;
            }
        }
        this.pushback(c);
        return 360;
    }

    private int caret() throws IOException {
        int c = this.nextc();
        if (c == 61) {
            this.setState(1);
            return 338;
        }
        this.setState(this.isAfterOperator() ? 16 : 1);
        this.pushback(c);
        return 361;
    }

    private int colon(boolean spaceSeen) throws IOException {
        int c = this.nextc();
        if (c == 58) {
            if (this.isBEG() || RipperLexer.isLexState(this.lex_state, 512) || this.isARG() && spaceSeen) {
                this.setState(1);
                return 337;
            }
            this.setState(256);
            return 336;
        }
        if (this.isEND() || Character.isWhitespace(c) || c == 35) {
            this.pushback(c);
            this.setState(1);
            return 58;
        }
        switch (c) {
            case 39: {
                this.lex_strterm = new StringTerm(16, 0, c);
                break;
            }
            case 34: {
                this.lex_strterm = new StringTerm(18, 0, c);
                break;
            }
            default: {
                this.pushback(c);
            }
        }
        this.setState(128);
        return 365;
    }

    private int comma(int c) throws IOException {
        this.setState(1025);
        return c;
    }

    private int doKeyword(int state2) {
        int leftParenBegin = this.getLeftParenBegin();
        if (leftParenBegin > 0 && leftParenBegin == this.parenNest) {
            this.setLeftParenBegin(0);
            --this.parenNest;
            return 305;
        }
        if (this.conditionState.isInState()) {
            return 281;
        }
        if (this.cmdArgumentState.isInState() && !RipperLexer.isLexState(state2, 32)) {
            return 282;
        }
        if (RipperLexer.isLexState(state2, 5)) {
            return 282;
        }
        return 280;
    }

    private int dollar() throws IOException {
        this.setState(2);
        this.newtok(true);
        int c = this.nextc();
        switch (c) {
            case 95: {
                c = this.nextc();
                if (this.isIdentifierChar(c)) {
                    if (this.tokadd_ident(c)) {
                        return -1;
                    }
                    this.last_state = this.lex_state;
                    this.setState(2);
                    this.identValue = this.createTokenString().intern();
                    return 308;
                }
                this.pushback(c);
                c = 95;
            }
            case 33: 
            case 34: 
            case 36: 
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 92: 
            case 126: {
                this.identValue = "$" + (char)c;
                return 308;
            }
            case 45: {
                c = this.nextc();
                if (this.isIdentifierChar(c)) {
                    if (!this.tokadd_mbchar(c)) {
                        return -1;
                    }
                } else {
                    this.pushback(c);
                    this.pushback(45);
                    return 36;
                }
                this.identValue = this.createTokenString().intern();
                return 308;
            }
            case 38: 
            case 39: 
            case 43: 
            case 96: {
                if (this.last_state == 128) {
                    this.identValue = "$" + (char)c;
                    return 308;
                }
                this.identValue = "$" + (char)c;
                return 377;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                while (Character.isDigit(c = this.nextc())) {
                }
                this.pushback(c);
                if (this.last_state == 128) {
                    this.identValue = this.createTokenString().intern();
                    return 308;
                }
                String refAsString = this.createTokenString();
                try {
                    Integer.parseInt(refAsString.substring(1).intern());
                }
                catch (NumberFormatException e) {
                    this.warn("`" + refAsString + "' is too big for a number variable, always nil");
                }
                this.identValue = this.createTokenString().intern();
                return 376;
            }
            case 48: {
                this.setState(2);
                return this.identifierToken(this.last_state, 308, ("$" + (char)c).intern());
            }
        }
        if (!this.isIdentifierChar(c)) {
            if (c == -1 || Character.isSpaceChar(c)) {
                this.compile_error("`$' without identifiers is not allowed as a global variable name");
            } else {
                this.pushback(c);
                this.compile_error("`$" + (char)c + "' is not allowed as a global variable name");
            }
            return -1;
        }
        this.last_state = this.lex_state;
        this.setState(2);
        this.tokadd_ident(c);
        return this.identifierToken(this.last_state, 308, this.createTokenString().intern());
    }

    private int dot() throws IOException {
        this.setState(1);
        int c = this.nextc();
        if (c == 46) {
            c = this.nextc();
            if (c == 46) {
                return 330;
            }
            this.pushback(c);
            return 329;
        }
        this.pushback(c);
        if (Character.isDigit(c)) {
            this.compile_error("no .<digit> floating literal anymore; put 0 before dot");
        }
        this.setState(256);
        return 328;
    }

    private int doubleQuote(boolean commandState) throws IOException {
        int label2 = this.isLabelPossible(commandState) ? 64 : 0;
        this.lex_strterm = new StringTerm(2 | label2, 0, 34);
        return 366;
    }

    private int greaterThan() throws IOException {
        this.setState(this.isAfterOperator() ? 16 : 1);
        int c = this.nextc();
        switch (c) {
            case 61: {
                return 322;
            }
            case 62: {
                c = this.nextc();
                if (c == 61) {
                    this.setState(1);
                    return 338;
                }
                this.pushback(c);
                return 334;
            }
        }
        this.pushback(c);
        return 358;
    }

    private int identifier(int c, boolean commandState) throws IOException {
        Keyword keyword;
        String tempVal;
        if (!this.isIdentifierChar(c)) {
            String badChar = "\\" + Integer.toOctalString(c & 0xFF);
            this.compile_error("Invalid char `" + badChar + "' ('" + (char)c + "') in expression");
        }
        int whereKeywordShouldStart = this.lex_p - 1;
        do {
            if (this.tokadd_mbchar(c)) continue;
            return -1;
        } while (this.isIdentifierChar(c = this.nextc()));
        boolean lastBangOrPredicate = false;
        if (c == 33 || c == 63) {
            if (!this.peek(61)) {
                lastBangOrPredicate = true;
            } else {
                this.pushback(c);
            }
        } else {
            this.pushback(c);
        }
        int result2 = 0;
        this.last_state = this.lex_state;
        if (lastBangOrPredicate) {
            result2 = 307;
            tempVal = this.createTokenString();
        } else {
            if (RipperLexer.isLexState(this.lex_state, 128)) {
                c = this.nextc();
                if (c == 61) {
                    int c2 = this.nextc();
                    if (c2 != 126 && c2 != 62 && (c2 != 61 || this.peek(62))) {
                        result2 = 306;
                        this.pushback(c2);
                    } else {
                        this.pushback(c2);
                        this.pushback(c);
                    }
                } else {
                    this.pushback(c);
                }
            }
            tempVal = this.createTokenString();
            result2 = result2 == 0 && Character.isUpperCase(tempVal.charAt(0)) ? 310 : 306;
        }
        if (this.isLabelPossible(commandState) && this.isLabelSuffix()) {
            this.setState(2064);
            this.nextc();
            this.identValue = tempVal.intern();
            return 312;
        }
        if (this.lex_state != 256 && (keyword = RipperLexer.getKeyword(this.createTokenString(whereKeywordShouldStart))) != null) {
            int state2 = this.lex_state;
            this.setState(keyword.state);
            if (RipperLexer.isLexState(state2, 128)) {
                this.identValue = tempVal;
                return keyword.id0;
            }
            if (RipperLexer.isLexState(this.lex_state, 1)) {
                this.commandStart = true;
            }
            if (keyword.id0 == 280) {
                return this.doKeyword(state2);
            }
            if (RipperLexer.isLexState(state2, 2049)) {
                return keyword.id0;
            }
            if (keyword.id0 != keyword.id1) {
                this.setState(1025);
            }
            return keyword.id1;
        }
        if (RipperLexer.isLexState(this.lex_state, 881)) {
            this.setState(commandState ? 32 : 16);
        } else if (this.lex_state == 128) {
            this.setState(8);
        } else {
            this.setState(2);
        }
        return this.identifierToken(this.last_state, result2, tempVal.intern());
    }

    private int leftBracket(boolean spaceSeen) throws IOException {
        ++this.parenNest;
        int c = 91;
        if (this.isAfterOperator()) {
            this.setState(16);
            c = this.nextc();
            if (c == 93) {
                if (this.peek(61)) {
                    this.nextc();
                    return 332;
                }
                return 331;
            }
            this.pushback(c);
            this.setState(this.getState() | 0x400);
            return 91;
        }
        if (this.isBEG() || this.isARG() && (spaceSeen || RipperLexer.isLexState(this.lex_state, 2048))) {
            c = 344;
        }
        this.setState(1025);
        this.conditionState.stop();
        this.cmdArgumentState.stop();
        this.yaccValue = "[";
        return c;
    }

    private int leftCurly() {
        ++this.braceNest;
        int leftParenBegin = this.getLeftParenBegin();
        if (leftParenBegin > 0 && leftParenBegin == this.parenNest) {
            this.setState(1);
            this.setLeftParenBegin(0);
            --this.parenNest;
            this.conditionState.stop();
            this.cmdArgumentState.stop();
            return 375;
        }
        int c = RipperLexer.isLexState(this.lex_state, 2048) ? 346 : (RipperLexer.isLexState(this.lex_state, 58) ? 362 : (RipperLexer.isLexState(this.lex_state, 4) ? 347 : 346));
        this.conditionState.stop();
        this.cmdArgumentState.stop();
        this.setState(1);
        if (c != 347) {
            this.setState(this.getState() | 0x400);
        }
        if (c != 346) {
            this.commandStart = true;
        }
        return c;
    }

    private int leftParen(boolean spaceSeen) throws IOException {
        int result2 = this.isBEG() ? 340 : (this.isSpaceArg(40, spaceSeen) ? 343 : 341);
        ++this.parenNest;
        this.conditionState.stop();
        this.cmdArgumentState.stop();
        this.setState(1025);
        return result2;
    }

    private int lessThan(boolean spaceSeen) throws IOException {
        int tok;
        this.last_state = this.lex_state;
        int c = this.nextc();
        if (!(c != 60 || RipperLexer.isLexState(this.lex_state, 768) || this.isEND() || this.isARG() && !RipperLexer.isLexState(this.lex_state, 2048) && !spaceSeen || (tok = this.hereDocumentIdentifier()) == 0)) {
            return tok;
        }
        this.setState(this.isAfterOperator() ? 16 : 1);
        switch (c) {
            case 61: {
                c = this.nextc();
                if (c == 62) {
                    return 318;
                }
                this.pushback(c);
                return 323;
            }
            case 60: {
                c = this.nextc();
                if (c == 61) {
                    this.setState(1);
                    return 338;
                }
                this.pushback(c);
                this.warn_balanced(c, spaceSeen, "<<", "here document");
                return 333;
            }
        }
        this.pushback(c);
        return 357;
    }

    private int minus(boolean spaceSeen) throws IOException {
        int c = this.nextc();
        if (this.isAfterOperator()) {
            this.setState(16);
            if (c == 64) {
                return 315;
            }
            this.pushback(c);
            return 356;
        }
        if (c == 61) {
            this.setState(1);
            return 338;
        }
        if (c == 62) {
            this.setState(8);
            return 374;
        }
        if (this.isBEG() || this.isSpaceArg(c, spaceSeen) && this.arg_ambiguous()) {
            this.setState(1);
            this.pushback(c);
            if (Character.isDigit(c)) {
                return 316;
            }
            return 315;
        }
        this.setState(1);
        this.pushback(c);
        this.warn_balanced(c, spaceSeen, "-", "unary operator");
        return 356;
    }

    private int percent(boolean spaceSeen) throws IOException {
        if (this.isBEG()) {
            return this.parseQuote(this.nextc());
        }
        int c = this.nextc();
        if (c == 61) {
            this.setState(1);
            return 338;
        }
        if (this.isSpaceArg(c, spaceSeen) || RipperLexer.isLexState(this.lex_state, 4096) && c == 115) {
            return this.parseQuote(c);
        }
        this.setState(this.isAfterOperator() ? 16 : 1);
        this.pushback(c);
        this.warn_balanced(c, spaceSeen, "%", "string literal");
        return 353;
    }

    private int pipe() throws IOException {
        int c = this.nextc();
        switch (c) {
            case 124: {
                this.setState(1);
                c = this.nextc();
                if (c == 61) {
                    this.setState(1);
                    return 338;
                }
                this.pushback(c);
                return 325;
            }
            case 61: {
                this.setState(1);
                return 338;
            }
        }
        this.setState(this.isAfterOperator() ? 16 : 1025);
        this.pushback(c);
        return 359;
    }

    private int plus(boolean spaceSeen) throws IOException {
        int c = this.nextc();
        if (this.isAfterOperator()) {
            this.setState(16);
            if (c == 64) {
                return 314;
            }
            this.pushback(c);
            return 355;
        }
        if (c == 61) {
            this.setState(1);
            return 338;
        }
        if (this.isBEG() || this.isSpaceArg(c, spaceSeen) && this.arg_ambiguous()) {
            this.setState(1);
            this.pushback(c);
            if (Character.isDigit(c)) {
                c = 43;
                return this.parseNumber(c);
            }
            return 314;
        }
        this.setState(1);
        this.pushback(c);
        this.warn_balanced(c, spaceSeen, "+", "unary operator");
        return 355;
    }

    private int questionMark() throws IOException {
        if (this.isEND()) {
            this.setState(1);
            return 63;
        }
        int c = this.nextc();
        if (c == -1) {
            this.compile_error("incomplete character syntax");
            return -1;
        }
        if (Character.isWhitespace(c)) {
            if (!this.isARG()) {
                int c2 = 0;
                switch (c) {
                    case 32: {
                        c2 = 115;
                        break;
                    }
                    case 10: {
                        c2 = 110;
                        break;
                    }
                    case 9: {
                        c2 = 116;
                        break;
                    }
                    case 13: {
                        c2 = 114;
                        break;
                    }
                    case 12: {
                        c2 = 102;
                    }
                }
                if (c2 != 0) {
                    this.warn("invalid character syntax; use ?\\" + c2);
                }
            }
            this.pushback(c);
            this.setState(1);
            return 63;
        }
        if (this.isASCII()) {
            ByteList buffer = new ByteList(1);
            if (!this.tokenAddMBC(c, buffer)) {
                return -1;
            }
            this.setState(2);
            return 313;
        }
        if (this.isIdentifierChar(c) && !this.peek(10) && this.isNext_identchar()) {
            this.pushback(c);
            this.setState(1);
            return 63;
        }
        if (c == 92) {
            if (this.peek(117)) {
                this.nextc();
                ByteList oneCharBL = new ByteList(2);
                c = this.readUTFEscape(oneCharBL, false, false);
                if (c >= 128) {
                    this.tokenAddMBC(c, oneCharBL);
                } else {
                    oneCharBL.append(c);
                }
                this.setState(2);
                return 379;
            }
            c = this.readEscape();
        }
        this.setState(2);
        ByteList oneCharBL = new ByteList(1);
        oneCharBL.append(c);
        return 313;
    }

    private int rightBracket() {
        --this.parenNest;
        this.conditionState.restart();
        this.cmdArgumentState.restart();
        this.setState(4);
        return 345;
    }

    private int rightCurly() {
        this.conditionState.restart();
        this.cmdArgumentState.restart();
        this.setState(4);
        int tok = this.braceNest == 0 ? 395 : 363;
        --this.braceNest;
        return tok;
    }

    private int rightParen() {
        --this.parenNest;
        this.conditionState.restart();
        this.cmdArgumentState.restart();
        this.setState(8);
        return 342;
    }

    private int singleQuote(boolean commandState) throws IOException {
        int label2 = this.isLabelPossible(commandState) ? 64 : 0;
        this.lex_strterm = new StringTerm(0 | label2, 0, 39);
        return 366;
    }

    private int slash(boolean spaceSeen) throws IOException {
        if (this.isBEG()) {
            this.lex_strterm = new StringTerm(7, 0, 47);
            return 368;
        }
        int c = this.nextc();
        if (c == 61) {
            this.setState(1);
            return 338;
        }
        this.pushback(c);
        if (this.isSpaceArg(c, spaceSeen)) {
            this.arg_ambiguous();
            this.lex_strterm = new StringTerm(7, 0, 47);
            return 368;
        }
        this.setState(this.isAfterOperator() ? 16 : 1);
        this.warn_balanced(c, spaceSeen, "/", "regexp literal");
        return 354;
    }

    private int star(boolean spaceSeen) throws IOException {
        int c = this.nextc();
        switch (c) {
            case 42: {
                c = this.nextc();
                if (c == 61) {
                    this.setState(1);
                    return 338;
                }
                this.pushback(c);
                if (this.isSpaceArg(c, spaceSeen)) {
                    if (this.isVerbose() && ((Boolean)Options.PARSER_WARN_ARGUMENT_PREFIX.load()).booleanValue()) {
                        this.warning("`**' interpreted as argument prefix");
                    }
                    c = 394;
                    break;
                }
                if (this.isBEG()) {
                    c = 394;
                    break;
                }
                this.warn_balanced(c, spaceSeen, "**", "argument prefix");
                c = 317;
                break;
            }
            case 61: {
                this.setState(1);
                return 338;
            }
            default: {
                this.pushback(c);
                if (this.isSpaceArg(c, spaceSeen)) {
                    if (this.isVerbose() && ((Boolean)Options.PARSER_WARN_ARGUMENT_PREFIX.load()).booleanValue()) {
                        this.warning("`*' interpreted as argument prefix");
                    }
                    c = 348;
                    break;
                }
                if (this.isBEG()) {
                    c = 348;
                    break;
                }
                this.warn_balanced(c, spaceSeen, "*", "argument prefix");
                c = 349;
            }
        }
        this.setState(this.isAfterOperator() ? 16 : 1);
        return c;
    }

    private int tilde() throws IOException {
        if (this.isAfterOperator()) {
            int c = this.nextc();
            if (c != 64) {
                this.pushback(c);
            }
            this.setState(16);
        } else {
            this.setState(1);
        }
        return 352;
    }

    private int parseNumber(int c) throws IOException {
        this.setState(2);
        this.numberBuffer.setRealSize(0);
        if (c == 45) {
            this.numberBuffer.append((int)((char)c));
            c = this.nextc();
        } else if (c == 43) {
            c = this.nextc();
        }
        int nondigit = 0;
        if (c == 48) {
            int startLen = this.numberBuffer.length();
            c = this.nextc();
            switch (c) {
                case 88: 
                case 120: {
                    c = this.nextc();
                    if (RipperLexer.isHexChar(c)) {
                        while (true) {
                            if (c == 95) {
                                if (nondigit != 0) break;
                                nondigit = c;
                            } else {
                                if (!RipperLexer.isHexChar(c)) break;
                                nondigit = 0;
                                this.numberBuffer.append((int)((char)c));
                            }
                            c = this.nextc();
                        }
                    }
                    this.pushback(c);
                    if (this.numberBuffer.length() == startLen) {
                        this.compile_error("Hexadecimal number without hex-digits.");
                    } else if (nondigit != 0) {
                        this.compile_error("Trailing '_' in number.");
                    }
                    return this.setIntegerLiteral(this.numberBuffer.toString(), this.numberLiteralSuffix(3));
                }
                case 66: 
                case 98: {
                    c = this.nextc();
                    if (c == 48 || c == 49) {
                        while (true) {
                            if (c == 95) {
                                if (nondigit != 0) break;
                                nondigit = c;
                            } else {
                                if (c != 48 && c != 49) break;
                                nondigit = 0;
                                this.numberBuffer.append((int)((char)c));
                            }
                            c = this.nextc();
                        }
                    }
                    this.pushback(c);
                    if (this.numberBuffer.length() == startLen) {
                        this.compile_error("Binary number without digits.");
                    } else if (nondigit != 0) {
                        this.compile_error("Trailing '_' in number.");
                    }
                    return this.setIntegerLiteral(this.numberBuffer.toString(), this.numberLiteralSuffix(3));
                }
                case 68: 
                case 100: {
                    c = this.nextc();
                    if (Character.isDigit(c)) {
                        while (true) {
                            if (c == 95) {
                                if (nondigit != 0) break;
                                nondigit = c;
                            } else {
                                if (!Character.isDigit(c)) break;
                                nondigit = 0;
                                this.numberBuffer.append((int)((char)c));
                            }
                            c = this.nextc();
                        }
                    }
                    this.pushback(c);
                    if (this.numberBuffer.length() == startLen) {
                        this.compile_error("Binary number without digits.");
                    } else if (nondigit != 0) {
                        this.compile_error("Trailing '_' in number.");
                    }
                    return this.setIntegerLiteral(this.numberBuffer.toString(), this.numberLiteralSuffix(3));
                }
                case 79: 
                case 111: {
                    c = this.nextc();
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 95: {
                    while (true) {
                        if (c == 95) {
                            if (nondigit != 0) break;
                            nondigit = c;
                        } else {
                            if (c < 48 || c > 55) break;
                            nondigit = 0;
                            this.numberBuffer.append((int)((char)c));
                        }
                        c = this.nextc();
                    }
                    if (this.numberBuffer.length() > startLen) {
                        this.pushback(c);
                        if (nondigit != 0) {
                            this.compile_error("Trailing '_' in number.");
                        }
                        return this.setIntegerLiteral(this.numberBuffer.toString(), this.numberLiteralSuffix(3));
                    }
                }
                case 56: 
                case 57: {
                    this.compile_error("Illegal octal digit.");
                }
                case 46: 
                case 69: 
                case 101: {
                    this.numberBuffer.append(48);
                    break;
                }
                default: {
                    this.pushback(c);
                    this.numberBuffer.append(48);
                    return this.setIntegerLiteral(this.numberBuffer.toString(), this.numberLiteralSuffix(3));
                }
            }
        }
        boolean seen_point = false;
        boolean seen_e = false;
        while (true) {
            switch (c) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    nondigit = 0;
                    this.numberBuffer.append((int)((char)c));
                    break;
                }
                case 46: {
                    if (nondigit != 0) {
                        this.pushback(c);
                        this.compile_error("Trailing '_' in number.");
                        break;
                    }
                    if (seen_point || seen_e) {
                        this.pushback(c);
                        return this.getNumberLiteral(this.numberBuffer.toString(), seen_e, seen_point, nondigit);
                    }
                    int c2 = this.nextc();
                    if (!Character.isDigit(c2)) {
                        this.pushback(c2);
                        this.pushback(46);
                        if (c == 95) break;
                        return this.getNumberLiteral(this.numberBuffer.toString(), seen_e, seen_point, nondigit);
                    }
                    this.numberBuffer.append(46);
                    this.numberBuffer.append((int)((char)c2));
                    seen_point = true;
                    nondigit = 0;
                    break;
                }
                case 69: 
                case 101: {
                    if (nondigit != 0) {
                        this.compile_error("Trailing '_' in number.");
                        break;
                    }
                    if (seen_e) {
                        this.pushback(c);
                        return this.getNumberLiteral(this.numberBuffer.toString(), seen_e, seen_point, nondigit);
                    }
                    this.numberBuffer.append((int)((char)c));
                    seen_e = true;
                    nondigit = c;
                    c = this.nextc();
                    if (c == 45 || c == 43) {
                        this.numberBuffer.append((int)((char)c));
                        nondigit = c;
                        break;
                    }
                    this.pushback(c);
                    break;
                }
                case 95: {
                    if (nondigit != 0) {
                        this.compile_error("Trailing '_' in number.");
                    }
                    nondigit = c;
                    break;
                }
                default: {
                    this.pushback(c);
                    return this.getNumberLiteral(this.numberBuffer.toString(), seen_e, seen_point, nondigit);
                }
            }
            c = this.nextc();
        }
    }

    private int getNumberLiteral(String number, boolean seen_e, boolean seen_point, int nondigit) throws IOException {
        boolean isFloat;
        if (nondigit != 0) {
            this.compile_error("Trailing '_' in number.");
        }
        boolean bl = isFloat = seen_e || seen_point;
        if (isFloat) {
            return this.getFloatToken(number, this.numberLiteralSuffix(seen_e ? 2 : 3));
        }
        return this.setIntegerLiteral(number, this.numberLiteralSuffix(3));
    }

    private int setNumberLiteral(String number, int type2, int suffix) {
        if ((suffix & 2) != 0) {
            type2 = 380;
        }
        return type2;
    }

    private int setIntegerLiteral(String value2, int suffix) {
        int type2 = (suffix & 1) != 0 ? 382 : 379;
        return this.setNumberLiteral(value2, type2, suffix);
    }

    public void readUTFEscapeRegexpLiteral(ByteList buffer) throws IOException {
        buffer.append(92);
        buffer.append(117);
        if (this.peek(123)) {
            do {
                buffer.append(this.nextc());
                if (this.scanHexLiteral(buffer, 6, false, "invalid Unicode escape") <= '\u10ffff') continue;
                this.compile_error("invalid Unicode codepoint (too large)");
            } while (this.peek(32) || this.peek(9));
            int c = this.nextc();
            if (c != 125) {
                this.compile_error("unterminated Unicode escape");
            }
            buffer.append((int)((char)c));
        } else {
            this.scanHexLiteral(buffer, 4, true, "Invalid Unicode escape");
        }
    }

    public boolean tokenAddMBC(int first_byte, ByteList buffer) {
        int length2 = this.precise_mbclen();
        if (length2 <= 0) {
            this.compile_error("invalid multibyte char (" + this.getEncoding().getName() + ")");
            return false;
        }
        this.tokAdd(first_byte, buffer);
        this.lex_p += length2 - 1;
        if (length2 > 1) {
            this.tokCopy(length2 - 1, buffer);
        }
        return true;
    }

    public int readUTFEscape(ByteList buffer, boolean stringLiteral, boolean symbolLiteral) throws IOException {
        int codepoint;
        if (this.peek(123)) {
            do {
                this.nextc();
                codepoint = this.scanHex(6, false, "invalid Unicode escape");
                if (codepoint > 0x10FFFF) {
                    this.compile_error("invalid Unicode codepoint (too large)");
                }
                if (buffer == null) continue;
                this.readUTF8EscapeIntoBuffer(codepoint, buffer, stringLiteral);
            } while (this.peek(32) || this.peek(9));
            int c = this.nextc();
            if (c != 125) {
                this.compile_error("unterminated Unicode escape");
            }
        } else {
            codepoint = this.scanHex(4, true, "Invalid Unicode escape");
            if (buffer != null) {
                this.readUTF8EscapeIntoBuffer(codepoint, buffer, stringLiteral);
            }
        }
        return codepoint;
    }

    private void readUTF8EscapeIntoBuffer(int codepoint, ByteList buffer, boolean stringLiteral) {
        if (codepoint >= 128) {
            buffer.setEncoding(UTF8_ENCODING);
            if (stringLiteral) {
                this.tokenAddMBC(codepoint, buffer);
            }
        } else if (stringLiteral) {
            buffer.append((int)((char)codepoint));
        }
    }

    public int readEscape() throws IOException {
        int c = this.nextc();
        switch (c) {
            case 92: {
                return c;
            }
            case 110: {
                return 10;
            }
            case 116: {
                return 9;
            }
            case 114: {
                return 13;
            }
            case 102: {
                return 12;
            }
            case 118: {
                return 11;
            }
            case 97: {
                return 7;
            }
            case 101: {
                return 27;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                this.pushback(c);
                return this.scanOct(3);
            }
            case 120: {
                return this.scanHex(2, false, "Invalid escape character syntax");
            }
            case 98: {
                return 8;
            }
            case 115: {
                return 32;
            }
            case 77: {
                c = this.nextc();
                if (c != 45) {
                    this.compile_error("Invalid escape character syntax");
                } else {
                    c = this.nextc();
                    if (c == 92) {
                        return (char)(this.readEscape() | 0x80);
                    }
                    if (c == -1) {
                        this.compile_error("Invalid escape character syntax");
                    }
                }
                return (char)(c & 0xFF | 0x80);
            }
            case 67: {
                if (this.nextc() != 45) {
                    this.compile_error("Invalid escape character syntax");
                }
            }
            case 99: {
                c = this.nextc();
                if (c == 92) {
                    c = this.readEscape();
                } else {
                    if (c == 63) {
                        return 127;
                    }
                    if (c == -1) {
                        this.compile_error("Invalid escape character syntax");
                    }
                }
                return (char)(c & 0x9F);
            }
            case -1: {
                this.compile_error("Invalid escape character syntax");
            }
        }
        return c;
    }

    private char scanHexLiteral(ByteList buffer, int count2, boolean strict, String errorMessage) throws IOException {
        int i2;
        char hexValue = '\u0000';
        for (i2 = 0; i2 < count2; ++i2) {
            int h1 = this.nextc();
            if (!RipperLexer.isHexChar(h1)) {
                this.pushback(h1);
                break;
            }
            buffer.append(h1);
            hexValue = (char)(hexValue << 4);
            hexValue = (char)(hexValue | Integer.parseInt(String.valueOf((char)h1), 16) & 0xF);
        }
        if (i2 == 0 || strict && count2 != i2) {
            this.compile_error(errorMessage);
        }
        return hexValue;
    }

    private int scanHex(int count2, boolean strict, String errorMessage) throws IOException {
        int i2;
        int hexValue = 0;
        for (i2 = 0; i2 < count2; ++i2) {
            int h1 = this.nextc();
            if (!RipperLexer.isHexChar(h1)) {
                this.pushback(h1);
                break;
            }
            hexValue <<= 4;
            hexValue |= Integer.parseInt(String.valueOf((char)h1), 16) & 0xF;
        }
        if (i2 == 0 || strict && count2 != i2) {
            this.compile_error(errorMessage);
        }
        return hexValue;
    }

    static {
        map.put("end", Keyword.END);
        map.put("else", Keyword.ELSE);
        map.put("case", Keyword.CASE);
        map.put("ensure", Keyword.ENSURE);
        map.put("module", Keyword.MODULE);
        map.put("elsif", Keyword.ELSIF);
        map.put("def", Keyword.DEF);
        map.put("rescue", Keyword.RESCUE);
        map.put("not", Keyword.NOT);
        map.put("then", Keyword.THEN);
        map.put("yield", Keyword.YIELD);
        map.put("for", Keyword.FOR);
        map.put("self", Keyword.SELF);
        map.put("false", Keyword.FALSE);
        map.put("retry", Keyword.RETRY);
        map.put("return", Keyword.RETURN);
        map.put("true", Keyword.TRUE);
        map.put("if", Keyword.IF);
        map.put("defined?", Keyword.DEFINED_P);
        map.put("super", Keyword.SUPER);
        map.put("undef", Keyword.UNDEF);
        map.put("break", Keyword.BREAK);
        map.put("in", Keyword.IN);
        map.put("do", Keyword.DO);
        map.put("nil", Keyword.NIL);
        map.put("until", Keyword.UNTIL);
        map.put("unless", Keyword.UNLESS);
        map.put("or", Keyword.OR);
        map.put("next", Keyword.NEXT);
        map.put("when", Keyword.WHEN);
        map.put("redo", Keyword.REDO);
        map.put("and", Keyword.AND);
        map.put("begin", Keyword.BEGIN);
        map.put("__LINE__", Keyword.__LINE__);
        map.put("class", Keyword.CLASS);
        map.put("__FILE__", Keyword.__FILE__);
        map.put("END", Keyword.LEND);
        map.put("BEGIN", Keyword.LBEGIN);
        map.put("while", Keyword.WHILE);
        map.put("alias", Keyword.ALIAS);
        map.put("__ENCODING__", Keyword.__ENCODING__);
    }

    public static enum Keyword {
        END("end", 264, 264, 2),
        ELSE("else", 269, 269, 1),
        CASE("case", 270, 270, 1),
        ENSURE("ensure", 263, 263, 1),
        MODULE("module", 258, 258, 1),
        ELSIF("elsif", 268, 268, 1),
        DEF("def", 259, 259, 128),
        RESCUE("rescue", 262, 297, 64),
        NOT("not", 292, 292, 16),
        THEN("then", 267, 267, 1),
        YIELD("yield", 284, 284, 16),
        FOR("for", 274, 274, 1),
        SELF("self", 286, 286, 2),
        FALSE("false", 289, 289, 2),
        RETRY("retry", 278, 278, 2),
        RETURN("return", 283, 283, 64),
        TRUE("true", 288, 288, 2),
        IF("if", 265, 293, 1),
        DEFINED_P("defined?", 299, 299, 16),
        SUPER("super", 285, 285, 16),
        UNDEF("undef", 260, 260, 4224),
        BREAK("break", 275, 275, 64),
        IN("in", 279, 279, 1),
        DO("do", 280, 280, 1),
        NIL("nil", 287, 287, 2),
        UNTIL("until", 273, 296, 1),
        UNLESS("unless", 266, 294, 1),
        OR("or", 291, 291, 1),
        NEXT("next", 276, 276, 64),
        WHEN("when", 271, 271, 1),
        REDO("redo", 277, 277, 2),
        AND("and", 290, 290, 1),
        BEGIN("begin", 261, 261, 1),
        __LINE__("__LINE__", 302, 302, 2),
        CLASS("class", 257, 257, 512),
        __FILE__("__FILE__", 303, 303, 2),
        LEND("END", 301, 301, 2),
        LBEGIN("BEGIN", 300, 300, 2),
        WHILE("while", 272, 295, 1),
        ALIAS("alias", 298, 298, 4224),
        __ENCODING__("__ENCODING__", 304, 304, 2);

        public final String name;
        public final int id0;
        public final int id1;
        public final int state;

        private Keyword(String name2, int id0, int id1, int state2) {
            this.name = name2;
            this.id0 = id0;
            this.id1 = id1;
            this.state = state2;
        }
    }
}

