/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.JumpException;
import org.jruby.java.proxies.ConcreteJavaProxy;
import org.jruby.runtime.Block;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.backtrace.BacktraceData;
import org.jruby.runtime.backtrace.RubyStackTraceElement;
import org.jruby.runtime.backtrace.TraceType;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.Variable;
import org.jruby.runtime.component.VariableEntry;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;

@JRubyClass(name={"Exception"})
public class RubyException
extends RubyObject {
    public static ObjectAllocator EXCEPTION_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            RubyException instance = new RubyException(runtime, klass);
            instance.setMetaClass(klass);
            return instance;
        }
    };
    private static final ObjectMarshal EXCEPTION_MARSHAL = new ObjectMarshal(){

        @Override
        public void marshalTo(Ruby runtime, Object obj, RubyClass type2, MarshalStream marshalStream) throws IOException {
            RubyException exc = (RubyException)obj;
            marshalStream.registerLinkTarget(exc);
            List<Variable<Object>> attrs = exc.getVariableList();
            attrs.add(new VariableEntry<IRubyObject>("mesg", exc.getMessage()));
            attrs.add(new VariableEntry<IRubyObject>("bt", exc.getBacktrace()));
            marshalStream.dumpVariables(attrs);
        }

        @Override
        public Object unmarshalFrom(Ruby runtime, RubyClass type2, UnmarshalStream unmarshalStream) throws IOException {
            RubyException exc = (RubyException)type2.allocate();
            unmarshalStream.registerLinkTarget(exc);
            unmarshalStream.defaultVariablesUnmarshal(exc);
            exc.setMessage((IRubyObject)exc.removeInternalVariable("mesg"));
            exc.set_backtrace((IRubyObject)exc.removeInternalVariable("bt"));
            return exc;
        }
    };
    private BacktraceData backtraceData;
    private IRubyObject backtrace;
    IRubyObject message;
    IRubyObject cause;
    public static final int TRACE_HEAD = 8;
    public static final int TRACE_TAIL = 4;
    public static final int TRACE_MAX = 18;

    protected RubyException(Ruby runtime, RubyClass rubyClass) {
        super(runtime, rubyClass);
        this.cause = RubyBasicObject.UNDEF;
    }

    public RubyException(Ruby runtime, RubyClass rubyClass, String message2) {
        super(runtime, rubyClass);
        this.setMessage(message2 == null ? runtime.getNil() : runtime.newString(message2));
        this.cause = RubyBasicObject.UNDEF;
    }

    @JRubyMethod(optional=2, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args2, Block block) {
        if (args2.length == 1) {
            this.setMessage(args2[0]);
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject backtrace() {
        return this.getBacktrace();
    }

    @JRubyMethod(required=1)
    public IRubyObject set_backtrace(IRubyObject obj) {
        this.setBacktrace(obj);
        return this.backtrace();
    }

    private void setBacktrace(IRubyObject obj) {
        if (obj.isNil()) {
            this.backtrace = null;
        } else if (this.isArrayOfStrings(obj)) {
            this.backtrace = obj;
        } else if (obj instanceof RubyString) {
            this.backtrace = RubyArray.newArray(this.getRuntime(), obj);
        } else {
            throw this.getRuntime().newTypeError("backtrace must be Array of String");
        }
    }

    @JRubyMethod(omit=true)
    public IRubyObject backtrace_locations(ThreadContext context) {
        Ruby runtime = context.runtime;
        RubyStackTraceElement[] elements = this.backtraceData.getBacktrace(runtime);
        return RubyThread.Location.newLocationArray(runtime, elements);
    }

    @JRubyMethod(name={"exception"}, optional=1, rest=true, meta=true)
    public static IRubyObject exception(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return ((RubyClass)recv2).newInstance(context, args2, block);
    }

    @JRubyMethod(optional=1)
    public RubyException exception(IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this;
            }
            case 1: {
                if (args2[0] == this) {
                    return this;
                }
                RubyException ret = (RubyException)this.rbClone();
                ret.initialize(args2, Block.NULL_BLOCK);
                return ret;
            }
        }
        throw this.getRuntime().newArgumentError("Wrong argument count");
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s(ThreadContext context) {
        IRubyObject msg = this.getMessage();
        if (!msg.isNil()) {
            return msg.asString();
        }
        return context.runtime.newString(this.getMetaClass().getRealClass().getName());
    }

    @Deprecated
    public IRubyObject to_s19(ThreadContext context) {
        return this.to_s(context);
    }

    @JRubyMethod(name={"message"})
    public IRubyObject message(ThreadContext context) {
        return this.callMethod(context, "to_s");
    }

    @JRubyMethod(name={"inspect"})
    public RubyString inspect(ThreadContext context) {
        String rubyClass = this.getMetaClass().getRealClass().getName();
        RubyString exception2 = RubyString.objAsString(context, this);
        if (exception2.isEmpty()) {
            return context.runtime.newString(rubyClass);
        }
        return RubyString.newString(context.runtime, new StringBuilder(2 + rubyClass.length() + 2 + exception2.size() + 1).append("#<").append(rubyClass).append(": ").append((CharSequence)exception2.getByteList()).append('>'));
    }

    @Override
    @JRubyMethod(name={"=="})
    public RubyBoolean op_equal(ThreadContext context, IRubyObject other) {
        if (this == other) {
            return context.runtime.getTrue();
        }
        boolean equal = context.runtime.getException().isInstance(other) && this.getMetaClass().getRealClass() == other.getMetaClass().getRealClass() && this.callMethod(context, "message").equals(other.callMethod(context, "message")) && this.callMethod(context, "backtrace").equals(other.callMethod(context, "backtrace"));
        return context.runtime.newBoolean(equal);
    }

    @JRubyMethod(name={"==="}, meta=true)
    public static IRubyObject op_eqq(ThreadContext context, IRubyObject recv2, IRubyObject other) {
        Object object;
        Ruby runtime = context.runtime;
        if (other instanceof ConcreteJavaProxy && (recv2 == runtime.getException() || recv2 == runtime.getStandardError()) && (object = ((ConcreteJavaProxy)other).getObject()) instanceof Throwable && !(object instanceof JumpException.FlowControlException) && (recv2 == runtime.getException() || object instanceof Exception)) {
            return context.runtime.getTrue();
        }
        return ((RubyClass)recv2).op_eqq(context, other);
    }

    @JRubyMethod(name={"cause"})
    public IRubyObject cause(ThreadContext context) {
        assert (this.cause != null);
        if (this.cause == RubyBasicObject.UNDEF) {
            return context.nil;
        }
        return this.cause;
    }

    public void setCause(IRubyObject cause2) {
        this.cause = cause2;
    }

    public Object getCause() {
        return this.cause;
    }

    public void setBacktraceData(BacktraceData backtraceData) {
        this.backtraceData = backtraceData;
    }

    public BacktraceData getBacktraceData() {
        return this.backtraceData;
    }

    public RubyStackTraceElement[] getBacktraceElements() {
        if (this.backtraceData == null) {
            return RubyStackTraceElement.EMPTY_ARRAY;
        }
        return this.backtraceData.getBacktrace(this.getRuntime());
    }

    public void prepareBacktrace(ThreadContext context, boolean nativeException) {
        if (this.backtraceData == null) {
            this.backtraceData = context.runtime.getInstanceConfig().getTraceType().getBacktrace(context, nativeException);
        }
    }

    public void prepareIntegratedBacktrace(ThreadContext context, StackTraceElement[] javaTrace) {
        if (this.backtraceData == null) {
            this.backtraceData = context.runtime.getInstanceConfig().getTraceType().getIntegratedBacktrace(context, javaTrace);
        }
    }

    public void forceBacktrace(IRubyObject backtrace2) {
        this.backtraceData = backtrace2 != null && backtrace2.isNil() ? null : BacktraceData.EMPTY;
        this.setBacktrace(backtrace2);
    }

    public IRubyObject getBacktrace() {
        if (this.backtrace == null) {
            this.initBacktrace();
        }
        return this.backtrace;
    }

    public void initBacktrace() {
        Ruby runtime = this.getRuntime();
        this.backtrace = this.backtraceData == null ? runtime.getNil() : TraceType.generateMRIBacktrace(runtime, this.backtraceData.getBacktrace(runtime));
    }

    @Override
    public void copySpecialInstanceVariables(IRubyObject clone2) {
        RubyException exception2 = (RubyException)clone2;
        exception2.backtraceData = this.backtraceData;
        exception2.backtrace = this.backtrace;
        exception2.message = this.message;
    }

    public void printBacktrace(PrintStream errorStream) {
        this.printBacktrace(errorStream, 0);
    }

    public void printBacktrace(PrintStream errorStream, int skip2) {
        IRubyObject trace = this.callMethod(this.getRuntime().getCurrentContext(), "backtrace");
        if (trace.isNil()) {
            return;
        }
        if (trace instanceof RubyArray) {
            IRubyObject[] elements = ((RubyArray)trace).toJavaArrayMaybeUnsafe();
            for (int i2 = skip2; i2 < elements.length; ++i2) {
                IRubyObject stackTraceLine = elements[i2];
                if (stackTraceLine instanceof RubyString) {
                    errorStream.println("\tfrom " + stackTraceLine);
                    continue;
                }
                errorStream.println("\t" + stackTraceLine);
            }
        }
    }

    private boolean isArrayOfStrings(IRubyObject backtrace2) {
        if (!(backtrace2 instanceof RubyArray)) {
            return false;
        }
        RubyArray rTrace = (RubyArray)backtrace2;
        for (int i2 = 0; i2 < rTrace.getLength(); ++i2) {
            if (rTrace.eltInternal(i2) instanceof RubyString) continue;
            return false;
        }
        return true;
    }

    public static RubyClass createExceptionClass(Ruby runtime) {
        RubyClass exceptionClass = runtime.defineClass("Exception", runtime.getObject(), EXCEPTION_ALLOCATOR);
        runtime.setException(exceptionClass);
        exceptionClass.setClassIndex(ClassIndex.EXCEPTION);
        exceptionClass.setReifiedClass(RubyException.class);
        exceptionClass.setMarshal(EXCEPTION_MARSHAL);
        exceptionClass.defineAnnotatedMethods(RubyException.class);
        return exceptionClass;
    }

    public static RubyException newException(Ruby runtime, RubyClass excptnClass, String msg) {
        return new RubyException(runtime, excptnClass, msg);
    }

    public static IRubyObject newException(ThreadContext context, RubyClass exceptionClass, IRubyObject message2) {
        return exceptionClass.callMethod(context, "new", (IRubyObject)message2.convertToString());
    }

    public IRubyObject getMessage() {
        return this.message == null ? this.getRuntime().getNil() : this.message;
    }

    public void setMessage(IRubyObject message2) {
        this.message = message2;
    }

    public String getMessageAsJavaString() {
        IRubyObject msg = this.getMessage();
        return msg.isNil() ? null : msg.toString();
    }
}

