/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.invokedynamic;

import com.headius.invokebinder.Binder;
import com.headius.invokebinder.Signature;
import com.headius.invokebinder.SmartBinder;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.Framing;
import org.jruby.internal.runtime.methods.Scoping;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;

public class InvocationLinker {
    public static MethodHandle wrapWithFraming(Signature signature, CallConfiguration callConfig, RubyModule implClass, String name2, MethodHandle nativeTarget, StaticScope scope) {
        MethodHandle framePre = InvocationLinker.getFramePre(signature, callConfig, implClass, name2, scope);
        if (framePre != null) {
            MethodHandle framePost = InvocationLinker.getFramePost(signature, callConfig);
            boolean heapScoped = callConfig.scoping() != Scoping.None;
            boolean framed = callConfig.framing() != Framing.None;
            nativeTarget = Binder.from((MethodType)nativeTarget.type()).tryFinally(framePost).invoke(nativeTarget);
            nativeTarget = MethodHandles.foldArguments(nativeTarget, framePre);
            nativeTarget = Binder.from((MethodType)nativeTarget.type()).fold(Binder.from((MethodType)nativeTarget.type().changeReturnType(Void.TYPE)).permute(new int[]{0}).invokeStaticQuiet(MethodHandles.lookup(), ThreadContext.class, "callThreadPoll")).invoke(nativeTarget);
        }
        return nativeTarget;
    }

    public static MethodHandle getFramePre(Signature signature, CallConfiguration callConfig, RubyModule implClass, String name2, StaticScope scope) {
        Signature inbound = signature.asFold(Void.TYPE);
        SmartBinder binder = SmartBinder.from((Signature)inbound);
        switch (callConfig) {
            case FrameFullScopeFull: {
                return binder.permute(new String[]{"context", "self", "block"}).insert(1, Helpers.arrayOf("selfClass", "name"), Helpers.arrayOf(RubyModule.class, String.class), new Object[]{implClass, name2}).insert(5, Helpers.arrayOf("scope"), Helpers.arrayOf(StaticScope.class), new Object[]{scope}).invokeVirtualQuiet(MethodHandles.lookup(), "preMethodFrameAndScope").handle();
            }
            case FrameFullScopeDummy: {
                return binder.permute(new String[]{"context", "self", "block"}).insert(1, Helpers.arrayOf("selfClass", "name"), Helpers.arrayOf(RubyModule.class, String.class), new Object[]{implClass, name2}).insert(5, Helpers.arrayOf("scope"), Helpers.arrayOf(StaticScope.class), new Object[]{scope}).invokeVirtualQuiet(MethodHandles.lookup(), "preMethodFrameAndDummyScope").handle();
            }
            case FrameFullScopeNone: {
                return binder.permute(new String[]{"context", "self", "block"}).insert(1, Helpers.arrayOf("selfClass", "name"), Helpers.arrayOf(RubyModule.class, String.class), new Object[]{implClass, name2}).invokeVirtualQuiet(MethodHandles.lookup(), "preMethodFrameOnly").handle();
            }
            case FrameNoneScopeFull: {
                return binder.permute(new String[]{"context"}).insert(1, Helpers.arrayOf("selfClass", "scope"), Helpers.arrayOf(RubyModule.class, StaticScope.class), new Object[]{implClass, scope}).invokeVirtualQuiet(MethodHandles.lookup(), "preMethodScopeOnly").handle();
            }
            case FrameNoneScopeDummy: {
                return binder.permute(new String[]{"context"}).insert(1, Helpers.arrayOf("selfClass", "scope"), Helpers.arrayOf(RubyModule.class, StaticScope.class), new Object[]{implClass, scope}).invokeVirtualQuiet(MethodHandles.lookup(), "preMethodNoFrameAndDummyScope").handle();
            }
        }
        return null;
    }

    public static MethodHandle getFramePost(Signature signature, CallConfiguration callConfig) {
        Signature inbound = signature.asFold(Void.TYPE);
        SmartBinder binder = SmartBinder.from((Signature)inbound).permute(new String[]{"context"});
        switch (callConfig) {
            case FrameFullScopeFull: {
                return binder.invokeVirtualQuiet(MethodHandles.lookup(), "postMethodFrameAndScope").handle();
            }
            case FrameFullScopeDummy: {
                return binder.invokeVirtualQuiet(MethodHandles.lookup(), "postMethodFrameAndScope").handle();
            }
            case FrameFullScopeNone: {
                return binder.invokeVirtualQuiet(MethodHandles.lookup(), "postMethodFrameOnly").handle();
            }
            case FrameNoneScopeFull: {
                return binder.invokeVirtualQuiet(MethodHandles.lookup(), "postMethodScopeOnly").handle();
            }
            case FrameNoneScopeDummy: {
                return binder.invokeVirtualQuiet(MethodHandles.lookup(), "postMethodScopeOnly").handle();
            }
        }
        return null;
    }
}

