/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.EvalType;
import org.jruby.RubyArray;
import org.jruby.RubyProc;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.NullBlockBody;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.StringSupport;

public abstract class BlockBody {
    public static final String[] EMPTY_PARAMETER_LIST = StringSupport.EMPTY_STRING_ARRAY;
    protected final Signature signature;
    public static final BlockBody NULL_BODY = new NullBlockBody();

    public BlockBody(Signature signature) {
        this.signature = signature;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public void setEvalType(EvalType evalType) {
        System.err.println("setEvalType unimplemented in " + this.getClass().getName());
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2) {
        args2 = this.prepareArgumentsForCall(context, args2, type2);
        return this.yield(context, args2, null, binding2, type2);
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2, Block block) {
        args2 = this.prepareArgumentsForCall(context, args2, type2);
        return this.yield(context, args2, null, binding2, type2, block);
    }

    public final IRubyObject yield(ThreadContext context, IRubyObject value2, Binding binding2, Block.Type type2) {
        return this.doYield(context, value2, binding2, type2);
    }

    public final IRubyObject yield(ThreadContext context, IRubyObject[] args2, IRubyObject self2, Binding binding2, Block.Type type2) {
        IRubyObject[] preppedValue = RubyProc.prepareArgs(context, type2, this, args2);
        return this.doYield(context, preppedValue, self2, binding2, type2);
    }

    protected abstract IRubyObject doYield(ThreadContext var1, IRubyObject var2, Binding var3, Block.Type var4);

    protected abstract IRubyObject doYield(ThreadContext var1, IRubyObject[] var2, IRubyObject var3, Binding var4, Block.Type var5);

    public IRubyObject yield(ThreadContext context, IRubyObject[] args2, IRubyObject self2, Binding binding2, Block.Type type2, Block block) {
        return this.yield(context, args2, self2, binding2, type2);
    }

    public IRubyObject yield(ThreadContext context, IRubyObject value2, Binding binding2, Block.Type type2, Block block) {
        return this.yield(context, value2, binding2, type2);
    }

    public IRubyObject call(ThreadContext context, Binding binding2, Block.Type type2) {
        IRubyObject[] args2 = IRubyObject.NULL_ARRAY;
        args2 = this.prepareArgumentsForCall(context, args2, type2);
        return this.yield(context, args2, null, binding2, type2);
    }

    public IRubyObject call(ThreadContext context, Binding binding2, Block.Type type2, Block unusedBlock) {
        return this.call(context, binding2, type2);
    }

    public IRubyObject yieldSpecific(ThreadContext context, Binding binding2, Block.Type type2) {
        return this.yield(context, null, binding2, type2);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0, Binding binding2, Block.Type type2) {
        IRubyObject[] args2 = new IRubyObject[]{arg0};
        args2 = this.prepareArgumentsForCall(context, args2, type2);
        return this.yield(context, args2, null, binding2, type2);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0, Binding binding2, Block.Type type2, Block unusedBlock) {
        return this.call(context, arg0, binding2, type2);
    }

    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, Binding binding2, Block.Type type2) {
        return this.yield(context, arg0, binding2, type2);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Binding binding2, Block.Type type2) {
        IRubyObject[] args2 = new IRubyObject[]{arg0, arg1};
        args2 = this.prepareArgumentsForCall(context, args2, type2);
        return this.yield(context, args2, null, binding2, type2);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Binding binding2, Block.Type type2, Block unusedBlock) {
        return this.call(context, arg0, arg1, binding2, type2);
    }

    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Binding binding2, Block.Type type2) {
        return this.yield(context, new IRubyObject[]{arg0, arg1}, null, binding2, type2);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Binding binding2, Block.Type type2) {
        IRubyObject[] args2 = new IRubyObject[]{arg0, arg1, arg2};
        args2 = this.prepareArgumentsForCall(context, args2, type2);
        return this.yield(context, args2, null, binding2, type2);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Binding binding2, Block.Type type2, Block unusedBlock) {
        return this.call(context, arg0, arg1, arg2, binding2, type2);
    }

    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Binding binding2, Block.Type type2) {
        return this.yield(context, new IRubyObject[]{arg0, arg1, arg2}, null, binding2, type2);
    }

    public abstract StaticScope getStaticScope();

    public abstract void setStaticScope(StaticScope var1);

    @Deprecated
    public Arity arity() {
        return this.signature.arity();
    }

    public boolean isGiven() {
        return true;
    }

    public abstract String getFile();

    public abstract int getLine();

    public IRubyObject[] prepareArgumentsForCall(ThreadContext context, IRubyObject[] args2, Block.Type type2) {
        if (type2 == Block.Type.LAMBDA) {
            this.signature.checkArity(context.runtime, args2);
        } else if (args2.length == 1) {
            args2 = IRRuntimeHelpers.convertValueIntoArgArray(context, args2[0], this.signature.arityValue(), type2 == Block.Type.NORMAL && args2[0] instanceof RubyArray);
        } else if (this.getSignature().arityValue() == 1 && !this.getSignature().restKwargs()) {
            IRubyObject[] iRubyObjectArray;
            if (args2.length == 0) {
                iRubyObjectArray = context.runtime.getSingleNilArray();
            } else {
                IRubyObject[] iRubyObjectArray2 = new IRubyObject[1];
                iRubyObjectArray = iRubyObjectArray2;
                iRubyObjectArray2[0] = args2[0];
            }
            args2 = iRubyObjectArray;
        }
        return args2;
    }

    public ArgumentDescriptor[] getArgumentDescriptors() {
        return ArgumentDescriptor.EMPTY_ARRAY;
    }
}

