/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.proxy;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jruby.Ruby;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.proxy.InternalJavaProxy;
import org.jruby.javasupport.proxy.InternalJavaProxyHelper;
import org.jruby.javasupport.proxy.JavaProxyClass;
import org.jruby.javasupport.proxy.JavaProxyInvocationHandler;
import org.jruby.javasupport.proxy.JavaProxyMethod;
import org.jruby.org.objectweb.asm.ClassVisitor;
import org.jruby.org.objectweb.asm.ClassWriter;
import org.jruby.org.objectweb.asm.FieldVisitor;
import org.jruby.org.objectweb.asm.Label;
import org.jruby.org.objectweb.asm.MethodVisitor;
import org.jruby.org.objectweb.asm.Type;
import org.jruby.org.objectweb.asm.commons.GeneratorAdapter;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class JavaProxyClassFactory {
    private static final Logger LOG = LoggerFactory.getLogger("JavaProxyClassFactory");
    static final Type[] EMPTY_TYPE_ARRAY = new Type[0];
    static final Type JAVA_LANG_CLASS_TYPE = Type.getType(Class.class);
    private static final org.jruby.org.objectweb.asm.commons.Method forName = org.jruby.org.objectweb.asm.commons.Method.getMethod("java.lang.Class forName(java.lang.String)");
    private static final String INVOCATION_HANDLER_FIELD_NAME = "__handler";
    private static final String PROXY_CLASS_FIELD_NAME = "__proxy_class";
    private static final Type PROXY_METHOD_TYPE = Type.getType(JavaProxyMethod.class);
    private static final Type PROXY_CLASS_TYPE = Type.getType(JavaProxyClass.class);
    private static final Type INVOCATION_HANDLER_TYPE = Type.getType(JavaProxyInvocationHandler.class);
    private static final org.jruby.org.objectweb.asm.commons.Method invoke = org.jruby.org.objectweb.asm.commons.Method.getMethod("java.lang.Object invoke(java.lang.Object, " + PROXY_METHOD_TYPE.getClassName() + ", java.lang.Object[])");
    private static final Type INTERNAL_PROXY_HELPER_TYPE = Type.getType(InternalJavaProxyHelper.class);
    private static final org.jruby.org.objectweb.asm.commons.Method initProxyClass = org.jruby.org.objectweb.asm.commons.Method.getMethod(JavaProxyClass.class.getName() + " initProxyClass(java.lang.Class)");
    private static final org.jruby.org.objectweb.asm.commons.Method initProxyMethod = org.jruby.org.objectweb.asm.commons.Method.getMethod(PROXY_METHOD_TYPE.getClassName() + " initProxyMethod(" + JavaProxyClass.class.getName() + ",java.lang.String,java.lang.String,boolean)");
    private static final Type JAVA_PROXY_TYPE = Type.getType(InternalJavaProxy.class);
    private static final AtomicInteger counter = new AtomicInteger(0);
    private static final Method defineClassMethod = AccessController.doPrivileged(new PrivilegedAction<Method>(){

        @Override
        public Method run() {
            try {
                Class[] parameterTypes = new Class[]{String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class};
                Method method = ClassLoader.class.getDeclaredMethod("defineClass", parameterTypes);
                method.setAccessible(true);
                return method;
            }
            catch (Exception e) {
                LOG.error("could not use ClassLoader.defineClass method", e);
                return null;
            }
        }
    });

    private static int nextId() {
        return counter.incrementAndGet();
    }

    public static JavaProxyClassFactory createFactory() {
        String factoryClassName = (String)Options.JI_PROXYCLASSFACTORY.load();
        JavaProxyClassFactory factory = null;
        if (factoryClassName != null) {
            try {
                Class<?> clazz = Class.forName(factoryClassName);
                Object instance = clazz.newInstance();
                if (instance instanceof JavaProxyClassFactory) {
                    factory = (JavaProxyClassFactory)instance;
                    LOG.info("Created proxy class factory: " + factory, new Object[0]);
                } else {
                    LOG.error("Invalid proxy class factory: " + instance, new Object[0]);
                }
            }
            catch (ClassNotFoundException e) {
                LOG.error("ClassNotFoundException creating proxy class factory: " + e, new Object[0]);
            }
            catch (InstantiationException e) {
                LOG.error("InstantiationException creating proxy class factory: " + e, new Object[0]);
            }
            catch (IllegalAccessException e) {
                LOG.error("IllegalAccessException creating proxy class factory: " + e, new Object[0]);
            }
        }
        return factory != null ? factory : new JavaProxyClassFactory();
    }

    public JavaProxyClass newProxyClass(Ruby runtime, ClassLoader loader, String targetClassName, Class superClass, Class[] interfaces2, Set<String> names2) throws InvocationTargetException {
        if (loader == null) {
            loader = JavaProxyClassFactory.class.getClassLoader();
        }
        if (superClass == null) {
            superClass = Object.class;
        }
        if (interfaces2 == null) {
            interfaces2 = JavaClass.EMPTY_CLASS_ARRAY;
        }
        HashSet<Object> cacheKey = new HashSet<Object>();
        cacheKey.add(superClass);
        for (int i2 = 0; i2 < interfaces2.length; ++i2) {
            cacheKey.add(interfaces2[i2]);
        }
        if (names2 != null) {
            cacheKey.addAll(names2);
        } else {
            names2 = Collections.emptySet();
        }
        Map<Set<?>, JavaProxyClass> proxyCache = runtime.getJavaSupport().getJavaProxyClassCache();
        JavaProxyClass proxyClass = proxyCache.get(cacheKey);
        if (proxyClass == null) {
            if (targetClassName == null) {
                targetClassName = JavaProxyClassFactory.targetClassName(superClass);
            }
            JavaProxyClassFactory.validateArgs(runtime, targetClassName, superClass);
            Type selfType = Type.getType("L" + JavaProxyClassFactory.toInternalClassName(targetClassName) + ";");
            Map<MethodKey, MethodData> methods2 = JavaProxyClassFactory.collectMethods(superClass, interfaces2, names2);
            proxyClass = this.generate(loader, targetClassName, superClass, interfaces2, methods2, selfType);
            proxyCache.put(cacheKey, proxyClass);
        }
        return proxyClass;
    }

    private JavaProxyClass generate(ClassLoader loader, String targetClassName, Class superClass, Class[] interfaces2, Map<MethodKey, MethodData> methods2, Type selfType) {
        ClassWriter cw = this.beginProxyClass(targetClassName, superClass, interfaces2);
        GeneratorAdapter clazzInit = this.createClassInitializer(selfType, cw);
        this.generateConstructors(superClass, selfType, cw);
        this.generateGetProxyClass(selfType, cw);
        this.generateGetInvocationHandler(selfType, cw);
        this.generateProxyMethods(superClass, methods2, selfType, cw, clazzInit);
        clazzInit.returnValue();
        clazzInit.endMethod();
        cw.visitEnd();
        Class clazz = this.invokeDefineClass(loader, selfType.getClassName(), cw.toByteArray());
        try {
            Field proxy_class = clazz.getDeclaredField(PROXY_CLASS_FIELD_NAME);
            proxy_class.setAccessible(true);
            return (JavaProxyClass)proxy_class.get(clazz);
        }
        catch (Exception ex) {
            InternalError ie = new InternalError();
            ie.initCause(ex);
            throw ie;
        }
    }

    private static String targetClassName(Class clazz) {
        String pkgName = JavaProxyClassFactory.proxyPackageName(clazz);
        String fullName = clazz.getName();
        int ix = fullName.lastIndexOf(46);
        String className = ix == -1 ? fullName : fullName.substring(ix + 1);
        return pkgName + '.' + className + "$Proxy" + JavaProxyClassFactory.nextId();
    }

    protected Class invokeDefineClass(ClassLoader loader, String className, byte[] data2) {
        try {
            Object[] parameters2 = new Object[]{className, data2, 0, data2.length, JavaProxyClassFactory.class.getProtectionDomain()};
            return (Class)defineClassMethod.invoke((Object)loader, parameters2);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("defining class with name " + className + " failed", e);
            return null;
        }
        catch (IllegalAccessException e) {
            LOG.warn("defining class with name " + className + " failed", e);
            return null;
        }
        catch (InvocationTargetException e) {
            LOG.warn("defining class with name " + className + " failed", e);
            return null;
        }
    }

    private ClassWriter beginProxyClass(String className, Class superClass, Class[] interfaces2) {
        ClassWriter cw = new ClassWriter(1);
        cw.visit(49, 49, JavaProxyClassFactory.toInternalClassName(className), null, JavaProxyClassFactory.toInternalClassName(superClass), this.interfaceNamesForProxyClass(interfaces2));
        cw.visitField(2, INVOCATION_HANDLER_FIELD_NAME, INVOCATION_HANDLER_TYPE.getDescriptor(), null, null).visitEnd();
        cw.visitField(10, PROXY_CLASS_FIELD_NAME, PROXY_CLASS_TYPE.getDescriptor(), null, null).visitEnd();
        return cw;
    }

    private String[] interfaceNamesForProxyClass(Class[] interfaces2) {
        String[] interfaceNames = new String[interfaces2.length + 1];
        for (int i2 = 0; i2 < interfaces2.length; ++i2) {
            interfaceNames[i2] = JavaProxyClassFactory.toInternalClassName(interfaces2[i2]);
        }
        interfaceNames[interfaces2.length] = JavaProxyClassFactory.toInternalClassName(InternalJavaProxy.class);
        return interfaceNames;
    }

    private void generateProxyMethods(Class superClass, Map<MethodKey, MethodData> methods2, Type selfType, ClassVisitor cw, GeneratorAdapter clazzInit) {
        for (MethodData md : methods2.values()) {
            Type superClassType = Type.getType(superClass);
            this.generateProxyMethod(selfType, superClassType, cw, clazzInit, md);
        }
    }

    private void generateGetInvocationHandler(Type selfType, ClassVisitor cw) {
        GeneratorAdapter gh = new GeneratorAdapter(1, new org.jruby.org.objectweb.asm.commons.Method("___getInvocationHandler", INVOCATION_HANDLER_TYPE, EMPTY_TYPE_ARRAY), null, EMPTY_TYPE_ARRAY, cw);
        gh.loadThis();
        gh.getField(selfType, INVOCATION_HANDLER_FIELD_NAME, INVOCATION_HANDLER_TYPE);
        gh.returnValue();
        gh.endMethod();
    }

    private void generateGetProxyClass(Type selfType, ClassVisitor cw) {
        GeneratorAdapter gpc = new GeneratorAdapter(1, new org.jruby.org.objectweb.asm.commons.Method("___getProxyClass", PROXY_CLASS_TYPE, EMPTY_TYPE_ARRAY), null, EMPTY_TYPE_ARRAY, cw);
        gpc.getStatic(selfType, PROXY_CLASS_FIELD_NAME, PROXY_CLASS_TYPE);
        gpc.returnValue();
        gpc.endMethod();
    }

    private void generateConstructors(Class superClass, Type selfType, ClassVisitor cw) {
        Constructor<?>[] cons = superClass.getDeclaredConstructors();
        for (int i2 = 0; i2 < cons.length; ++i2) {
            if (Modifier.isPrivate(cons[i2].getModifiers())) continue;
            this.generateConstructor(selfType, cons[i2], cw);
        }
    }

    private GeneratorAdapter createClassInitializer(Type selfType, ClassVisitor cw) {
        GeneratorAdapter clazzInit = new GeneratorAdapter(10, new org.jruby.org.objectweb.asm.commons.Method("<clinit>", Type.VOID_TYPE, EMPTY_TYPE_ARRAY), null, EMPTY_TYPE_ARRAY, cw);
        clazzInit.visitLdcInsn(selfType.getClassName());
        clazzInit.invokeStatic(JAVA_LANG_CLASS_TYPE, forName);
        clazzInit.invokeStatic(INTERNAL_PROXY_HELPER_TYPE, initProxyClass);
        clazzInit.dup();
        clazzInit.putStatic(selfType, PROXY_CLASS_FIELD_NAME, PROXY_CLASS_TYPE);
        return clazzInit;
    }

    private void generateProxyMethod(Type selfType, Type superType, ClassVisitor cw, GeneratorAdapter clazzInit, MethodData md) {
        if (!md.generateProxyMethod()) {
            return;
        }
        org.jruby.org.objectweb.asm.commons.Method m = md.getMethod();
        Type[] ex = JavaProxyClassFactory.toTypes(md.getExceptions());
        String field_name = "__mth$" + md.getName() + md.scrambledSignature();
        FieldVisitor fv = cw.visitField(10, field_name, PROXY_METHOD_TYPE.getDescriptor(), null, null);
        fv.visitEnd();
        clazzInit.dup();
        clazzInit.push(m.getName());
        clazzInit.push(m.getDescriptor());
        clazzInit.push(md.isImplemented());
        clazzInit.invokeStatic(INTERNAL_PROXY_HELPER_TYPE, initProxyMethod);
        clazzInit.putStatic(selfType, field_name, PROXY_METHOD_TYPE);
        org.jruby.org.objectweb.asm.commons.Method sm = new org.jruby.org.objectweb.asm.commons.Method("__super$" + m.getName(), m.getReturnType(), m.getArgumentTypes());
        GeneratorAdapter ga = new GeneratorAdapter(1, m, null, ex, cw);
        ga.loadThis();
        ga.getField(selfType, INVOCATION_HANDLER_FIELD_NAME, INVOCATION_HANDLER_TYPE);
        if (md.isImplemented()) {
            ga.dup();
            Label ok = ga.newLabel();
            ga.ifNonNull(ok);
            ga.loadThis();
            ga.loadArgs();
            ga.invokeConstructor(superType, m);
            ga.returnValue();
            ga.mark(ok);
        }
        ga.loadThis();
        ga.getStatic(selfType, field_name, PROXY_METHOD_TYPE);
        if (m.getArgumentTypes().length == 0) {
            ga.getStatic(JAVA_PROXY_TYPE, "NO_ARGS", JavaProxyClassFactory.toType(Object[].class));
        } else {
            ga.loadArgArray();
        }
        Label before = ga.mark();
        ga.invokeInterface(INVOCATION_HANDLER_TYPE, invoke);
        Label after = ga.mark();
        ga.unbox(m.getReturnType());
        ga.returnValue();
        Label rethrow = ga.mark();
        ga.visitInsn(191);
        for (int i2 = 0; i2 < ex.length; ++i2) {
            ga.visitTryCatchBlock(before, after, rethrow, ex[i2].getInternalName());
        }
        ga.visitTryCatchBlock(before, after, rethrow, "java/lang/Error");
        ga.visitTryCatchBlock(before, after, rethrow, "java/lang/RuntimeException");
        Type thr = JavaProxyClassFactory.toType(Throwable.class);
        Label handler = ga.mark();
        Type udt = JavaProxyClassFactory.toType(UndeclaredThrowableException.class);
        int loc = ga.newLocal(thr);
        ga.storeLocal(loc, thr);
        ga.newInstance(udt);
        ga.dup();
        ga.loadLocal(loc, thr);
        ga.invokeConstructor(udt, org.jruby.org.objectweb.asm.commons.Method.getMethod("void <init>(java.lang.Throwable)"));
        ga.throwException();
        ga.visitTryCatchBlock(before, after, handler, "java/lang/Throwable");
        ga.endMethod();
        if (md.isImplemented()) {
            GeneratorAdapter ga2 = new GeneratorAdapter(1, sm, null, ex, cw);
            ga2.loadThis();
            ga2.loadArgs();
            ga2.invokeConstructor(superType, m);
            ga2.returnValue();
            ga2.endMethod();
        }
    }

    private Class[] generateConstructor(Type selfType, Constructor constructor2, ClassVisitor cw) {
        Class[] superConstructorParameterTypes = constructor2.getParameterTypes();
        Class[] newConstructorParameterTypes = new Class[superConstructorParameterTypes.length + 1];
        System.arraycopy(superConstructorParameterTypes, 0, newConstructorParameterTypes, 0, superConstructorParameterTypes.length);
        newConstructorParameterTypes[superConstructorParameterTypes.length] = JavaProxyInvocationHandler.class;
        int access = 1;
        String name1 = "<init>";
        String signature = null;
        Class[] superConstructorExceptions = constructor2.getExceptionTypes();
        boolean superConstructorVarArgs = constructor2.isVarArgs();
        org.jruby.org.objectweb.asm.commons.Method super_m = new org.jruby.org.objectweb.asm.commons.Method(name1, Type.VOID_TYPE, JavaProxyClassFactory.toTypes(superConstructorParameterTypes));
        org.jruby.org.objectweb.asm.commons.Method m = new org.jruby.org.objectweb.asm.commons.Method(name1, Type.VOID_TYPE, JavaProxyClassFactory.toTypes(newConstructorParameterTypes));
        String[] exceptionNames = JavaProxyClassFactory.toInternalNames(superConstructorExceptions);
        MethodVisitor mv = cw.visitMethod(access, m.getName(), m.getDescriptor(), signature, exceptionNames);
        if (superConstructorVarArgs) {
            mv.visitAnnotation(Type.getDescriptor(VarArgs.class), true);
        }
        GeneratorAdapter ga = new GeneratorAdapter(access, m, mv);
        ga.loadThis();
        ga.loadArgs(0, superConstructorParameterTypes.length);
        ga.invokeConstructor(JavaProxyClassFactory.toType(constructor2.getDeclaringClass()), super_m);
        ga.loadThis();
        ga.loadArg(superConstructorParameterTypes.length);
        ga.putField(selfType, INVOCATION_HANDLER_FIELD_NAME, INVOCATION_HANDLER_TYPE);
        ga.returnValue();
        ga.endMethod();
        return newConstructorParameterTypes;
    }

    static boolean isVarArgs(Constructor<?> ctor) {
        return ctor.isVarArgs() || ctor.getAnnotation(VarArgs.class) != null;
    }

    private static String toInternalClassName(Class clazz) {
        return JavaProxyClassFactory.toInternalClassName(clazz.getName());
    }

    private static String toInternalClassName(String name2) {
        return name2.replace('.', '/');
    }

    private static Type toType(Class clazz) {
        return Type.getType(clazz);
    }

    private static Type[] toTypes(Class[] params2) {
        Type[] types = new Type[params2.length];
        for (int i2 = 0; i2 < types.length; ++i2) {
            types[i2] = Type.getType(params2[i2]);
        }
        return types;
    }

    private static String[] toInternalNames(Class[] params2) {
        if (params2 == null) {
            return null;
        }
        String[] names2 = new String[params2.length];
        for (int i2 = 0; i2 < names2.length; ++i2) {
            names2[i2] = Type.getType(params2[i2]).getInternalName();
        }
        return names2;
    }

    private static Map<MethodKey, MethodData> collectMethods(Class superClass, Class[] interfaces2, Set<String> names2) {
        HashMap<MethodKey, MethodData> methods2 = new HashMap<MethodKey, MethodData>();
        HashSet<Class> allClasses = new HashSet<Class>();
        JavaProxyClassFactory.addClass(allClasses, methods2, superClass, names2);
        JavaProxyClassFactory.addInterfaces(allClasses, methods2, interfaces2, names2);
        return methods2;
    }

    private static void addInterfaces(Set<Class> allClasses, Map<MethodKey, MethodData> methods2, Class[] ifaces, Set<String> names2) {
        for (int i2 = 0; i2 < ifaces.length; ++i2) {
            JavaProxyClassFactory.addInterface(allClasses, methods2, ifaces[i2], names2);
        }
    }

    private static void addInterface(Set<Class> allClasses, Map<MethodKey, MethodData> methods2, Class iface, Set<String> names2) {
        if (allClasses.add(iface)) {
            JavaProxyClassFactory.addMethods(methods2, iface, names2);
            JavaProxyClassFactory.addInterfaces(allClasses, methods2, iface.getInterfaces(), names2);
        }
    }

    private static void addMethods(Map<MethodKey, MethodData> methods2, Class classOrIface, Set<String> names2) {
        Method[] decMethods = classOrIface.getDeclaredMethods();
        for (int i2 = 0; i2 < decMethods.length; ++i2) {
            Method decMethod = decMethods[i2];
            if (!names2.contains(decMethod.getName())) continue;
            JavaProxyClassFactory.addMethod(methods2, decMethod);
        }
    }

    private static void addMethod(Map<MethodKey, MethodData> methods2, Method method) {
        int mod = method.getModifiers();
        if (Modifier.isStatic(mod) || Modifier.isPrivate(mod)) {
            return;
        }
        MethodKey methodKey = new MethodKey(method);
        MethodData methodData = methods2.get(methodKey);
        if (methodData == null) {
            methodData = new MethodData(method);
            methods2.put(methodKey, methodData);
        }
        methodData.add(method);
    }

    private static void addClass(Set<Class> allClasses, Map<MethodKey, MethodData> methods2, Class clazz, Set<String> names2) {
        if (allClasses.add(clazz)) {
            JavaProxyClassFactory.addMethods(methods2, clazz, names2);
            Class superClass = clazz.getSuperclass();
            if (superClass != null) {
                JavaProxyClassFactory.addClass(allClasses, methods2, superClass, names2);
            }
            JavaProxyClassFactory.addInterfaces(allClasses, methods2, clazz.getInterfaces(), names2);
        }
    }

    private static void validateArgs(Ruby runtime, String targetClassName, Class superClass) {
        if (Modifier.isFinal(superClass.getModifiers())) {
            throw runtime.newTypeError("cannot extend final class " + superClass.getName());
        }
        if (!JavaProxyClassFactory.hasPublicOrProtectedConstructor(superClass)) {
            throw runtime.newTypeError("class " + superClass.getName() + " doesn't have a public or protected constructor");
        }
        String targetPackage = JavaProxyClassFactory.packageName(targetClassName);
        String packagePath = targetPackage.replace('.', '/');
        if (packagePath.startsWith("java")) {
            throw runtime.newTypeError("cannot add classes to package " + packagePath);
        }
        Package pkg = Package.getPackage(packagePath);
        if (pkg != null && pkg.isSealed()) {
            throw runtime.newTypeError("package " + pkg + " is sealed");
        }
    }

    private static boolean hasPublicOrProtectedConstructor(Class clazz) {
        Constructor<?>[] constructors2;
        for (Constructor<?> constructor2 : constructors2 = clazz.getDeclaredConstructors()) {
            int mod = constructor2.getModifiers();
            if (!Modifier.isPublic(mod) && !Modifier.isProtected(mod)) continue;
            return true;
        }
        return false;
    }

    private static String packageName(String clazzName) {
        int idx = clazzName.lastIndexOf(46);
        if (idx == -1) {
            return "";
        }
        return clazzName.substring(0, idx);
    }

    private static String proxyPackageName(Class clazz) {
        String clazzName = clazz.getName();
        int idx = clazzName.lastIndexOf(46);
        if (idx == -1) {
            return "org.jruby.proxy";
        }
        return "org.jruby.proxy." + clazzName.substring(0, idx);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.CONSTRUCTOR, ElementType.METHOD})
    public static @interface VarArgs {
    }

    static class MethodKey {
        private final String name;
        private final Class[] arguments;

        MethodKey(Method method) {
            this.name = method.getName();
            this.arguments = method.getParameterTypes();
        }

        public boolean equals(Object obj) {
            if (obj instanceof MethodKey) {
                MethodKey key2 = (MethodKey)obj;
                return this.name.equals(key2.name) && Arrays.equals(this.arguments, key2.arguments);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    static class MethodData {
        final Set<Method> methods = new HashSet<Method>();
        final Method mostSpecificMethod;
        final Class[] mostSpecificParameterTypes;

        MethodData(Method method) {
            this.mostSpecificMethod = method;
            this.mostSpecificParameterTypes = this.mostSpecificMethod.getParameterTypes();
        }

        public String scrambledSignature() {
            StringBuilder sb = new StringBuilder();
            Class[] parms = this.getParameterTypes();
            for (int i2 = 0; i2 < parms.length; ++i2) {
                sb.append('$');
                String name2 = parms[i2].getName();
                name2 = name2.replace('[', '1');
                name2 = name2.replace('.', '_');
                name2 = name2.replace(';', '2');
                sb.append(name2);
            }
            return sb.toString();
        }

        public Class getDeclaringClass() {
            return this.mostSpecificMethod.getDeclaringClass();
        }

        public org.jruby.org.objectweb.asm.commons.Method getMethod() {
            return new org.jruby.org.objectweb.asm.commons.Method(this.getName(), Type.getType(this.getReturnType()), this.getType(this.getParameterTypes()));
        }

        private Type[] getType(Class[] parameterTypes) {
            Type[] result2 = new Type[parameterTypes.length];
            for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
                result2[i2] = Type.getType(parameterTypes[i2]);
            }
            return result2;
        }

        private String getName() {
            return this.mostSpecificMethod.getName();
        }

        private Class[] getParameterTypes() {
            return this.mostSpecificParameterTypes;
        }

        public Class[] getExceptions() {
            HashSet exceptions = new HashSet();
            for (Method method : this.methods) {
                Class<?>[] exTypes = method.getExceptionTypes();
                for (int i2 = 0; i2 < exTypes.length; ++i2) {
                    Class<?> exType = exTypes[i2];
                    if (exceptions.contains(exType)) continue;
                    boolean add2 = true;
                    Iterator it = exceptions.iterator();
                    while (it.hasNext()) {
                        Class curType = (Class)it.next();
                        if (curType.isAssignableFrom(exType)) {
                            add2 = false;
                            break;
                        }
                        if (!exType.isAssignableFrom(curType)) continue;
                        it.remove();
                        add2 = true;
                    }
                    if (!add2) continue;
                    exceptions.add(exType);
                }
            }
            return exceptions.toArray(new Class[exceptions.size()]);
        }

        public boolean generateProxyMethod() {
            return !this.isFinal() && !this.isPrivate();
        }

        public void add(Method method) {
            this.methods.add(method);
        }

        Class getReturnType() {
            return this.mostSpecificMethod.getReturnType();
        }

        boolean isFinal() {
            if (this.mostSpecificMethod.getDeclaringClass().isInterface()) {
                return false;
            }
            return Modifier.isFinal(this.mostSpecificMethod.getModifiers());
        }

        boolean isPrivate() {
            if (this.mostSpecificMethod.getDeclaringClass().isInterface()) {
                return false;
            }
            return Modifier.isPrivate(this.mostSpecificMethod.getModifiers());
        }

        boolean isImplemented() {
            if (this.mostSpecificMethod.getDeclaringClass().isInterface()) {
                return false;
            }
            return !Modifier.isAbstract(this.mostSpecificMethod.getModifiers());
        }
    }
}

