/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.File;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.Channel;
import jnr.constants.platform.Fcntl;
import jnr.constants.platform.OpenFlags;
import jnr.constants.platform.SocketLevel;
import jnr.constants.platform.SocketOption;
import jnr.ffi.LastError;
import jnr.ffi.Runtime;
import jnr.unixsocket.UnixServerSocket;
import jnr.unixsocket.UnixServerSocketChannel;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.socket.RubyBasicSocket;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.io.ModeFlags;

@JRubyClass(name={"UNIXSocket"}, parent="BasicSocket")
public class RubyUNIXSocket
extends RubyBasicSocket {
    private static ObjectAllocator UNIXSOCKET_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyUNIXSocket(runtime, klass);
        }
    };
    protected static final int F_GETFL = Fcntl.F_GETFL.intValue();
    protected static final int F_SETFL = Fcntl.F_SETFL.intValue();
    protected static final int O_NONBLOCK = OpenFlags.O_NONBLOCK.intValue();

    static void createUNIXSocket(Ruby runtime) {
        RubyClass rb_cUNIXSocket = runtime.defineClass("UNIXSocket", runtime.getClass("BasicSocket"), UNIXSOCKET_ALLOCATOR);
        runtime.getObject().setConstant("UNIXsocket", rb_cUNIXSocket);
        rb_cUNIXSocket.defineAnnotatedMethods(RubyUNIXSocket.class);
    }

    public RubyUNIXSocket(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject path2) {
        this.init_unixsock(context.runtime, path2, false);
        return context.nil;
    }

    @JRubyMethod
    public IRubyObject path(ThreadContext context) {
        return RubyString.newEmptyString(context.runtime);
    }

    @JRubyMethod
    public IRubyObject addr(ThreadContext context) {
        Ruby runtime = context.runtime;
        return runtime.newArray((IRubyObject)runtime.newString("AF_UNIX"), (IRubyObject)RubyString.newEmptyString(runtime));
    }

    @JRubyMethod
    public IRubyObject peeraddr(ThreadContext context) {
        Ruby runtime = context.runtime;
        return runtime.newArray((IRubyObject)runtime.newString("AF_UNIX"), (IRubyObject)runtime.newString(this.openFile.getPath()));
    }

    @JRubyMethod(name={"recvfrom"}, required=1, optional=1)
    public IRubyObject recvfrom(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        IRubyObject _length = args2[0];
        IRubyObject _flags = args2.length == 2 ? args2[1] : runtime.getNil();
        _length = args2[0];
        if (_flags.isNil()) {
            boolean flags2 = false;
        } else {
            int flags3 = RubyNumeric.fix2int(_flags);
        }
        return runtime.newArray(this.recv(context, _length), this.peeraddr(context));
    }

    @JRubyMethod(notImplemented=true)
    public IRubyObject send_io(IRubyObject path2) {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(rest=true, notImplemented=true)
    public IRubyObject recv_io(IRubyObject[] args2) {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"socketpair", "pair"}, optional=2, meta=true)
    public static IRubyObject socketpair(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        try {
            UnixSocketChannel[] sp = UnixSocketChannel.pair();
            RubyUNIXSocket sock = (RubyUNIXSocket)Helpers.invoke(context, runtime.getClass("UNIXSocket"), "allocate");
            sock.init_sock(runtime, (Channel)sp[0], "");
            RubyUNIXSocket sock2 = (RubyUNIXSocket)Helpers.invoke(context, runtime.getClass("UNIXSocket"), "allocate");
            sock2.init_sock(runtime, (Channel)sp[1], "");
            return runtime.newArray((IRubyObject)sock, (IRubyObject)sock2);
        }
        catch (IOException ioe) {
            throw runtime.newIOErrorFromException(ioe);
        }
    }

    @Override
    public IRubyObject setsockopt(ThreadContext context, IRubyObject _level, IRubyObject _opt, IRubyObject val) {
        SocketLevel level2 = RubyUNIXSocket.levelFromArg(_level);
        SocketOption opt = RubyUNIXSocket.optionFromArg(_opt);
        block0 : switch (level2) {
            case SOL_SOCKET: {
                switch (opt) {
                    case SO_KEEPALIVE: {
                        break block0;
                    }
                }
                throw context.runtime.newErrnoENOPROTOOPTError();
            }
            default: {
                throw context.runtime.newErrnoENOPROTOOPTError();
            }
        }
        return context.runtime.newFixnum(0);
    }

    protected static void rb_sys_fail(Ruby runtime, String message2) {
        int n = LastError.getLastError(Runtime.getSystemRuntime());
        RubyClass instance = runtime.getErrno(n);
        if (instance == null) {
            throw runtime.newSystemCallError(message2);
        }
        throw runtime.newErrnoFromInt(n, message2);
    }

    protected void init_unixsock(Ruby runtime, IRubyObject _path, boolean server) {
        ByteList path2 = _path.convertToString().getByteList();
        String fpath = Helpers.decodeByteList(runtime, path2);
        int maxSize = 103;
        if (fpath.length() > 103) {
            throw runtime.newArgumentError("too long unix socket path (max: " + maxSize + "bytes)");
        }
        try {
            if (server) {
                UnixServerSocketChannel channel = UnixServerSocketChannel.open();
                UnixServerSocket socket2 = channel.socket();
                socket2.bind((SocketAddress)new UnixSocketAddress(new File(fpath)));
                this.init_sock(runtime, (Channel)channel, fpath);
            } else {
                File fpathFile = new File(fpath);
                if (!fpathFile.exists()) {
                    throw runtime.newErrnoENOENTError("unix socket");
                }
                UnixSocketChannel channel = UnixSocketChannel.open();
                channel.connect(new UnixSocketAddress(fpathFile));
                this.init_sock(runtime, (Channel)channel);
            }
        }
        catch (IOException ioe) {
            throw runtime.newIOErrorFromException(ioe);
        }
    }

    protected void init_sock(Ruby runtime, Channel channel, String path2) {
        this.MakeOpenFile();
        ModeFlags modes = RubyUNIXSocket.newModeFlags(runtime, ModeFlags.RDWR);
        this.openFile.setFD(RubyUNIXSocket.newChannelFD(runtime, channel));
        this.openFile.setMode(modes.getOpenFileFlags());
        this.openFile.setSync(true);
        this.openFile.setPath(path2);
    }

    protected void init_sock(Ruby runtime, Channel channel) {
        this.init_sock(runtime, channel, null);
    }

    private UnixSocketChannel asUnixSocket() {
        return (UnixSocketChannel)this.getOpenFile().fd().ch;
    }
}

