/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import java.io.IOException;
import java.io.OutputStream;
import org.jruby.Ruby;
import org.jruby.runtime.Helpers;

public class RubyOutputStream {
    private final Ruby runtime;
    private final OutputStream wrap;

    public RubyOutputStream(Ruby runtime2, OutputStream wrap2) {
        this.runtime = runtime2;
        this.wrap = wrap2;
    }

    public void write(int b2) {
        try {
            this.wrap.write(b2);
        }
        catch (IOException ioe) {
            this.handle(ioe);
        }
    }

    public void write(byte[] b2, int off, int len) {
        try {
            this.wrap.write(b2, off, len);
        }
        catch (IOException ioe) {
            this.handle(ioe);
        }
    }

    public void write(byte[] b2) {
        try {
            this.wrap.write(b2);
        }
        catch (IOException ioe) {
            this.handle(ioe);
        }
    }

    public void flush() {
        try {
            this.wrap.flush();
        }
        catch (IOException ioe) {
            this.handle(ioe);
        }
    }

    public void close() {
        try {
            this.wrap.close();
        }
        catch (IOException ioe) {
            this.handle(ioe);
        }
    }

    private void handle(IOException ioe) {
        throw Helpers.newIOErrorFromException(this.runtime, ioe);
    }
}

