/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.ext.ripper.RubyLexer;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.RubyStringBuilder;

@JRubyClass(name={"Binding"})
public class RubyBinding
extends RubyObject {
    private Binding binding;

    public RubyBinding(Ruby runtime2, RubyClass rubyClass, Binding binding2) {
        super(runtime2, rubyClass);
        this.binding = binding2;
    }

    private RubyBinding(Ruby runtime2, RubyClass rubyClass) {
        super(runtime2, rubyClass);
    }

    public static RubyClass createBindingClass(ThreadContext context, RubyClass Object2) {
        return ((RubyModule)((RubyModule)Define.defineClass(context, "Binding", Object2, RubyBinding::new).reifiedClass(RubyBinding.class)).classIndex(ClassIndex.BINDING)).defineMethods(context, RubyBinding.class).tap(c -> c.singletonClass(context).undefMethods(context, "new"));
    }

    public Binding getBinding() {
        return this.binding;
    }

    public static RubyBinding newBinding(Ruby runtime2, Binding binding2) {
        return new RubyBinding(runtime2, runtime2.getBinding(), binding2);
    }

    @Deprecated
    public static RubyBinding newBinding(Ruby runtime2) {
        return RubyBinding.newBinding(runtime2, runtime2.getCurrentContext().currentBinding());
    }

    @Deprecated
    public static RubyBinding newBinding(Ruby runtime2, IRubyObject self2) {
        return RubyBinding.newBinding(runtime2, runtime2.getCurrentContext().currentBinding(self2));
    }

    @Override
    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context) {
        this.binding = context.currentBinding();
        return this;
    }

    @Override
    @JRubyMethod
    public IRubyObject dup(ThreadContext context) {
        RubyBinding newBinding = RubyBinding.newBinding(context.runtime, this.binding.dup(context));
        this.copyInstanceVariablesInto(newBinding);
        return newBinding;
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(ThreadContext context, IRubyObject other) {
        this.binding = ((RubyBinding)other).binding.clone();
        return this;
    }

    @JRubyMethod(name={"eval"}, required=1, optional=2, checkArity=false)
    public IRubyObject eval(ThreadContext context, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 1, 3);
        IRubyObject[] newArgs = new IRubyObject[argc + 1];
        newArgs[0] = args2[0];
        newArgs[1] = this;
        if (argc > 1) {
            newArgs[2] = args2[1];
            if (argc > 2) {
                newArgs[3] = args2[2];
            }
        }
        return RubyKernel.eval(context, this, newArgs, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"local_variable_defined?"})
    public IRubyObject local_variable_defined_p(ThreadContext context, IRubyObject symbol) {
        String id2 = this.checkLocalId(context, symbol);
        return Convert.asBoolean(context, this.binding.getEvalScope(context.runtime).getStaticScope().isDefined(id2) != -1);
    }

    @JRubyMethod
    public IRubyObject local_variable_get(ThreadContext context, IRubyObject symbol) {
        String id2 = this.checkLocalId(context, symbol);
        DynamicScope evalScope = this.binding.getEvalScope(context.runtime);
        int slot = evalScope.getStaticScope().isDefined(id2);
        if (slot == -1) {
            throw Error.nameError(context, RubyStringBuilder.str(context.runtime, "local variable '", symbol, "' not defined for " + String.valueOf(this.inspect(context))), symbol);
        }
        return evalScope.getValueOrNil(slot & 0xFFFF, slot >> 16, context.nil);
    }

    @JRubyMethod
    public IRubyObject local_variable_set(ThreadContext context, IRubyObject symbol, IRubyObject value2) {
        String id2 = this.checkLocalId(context, symbol);
        DynamicScope evalScope = this.binding.getEvalScope(context.runtime);
        int slot = evalScope.getStaticScope().isDefined(id2);
        if (slot == -1) {
            slot = evalScope.getStaticScope().addVariable(id2.intern());
            evalScope.growIfNeeded();
        }
        return evalScope.setValue(slot & 0xFFFF, value2, slot >> 16);
    }

    private String checkLocalId(ThreadContext context, IRubyObject obj) {
        String id2 = RubySymbol.idStringFromObject(context, obj);
        if (!RubyLexer.isIdentifierChar(id2.charAt(0))) {
            throw Error.nameError(context, RubyStringBuilder.str(context.runtime, "wrong local variable name '", obj, "' for ", this), id2);
        }
        return id2;
    }

    @JRubyMethod
    public IRubyObject local_variables(ThreadContext context) {
        return this.binding.getEvalScope(context.runtime).getStaticScope().getLocalVariables(context);
    }

    @JRubyMethod(name={"receiver"})
    public IRubyObject receiver(ThreadContext context) {
        return this.binding.getSelf();
    }

    @JRubyMethod
    public IRubyObject source_location(ThreadContext context) {
        IRubyObject filename2 = Create.newString(context, this.binding.getFile()).freeze(context);
        RubyFixnum line = Convert.asFixnum(context, this.binding.getLine() + 1);
        return Create.newArray(context, filename2, (IRubyObject)line);
    }
}

