/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jruby.RubyInstanceConfig;
import org.jruby.util.ClassDefiningClassLoader;
import org.jruby.util.JRubyClassLoader;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class ClassCache<T> {
    private static final Logger LOG = LoggerFactory.getLogger("ClassCache");
    private final AtomicInteger classLoadCount = new AtomicInteger(0);
    private final AtomicInteger classReuseCount = new AtomicInteger(0);
    private final ReferenceQueue referenceQueue = new ReferenceQueue();
    private final Map<Object, KeyedClassReference> cache = new ConcurrentHashMap<Object, KeyedClassReference>();
    private final ClassLoader classLoader;
    private final int max;

    public ClassCache(ClassLoader classLoader, int max2) {
        assert (classLoader != null) : "Null classloader provided for ClassCache";
        this.classLoader = classLoader;
        this.max = max2;
    }

    public ClassCache(ClassLoader classLoader) {
        this(classLoader, -1);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public int getMax() {
        return this.max;
    }

    public Class<T> cacheClassByKey(Object key2, ClassGenerator classGenerator) throws ClassNotFoundException {
        Class<T> contents = null;
        if (RubyInstanceConfig.JIT_CACHE_ENABLED) {
            WeakReference weakRef = this.cache.get(key2);
            if (weakRef != null) {
                contents = (Class<T>)weakRef.get();
            }
            if (weakRef == null || contents == null) {
                if (((Boolean)Options.JIT_DEBUG.load()).booleanValue()) {
                    LOG.info("JITed code for key " + key2 + " not found, recaching", new Object[0]);
                }
                if (this.isFull()) {
                    return null;
                }
                contents = this.defineClass(classGenerator);
                this.cleanup();
                this.cache.put(key2, new KeyedClassReference<T>(key2, contents, this.referenceQueue));
            } else {
                if (((Boolean)Options.JIT_DEBUG.load()).booleanValue()) {
                    LOG.info("JITed code for key " + key2 + " found as class " + contents.getName(), new Object[0]);
                }
                this.classReuseCount.incrementAndGet();
            }
        } else {
            contents = this.defineClass(classGenerator);
        }
        return contents;
    }

    protected Class<T> defineClass(ClassGenerator classGenerator) {
        OneShotClassLoader oneShotCL = new OneShotClassLoader(this.getClassLoader());
        classGenerator.generate();
        Class<?> contents = oneShotCL.defineClass(classGenerator.name(), classGenerator.bytecode());
        this.classLoadCount.incrementAndGet();
        return contents;
    }

    public void flush() {
        this.cache.clear();
    }

    public boolean isFull() {
        this.cleanup();
        return this.max > 0 && this.cache.size() >= this.max;
    }

    public int getClassLoadCount() {
        return this.classLoadCount.get();
    }

    public int getLiveClassCount() {
        this.cleanup();
        return this.cache.size();
    }

    public int getClassReuseCount() {
        return this.classReuseCount.get();
    }

    private void cleanup() {
        KeyedClassReference reference2;
        while ((reference2 = (KeyedClassReference)this.referenceQueue.poll()) != null) {
            this.cache.remove(reference2.getKey());
        }
    }

    public static class OneShotClassLoader
    extends ClassLoader
    implements ClassDefiningClassLoader {
        private static final ProtectionDomain DEFAULT_DOMAIN = JRubyClassLoader.class.getProtectionDomain();

        public OneShotClassLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        public Class<?> defineClass(String name2, byte[] bytes2) {
            return super.defineClass(name2, bytes2, 0, bytes2.length, DEFAULT_DOMAIN);
        }
    }

    private static class KeyedClassReference<T>
    extends WeakReference<Class<T>> {
        private final Object key;

        public KeyedClassReference(Object key2, Class<T> referent, ReferenceQueue<Class<T>> referenceQueue) {
            super(referent, referenceQueue);
            this.key = key2;
        }

        public Object getKey() {
            return this.key;
        }
    }

    public static interface ClassGenerator {
        public void generate();

        public byte[] bytecode();

        public String name();
    }
}

