/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.channels.Channel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubySystemExit;
import org.jruby.RubyThreadGroup;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.ThreadKill;
import org.jruby.internal.runtime.FutureThread;
import org.jruby.internal.runtime.NativeThread;
import org.jruby.internal.runtime.RubyRunnable;
import org.jruby.internal.runtime.ThreadLike;
import org.jruby.internal.runtime.ThreadService;
import org.jruby.internal.runtime.ThreadedRunnable;
import org.jruby.java.proxies.ConcreteJavaProxy;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.ExecutionContext;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.backtrace.RubyStackTraceElement;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.cli.Options;
import org.jruby.util.io.BlockingIO;
import org.jruby.util.io.SelectorFactory;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

@JRubyClass(name={"Thread"})
public class RubyThread
extends RubyObject
implements ExecutionContext {
    private static final Logger LOG = LoggerFactory.getLogger("RubyThread");
    private ThreadLike threadImpl;
    private transient Map<IRubyObject, IRubyObject> threadLocalVariables;
    private final Map<Object, IRubyObject> contextVariables = new WeakHashMap<Object, IRubyObject>();
    private boolean abortOnException;
    private IRubyObject finalResult;
    private RaiseException exitingException;
    private RubyThreadGroup threadGroup;
    private IRubyObject errorInfo;
    private volatile WeakReference<ThreadContext> contextRef;
    private static final boolean DEBUG = false;
    private int RUBY_MIN_THREAD_PRIORITY = -3;
    private int RUBY_MAX_THREAD_PRIORITY = 3;
    private final AtomicReference<Status> status = new AtomicReference<Status>(Status.RUN);
    private final AtomicReference<ThreadService.Event> mail = new AtomicReference();
    private volatile BlockingTask currentBlockingTask;
    private final List<Lock> heldLocks = new Vector<Lock>();
    private volatile boolean disposed = false;
    private int initialPriority;
    private volatile Selector currentSelector;
    private volatile BlockingIO.Condition blockingIO = null;

    protected RubyThread(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
        this.finalResult = runtime.getNil();
        this.errorInfo = runtime.getNil();
    }

    public RubyThread(Ruby runtime, RubyClass klass, ThreadedRunnable runnable) {
        this(runtime, klass);
        this.startWith(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveMail(ThreadService.Event event2) {
        RubyThread rubyThread = this;
        synchronized (rubyThread) {
            if (this.status.get() == Status.ABORTING) {
                return;
            }
            this.mail.set(event2);
            switch (event2.type) {
                case KILL: {
                    this.status.set(Status.ABORTING);
                }
            }
            this.notify();
        }
        this.interrupt();
    }

    public void checkMail(ThreadContext context) {
        ThreadService.Event myEvent = this.mail.getAndSet(null);
        if (myEvent != null) {
            switch (myEvent.type) {
                case RAISE: {
                    this.receivedAnException(context, myEvent.exception);
                }
                case KILL: {
                    RubyThread.throwThreadKill();
                }
            }
        }
    }

    public IRubyObject getErrorInfo() {
        return this.errorInfo;
    }

    public IRubyObject setErrorInfo(IRubyObject errorInfo) {
        this.errorInfo = errorInfo;
        return errorInfo;
    }

    public void setContext(ThreadContext context) {
        this.contextRef = new WeakReference<ThreadContext>(context);
    }

    public ThreadContext getContext() {
        return this.contextRef == null ? null : (ThreadContext)this.contextRef.get();
    }

    public Thread getNativeThread() {
        return this.threadImpl.nativeThread();
    }

    public void beforeStart() {
        this.initialPriority = Thread.currentThread().getPriority();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.disposed) {
            return;
        }
        RubyThread rubyThread = this;
        synchronized (rubyThread) {
            if (this.disposed) {
                return;
            }
            this.disposed = true;
            this.threadGroup.remove(this);
            this.unlockAll();
            if (((Boolean)Options.THREADPOOL_ENABLED.load()).booleanValue()) {
                this.threadImpl.setPriority(this.initialPriority);
            }
            this.beDead();
        }
        this.getRuntime().getThreadService().unregisterThread(this);
    }

    public static RubyClass createThreadClass(Ruby runtime) {
        RubyClass threadClass = runtime.defineClass("Thread", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime.setThread(threadClass);
        threadClass.index = 29;
        threadClass.setReifiedClass(RubyThread.class);
        threadClass.defineAnnotatedMethods(RubyThread.class);
        RubyThread rubyThread = new RubyThread(runtime, threadClass);
        rubyThread.threadImpl = new NativeThread(rubyThread, Thread.currentThread());
        runtime.getThreadService().setMainThread(Thread.currentThread(), rubyThread);
        runtime.getDefaultThreadGroup().addDirectly(rubyThread);
        threadClass.setMarshal(ObjectMarshal.NOT_MARSHALABLE_MARSHAL);
        if (runtime.is2_0()) {
            RubyClass backtrace2 = threadClass.defineClassUnder("Backtrace", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
            RubyClass location = backtrace2.defineClassUnder("Location", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
            location.defineAnnotatedMethods(Location.class);
            runtime.setLocation(location);
        }
        return threadClass;
    }

    @JRubyMethod(name={"new", "fork"}, rest=true, meta=true)
    public static IRubyObject newInstance(IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyThread.startThread(recv2, args2, true, block);
    }

    @JRubyMethod(rest=true, meta=true, compat=CompatVersion.RUBY1_8)
    public static RubyThread start(IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyThread.startThread(recv2, args2, false, block);
    }

    @JRubyMethod(rest=true, name={"start"}, meta=true, compat=CompatVersion.RUBY1_9)
    public static RubyThread start19(IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime = recv2.getRuntime();
        if (!block.isGiven()) {
            throw runtime.newArgumentError("tried to create Proc object without a block");
        }
        return RubyThread.startThread(recv2, args2, false, block);
    }

    public static RubyThread adopt(IRubyObject recv2, Thread t) {
        return RubyThread.adoptThread(recv2, t, Block.NULL_BLOCK);
    }

    private static RubyThread adoptThread(IRubyObject recv2, Thread t, Block block) {
        Ruby runtime = recv2.getRuntime();
        RubyThread rubyThread = new RubyThread(runtime, (RubyClass)recv2);
        rubyThread.threadImpl = new NativeThread(rubyThread, t);
        ThreadContext context = runtime.getThreadService().registerNewThread(rubyThread);
        runtime.getThreadService().associateThread(t, rubyThread);
        context.preAdoptThread();
        runtime.getDefaultThreadGroup().addDirectly(rubyThread);
        return rubyThread;
    }

    @JRubyMethod(rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2, Block block) {
        Ruby runtime = this.getRuntime();
        if (!block.isGiven()) {
            throw runtime.newThreadError("must be called with a block");
        }
        if (this.threadImpl != null) {
            throw runtime.newThreadError("already initialized thread");
        }
        RubyRunnable runnable = new RubyRunnable(this, args2, block);
        return this.startWith(runnable);
    }

    private IRubyObject startWith(ThreadedRunnable runnable) throws RaiseException, OutOfMemoryError {
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        try {
            if (RubyInstanceConfig.POOLING_ENABLED) {
                FutureThread futureThread = new FutureThread(this, runnable);
                this.threadImpl = futureThread;
                this.addToCorrectThreadGroup(context);
                this.threadImpl.start();
                runtime.getThreadService().associateThread(futureThread.getFuture(), this);
            } else {
                Thread thread2 = new Thread(runnable);
                thread2.setDaemon(true);
                thread2.setName("Ruby-" + runtime.getRuntimeNumber() + "-" + thread2.getName() + ": " + context.getFile() + ":" + (context.getLine() + 1));
                this.threadImpl = new NativeThread(this, thread2);
                this.addToCorrectThreadGroup(context);
                runtime.getThreadService().associateThread(thread2, this);
                this.threadImpl.start();
            }
            Thread.yield();
            return this;
        }
        catch (OutOfMemoryError oome) {
            if (oome.getMessage().equals("unable to create new native thread")) {
                throw runtime.newThreadError(oome.getMessage());
            }
            throw oome;
        }
        catch (SecurityException ex) {
            throw runtime.newThreadError(ex.getMessage());
        }
    }

    private static RubyThread startThread(IRubyObject recv2, IRubyObject[] args2, boolean callInit, Block block) {
        RubyThread rubyThread = new RubyThread(recv2.getRuntime(), (RubyClass)recv2);
        if (callInit) {
            rubyThread.callInit(args2, block);
        } else {
            rubyThread.initialize(recv2.getRuntime().getCurrentContext(), args2, block);
        }
        return rubyThread;
    }

    public synchronized void cleanTerminate(IRubyObject result2) {
        this.finalResult = result2;
    }

    public synchronized void beDead() {
        this.status.set(Status.DEAD);
    }

    public void pollThreadEvents() {
        this.pollThreadEvents(this.getRuntime().getCurrentContext());
    }

    public void pollThreadEvents(ThreadContext context) {
        if (this.mail != null) {
            this.checkMail(context);
        }
    }

    private static void throwThreadKill() {
        throw new ThreadKill();
    }

    @JRubyMethod(name={"abort_on_exception"}, meta=true)
    public static RubyBoolean abort_on_exception_x(IRubyObject recv2) {
        Ruby runtime = recv2.getRuntime();
        return runtime.isGlobalAbortOnExceptionEnabled() ? runtime.getTrue() : runtime.getFalse();
    }

    @JRubyMethod(name={"abort_on_exception="}, required=1, meta=true)
    public static IRubyObject abort_on_exception_set_x(IRubyObject recv2, IRubyObject value2) {
        recv2.getRuntime().setGlobalAbortOnExceptionEnabled(value2.isTrue());
        return value2;
    }

    @JRubyMethod(name={"current"}, meta=true)
    public static RubyThread current(IRubyObject recv2) {
        return recv2.getRuntime().getCurrentContext().getThread();
    }

    @JRubyMethod(name={"main"}, meta=true)
    public static RubyThread main(IRubyObject recv2) {
        return recv2.getRuntime().getThreadService().getMainThread();
    }

    @JRubyMethod(name={"pass"}, meta=true)
    public static IRubyObject pass(IRubyObject recv2) {
        Ruby runtime = recv2.getRuntime();
        ThreadService ts = runtime.getThreadService();
        boolean critical2 = ts.getCritical();
        ts.setCritical(false);
        Thread.yield();
        ts.setCritical(critical2);
        return recv2.getRuntime().getNil();
    }

    @JRubyMethod(name={"list"}, meta=true)
    public static RubyArray list(IRubyObject recv2) {
        IRubyObject[] activeThreads = recv2.getRuntime().getThreadService().getActiveRubyThreads();
        return recv2.getRuntime().newArrayNoCopy(activeThreads);
    }

    private void addToCorrectThreadGroup(ThreadContext context) {
        IRubyObject group2 = context.getThread().group();
        if (!group2.isNil()) {
            ((RubyThreadGroup)group2).addDirectly(this);
        } else {
            context.runtime.getDefaultThreadGroup().addDirectly(this);
        }
    }

    private IRubyObject getSymbolKey(IRubyObject originalKey) {
        if (originalKey instanceof RubySymbol) {
            return originalKey;
        }
        if (originalKey instanceof RubyString) {
            return this.getRuntime().newSymbol(originalKey.asJavaString());
        }
        if (originalKey instanceof RubyFixnum) {
            this.getRuntime().getWarnings().warn(IRubyWarnings.ID.FIXNUMS_NOT_SYMBOLS, "Do not use Fixnums as Symbols");
            throw this.getRuntime().newArgumentError(originalKey + " is not a symbol");
        }
        throw this.getRuntime().newTypeError(originalKey + " is not a symbol");
    }

    private synchronized Map<IRubyObject, IRubyObject> getThreadLocals() {
        if (this.threadLocalVariables == null) {
            this.threadLocalVariables = new HashMap<IRubyObject, IRubyObject>();
        }
        return this.threadLocalVariables;
    }

    private void clearThreadLocals() {
        this.threadLocalVariables = null;
    }

    @Override
    public final Map<Object, IRubyObject> getContextVariables() {
        return this.contextVariables;
    }

    public boolean isAlive() {
        return this.threadImpl.isAlive() && this.status.get() != Status.ABORTING;
    }

    @JRubyMethod(name={"[]"}, required=1)
    public IRubyObject op_aref(IRubyObject key2) {
        IRubyObject value2 = this.getThreadLocals().get(this.getSymbolKey(key2));
        if (value2 != null) {
            return value2;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"[]="}, required=2)
    public IRubyObject op_aset(IRubyObject key2, IRubyObject value2) {
        key2 = this.getSymbolKey(key2);
        this.getThreadLocals().put(key2, value2);
        return value2;
    }

    @JRubyMethod(name={"abort_on_exception"})
    public RubyBoolean abort_on_exception() {
        return this.abortOnException ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"abort_on_exception="}, required=1)
    public IRubyObject abort_on_exception_set(IRubyObject val) {
        this.abortOnException = val.isTrue();
        return val;
    }

    @JRubyMethod(name={"alive?"})
    public RubyBoolean alive_p() {
        return this.isAlive() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"join"}, optional=1)
    public IRubyObject join(IRubyObject[] args2) {
        block16: {
            Ruby runtime = this.getRuntime();
            long timeoutMillis = Long.MAX_VALUE;
            if (args2.length > 0 && !args2[0].isNil()) {
                if (args2.length > 1) {
                    throw this.getRuntime().newArgumentError(args2.length, 1);
                }
                timeoutMillis = (long)(1000.0 * args2[0].convertToFloat().getValue());
                if (timeoutMillis <= 0L) {
                    if (this.threadImpl.isAlive()) {
                        return this.getRuntime().getNil();
                    }
                    return this;
                }
            }
            if (this.isCurrent()) {
                throw this.getRuntime().newThreadError("thread " + this.identityString() + " tried to join itself");
            }
            try {
                if (runtime.getThreadService().getCritical()) {
                    RubyThread rubyThread = this;
                    synchronized (rubyThread) {
                        this.notify();
                    }
                }
                RubyThread currentThread = this.getRuntime().getCurrentContext().getThread();
                long timeToWait = Math.min(timeoutMillis, 200L);
                long start2 = System.currentTimeMillis();
                do {
                    currentThread.pollThreadEvents();
                    this.threadImpl.join(timeToWait);
                } while (this.threadImpl.isAlive() && System.currentTimeMillis() - start2 <= timeoutMillis);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
                assert (false) : ie;
            }
            catch (ExecutionException ie) {
                ie.printStackTrace();
                if ($assertionsDisabled) break block16;
                throw new AssertionError((Object)ie);
            }
        }
        if (this.exitingException != null) {
            this.getRuntime().getGlobalVariables().set("$!", this.exitingException.getException());
            throw this.exitingException;
        }
        if (this.threadImpl.isAlive()) {
            return this.getRuntime().getNil();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod
    public IRubyObject value() {
        this.join(new IRubyObject[0]);
        RubyThread rubyThread = this;
        synchronized (rubyThread) {
            return this.finalResult;
        }
    }

    @JRubyMethod
    public IRubyObject group() {
        if (this.threadGroup == null) {
            return this.getRuntime().getNil();
        }
        return this.threadGroup;
    }

    void setThreadGroup(RubyThreadGroup rubyThreadGroup) {
        this.threadGroup = rubyThreadGroup;
    }

    @Override
    @JRubyMethod(name={"inspect"})
    public synchronized IRubyObject inspect() {
        StringBuilder part = new StringBuilder();
        String cname = this.getMetaClass().getRealClass().getName();
        part.append("#<").append(cname).append(":");
        part.append(this.identityString());
        part.append(' ');
        part.append(this.status.toString().toLowerCase());
        part.append('>');
        return this.getRuntime().newString(part.toString());
    }

    @JRubyMethod(name={"key?"}, required=1)
    public RubyBoolean key_p(IRubyObject key2) {
        key2 = this.getSymbolKey(key2);
        return this.getRuntime().newBoolean(this.getThreadLocals().containsKey(key2));
    }

    @JRubyMethod(name={"keys"})
    public RubyArray keys() {
        IRubyObject[] keys2 = new IRubyObject[this.getThreadLocals().size()];
        return RubyArray.newArrayNoCopy(this.getRuntime(), this.getThreadLocals().keySet().toArray(keys2));
    }

    @JRubyMethod(name={"critical="}, required=1, meta=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject critical_set(IRubyObject receiver2, IRubyObject value2) {
        receiver2.getRuntime().getThreadService().setCritical(value2.isTrue());
        return value2;
    }

    @JRubyMethod(name={"critical"}, meta=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject critical(IRubyObject receiver2) {
        return receiver2.getRuntime().newBoolean(receiver2.getRuntime().getThreadService().getCritical());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"stop"}, meta=true)
    public static IRubyObject stop(ThreadContext context, IRubyObject receiver2) {
        RubyThread rubyThread;
        RubyThread rubyThread2 = rubyThread = context.getThread();
        synchronized (rubyThread2) {
            rubyThread.checkMail(context);
            try {
                receiver2.getRuntime().getThreadService().setCritical(false);
                rubyThread.status.set(Status.SLEEP);
                rubyThread.wait();
            }
            catch (InterruptedException ie) {
                rubyThread.checkMail(context);
                rubyThread.status.set(Status.RUN);
            }
        }
        return receiver2.getRuntime().getNil();
    }

    @JRubyMethod(required=1, meta=true)
    public static IRubyObject kill(IRubyObject receiver2, IRubyObject rubyThread, Block block) {
        if (!(rubyThread instanceof RubyThread)) {
            throw receiver2.getRuntime().newTypeError(rubyThread, receiver2.getRuntime().getThread());
        }
        return ((RubyThread)rubyThread).kill();
    }

    @JRubyMethod(meta=true)
    public static IRubyObject exit(IRubyObject receiver2, Block block) {
        RubyThread rubyThread;
        RubyThread rubyThread2 = rubyThread = receiver2.getRuntime().getThreadService().getCurrentContext().getThread();
        synchronized (rubyThread2) {
            rubyThread.status.set(Status.ABORTING);
            rubyThread.mail.set(null);
            receiver2.getRuntime().getThreadService().setCritical(false);
            throw new ThreadKill();
        }
    }

    @JRubyMethod(name={"stop?"})
    public RubyBoolean stop_p() {
        return this.getRuntime().newBoolean(this.status.get() == Status.SLEEP || this.status.get() == Status.DEAD);
    }

    @JRubyMethod(name={"wakeup"})
    public synchronized RubyThread wakeup() {
        if (!this.threadImpl.isAlive() && this.status.get() == Status.DEAD) {
            throw this.getRuntime().newThreadError("killed thread");
        }
        this.status.set(Status.RUN);
        this.notifyAll();
        return this;
    }

    @JRubyMethod(name={"priority"})
    public RubyFixnum priority() {
        return RubyFixnum.newFixnum(this.getRuntime(), this.javaPriorityToRubyPriority(this.threadImpl.getPriority()));
    }

    @JRubyMethod(name={"priority="}, required=1)
    public IRubyObject priority_set(IRubyObject priority2) {
        int iPriority = RubyNumeric.fix2int(priority2);
        if (iPriority < this.RUBY_MIN_THREAD_PRIORITY) {
            iPriority = this.RUBY_MIN_THREAD_PRIORITY;
        } else if (iPriority > this.RUBY_MAX_THREAD_PRIORITY) {
            iPriority = this.RUBY_MAX_THREAD_PRIORITY;
        }
        if (this.threadImpl.isAlive()) {
            int jPriority = this.rubyPriorityToJavaPriority(iPriority);
            if (jPriority < 1) {
                jPriority = 1;
            } else if (jPriority > 10) {
                jPriority = 10;
            }
            this.threadImpl.setPriority(jPriority);
        }
        return RubyFixnum.newFixnum(this.getRuntime(), iPriority);
    }

    private int javaPriorityToRubyPriority(int javaPriority) {
        double d = 1.5 * Math.sqrt(8.0 * (double)javaPriority + 41.0) - 13.5;
        return Math.round((float)d);
    }

    private int rubyPriorityToJavaPriority(int rubyPriority) {
        if (rubyPriority < this.RUBY_MIN_THREAD_PRIORITY) {
            rubyPriority = this.RUBY_MIN_THREAD_PRIORITY;
        } else if (rubyPriority > this.RUBY_MAX_THREAD_PRIORITY) {
            rubyPriority = this.RUBY_MAX_THREAD_PRIORITY;
        }
        double d = Math.pow(rubyPriority, 2.0) / 18.0 + 1.5 * (double)rubyPriority + 5.0;
        return Math.round((float)d);
    }

    public IRubyObject raise(IRubyObject exception2) {
        return this.raise(new IRubyObject[]{exception2}, Block.NULL_BLOCK);
    }

    @JRubyMethod(optional=3)
    public IRubyObject raise(IRubyObject[] args2, Block block) {
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        if (this == context.getThread()) {
            return RubyKernel.raise(context, runtime.getKernel(), args2, block);
        }
        RubyThread.debug(this, "before raising");
        RubyThread currentThread = this.getRuntime().getCurrentContext().getThread();
        RubyThread.debug(this, "raising");
        IRubyObject exception2 = this.prepareRaiseException(runtime, args2, block);
        runtime.getThreadService().deliverEvent(new ThreadService.Event(currentThread, this, ThreadService.Event.Type.RAISE, exception2));
        return this;
    }

    public void internalRaise(IRubyObject[] args2) {
        Ruby runtime = this.getRuntime();
        IRubyObject exception2 = this.prepareRaiseException(runtime, args2, Block.NULL_BLOCK);
        this.receiveMail(new ThreadService.Event(this, this, ThreadService.Event.Type.RAISE, exception2));
    }

    private IRubyObject prepareRaiseException(Ruby runtime, IRubyObject[] args2, Block block) {
        IRubyObject exception2;
        if (args2.length == 0) {
            IRubyObject lastException = this.errorInfo;
            if (lastException.isNil()) {
                return new RaiseException(runtime, runtime.getRuntimeError(), "", false).getException();
            }
            return lastException;
        }
        ThreadContext context = this.getRuntime().getCurrentContext();
        if (args2.length == 1) {
            if (args2[0] instanceof RubyString) {
                return runtime.getRuntimeError().newInstance(context, args2, block);
            }
            if (args2[0] instanceof ConcreteJavaProxy) {
                return args2[0];
            }
            if (!args2[0].respondsTo("exception")) {
                return runtime.newTypeError("exception class/object expected").getException();
            }
            exception2 = args2[0].callMethod(context, "exception");
        } else {
            if (!args2[0].respondsTo("exception")) {
                return runtime.newTypeError("exception class/object expected").getException();
            }
            exception2 = args2[0].callMethod(context, "exception", args2[1]);
        }
        if (!runtime.getException().isInstance(exception2)) {
            return runtime.newTypeError("exception object expected").getException();
        }
        if (args2.length == 3) {
            ((RubyException)exception2).set_backtrace(args2[2]);
        }
        return exception2;
    }

    @JRubyMethod(name={"run"})
    public synchronized IRubyObject run() {
        return this.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean sleep(long millis) throws InterruptedException {
        assert (this == this.getRuntime().getCurrentContext().getThread());
        boolean result2 = true;
        RubyThread rubyThread = this;
        synchronized (rubyThread) {
            this.pollThreadEvents();
            try {
                this.status.set(Status.SLEEP);
                if (millis == -1L) {
                    this.wait();
                } else {
                    this.wait(millis);
                }
                result2 = this.status.get() != Status.RUN;
            }
            catch (Throwable throwable) {
                result2 = this.status.get() != Status.RUN;
                this.pollThreadEvents();
                this.status.set(Status.RUN);
                throw throwable;
            }
            this.pollThreadEvents();
            this.status.set(Status.RUN);
        }
        return result2;
    }

    public IRubyObject status() {
        return this.status(this.getRuntime());
    }

    @JRubyMethod(name={"status"})
    public IRubyObject status(ThreadContext context) {
        return this.status(context.runtime);
    }

    private synchronized IRubyObject status(Ruby runtime) {
        if (this.threadImpl.isAlive()) {
            return RubyString.newStringShared(runtime, this.status.get().bytes);
        }
        if (this.exitingException != null) {
            return runtime.getNil();
        }
        return runtime.getFalse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeBlockingTask(BlockingTask task) throws InterruptedException {
        this.enterSleep();
        try {
            this.currentBlockingTask = task;
            this.pollThreadEvents();
            task.run();
        }
        finally {
            this.exitSleep();
            this.currentBlockingTask = null;
            this.pollThreadEvents();
        }
    }

    public void enterSleep() {
        this.status.set(Status.SLEEP);
    }

    public void exitSleep() {
        this.status.set(Status.RUN);
    }

    @JRubyMethod(name={"kill", "exit", "terminate"})
    public IRubyObject kill() {
        RubyThread currentThread = this.getRuntime().getCurrentContext().getThread();
        if (currentThread == this) {
            RubyThread.throwThreadKill();
        }
        RubyThread.debug(this, "trying to kill");
        currentThread.pollThreadEvents();
        this.getRuntime().getThreadService().deliverEvent(new ThreadService.Event(currentThread, this, ThreadService.Event.Type.KILL));
        RubyThread.debug(this, "succeeded with kill");
        return this;
    }

    public void dieFromFinalizer() {
        this.receiveMail(new ThreadService.Event(null, this, ThreadService.Event.Type.KILL));
    }

    private static void debug(RubyThread thread2, String message2) {
    }

    @JRubyMethod(name={"kill!", "exit!", "terminate!"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject kill_bang() {
        throw this.getRuntime().newNotImplementedError("Thread#kill!, exit!, and terminate! are not safe and not supported");
    }

    @JRubyMethod(name={"safe_level"})
    public IRubyObject safe_level() {
        throw this.getRuntime().newNotImplementedError("Thread-specific SAFE levels are not supported");
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject backtrace(ThreadContext context) {
        ThreadContext myContext = this.getContext();
        if (myContext == null) {
            return context.nil;
        }
        return myContext.createCallerBacktrace(0, this.getNativeThread().getStackTrace());
    }

    @JRubyMethod(name={"backtrace"}, optional=2, compat=CompatVersion.RUBY2_0)
    public IRubyObject backtrace20(ThreadContext context, IRubyObject[] args2) {
        ThreadContext myContext = this.getContext();
        if (myContext == null) {
            return context.nil;
        }
        Thread nativeThread = this.getNativeThread();
        if (nativeThread == null) {
            return context.nil;
        }
        Ruby runtime = context.runtime;
        Integer[] ll = RubyKernel.levelAndLengthFromArgs(runtime, args2, 0);
        Integer level2 = ll[0];
        Integer length2 = ll[1];
        return myContext.createCallerBacktrace(level2, length2, this.getNativeThread().getStackTrace());
    }

    @JRubyMethod(optional=2, compat=CompatVersion.RUBY2_0)
    public IRubyObject backtrace_locations(ThreadContext context, IRubyObject[] args2) {
        ThreadContext myContext = this.getContext();
        if (myContext == null) {
            return context.nil;
        }
        Ruby runtime = context.runtime;
        Integer[] ll = RubyKernel.levelAndLengthFromArgs(runtime, args2, 0);
        Integer level2 = ll[0];
        Integer length2 = ll[1];
        return myContext.createCallerLocations(level2, length2, this.getNativeThread().getStackTrace());
    }

    public StackTraceElement[] javaBacktrace() {
        if (this.threadImpl instanceof NativeThread) {
            return ((NativeThread)this.threadImpl).getThread().getStackTrace();
        }
        return new StackTraceElement[0];
    }

    private boolean isCurrent() {
        return this.threadImpl.isCurrent();
    }

    public void exceptionRaised(RaiseException exception2) {
        assert (this.isCurrent());
        RubyException rubyException = exception2.getException();
        Ruby runtime = rubyException.getRuntime();
        if (runtime.getSystemExit().isInstance(rubyException)) {
            runtime.getThreadService().getMainThread().raise(new IRubyObject[]{rubyException}, Block.NULL_BLOCK);
        } else {
            if (this.abortOnException(runtime)) {
                RubyException systemExit;
                if (!runtime.is1_9()) {
                    runtime.printError(rubyException);
                    String message2 = rubyException.message.convertToString().toString();
                    systemExit = RubySystemExit.newInstance(runtime, 1, message2);
                    systemExit.set_backtrace(rubyException.backtrace());
                } else {
                    systemExit = rubyException;
                }
                runtime.getThreadService().getMainThread().raise(new IRubyObject[]{systemExit}, Block.NULL_BLOCK);
                return;
            }
            if (runtime.getDebug().isTrue()) {
                runtime.printError(exception2.getException());
            }
        }
        this.exitingException = exception2;
    }

    public void exceptionRaised(Throwable exception2) {
        if (exception2 instanceof RaiseException) {
            this.exceptionRaised((RaiseException)exception2);
            return;
        }
        assert (this.isCurrent());
        Ruby runtime = this.getRuntime();
        if (this.abortOnException(runtime) && exception2 instanceof Error) {
            runtime.getThreadService().getMainThread().raise(JavaUtil.convertJavaToUsableRubyObject(runtime, exception2));
        } else {
            Helpers.throwException(exception2);
        }
    }

    private boolean abortOnException(Ruby runtime) {
        return runtime.isGlobalAbortOnExceptionEnabled() || this.abortOnException;
    }

    public static RubyThread mainThread(IRubyObject receiver2) {
        return receiver2.getRuntime().getThreadService().getMainThread();
    }

    @Deprecated
    public boolean selectForAccept(RubyIO io2) {
        return this.select(io2, 16);
    }

    private synchronized Selector getSelector(SelectableChannel channel) throws IOException {
        return SelectorFactory.openWithRetryFrom(this.getRuntime(), channel.provider());
    }

    public boolean select(RubyIO io2, int ops) {
        return this.select(io2.getChannel(), io2, ops);
    }

    public boolean select(RubyIO io2, int ops, long timeout2) {
        return this.select(io2.getChannel(), io2, ops, timeout2);
    }

    public boolean select(Channel channel, RubyIO io2, int ops) {
        return this.select(channel, io2, ops, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean select(Channel channel, RubyIO io2, int ops, long timeout2) {
        if (!(channel instanceof SelectableChannel)) {
            return true;
        }
        SelectableChannel selectable = (SelectableChannel)channel;
        Object object = selectable.blockingLock();
        synchronized (object) {
            boolean oldBlocking = selectable.isBlocking();
            SelectionKey key2 = null;
            try {
                Set<SelectionKey> keySet;
                selectable.configureBlocking(false);
                if (io2 != null) {
                    io2.addBlockingThread(this);
                }
                this.currentSelector = this.getRuntime().getSelectorPool().get(selectable.provider());
                key2 = selectable.register(this.currentSelector, ops);
                this.beforeBlockingCall();
                int result2 = timeout2 < 0L ? this.currentSelector.select() : (timeout2 == 0L ? this.currentSelector.selectNow() : this.currentSelector.select(timeout2));
                this.pollThreadEvents();
                if (result2 == 1 && (keySet = this.currentSelector.selectedKeys()).iterator().next() == key2) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (IOException ioe) {
                throw this.getRuntime().newIOErrorFromException(ioe);
            }
            finally {
                try {
                    if (key2 != null) {
                        key2.cancel();
                    }
                    if (this.currentSelector != null) {
                        this.currentSelector.selectNow();
                    }
                }
                catch (Exception e) {}
                try {
                    if (this.currentSelector != null) {
                        this.getRuntime().getSelectorPool().put(this.currentSelector);
                    }
                }
                catch (Exception e) {
                }
                finally {
                    this.currentSelector = null;
                }
                if (io2 != null) {
                    io2.removeBlockingThread(this);
                }
                try {
                    selectable.configureBlocking(oldBlocking);
                }
                catch (Exception e) {}
                this.afterBlockingCall();
            }
        }
    }

    public void interrupt() {
        BlockingTask task;
        BlockingIO.Condition iowait;
        Selector activeSelector = this.currentSelector;
        if (activeSelector != null) {
            activeSelector.wakeup();
        }
        if ((iowait = this.blockingIO) != null) {
            iowait.cancel();
        }
        if ((task = this.currentBlockingTask) != null) {
            task.wakeup();
        }
    }

    public boolean waitForIO(ThreadContext context, RubyIO io2, int ops) {
        Channel channel = io2.getChannel();
        if (!(channel instanceof SelectableChannel)) {
            return true;
        }
        try {
            io2.addBlockingThread(this);
            this.blockingIO = BlockingIO.newCondition(channel, ops);
            boolean ready2 = this.blockingIO.await();
            this.pollThreadEvents();
            boolean bl = ready2;
            return bl;
        }
        catch (IOException ioe) {
            throw context.runtime.newRuntimeError("Error with selector: " + ioe);
        }
        catch (InterruptedException ex) {
            throw context.runtime.newRuntimeError("Interrupted");
        }
        finally {
            this.blockingIO = null;
            io2.removeBlockingThread(this);
        }
    }

    public void beforeBlockingCall() {
        this.pollThreadEvents();
        this.enterSleep();
    }

    public void afterBlockingCall() {
        this.exitSleep();
        this.pollThreadEvents();
    }

    private void receivedAnException(ThreadContext context, IRubyObject exception2) {
        RubyModule kernelModule = this.getRuntime().getKernel();
        RubyThread.debug(this, "before propagating exception");
        kernelModule.callMethod(context, "raise", exception2);
    }

    public boolean wait_timeout(IRubyObject o, Double timeout2) throws InterruptedException {
        if (timeout2 != null) {
            long end_ns;
            long delay_ns = (long)(timeout2 * 1.0E9);
            long start_ns = System.nanoTime();
            if (delay_ns > 0L) {
                long delay_ms = delay_ns / 1000000L;
                int delay_ns_remainder = (int)(delay_ns % 1000000L);
                this.executeBlockingTask(new SleepTask(o, delay_ms, delay_ns_remainder));
            }
            return (end_ns = System.nanoTime()) - start_ns <= delay_ns;
        }
        this.executeBlockingTask(new SleepTask(o, 0L, 0));
        return true;
    }

    public RubyThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RubyThread other = (RubyThread)obj;
        return this.threadImpl == other.threadImpl || this.threadImpl != null && this.threadImpl.equals(other.threadImpl);
    }

    @Override
    public int hashCode() {
        int hash2 = 3;
        hash2 = 97 * hash2 + (this.threadImpl != null ? this.threadImpl.hashCode() : 0);
        return hash2;
    }

    @Override
    public String toString() {
        return this.threadImpl.toString();
    }

    public void lock(Lock lock2) {
        assert (Thread.currentThread() == this.getNativeThread());
        lock2.lock();
        this.heldLocks.add(lock2);
    }

    public void lockInterruptibly(Lock lock2) throws InterruptedException {
        assert (Thread.currentThread() == this.getNativeThread());
        lock2.lockInterruptibly();
        this.heldLocks.add(lock2);
    }

    public boolean tryLock(Lock lock2) {
        assert (Thread.currentThread() == this.getNativeThread());
        boolean locked = lock2.tryLock();
        if (locked) {
            this.heldLocks.add(lock2);
        }
        return locked;
    }

    public void unlock(Lock lock2) {
        assert (Thread.currentThread() == this.getNativeThread());
        lock2.unlock();
        this.heldLocks.remove(lock2);
    }

    public void unlockAll() {
        assert (Thread.currentThread() == this.getNativeThread());
        for (Lock lock2 : this.heldLocks) {
            lock2.unlock();
        }
    }

    private String identityString() {
        return "0x" + Integer.toHexString(System.identityHashCode(this));
    }

    public static final class SleepTask
    implements BlockingTask {
        private final Object object;
        private final long millis;
        private final int nanos;

        public SleepTask(Object object, long millis, int nanos) {
            this.object = object;
            this.millis = millis;
            this.nanos = nanos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() throws InterruptedException {
            Object object = this.object;
            synchronized (object) {
                this.object.wait(this.millis, this.nanos);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void wakeup() {
            Object object = this.object;
            synchronized (object) {
                this.object.notify();
            }
        }
    }

    public static interface BlockingTask {
        public void run() throws InterruptedException;

        public void wakeup();
    }

    public static class Location
    extends RubyObject {
        private final RubyStackTraceElement element;

        public Location(Ruby runtime, RubyClass klass, RubyStackTraceElement element) {
            super(runtime, klass);
            this.element = element;
        }

        @JRubyMethod
        public IRubyObject absolute_path(ThreadContext context) {
            return context.runtime.newString(this.element.getFileName());
        }

        @JRubyMethod
        public IRubyObject base_label(ThreadContext context) {
            return context.runtime.newString(this.element.getMethodName());
        }

        @JRubyMethod
        public IRubyObject inspect(ThreadContext context) {
            return this.to_s(context).inspect();
        }

        @JRubyMethod
        public IRubyObject label(ThreadContext context) {
            return context.runtime.newString(this.element.getMethodName());
        }

        @JRubyMethod
        public IRubyObject lineno(ThreadContext context) {
            return context.runtime.newFixnum(this.element.getLineNumber());
        }

        @JRubyMethod
        public IRubyObject path(ThreadContext context) {
            return context.runtime.newString(this.element.getFileName());
        }

        @JRubyMethod
        public IRubyObject to_s(ThreadContext context) {
            return context.runtime.newString(this.element.mriStyleString());
        }

        public static IRubyObject newLocationArray(Ruby runtime, RubyStackTraceElement[] elements) {
            RubyArray ary = runtime.newArray(elements.length);
            for (RubyStackTraceElement element : elements) {
                ary.append(new Location(runtime, runtime.getLocation(), element));
            }
            return ary;
        }
    }

    public static enum Status {
        RUN,
        SLEEP,
        ABORTING,
        DEAD;

        public final ByteList bytes = new ByteList(this.toString().toLowerCase().getBytes(RubyEncoding.UTF8));
    }
}

