/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import org.jruby.ext.posix.JavaSecuredFile;

public class NormalizedFile
extends JavaSecuredFile {
    private static final long serialVersionUID = 7630618150344842227L;

    public NormalizedFile(String pathname) {
        super(pathname);
    }

    public NormalizedFile(URI uri) {
        super(uri);
    }

    public NormalizedFile(File parent, String child) {
        super(parent, child);
    }

    public NormalizedFile(String parent, String child) {
        super(parent, child);
    }

    public String getAbsolutePath() {
        return new File(super.getPath()).getAbsolutePath().replace(File.separatorChar, '/');
    }

    public String getCanonicalPath() throws IOException {
        return super.getCanonicalPath().replace(File.separatorChar, '/');
    }

    public String getPath() {
        return super.getPath().replace(File.separatorChar, '/');
    }

    public String toString() {
        return super.toString().replace(File.separatorChar, '/');
    }

    public File getAbsoluteFile() {
        return new NormalizedFile(this.getAbsolutePath());
    }

    public File getCanonicalFile() throws IOException {
        return new NormalizedFile(this.getCanonicalPath());
    }

    public String getParent() {
        return super.getParent().replace(File.separatorChar, '/');
    }

    public File getParentFile() {
        return new NormalizedFile(this.getParent());
    }

    public static File[] listRoots() {
        File[] roots = File.listRoots();
        NormalizedFile[] smartRoots = new NormalizedFile[roots.length];
        for (int i2 = 0; i2 < roots.length; ++i2) {
            smartRoots[i2] = new NormalizedFile(roots[i2].getPath());
        }
        return smartRoots;
    }

    public static File createTempFile(String prefix, String suffix, File directory) throws IOException {
        File file2 = File.createTempFile(prefix, suffix, directory);
        return new NormalizedFile(file2.getPath());
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        File file2 = File.createTempFile(prefix, suffix);
        return new NormalizedFile(file2.getPath());
    }

    public String[] list() {
        return super.list();
    }

    public String[] list(FilenameFilter filter) {
        String[] files = super.list(filter);
        if (files == null) {
            return null;
        }
        String[] smartFiles = new String[files.length];
        for (int i2 = 0; i2 < files.length; ++i2) {
            smartFiles[i2] = files[i2].replace(File.separatorChar, '/');
        }
        return smartFiles;
    }

    public File[] listFiles() {
        File[] files = super.listFiles();
        if (files == null) {
            return null;
        }
        NormalizedFile[] smartFiles = new NormalizedFile[files.length];
        for (int i2 = 0; i2 < files.length; ++i2) {
            smartFiles[i2] = new NormalizedFile(files[i2].getPath());
        }
        return smartFiles;
    }

    public File[] listFiles(FileFilter filter) {
        File[] files = super.listFiles(filter);
        if (files == null) {
            return null;
        }
        NormalizedFile[] smartFiles = new NormalizedFile[files.length];
        for (int i2 = 0; i2 < files.length; ++i2) {
            smartFiles[i2] = new NormalizedFile(files[i2].getPath());
        }
        return smartFiles;
    }

    public File[] listFiles(FilenameFilter filter) {
        File[] files = super.listFiles(filter);
        if (files == null) {
            return null;
        }
        NormalizedFile[] smartFiles = new NormalizedFile[files.length];
        for (int i2 = 0; i2 < files.length; ++i2) {
            smartFiles[i2] = new NormalizedFile(files[i2].getPath());
        }
        return smartFiles;
    }

    public static String getFileProperty(String property) {
        String value2 = System.getProperty(property);
        return value2.replace(File.separatorChar, '/');
    }
}

