/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.lexer.yacc;

import java.io.IOException;
import org.jcodings.Encoding;
import org.jruby.ast.RegexpNode;
import org.jruby.lexer.yacc.LexerSource;
import org.jruby.lexer.yacc.RubyYaccLexer;
import org.jruby.lexer.yacc.StrTerm;
import org.jruby.lexer.yacc.SyntaxException;
import org.jruby.lexer.yacc.Token;
import org.jruby.util.ByteList;
import org.jruby.util.KCode;
import org.jruby.util.RegexpOptions;

public class StringTerm
extends StrTerm {
    private int flags;
    private final char begin;
    private final char end;
    private int nest;

    public StringTerm(int flags, int begin2, int end2) {
        this.flags = flags;
        this.begin = (char)begin2;
        this.end = (char)end2;
        this.nest = 0;
    }

    protected ByteList createByteList(RubyYaccLexer lexer) {
        if (lexer.isOneEight()) {
            return new ByteList();
        }
        return new ByteList(new byte[0], lexer.getEncoding());
    }

    private int endFound(RubyYaccLexer lexer, LexerSource src) throws IOException {
        if ((this.flags & 8) != 0) {
            this.flags = -1;
            lexer.getPosition();
            return 32;
        }
        if ((this.flags & 4) != 0) {
            RegexpOptions options2 = this.parseRegexpFlags(src);
            ByteList regexpBytelist = ByteList.create((CharSequence)"");
            lexer.setValue(new RegexpNode(src.getPosition(), regexpBytelist, options2));
            return 380;
        }
        lexer.setValue(new Token("\"", lexer.getPosition()));
        return 372;
    }

    public int parseString(RubyYaccLexer lexer, LexerSource src) throws IOException {
        boolean spaceSeen = false;
        if (this.flags == -1) {
            lexer.setValue(new Token("\"", lexer.getPosition()));
            return 372;
        }
        int c = src.read();
        if ((this.flags & 8) != 0 && Character.isWhitespace(c)) {
            while (Character.isWhitespace(c = src.read())) {
            }
            spaceSeen = true;
        }
        if (c == this.end && this.nest == 0) {
            return this.endFound(lexer, src);
        }
        if (spaceSeen) {
            src.unread(c);
            lexer.getPosition();
            return 32;
        }
        ByteList buffer = this.createByteList(lexer);
        if ((this.flags & 2) != 0 && c == 35) {
            c = src.read();
            switch (c) {
                case 36: 
                case 64: {
                    src.unread(c);
                    lexer.setValue(new Token("#" + c, lexer.getPosition()));
                    return 371;
                }
                case 123: {
                    lexer.setValue(new Token("#" + c, lexer.getPosition()));
                    return 370;
                }
            }
            buffer.append((byte)35);
        }
        src.unread(c);
        if (this.parseStringIntoBuffer(lexer, src, buffer) == -1) {
            throw new SyntaxException(SyntaxException.PID.STRING_HITS_EOF, src.getPosition(), src.getCurrentLine(), "unterminated string meets end of file", new Object[0]);
        }
        lexer.setValue(lexer.createStrNode(lexer.getPosition(), buffer, this.flags));
        return 377;
    }

    private RegexpOptions parseRegexpFlags(LexerSource src) throws IOException {
        RegexpOptions options2 = new RegexpOptions();
        StringBuilder unknownFlags = new StringBuilder(10);
        int c = src.read();
        while (c != -1 && Character.isLetter(c)) {
            switch (c) {
                case 105: {
                    options2.setIgnorecase(true);
                    break;
                }
                case 120: {
                    options2.setExtended(true);
                    break;
                }
                case 109: {
                    options2.setMultiline(true);
                    break;
                }
                case 111: {
                    options2.setOnce(true);
                    break;
                }
                case 110: {
                    options2.setExplicitKCode(KCode.NONE);
                    break;
                }
                case 101: {
                    options2.setExplicitKCode(KCode.EUC);
                    break;
                }
                case 115: {
                    options2.setExplicitKCode(KCode.SJIS);
                    break;
                }
                case 117: {
                    options2.setExplicitKCode(KCode.UTF8);
                    break;
                }
                case 106: {
                    options2.setJava(true);
                    break;
                }
                default: {
                    unknownFlags.append((char)c);
                }
            }
            c = src.read();
        }
        src.unread(c);
        if (unknownFlags.length() != 0) {
            throw new SyntaxException(SyntaxException.PID.REGEXP_UNKNOWN_OPTION, src.getPosition(), "unknown regexp option" + (unknownFlags.length() > 1 ? "s" : "") + " - " + unknownFlags.toString(), unknownFlags.toString(), new Object[0]);
        }
        return options2;
    }

    private void mixedEscape(RubyYaccLexer lexer, Encoding foundEncoding, Encoding parserEncoding) {
        throw new SyntaxException(SyntaxException.PID.MIXED_ENCODING, lexer.getPosition(), "", foundEncoding + " mixed within " + parserEncoding, new Object[0]);
    }

    public int parseStringIntoBuffer(RubyYaccLexer lexer, LexerSource src, ByteList buffer) throws IOException {
        int c;
        boolean qwords = (this.flags & 8) != 0;
        boolean expand = (this.flags & 2) != 0;
        boolean escape = (this.flags & 1) != 0;
        boolean regexp2 = (this.flags & 4) != 0;
        boolean symbol = (this.flags & 0x10) != 0;
        boolean hasNonAscii = false;
        Encoding encoding2 = lexer.getEncoding();
        block5: while ((c = src.read()) != -1) {
            block24: {
                block27: {
                    block26: {
                        block25: {
                            block23: {
                                if (this.begin == '\u0000' || c != this.begin) break block23;
                                ++this.nest;
                                break block24;
                            }
                            if (c != this.end) break block25;
                            if (this.nest == 0) {
                                src.unread(c);
                                break;
                            }
                            --this.nest;
                            break block24;
                        }
                        if (!expand || c != 35 || src.peek(10)) break block26;
                        int c2 = src.read();
                        if (c2 == 36 || c2 == 64 || c2 == 123) {
                            src.unread(c2);
                            src.unread(c);
                            break;
                        }
                        src.unread(c2);
                        break block24;
                    }
                    if (c != 92) break block27;
                    c = src.read();
                    switch (c) {
                        case 10: {
                            if (qwords) break;
                            if (expand) continue block5;
                            buffer.append(92);
                            break;
                        }
                        case 92: {
                            if (escape) {
                                buffer.append(c);
                                break;
                            }
                            break block24;
                        }
                        case 117: {
                            if (!lexer.isOneEight()) {
                                if (!expand) {
                                    buffer.append(92);
                                    break;
                                }
                                if (regexp2) {
                                    lexer.readUTFEscapeRegexpLiteral(buffer);
                                } else {
                                    lexer.readUTFEscape(buffer, true, symbol);
                                }
                                if (!hasNonAscii || buffer.getEncoding() == encoding2) continue block5;
                                this.mixedEscape(lexer, buffer.getEncoding(), encoding2);
                                continue block5;
                            }
                        }
                        default: {
                            if (regexp2) {
                                src.unread(c);
                                this.parseEscapeIntoBuffer(src, buffer);
                                if (!hasNonAscii || buffer.getEncoding() == encoding2) continue block5;
                                this.mixedEscape(lexer, buffer.getEncoding(), encoding2);
                                continue block5;
                            }
                            if (expand) {
                                src.unread(c);
                                if (escape) {
                                    buffer.append(92);
                                }
                                c = lexer.readEscape();
                                break;
                            }
                            if (qwords && Character.isWhitespace(c)) break;
                            if (c != this.end && (this.begin == '\u0000' || c != this.begin)) {
                                buffer.append(92);
                                break;
                            }
                            break block24;
                        }
                    }
                    break block24;
                }
                if (!lexer.isOneEight() && !Encoding.isAscii((byte)((byte)c))) {
                    if (buffer.getEncoding() != encoding2) {
                        this.mixedEscape(lexer, buffer.getEncoding(), encoding2);
                    }
                    if ((c = src.readCodepoint(c, encoding2)) == -2) {
                        throw new SyntaxException(SyntaxException.PID.INVALID_MULTIBYTE_CHAR, lexer.getPosition(), null, "invalid multibyte char (" + encoding2 + ")", new Object[0]);
                    }
                    if (lexer.tokenAddMBC(c, buffer) != -1) continue;
                    return -1;
                }
                if (qwords && Character.isWhitespace(c)) {
                    src.unread(c);
                    break;
                }
            }
            if (!lexer.isOneEight() && (c & 0x80) != 0) {
                hasNonAscii = true;
                if (buffer.getEncoding() != encoding2) {
                    this.mixedEscape(lexer, buffer.getEncoding(), encoding2);
                }
            }
            buffer.append(c);
        }
        return c;
    }

    private void escaped(LexerSource src, ByteList buffer) throws IOException {
        int c = src.read();
        switch (c) {
            case 92: {
                this.parseEscapeIntoBuffer(src, buffer);
                break;
            }
            case -1: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, src.getPosition(), src.getCurrentLine(), "Invalid escape character syntax", new Object[0]);
            }
            default: {
                buffer.append(c);
            }
        }
    }

    private void parseEscapeIntoBuffer(LexerSource src, ByteList buffer) throws IOException {
        int c = src.read();
        block0 : switch (c) {
            case 10: {
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                buffer.append(92);
                buffer.append(c);
                for (int i2 = 0; i2 < 2; ++i2) {
                    c = src.read();
                    if (c == -1) {
                        throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, src.getPosition(), src.getCurrentLine(), "Invalid escape character syntax", new Object[0]);
                    }
                    if (!RubyYaccLexer.isOctChar(c)) {
                        src.unread(c);
                        break block0;
                    }
                    buffer.append(c);
                }
                break;
            }
            case 120: {
                buffer.append(92);
                buffer.append(c);
                c = src.read();
                if (!RubyYaccLexer.isHexChar(c)) {
                    throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, src.getPosition(), src.getCurrentLine(), "Invalid escape character syntax", new Object[0]);
                }
                buffer.append(c);
                c = src.read();
                if (RubyYaccLexer.isHexChar(c)) {
                    buffer.append(c);
                    break;
                }
                src.unread(c);
                break;
            }
            case 77: {
                c = src.read();
                if (c != 45) {
                    throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, src.getPosition(), src.getCurrentLine(), "Invalid escape character syntax", new Object[0]);
                }
                buffer.append(new byte[]{92, 77, 45});
                this.escaped(src, buffer);
                break;
            }
            case 67: {
                c = src.read();
                if (c != 45) {
                    throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, src.getPosition(), src.getCurrentLine(), "Invalid escape character syntax", new Object[0]);
                }
                buffer.append(new byte[]{92, 67, 45});
                this.escaped(src, buffer);
                break;
            }
            case 99: {
                buffer.append(new byte[]{92, 99});
                this.escaped(src, buffer);
                break;
            }
            case -1: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, src.getPosition(), src.getCurrentLine(), "Invalid escape character syntax", new Object[0]);
            }
            default: {
                if (c != 92 || c != this.end) {
                    buffer.append(92);
                }
                buffer.append(c);
            }
        }
    }
}

