/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.cli;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import org.jruby.RubyInstanceConfig;
import org.jruby.common.RubyWarnings;
import org.jruby.exceptions.MainExitException;
import org.jruby.runtime.profile.builtin.ProfileOutput;
import org.jruby.util.FileResource;
import org.jruby.util.JRubyFile;
import org.jruby.util.KCode;
import org.jruby.util.SafePropertyAccessor;
import org.jruby.util.StringSupport;
import org.jruby.util.cli.Options;
import org.jruby.util.cli.OutputStrings;

public class ArgumentProcessor {
    public static final String SEPARATOR = "(?<!jar:file|jar|file|classpath|uri:classloader|uri|http|https):";
    private final List<Argument> arguments;
    private int argumentIndex = 0;
    private final boolean processArgv;
    private final boolean rubyOpts;
    final RubyInstanceConfig config;
    private boolean endOfArguments = false;
    private int characterIndex = 0;
    private boolean dashUpperU = false;
    private static final Pattern VERSION_FLAG = Pattern.compile("^--[12]\\.[89012]$");
    private static final Set<String> KNOWN_PROPERTIES = new HashSet<String>(Options.PROPERTIES.size() + 16, 1.0f);
    private static final List<String> KNOWN_PROPERTY_PREFIXES;
    private static final Map<String, BiFunction<ArgumentProcessor, Boolean, Void>> FEATURES;

    public ArgumentProcessor(String[] arguments, RubyInstanceConfig config) {
        this(arguments, true, false, false, config);
    }

    public ArgumentProcessor(String[] arguments, boolean processArgv, boolean dashed, boolean rubyOpts, RubyInstanceConfig config) {
        this.config = config;
        if (arguments != null && arguments.length > 0) {
            this.arguments = new ArrayList<Argument>(arguments.length);
            for (String argument : arguments) {
                this.arguments.add(new Argument(argument, dashed));
            }
        } else {
            this.arguments = new ArrayList<Argument>(0);
        }
        this.processArgv = processArgv;
        this.rubyOpts = rubyOpts;
    }

    public void processArguments() {
        this.processArguments(true);
    }

    public void processArguments(boolean inline) {
        ArgumentProcessor.checkProperties();
        while (this.argumentIndex < this.arguments.size() && this.isInterpreterArgument(this.arguments.get((int)this.argumentIndex).originalValue)) {
            this.processArgument();
            ++this.argumentIndex;
        }
        if (inline && !this.config.isInlineScript() && this.config.getScriptFileName() == null && !this.config.isForceStdin() && this.argumentIndex < this.arguments.size()) {
            this.config.setScriptFileName(this.arguments.get((int)this.argumentIndex).originalValue);
            ++this.argumentIndex;
        }
        if (this.processArgv) {
            this.processArgv();
        }
    }

    private void processArgv() {
        ArrayList<String> arglist = new ArrayList<String>();
        while (this.argumentIndex < this.arguments.size()) {
            String arg2 = this.arguments.get((int)this.argumentIndex).originalValue;
            if (this.config.isArgvGlobalsOn() && arg2.startsWith("-")) {
                int split2 = (arg2 = arg2.substring(1)).indexOf(61);
                if (split2 > 0) {
                    String key2 = arg2.substring(0, split2);
                    String val = arg2.substring(split2 + 1);
                    String globalName = key2.replace('-', '_');
                    this.config.getOptionGlobals().put(globalName, val);
                } else {
                    this.config.getOptionGlobals().put(arg2, null);
                }
            } else {
                this.config.setArgvGlobalsOn(false);
                arglist.add(arg2);
            }
            ++this.argumentIndex;
        }
        arglist.addAll(Arrays.asList(this.config.getArgv()));
        this.config.setArgv(arglist.toArray(new String[arglist.size()]));
    }

    private boolean isInterpreterArgument(String argument) {
        return argument.length() > 0 && (argument.charAt(0) == '-' || argument.charAt(0) == '+') && !this.endOfArguments;
    }

    private String getArgumentError(String additionalError) {
        return "jruby: invalid argument\n" + additionalError + "\n";
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processArgument() {
        String argument = this.arguments.get(this.argumentIndex).getDashedValue();
        if (argument.length() == 1) {
            this.endOfArguments = true;
            this.config.setForceStdin(true);
            return;
        }
        this.characterIndex = 1;
        while (this.characterIndex < argument.length()) {
            switch (argument.charAt(this.characterIndex)) {
                case '0': {
                    this.disallowedInRubyOpts(argument);
                    String temp = this.grabOptionalValue();
                    if (null == temp) {
                        this.config.setRecordSeparator("\u0000");
                        return;
                    }
                    if (temp.equals("0")) {
                        this.config.setRecordSeparator("\n\n");
                        return;
                    }
                    if (temp.equals("777")) {
                        this.config.setRecordSeparator("\uffff");
                        return;
                    }
                    try {
                        int val = Integer.parseInt(temp, 8);
                        this.config.setRecordSeparator(String.valueOf((char)val));
                        return;
                    }
                    catch (Exception e) {
                        MainExitException mee = new MainExitException(1, this.getArgumentError(" -0 must be followed by either 0, 777, or a valid octal value"));
                        mee.setUsageError(true);
                        throw mee;
                    }
                }
                case 'a': {
                    this.disallowedInRubyOpts(argument);
                    this.config.setSplit(true);
                    break;
                }
                case 'c': {
                    this.disallowedInRubyOpts(argument);
                    this.config.setShouldCheckSyntax(true);
                    break;
                }
                case 'C': {
                    this.disallowedInRubyOpts(argument);
                    try {
                        String saved = this.grabValue(this.getArgumentError(" -C must be followed by a directory expression"));
                        File base = new File(this.config.getCurrentDirectory());
                        File newDir = new File(saved);
                        if (saved.startsWith("uri:classloader:")) {
                            this.config.setCurrentDirectory(saved);
                        } else if (newDir.isAbsolute()) {
                            this.config.setCurrentDirectory(newDir.getCanonicalPath());
                        } else {
                            this.config.setCurrentDirectory(new File(base, newDir.getPath()).getCanonicalPath());
                        }
                        if (new File(this.config.getCurrentDirectory()).isDirectory() || this.config.getCurrentDirectory().startsWith("uri:classloader:")) return;
                        throw new MainExitException(1, "jruby: Can't chdir to " + saved + " (fatal)");
                    }
                    catch (IOException e) {
                        throw new MainExitException(1, this.getArgumentError(" -C must be followed by a valid directory"));
                    }
                }
                case 'd': {
                    this.config.setDebug(true);
                    this.config.setVerbosity(RubyInstanceConfig.Verbosity.TRUE);
                    this.config.getWarningCategories().add(RubyWarnings.Category.DEPRECATED);
                    break;
                }
                case 'e': {
                    this.disallowedInRubyOpts(argument);
                    this.config.getInlineScript().append(this.grabValue(this.getArgumentError(" -e must be followed by an expression to report")));
                    this.config.getInlineScript().append('\n');
                    this.config.setHasInlineScript(true);
                    return;
                }
                case 'E': {
                    if (this.dashUpperU) {
                        MainExitException mee = this.fakeRuntimeError("jruby: default_internal already set to UTF-8");
                        throw mee;
                    }
                    this.processEncodingOption("-E", this.grabValue(this.getArgumentError("unknown encoding name")));
                    return;
                }
                case 'F': {
                    this.disallowedInRubyOpts(argument);
                    this.config.setInputFieldSeparator(this.grabValue(this.getArgumentError(" -F must be followed by a pattern for input field separation")));
                    return;
                }
                case 'h': {
                    this.disallowedInRubyOpts(argument);
                    this.config.setShouldPrintUsage(true);
                    this.config.setShouldRunInterpreter(false);
                    break;
                }
                case 'i': {
                    this.disallowedInRubyOpts(argument);
                    this.config.setInPlaceBackupExtension(this.grabOptionalValue());
                    if (this.config.getInPlaceBackupExtension() != null) return;
                    this.config.setInPlaceBackupExtension("");
                    return;
                }
                case 'I': {
                    String s2 = this.grabValue(this.getArgumentError("-I must be followed by a directory name to add to lib path"));
                    String separator = File.pathSeparator;
                    if (":".equals(separator)) {
                        separator = SEPARATOR;
                    }
                    String[] ls = s2.split(separator);
                    for (int i2 = 0; i2 < ls.length; ++i2) {
                        File file2 = new File(ls[i2]);
                        if (file2.isAbsolute()) continue;
                        try {
                            ls[i2] = file2.getCanonicalPath();
                            continue;
                        }
                        catch (IOException e) {
                            ls[i2] = file2.getAbsolutePath();
                        }
                    }
                    this.config.getLoadPaths().addAll(Arrays.asList(ls));
                    return;
                }
                case 'J': {
                    String js = this.grabOptionalValue();
                    this.config.getError().println("warning: " + argument + " argument ignored (launched in same VM?)");
                    if (!js.equals("-cp") && !js.equals("-classpath")) return;
                    while (this.grabOptionalValue() != null) {
                    }
                    this.grabValue(this.getArgumentError(" -J-cp must be followed by a path expression"));
                    return;
                }
                case 'K': {
                    String eArg = this.grabValue(this.getArgumentError("provide a value for -K"));
                    KCode kcode = KCode.create(eArg);
                    if (kcode == KCode.NIL) break;
                    this.config.setKCode(kcode);
                    this.config.setSourceEncoding(this.config.getKCode().getEncoding().toString());
                    if (this.config.getExternalEncoding() != null) break;
                    this.config.setExternalEncoding(this.config.getKCode().getEncoding().toString());
                    break;
                }
                case 'l': {
                    this.disallowedInRubyOpts(argument);
                    this.config.setProcessLineEnds(true);
                    break;
                }
                case 'n': {
                    this.disallowedInRubyOpts(argument);
                    this.config.setAssumeLoop(true);
                    this.config.setKernelGsubDefined(true);
                    break;
                }
                case 'p': {
                    this.disallowedInRubyOpts(argument);
                    this.config.setAssumePrinting(true);
                    this.config.setAssumeLoop(true);
                    this.config.setKernelGsubDefined(true);
                    break;
                }
                case 'r': {
                    this.config.getRequiredLibraries().add(this.grabValue(this.getArgumentError("-r must be followed by a package to require")));
                    return;
                }
                case 's': {
                    this.disallowedInRubyOpts(argument);
                    this.config.setArgvGlobalsOn(true);
                    break;
                }
                case 'G': {
                    this.config.setLoadGemfile(true);
                    break;
                }
                case 'S': {
                    this.disallowedInRubyOpts(argument);
                    this.runBinScript();
                    return;
                }
                case 'U': {
                    this.dashUpperU = true;
                    this.config.setInternalEncoding("UTF-8");
                    break;
                }
                case 'v': {
                    this.config.setVerbosity(RubyInstanceConfig.Verbosity.TRUE);
                    this.config.getWarningCategories().add(RubyWarnings.Category.DEPRECATED);
                    this.config.setShowVersion(true);
                    break;
                }
                case 'w': {
                    this.config.setVerbosity(RubyInstanceConfig.Verbosity.TRUE);
                    this.config.getWarningCategories().add(RubyWarnings.Category.DEPRECATED);
                    break;
                }
                case 'W': {
                    void var10_15;
                    String temp = this.grabOptionalValue();
                    if (temp == null) {
                        this.config.setVerbosity(RubyInstanceConfig.Verbosity.TRUE);
                        this.config.getWarningCategories().add(RubyWarnings.Category.DEPRECATED);
                        return;
                    }
                    if (temp.equals("0")) {
                        this.config.setVerbosity(RubyInstanceConfig.Verbosity.NIL);
                        return;
                    }
                    if (temp.equals("1")) {
                        this.config.setVerbosity(RubyInstanceConfig.Verbosity.FALSE);
                        return;
                    }
                    if (temp.equals("2")) {
                        this.config.setVerbosity(RubyInstanceConfig.Verbosity.TRUE);
                        this.config.getWarningCategories().add(RubyWarnings.Category.DEPRECATED);
                        return;
                    }
                    String string2 = temp;
                    int n = -1;
                    switch (string2.hashCode()) {
                        case 1518658925: {
                            if (!string2.equals(":deprecated")) break;
                            boolean bl = false;
                            break;
                        }
                        case -914686139: {
                            if (!string2.equals(":no-deprecated")) break;
                            boolean bl = true;
                            break;
                        }
                        case -242067934: {
                            if (!string2.equals(":experimental")) break;
                            int n2 = 2;
                            break;
                        }
                        case 2070501882: {
                            if (!string2.equals(":no-experimental")) break;
                            int n3 = 3;
                        }
                    }
                    switch (var10_15) {
                        case 0: {
                            this.config.getWarningCategories().add(RubyWarnings.Category.DEPRECATED);
                            return;
                        }
                        case 1: {
                            this.config.getWarningCategories().remove((Object)RubyWarnings.Category.DEPRECATED);
                            return;
                        }
                        case 2: {
                            this.config.getWarningCategories().add(RubyWarnings.Category.EXPERIMENTAL);
                            return;
                        }
                        case 3: {
                            this.config.getWarningCategories().remove((Object)RubyWarnings.Category.EXPERIMENTAL);
                            return;
                        }
                        default: {
                            if (temp.charAt(0) == ':') {
                                this.config.getError().println("warning: unknown warning category: " + temp.substring(1));
                                return;
                            }
                            MainExitException mee = new MainExitException(1, this.getArgumentError(" -W must be followed by either 0, 1, 2 or a valid category"));
                            mee.setUsageError(true);
                            throw mee;
                        }
                    }
                }
                case 'x': {
                    this.disallowedInRubyOpts(argument);
                    try {
                        String saved = this.grabOptionalValue();
                        if (saved != null) {
                            File base = new File(this.config.getCurrentDirectory());
                            File file3 = new File(saved);
                            if (saved.startsWith("uri:classloader:")) {
                                this.config.setCurrentDirectory(saved);
                            } else if (file3.isAbsolute()) {
                                this.config.setCurrentDirectory(file3.getCanonicalPath());
                            } else {
                                this.config.setCurrentDirectory(new File(base, file3.getPath()).getCanonicalPath());
                            }
                            if (!new File(this.config.getCurrentDirectory()).isDirectory() && !this.config.getCurrentDirectory().startsWith("uri:classloader:")) {
                                throw new MainExitException(1, "jruby: Can't chdir to " + saved + " (fatal)");
                            }
                        }
                        this.config.setXFlag(true);
                        return;
                    }
                    catch (IOException e) {
                        throw new MainExitException(1, this.getArgumentError(" -x must be followed by a valid directory"));
                    }
                }
                case 'X': {
                    this.disallowedInRubyOpts(argument);
                    String extendedOption = this.grabOptionalValue();
                    if (extendedOption == null) {
                        if (!SafePropertyAccessor.getBoolean("jruby.launcher.nopreamble", false)) throw new MainExitException(0, "jruby: missing argument\n" + OutputStrings.getExtendedHelp());
                        throw new MainExitException(0, OutputStrings.getExtendedHelp());
                    }
                    if (extendedOption.equals("-O")) {
                        this.config.setObjectSpaceEnabled(false);
                        return;
                    }
                    if (extendedOption.equals("+O")) {
                        this.config.setObjectSpaceEnabled(true);
                        return;
                    }
                    if (extendedOption.equals("-C") || extendedOption.equals("-CIR")) {
                        this.config.setCompileMode(RubyInstanceConfig.CompileMode.OFF);
                        return;
                    }
                    if (extendedOption.equals("+C") || extendedOption.equals("+CIR")) {
                        this.config.setCompileMode(RubyInstanceConfig.CompileMode.FORCE);
                        return;
                    }
                    if (extendedOption.endsWith("...")) {
                        Options.listPrefix(extendedOption.substring(0, extendedOption.length() - "...".length()));
                        this.config.setShouldRunInterpreter(false);
                        return;
                    }
                    if (extendedOption.endsWith("?")) {
                        Options.listContains(extendedOption.substring(0, extendedOption.length() - 1));
                        this.config.setShouldRunInterpreter(false);
                        return;
                    }
                    MainExitException mee = new MainExitException(1, "jruby: invalid extended option " + extendedOption + " (-X will list valid options)\n");
                    mee.setUsageError(true);
                    throw mee;
                }
                case 'y': {
                    this.disallowedInRubyOpts(argument);
                    this.config.setParserDebug(true);
                    return;
                }
                case '-': {
                    if (argument.equals("--command") || argument.equals("--bin")) {
                        this.characterIndex = argument.length();
                        this.runBinScript();
                        break;
                    }
                    if (argument.equals("--compat")) {
                        this.characterIndex = argument.length();
                        this.grabValue(this.getArgumentError("--compat takes an argument, but will be ignored"));
                        this.config.getError().println("warning: " + argument + " ignored");
                        return;
                    }
                    if (argument.equals("--copyright")) {
                        this.disallowedInRubyOpts(argument);
                        this.config.setShowCopyright(true);
                        this.config.setShouldRunInterpreter(false);
                        return;
                    }
                    if (argument.equals("--debug")) {
                        this.disallowedInRubyOpts(argument);
                        Options.DEBUG_FULLTRACE.force("true");
                        RubyInstanceConfig.FULL_TRACE_ENABLED = true;
                        this.config.setDebuggingFrozenStringLiteral(true);
                        return;
                    }
                    if (argument.startsWith("--debug=")) {
                        for (String debug : ArgumentProcessor.valueListFor(argument, "debug")) {
                            boolean all = debug.equals("all");
                            if (all || debug.equals("frozen-string-literal")) {
                                this.config.setDebuggingFrozenStringLiteral(true);
                                continue;
                            }
                            this.config.getError().println("warning: unknown argument for --debug: `" + debug + "'");
                        }
                        return;
                    }
                    if (argument.startsWith("--encoding")) {
                        String encodingValue;
                        int n = argument.length();
                        if (n == "--encoding".length()) {
                            this.characterIndex = n;
                            encodingValue = this.grabValue(this.getArgumentError("unknown encoding name"));
                        } else {
                            int splitIndex = argument.indexOf(61);
                            if (splitIndex == -1 || n == splitIndex + 1) {
                                throw new MainExitException(0, "jruby: missing argument for --encoding");
                            }
                            encodingValue = argument.substring(splitIndex + 1);
                        }
                        this.processEncodingOption("--encoding", encodingValue);
                        return;
                    }
                    if (argument.equals("--jdb")) {
                        this.config.setDebug(true);
                        this.config.setVerbosity(RubyInstanceConfig.Verbosity.TRUE);
                        break;
                    }
                    if (argument.equals("--help")) {
                        this.disallowedInRubyOpts(argument);
                        this.config.setShouldPrintUsage(true);
                        this.config.setShouldRunInterpreter(false);
                        break;
                    }
                    if (argument.equals("--properties")) {
                        this.config.setShouldPrintProperties(true);
                        this.config.setShouldRunInterpreter(false);
                        break;
                    }
                    if (argument.equals("--version")) {
                        this.disallowedInRubyOpts(argument);
                        this.config.setShowVersion(true);
                        this.config.setShouldRunInterpreter(false);
                        return;
                    }
                    if (argument.equals("--bytecode")) {
                        this.config.setShowBytecode(true);
                        return;
                    }
                    if (argument.equals("--fast")) {
                        this.config.setCompileMode(RubyInstanceConfig.CompileMode.FORCE);
                        return;
                    }
                    if (argument.startsWith("--profile")) {
                        this.characterIndex = argument.length();
                        int dotIndex = argument.indexOf(46);
                        if (dotIndex == -1) {
                            this.config.setProfilingMode(RubyInstanceConfig.ProfilingMode.FLAT);
                            return;
                        }
                        String string3 = argument.substring(dotIndex + 1, argument.length());
                        if (string3.equals("out")) {
                            String outputFile = this.grabValue(this.getArgumentError("--profile.out requires an output file argument"));
                            try {
                                this.config.setProfileOutput(new ProfileOutput(new File(outputFile)));
                                return;
                            }
                            catch (FileNotFoundException e) {
                                throw new MainExitException(1, String.format("jruby: %s", e.getMessage()));
                            }
                        }
                        if (string3.equals("service")) {
                            String service = this.grabValue(this.getArgumentError("--profile.service requires an class name argument"));
                            this.config.setProfilingMode(RubyInstanceConfig.ProfilingMode.SERVICE);
                            this.config.setProfilingService(service);
                            return;
                        }
                        try {
                            this.config.setProfilingMode(RubyInstanceConfig.ProfilingMode.valueOf(string3.toUpperCase()));
                            return;
                        }
                        catch (IllegalArgumentException e) {
                            throw new MainExitException(1, String.format("jruby: unknown profiler mode \"%s\"", string3));
                        }
                    }
                    if (VERSION_FLAG.matcher(argument).matches()) {
                        this.config.getError().println("warning: " + argument + " ignored");
                        return;
                    }
                    if (argument.equals("--debug-frozen-string-literal")) {
                        this.config.setDebuggingFrozenStringLiteral(true);
                        return;
                    }
                    if (argument.startsWith("--disable")) {
                        int len = argument.length();
                        if (len == "--disable".length()) {
                            this.characterIndex = len;
                            String string4 = this.grabValue(this.getArgumentError("missing argument for --disable"), false);
                            argument = "--disable=" + string4;
                        }
                        for (String disable2 : ArgumentProcessor.valueListFor(argument, "disable")) {
                            this.enableDisableFeature(disable2, false);
                        }
                        return;
                    }
                    if (argument.startsWith("--enable")) {
                        int len = argument.length();
                        if (len == "--enable".length()) {
                            this.characterIndex = len;
                            String string5 = this.grabValue(this.getArgumentError("missing argument for --enable"), false);
                            argument = "--enable=" + string5;
                        }
                        for (String enable2 : ArgumentProcessor.valueListFor(argument, "enable")) {
                            this.enableDisableFeature(enable2, true);
                        }
                        return;
                    }
                    if (argument.equals("--gemfile")) {
                        this.config.setLoadGemfile(true);
                        return;
                    }
                    if (argument.equals("--dump")) {
                        this.characterIndex = argument.length();
                        String error2 = "--dump only supports [version, copyright, usage, yydebug, syntax, insns] on JRuby";
                        String string6 = this.grabValue(this.getArgumentError(error2));
                        if (string6.equals("version")) {
                            this.config.setShowVersion(true);
                            this.config.setShouldRunInterpreter(false);
                            return;
                        }
                        if (string6.equals("copyright")) {
                            this.config.setShowCopyright(true);
                            this.config.setShouldRunInterpreter(false);
                            return;
                        }
                        if (string6.equals("usage")) {
                            this.config.setShouldPrintUsage(true);
                            this.config.setShouldRunInterpreter(false);
                            return;
                        }
                        if (string6.equals("yydebug")) {
                            this.config.setParserDebug(true);
                            return;
                        }
                        if (string6.equals("syntax")) {
                            this.config.setShouldCheckSyntax(true);
                            break;
                        }
                        if (string6.equals("insns")) {
                            this.config.setShowBytecode(true);
                            break;
                        }
                        MainExitException mee = new MainExitException(1, error2);
                        mee.setUsageError(true);
                        throw mee;
                    }
                    if (argument.equals("--dev")) {
                        Options.COMPILE_INVOKEDYNAMIC.force("false");
                        this.config.setCompileMode(RubyInstanceConfig.CompileMode.OFF);
                        return;
                    }
                    if (argument.equals("--server") || argument.equals("--client")) return;
                    if (argument.equals("--yydebug")) {
                        this.disallowedInRubyOpts(argument);
                        this.config.setParserDebug(true);
                    } else {
                        String internalEncoding;
                        String externalEncoding;
                        if (argument.equals("--verbose")) {
                            this.config.setVerbosity(RubyInstanceConfig.Verbosity.TRUE);
                            return;
                        }
                        if (argument.startsWith("--backtrace-limit=")) {
                            String limit2 = ArgumentProcessor.valueListFor(argument, "backtrace-limit")[0];
                            this.config.setBacktraceLimit(Integer.parseInt(limit2));
                            return;
                        }
                        if (argument.startsWith("--external-encoding=")) {
                            externalEncoding = ArgumentProcessor.valueListFor(argument, "external-encoding")[0];
                            this.config.setExternalEncoding(externalEncoding);
                            return;
                        }
                        if (argument.startsWith("--external-encoding")) {
                            this.characterIndex = argument.length();
                            externalEncoding = this.grabValue(this.getArgumentError("invalid encoding"));
                            this.config.setExternalEncoding(externalEncoding);
                            return;
                        }
                        if (argument.startsWith("--internal-encoding=")) {
                            internalEncoding = ArgumentProcessor.valueListFor(argument, "internal-encoding")[0];
                            this.config.setInternalEncoding(internalEncoding);
                            return;
                        }
                        if (argument.startsWith("--internal-encoding")) {
                            this.characterIndex = argument.length();
                            internalEncoding = this.grabValue(this.getArgumentError("invalid encoding"));
                            this.config.setInternalEncoding(internalEncoding);
                            return;
                        }
                        if (!argument.equals("--")) throw new MainExitException(1, "jruby: unknown option " + argument);
                        this.endOfArguments = true;
                        break;
                    }
                }
                default: {
                    throw new MainExitException(1, "jruby: unknown option " + argument);
                }
            }
            ++this.characterIndex;
        }
    }

    private void enableDisableFeature(String name2, boolean enable2) {
        BiFunction<ArgumentProcessor, Boolean, Void> feature = FEATURES.get(name2);
        if (feature == null) {
            this.config.getError().println("warning: unknown argument for --" + (enable2 ? "enable" : "disable") + ": `" + name2 + "'");
        } else {
            feature.apply(this, enable2);
        }
    }

    private static String[] valueListFor(String argument, String key2) {
        int length2 = key2.length() + 3;
        String[] values2 = argument.substring(length2).split(",");
        if (values2.length == 0) {
            ArgumentProcessor.errorMissingEquals(key2);
        }
        return values2;
    }

    private void disallowedInRubyOpts(CharSequence option) {
        if (this.rubyOpts) {
            throw this.fakeRuntimeError("jruby: invalid switch in RUBYOPT: " + option);
        }
    }

    private MainExitException fakeRuntimeError(String message2) {
        return new MainExitException(1, message2 + " (RuntimeError)");
    }

    private static void errorMissingEquals(String label2) {
        MainExitException mee = new MainExitException(1, "missing argument for --" + label2 + "\n");
        mee.setUsageError(true);
        throw mee;
    }

    private void processEncodingOption(String optionString, String value2) {
        List<String> encodings = StringSupport.split(value2, ':', 3);
        switch (encodings.size()) {
            case 3: {
                throw new MainExitException(1, "extra argument for " + optionString + ": " + encodings.get(2));
            }
            case 2: {
                this.config.setInternalEncoding(encodings.get(1));
            }
            case 1: {
                this.config.setExternalEncoding(encodings.get(0));
            }
        }
    }

    private void runBinScript() {
        String scriptName = this.grabValue("jruby: provide a bin script to execute");
        if (scriptName.equals("irb")) {
            scriptName = "jirb";
        }
        this.config.setScriptFileName(this.resolveScript(scriptName));
        if (this.config.getScriptFileName() == null) {
            this.config.setScriptFileName(scriptName);
            this.config.getRequiredLibraries().add("jruby/commands");
            this.config.getInlineScript().append("JRuby::Commands.").append(scriptName);
            this.config.getInlineScript().append("\n");
            this.config.setHasInlineScript(true);
        }
        this.endOfArguments = true;
    }

    private String resolve(String path2, String scriptName) {
        if (RubyInstanceConfig.DEBUG_SCRIPT_RESOLUTION) {
            this.config.getError().println("Trying path: " + path2);
        }
        try {
            FileResource fullName = JRubyFile.createRestrictedResource(path2, scriptName);
            if (fullName.exists() && fullName.isFile()) {
                if (RubyInstanceConfig.DEBUG_SCRIPT_RESOLUTION) {
                    this.config.getError().println("Found: " + fullName.absolutePath());
                }
                return fullName.absolutePath();
            }
        }
        catch (Exception exception2) {
            // empty catch block
        }
        return null;
    }

    private String resolveScript(String scriptName) {
        String result2 = this.resolve(this.config.getCurrentDirectory(), scriptName);
        if (result2 != null) {
            return scriptName;
        }
        result2 = this.resolve(this.config.getJRubyHome() + "/bin", scriptName);
        if (result2 != null) {
            return result2;
        }
        result2 = this.resolve(this.config.getCurrentDirectory() + "/bin", scriptName);
        if (result2 != null) {
            return result2;
        }
        result2 = this.resolve("uri:classloader:/bin", scriptName);
        if (result2 != null) {
            return result2;
        }
        String maybePath = this.config.getEnvironment().get("PATH");
        if (maybePath != null) {
            String path2 = maybePath.toString();
            String[] paths = path2.split(File.pathSeparator);
            for (int i2 = 0; i2 < paths.length; ++i2) {
                result2 = this.resolve(new File(paths[i2]).getAbsolutePath(), scriptName);
                if (result2 == null) continue;
                return result2;
            }
        }
        if (this.config.isDebug()) {
            this.config.getError().println("warning: could not resolve -S script: " + scriptName);
        }
        return null;
    }

    @Deprecated
    public String resolveScriptUsingClassLoader(String scriptName) {
        if (RubyInstanceConfig.defaultClassLoader().getResourceAsStream("bin/" + scriptName) != null) {
            return "classpath:/bin/" + scriptName;
        }
        return null;
    }

    private String grabValue(String errorMessage) {
        return this.grabValue(errorMessage, true);
    }

    private String grabValue(String errorMessage, boolean usageError) {
        String optValue = this.grabOptionalValue();
        if (optValue != null) {
            return optValue;
        }
        ++this.argumentIndex;
        if (this.argumentIndex < this.arguments.size()) {
            return this.arguments.get((int)this.argumentIndex).originalValue;
        }
        MainExitException mee = new MainExitException(1, errorMessage);
        if (usageError) {
            mee.setUsageError(true);
        }
        throw mee;
    }

    private String grabOptionalValue() {
        ++this.characterIndex;
        String argValue = this.arguments.get((int)this.argumentIndex).originalValue;
        if (this.characterIndex < argValue.length()) {
            return argValue.substring(this.characterIndex);
        }
        return null;
    }

    private static void checkProperties() {
        for (String propertyName : System.getProperties().stringPropertyNames()) {
            if (!propertyName.startsWith("jruby.") || ArgumentProcessor.isPropertySupported(propertyName)) continue;
            System.err.println("jruby: warning: unknown property " + propertyName);
        }
    }

    private static boolean isPropertySupported(String propertyName) {
        if (KNOWN_PROPERTIES.contains(propertyName)) {
            return true;
        }
        for (String prefix : KNOWN_PROPERTY_PREFIXES) {
            if (!propertyName.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    static {
        Options.addPropertyNames(KNOWN_PROPERTIES);
        KNOWN_PROPERTIES.add("jruby.home");
        KNOWN_PROPERTIES.add("jruby.script");
        KNOWN_PROPERTIES.add("jruby.shell");
        KNOWN_PROPERTIES.add("jruby.lib");
        KNOWN_PROPERTIES.add("jruby.bindir");
        KNOWN_PROPERTIES.add("jruby.jar");
        KNOWN_PROPERTIES.add("jruby.compat.version");
        KNOWN_PROPERTIES.add("jruby.reflection");
        KNOWN_PROPERTIES.add("jruby.thread.pool.enabled");
        KNOWN_PROPERTIES.add("jruby.memory.max");
        KNOWN_PROPERTIES.add("jruby.stack.max");
        KNOWN_PROPERTY_PREFIXES = new ArrayList<String>(4);
        KNOWN_PROPERTY_PREFIXES.add("jruby.openssl.");
        HashMap<String, BiFunction<ArgumentProcessor, Boolean, Void>> features = new HashMap<String, BiFunction<ArgumentProcessor, Boolean, Void>>(12, 1.0f);
        features.put("all", new BiFunction<ArgumentProcessor, Boolean, Void>(){

            @Override
            public Void apply(ArgumentProcessor processor, Boolean enable2) {
                for (Map.Entry entry : FEATURES.entrySet()) {
                    if (((String)entry.getKey()).equals("all")) continue;
                    ((BiFunction)entry.getValue()).apply(processor, enable2);
                }
                return null;
            }
        });
        features.put("gem", (processor, enable2) -> {
            processor.config.setDisableGems(enable2 == false);
            return null;
        });
        features.put("gems", (processor, enable2) -> {
            processor.config.setDisableGems(enable2 == false);
            return null;
        });
        BiFunction<ArgumentProcessor, Boolean, Void> function = (processor, enable2) -> {
            processor.config.setDisableDidYouMean(enable2 == false);
            return null;
        };
        features.put("did-you-mean", function);
        features.put("did_you_mean", function);
        features.put("rubyopt", (processor, enable2) -> {
            processor.config.setDisableRUBYOPT(enable2 == false);
            return null;
        });
        function = (processor, enable2) -> {
            processor.config.setFrozenStringLiteral((boolean)enable2);
            return null;
        };
        features.put("frozen-string-literal", function);
        features.put("frozen_string_literal", function);
        FEATURES = features;
    }

    private static final class Argument {
        final String originalValue;
        private String dashedValue;

        Argument(String value2, boolean dashed) {
            this.originalValue = value2;
            this.dashedValue = dashed ? null : value2;
        }

        final String getDashedValue() {
            String dashedValue = this.dashedValue;
            if (dashedValue == null) {
                String value2 = this.originalValue;
                this.dashedValue = dashedValue = !value2.startsWith("-") ? '-' + value2 : value2;
            }
            return dashedValue;
        }

        public String toString() {
            return this.getDashedValue();
        }
    }
}

