/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.internal;

import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubySystemExit;
import org.jruby.ast.Node;
import org.jruby.ast.executable.Script;
import org.jruby.embed.AttributeName;
import org.jruby.embed.EmbedEvalUnit;
import org.jruby.embed.EvalFailedException;
import org.jruby.embed.ScriptingContainer;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class EmbedEvalUnitImpl
implements EmbedEvalUnit {
    private final ScriptingContainer container;
    private final Node node;
    private final DynamicScope scope;
    private final Script script;
    private final boolean wrapExceptions;

    EmbedEvalUnitImpl(ScriptingContainer container, Node node, DynamicScope scope, Script script, boolean wrapExceptions) {
        this.container = container;
        this.node = node;
        this.scope = scope;
        this.script = script;
        this.wrapExceptions = wrapExceptions;
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public DynamicScope getLocalVarScope() {
        return this.scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject run() {
        if (this.node == null && this.script == null) {
            return null;
        }
        Ruby runtime2 = this.container.getProvider().getRuntime();
        BiVariableMap vars = this.container.getVarMap();
        boolean sharing_variables = EmbedEvalUnitImpl.isSharingVariables(this.container);
        ThreadContext context = runtime2.getCurrentContext();
        if (sharing_variables) {
            vars.inject(this.scope);
            context.pushScope(this.scope);
        }
        try {
            RubyInstanceConfig.CompileMode mode2 = runtime2.getInstanceConfig().getCompileMode();
            IRubyObject ret = mode2 == RubyInstanceConfig.CompileMode.FORCE ? runtime2.runScriptBody(this.script) : runtime2.runInterpreter(this.node);
            if (sharing_variables) {
                vars.retrieve(ret);
            }
            IRubyObject iRubyObject = ret;
            return iRubyObject;
        }
        catch (RaiseException e) {
            runtime2.getCurrentContext().setErrorInfo(runtime2.getNil());
            if (e.getException() instanceof RubySystemExit) {
                IRubyObject iRubyObject = ((RubySystemExit)e.getException()).status();
                return iRubyObject;
            }
            if (this.wrapExceptions) {
                throw new EvalFailedException(e.getMessage(), e);
            }
            throw e;
        }
        catch (Exception e) {
            if (this.wrapExceptions) {
                throw new EvalFailedException(e);
            }
            Helpers.throwException(e);
            IRubyObject iRubyObject = null;
            return iRubyObject;
        }
        finally {
            if (sharing_variables) {
                context.popScope();
            }
            vars.terminate();
        }
    }

    static boolean isSharingVariables(ScriptingContainer container) {
        Object sharing = container.getAttribute((Object)AttributeName.SHARING_VARIABLES);
        return !(sharing instanceof Boolean) || (Boolean)sharing != false;
    }
}

