/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaAccessibleObject;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@Deprecated
public class JavaField
extends JavaAccessibleObject {
    private final Field field;

    public final Field getValue() {
        return this.field;
    }

    public static RubyClass createJavaFieldClass(Ruby runtime2, RubyModule javaModule) {
        RubyClass result2 = javaModule.defineClassUnder("JavaField", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        JavaAccessibleObject.registerRubyMethods(runtime2, result2);
        result2.defineAnnotatedMethods(JavaField.class);
        return result2;
    }

    public JavaField(Ruby runtime2, Field field2) {
        super(runtime2, runtime2.getJavaSupport().getJavaFieldClass());
        this.field = field2;
    }

    @Override
    public final boolean equals(Object other) {
        return other instanceof JavaField && this.field.equals(((JavaField)other).field);
    }

    @Override
    public final int hashCode() {
        return this.field.hashCode();
    }

    @JRubyMethod
    public RubyString value_type(ThreadContext context) {
        return context.runtime.newString(this.field.getType().getName());
    }

    @JRubyMethod(name={"public?"})
    public RubyBoolean public_p(ThreadContext context) {
        return context.runtime.newBoolean(Modifier.isPublic(this.field.getModifiers()));
    }

    @JRubyMethod(name={"static?"})
    public RubyBoolean static_p(ThreadContext context) {
        return context.runtime.newBoolean(Modifier.isStatic(this.field.getModifiers()));
    }

    @JRubyMethod(name={"enum_constant?"})
    public RubyBoolean enum_constant_p(ThreadContext context) {
        return context.runtime.newBoolean(this.field.isEnumConstant());
    }

    @JRubyMethod
    public RubyString to_generic_string(ThreadContext context) {
        return context.runtime.newString(this.field.toGenericString());
    }

    @JRubyMethod(name={"type"})
    public IRubyObject field_type(ThreadContext context) {
        return JavaClass.get(context.runtime, this.field.getType());
    }

    @JRubyMethod
    public IRubyObject value(ThreadContext context, IRubyObject object) {
        Ruby runtime2 = context.runtime;
        Object javaObject = !Modifier.isStatic(this.field.getModifiers()) ? this.unwrapJavaObject(context, object) : null;
        try {
            return JavaField.convertToRuby(runtime2, this.field.get(javaObject));
        }
        catch (IllegalAccessException iae) {
            throw runtime2.newTypeError("illegal access");
        }
    }

    @JRubyMethod
    public IRubyObject set_value(ThreadContext context, IRubyObject object, IRubyObject value2) {
        Object javaObject = !Modifier.isStatic(this.field.getModifiers()) ? this.unwrapJavaObject(context, object) : null;
        Object javaValue = this.convertValueToJava(value2);
        try {
            this.field.set(javaObject, javaValue);
        }
        catch (IllegalAccessException iae) {
            throw context.runtime.newTypeError("illegal access on setting variable: " + iae.getMessage());
        }
        catch (IllegalArgumentException iae) {
            throw context.runtime.newTypeError("wrong type for " + this.field.getType().getName() + ": " + (javaValue == null ? null : javaValue.getClass().getName()));
        }
        return value2;
    }

    @JRubyMethod(name={"final?"})
    public RubyBoolean final_p(ThreadContext context) {
        return context.runtime.newBoolean(Modifier.isFinal(this.field.getModifiers()));
    }

    @JRubyMethod
    public IRubyObject static_value(ThreadContext context) {
        try {
            return JavaField.convertToRuby(context.runtime, this.field.get(null));
        }
        catch (IllegalAccessException iae) {
            throw context.runtime.newTypeError("illegal static value access: " + iae.getMessage());
        }
    }

    @JRubyMethod
    public IRubyObject set_static_value(ThreadContext context, IRubyObject value2) {
        if (!(value2 instanceof JavaObject)) {
            throw context.runtime.newTypeError("not a java object:" + value2);
        }
        Object javaValue = this.convertValueToJava(value2);
        try {
            this.field.set(null, javaValue);
        }
        catch (IllegalAccessException iae) {
            throw context.runtime.newTypeError("illegal access on setting static variable: " + iae.getMessage());
        }
        catch (IllegalArgumentException iae) {
            throw context.runtime.newTypeError("wrong type for " + this.field.getType().getName() + ": " + (javaValue == null ? null : javaValue.getClass().getName()));
        }
        return value2;
    }

    @Override
    @JRubyMethod
    public RubyString name(ThreadContext context) {
        return context.runtime.newString(this.field.getName());
    }

    @Override
    public AccessibleObject accessibleObject() {
        return this.field;
    }

    private Object unwrapJavaObject(ThreadContext context, IRubyObject object) throws RaiseException {
        Object javaObject = JavaUtil.unwrapJavaValue(object);
        if (javaObject == null) {
            throw context.runtime.newTypeError("not a java object: " + object);
        }
        return javaObject;
    }

    private Object convertValueToJava(IRubyObject value2) {
        Object val = value2.dataGetStruct();
        if (val instanceof JavaObject) {
            value2 = (IRubyObject)val;
        }
        return value2.toJava(this.field.getType());
    }

    private static IRubyObject convertToRuby(Ruby runtime2, Object javaValue) {
        return JavaUtil.convertJavaToUsableRubyObject(runtime2, javaValue);
    }
}

