/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.RubySymbol;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.OneOperandResultBaseInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.targets.simple.ConstantLookupSite;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class SearchModuleForConstInstr
extends OneOperandResultBaseInstr
implements FixedArityInstr {
    private final RubySymbol constantName;
    private final boolean noPrivateConsts;
    private final boolean callConstMissing;
    private final ConstantLookupSite site;

    public SearchModuleForConstInstr(Variable result2, Operand currentModule, RubySymbol constantName, boolean noPrivateConsts) {
        this(result2, currentModule, constantName, noPrivateConsts, true);
    }

    public SearchModuleForConstInstr(Variable result2, Operand currentModule, RubySymbol constantName, boolean noPrivateConsts, boolean callConstMissing) {
        super(Operation.SEARCH_MODULE_FOR_CONST, result2, currentModule);
        this.constantName = constantName;
        this.noPrivateConsts = noPrivateConsts;
        this.callConstMissing = callConstMissing;
        this.site = new ConstantLookupSite(constantName);
    }

    public Operand getCurrentModule() {
        return this.getOperand1();
    }

    public String getId() {
        return this.constantName.idString();
    }

    public RubySymbol getName() {
        return this.constantName;
    }

    public boolean isNoPrivateConsts() {
        return this.noPrivateConsts;
    }

    public boolean callConstMissing() {
        return this.callConstMissing;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new SearchModuleForConstInstr(ii.getRenamedVariable(this.result), this.getCurrentModule().cloneForInlining(ii), this.constantName, this.noPrivateConsts, this.callConstMissing);
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"name: " + this.constantName, "no_priv: " + this.noPrivateConsts};
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getCurrentModule());
        e.encode(this.getName());
        e.encode(this.isNoPrivateConsts());
        e.encode(this.callConstMissing());
    }

    public static SearchModuleForConstInstr decode(IRReaderDecoder d) {
        return new SearchModuleForConstInstr(d.decodeVariable(), d.decodeOperand(), d.decodeSymbol(), d.decodeBoolean(), d.decodeBoolean());
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        Object cmVal = this.getCurrentModule().retrieve(context, self2, currScope, currDynScope, temp);
        return this.site.searchModuleForConst(context, (IRubyObject)cmVal, this.noPrivateConsts, this.callConstMissing);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.SearchModuleForConstInstr(this);
    }
}

