/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.strscan;

import java.util.Iterator;
import org.jcodings.Encoding;
import org.joni.Matcher;
import org.joni.NameEntry;
import org.joni.Regex;
import org.joni.Region;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyMatchData;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.StringSupport;

@JRubyClass(name={"StringScanner"})
public class RubyStringScanner
extends RubyObject {
    private RubyString str;
    private int curr = 0;
    private int prev = -1;
    private Region regs;
    private Regex pattern;
    private int scannerFlags;
    private boolean fixedAnchor;
    private static final int MATCHED_STR_SCN_F = 2048;
    final ThreadLocal<Matcher> currentMatcher = new ThreadLocal();
    final RubyThread.Task<RubyStringScanner, Integer> task = new RubyThread.Task<RubyStringScanner, Integer>(){

        @Override
        public Integer run(ThreadContext context, RubyStringScanner rubyStringScanner) throws InterruptedException {
            ByteList value2 = RubyStringScanner.this.str.getByteList();
            return RubyStringScanner.this.currentMatcher.get().matchInterruptible(value2.begin() + RubyStringScanner.this.curr, value2.begin() + value2.realSize(), 0);
        }

        @Override
        public void wakeup(RubyThread thread2, RubyStringScanner rubyStringScanner) {
            thread2.getNativeThread().interrupt();
        }
    };
    private static final int INSPECT_LENGTH = 5;
    private static final byte[] DOT_BYTES = "...".getBytes();

    public static RubyClass createScannerClass(Ruby runtime2) {
        RubyClass Object2 = runtime2.getObject();
        RubyClass scannerClass = runtime2.defineClass("StringScanner", Object2, RubyStringScanner::new);
        RubyClass standardError = runtime2.getStandardError();
        RubyClass error2 = scannerClass.defineClassUnder("Error", standardError, standardError.getAllocator());
        if (!Object2.isConstantDefined("ScanError")) {
            Object2.defineConstant("ScanError", error2);
        }
        RubyString version = runtime2.newString("3.0.2");
        version.setFrozen(true);
        scannerClass.setConstant("Version", version);
        RubyString id2 = runtime2.newString("$Id$");
        id2.setFrozen(true);
        scannerClass.setConstant("Id", id2);
        scannerClass.defineAnnotatedMethods(RubyStringScanner.class);
        return scannerClass;
    }

    private void clearMatched() {
        this.scannerFlags &= 0xFFFFF7FF;
    }

    private void setMatched() {
        this.scannerFlags |= 0x800;
    }

    private boolean isMatched() {
        return (this.scannerFlags & 0x800) != 0;
    }

    private void check(ThreadContext context) {
        if (this.str == null) {
            throw context.runtime.newArgumentError("uninitialized StringScanner object");
        }
    }

    protected RubyStringScanner(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject string2) {
        return this.initialize(context, string2, context.nil);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject string2, IRubyObject dupOrOpts) {
        this.str = string2.convertToString();
        this.fixedAnchor = ArgsUtil.extractKeywordArg(context, "fixed_anchor", dupOrOpts).isTrue();
        this.regs = Region.newRegion(0, 0);
        return this;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject string2, IRubyObject dup2, IRubyObject opts) {
        return this.initialize(context, string2, opts);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(ThreadContext context, IRubyObject other) {
        if (this == other) {
            return this;
        }
        if (!(other instanceof RubyStringScanner)) {
            throw context.runtime.newTypeError("wrong argument type " + other.getMetaClass() + " (expected StringScanner)");
        }
        RubyStringScanner otherScanner = (RubyStringScanner)other;
        this.str = otherScanner.str;
        this.curr = otherScanner.curr;
        this.prev = otherScanner.prev;
        this.scannerFlags = otherScanner.scannerFlags;
        this.regs = otherScanner.regs.clone();
        this.pattern = otherScanner.pattern;
        this.fixedAnchor = otherScanner.fixedAnchor;
        return this;
    }

    @JRubyMethod(name={"reset"})
    public IRubyObject reset(ThreadContext context) {
        this.check(context);
        this.curr = 0;
        this.clearMatched();
        return this;
    }

    @JRubyMethod(name={"terminate"})
    public IRubyObject terminate(ThreadContext context) {
        this.check(context);
        this.curr = this.str.getByteList().getRealSize();
        this.clearMatched();
        return this;
    }

    @JRubyMethod(name={"clear"})
    public IRubyObject clear(ThreadContext context) {
        this.check(context);
        Ruby runtime2 = context.runtime;
        if (runtime2.isVerbose()) {
            runtime2.getWarnings().warning(IRubyWarnings.ID.DEPRECATED_METHOD, "StringScanner#clear is obsolete; use #terminate instead");
        }
        return this.terminate(context);
    }

    @JRubyMethod(name={"string"})
    public RubyString string() {
        return this.str;
    }

    @JRubyMethod(name={"string="})
    public IRubyObject set_string(ThreadContext context, IRubyObject str) {
        this.str = RubyString.stringValue(str);
        this.curr = 0;
        this.clearMatched();
        return str;
    }

    @JRubyMethod(name={"concat", "<<"})
    public IRubyObject concat(ThreadContext context, IRubyObject obj) {
        this.check(context);
        this.str.append(obj.convertToString());
        return this;
    }

    @JRubyMethod(name={"pos", "pointer"})
    public RubyFixnum pos(ThreadContext context) {
        this.check(context);
        return RubyFixnum.newFixnum(context.runtime, this.curr);
    }

    @JRubyMethod(name={"pos=", "pointer="})
    public IRubyObject set_pos(ThreadContext context, IRubyObject pos2) {
        this.check(context);
        Ruby runtime2 = context.runtime;
        int i2 = RubyNumeric.num2int(pos2);
        int size2 = this.str.getByteList().getRealSize();
        if (i2 < 0) {
            i2 += size2;
        }
        if (i2 < 0 || i2 > size2) {
            throw runtime2.newRangeError("index out of range.");
        }
        this.curr = i2;
        return RubyFixnum.newFixnum(runtime2, i2);
    }

    @JRubyMethod(name={"charpos"})
    public IRubyObject charpos(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        ByteList strBL = this.str.getByteList();
        int strBeg = strBL.begin();
        return runtime2.newFixnum(StringSupport.strLength(strBL.getEncoding(), strBL.unsafeBytes(), strBeg, strBeg + this.curr));
    }

    private IRubyObject extractRange(Ruby runtime2, int beg, int end2) {
        int size2 = this.str.getByteList().getRealSize();
        if (beg > size2) {
            return runtime2.getNil();
        }
        if (end2 > size2) {
            end2 = size2;
        }
        return this.str.makeSharedString(runtime2, beg, end2 - beg);
    }

    private IRubyObject extractBegLen(Ruby runtime2, int beg, int len) {
        assert (len >= 0);
        int size2 = this.str.getByteList().getRealSize();
        if (beg > size2) {
            return runtime2.getNil();
        }
        len = Math.min(len, size2 - beg);
        return this.str.makeSharedString(runtime2, beg, len);
    }

    private IRubyObject scan(ThreadContext context, IRubyObject regex, boolean succptr, boolean getstr, boolean headonly) {
        Ruby runtime2 = context.runtime;
        if (headonly) {
            if (!(regex instanceof RubyRegexp)) {
                regex = regex.convertToString();
            }
        } else if (!(regex instanceof RubyRegexp)) {
            throw runtime2.newTypeError("wrong argument type " + regex.getMetaClass() + " (expected Regexp)");
        }
        this.check(context);
        ByteList strBL = this.str.getByteList();
        int strBeg = strBL.getBegin();
        this.clearMatched();
        if (this.restLen() < 0) {
            return context.nil;
        }
        if (regex instanceof RubyRegexp) {
            this.pattern = ((RubyRegexp)regex).preparePattern(this.str);
            int currPtr = this.currPtr();
            int range = currPtr + this.restLen();
            Matcher matcher = this.pattern.matcher(strBL.getUnsafeBytes(), this.matchTarget(), range);
            int ret = headonly ? RubyRegexp.matcherMatch(context, matcher, currPtr, range, 0) : RubyRegexp.matcherSearch(context, matcher, currPtr, range, 0);
            Region matchRegion = matcher.getRegion();
            this.regs = matchRegion == null ? Region.newRegion(matcher.getBegin(), matcher.getEnd()) : matchRegion;
            if (ret == -2) {
                throw runtime2.newRaiseException((RubyClass)this.getMetaClass().getConstant("ScanError"), "regexp buffer overflow");
            }
            if (ret < 0) {
                return context.nil;
            }
        } else {
            RubyString pattern = (RubyString)regex;
            this.str.checkEncoding(pattern);
            if (this.restLen() < pattern.size()) {
                return context.nil;
            }
            ByteList patternBL = pattern.getByteList();
            int patternSize = patternBL.realSize();
            if (ByteList.memcmp(strBL.unsafeBytes(), strBeg + this.curr, patternBL.unsafeBytes(), patternBL.begin(), patternSize) != 0) {
                return context.nil;
            }
            this.setRegisters(patternSize);
        }
        this.setMatched();
        this.prev = this.curr;
        if (succptr) {
            this.succ();
        }
        int length2 = this.lastMatchLength();
        if (getstr) {
            return this.extractBegLen(runtime2, this.prev, length2);
        }
        return RubyFixnum.newFixnum(runtime2, length2);
    }

    private int lastMatchLength() {
        if (this.fixedAnchor) {
            return this.regs.getEnd(0) - this.prev;
        }
        return this.regs.getEnd(0);
    }

    private void succ() {
        this.curr = this.fixedAnchor ? this.regs.getEnd(0) : (this.curr += this.regs.getEnd(0));
    }

    private int currPtr() {
        return this.str.getByteList().getBegin() + this.curr;
    }

    private int matchTarget() {
        if (this.fixedAnchor) {
            return this.str.getByteList().getBegin();
        }
        return this.str.getByteList().getBegin() + this.curr;
    }

    private int restLen() {
        return this.str.size() - this.curr;
    }

    private void setRegisters(int length2) {
        this.regs = this.fixedAnchor ? Region.newRegion(this.curr, this.curr + length2) : Region.newRegion(0, length2);
    }

    @JRubyMethod(name={"scan"})
    public IRubyObject scan(ThreadContext context, IRubyObject regex) {
        return this.scan(context, regex, true, true, true);
    }

    @JRubyMethod(name={"match?"})
    public IRubyObject match_p(ThreadContext context, IRubyObject regex) {
        return this.scan(context, regex, false, false, true);
    }

    @JRubyMethod(name={"skip"})
    public IRubyObject skip(ThreadContext context, IRubyObject regex) {
        return this.scan(context, regex, true, false, true);
    }

    @JRubyMethod(name={"check"})
    public IRubyObject check(ThreadContext context, IRubyObject regex) {
        return this.scan(context, regex, false, true, true);
    }

    @JRubyMethod(name={"scan_full"})
    public IRubyObject scan_full(ThreadContext context, IRubyObject regex, IRubyObject s2, IRubyObject f) {
        return this.scan(context, regex, s2.isTrue(), f.isTrue(), true);
    }

    @JRubyMethod(name={"scan_until"})
    public IRubyObject scan_until(ThreadContext context, IRubyObject regex) {
        return this.scan(context, regex, true, true, false);
    }

    @JRubyMethod(name={"exist?"})
    public IRubyObject exist_p(ThreadContext context, IRubyObject regex) {
        return this.scan(context, regex, false, false, false);
    }

    @JRubyMethod(name={"skip_until"})
    public IRubyObject skip_until(ThreadContext context, IRubyObject regex) {
        return this.scan(context, regex, true, false, false);
    }

    @JRubyMethod(name={"check_until"})
    public IRubyObject check_until(ThreadContext context, IRubyObject regex) {
        return this.scan(context, regex, false, true, false);
    }

    @JRubyMethod(name={"search_full"})
    public IRubyObject search_full(ThreadContext context, IRubyObject regex, IRubyObject s2, IRubyObject f) {
        return this.scan(context, regex, s2.isTrue(), f.isTrue(), false);
    }

    private void adjustRegisters() {
        this.regs = this.fixedAnchor ? Region.newRegion(this.prev, this.curr) : Region.newRegion(0, this.curr - this.prev);
    }

    private int adjustRegisterPosition(int position) {
        if (this.fixedAnchor) {
            return position;
        }
        return this.prev + position;
    }

    @JRubyMethod(name={"getch"})
    public IRubyObject getch(ThreadContext context) {
        return this.getchCommon(context);
    }

    public IRubyObject getchCommon(ThreadContext context) {
        this.check(context);
        this.clearMatched();
        ByteList strBL = this.str.getByteList();
        int strSize = strBL.getRealSize();
        if (this.curr >= strSize) {
            return context.nil;
        }
        Ruby runtime2 = context.runtime;
        Encoding strEnc = strBL.getEncoding();
        int setBeg = strBL.getBegin();
        int len = strEnc.isSingleByte() ? 1 : StringSupport.length(strEnc, strBL.getUnsafeBytes(), setBeg + this.curr, setBeg + strSize);
        len = Math.min(len, this.restLen());
        this.prev = this.curr;
        this.curr += len;
        this.setMatched();
        this.adjustRegisters();
        return this.extractRange(runtime2, this.adjustRegisterPosition(this.regs.getBeg(0)), this.adjustRegisterPosition(this.regs.getEnd(0)));
    }

    @JRubyMethod(name={"get_byte"})
    public IRubyObject get_byte(ThreadContext context) {
        this.check(context);
        this.clearMatched();
        if (this.curr >= this.str.getByteList().getRealSize()) {
            return context.nil;
        }
        this.prev = this.curr++;
        this.setMatched();
        this.adjustRegisters();
        return this.extractRange(context.runtime, this.adjustRegisterPosition(this.regs.getBeg(0)), this.adjustRegisterPosition(this.regs.getEnd(0)));
    }

    @JRubyMethod(name={"getbyte"})
    public IRubyObject getbyte(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        if (runtime2.isVerbose()) {
            runtime2.getWarnings().warning(IRubyWarnings.ID.DEPRECATED_METHOD, "StringScanner#getbyte is obsolete; use #get_byte instead");
        }
        return this.get_byte(context);
    }

    @JRubyMethod(name={"peek"})
    public IRubyObject peek(ThreadContext context, IRubyObject length2) {
        this.check(context);
        int len = RubyNumeric.num2int(length2);
        if (len < 0) {
            throw context.runtime.newArgumentError("negative string size (or size too big)");
        }
        ByteList value2 = this.str.getByteList();
        if (this.curr >= value2.getRealSize()) {
            return RubyString.newEmptyString(context.runtime);
        }
        if (this.curr + len > value2.getRealSize()) {
            len = value2.getRealSize() - this.curr;
        }
        return this.extractBegLen(context.runtime, this.curr, len);
    }

    @JRubyMethod(name={"peep"})
    public IRubyObject peep(ThreadContext context, IRubyObject length2) {
        Ruby runtime2 = context.runtime;
        if (runtime2.isVerbose()) {
            runtime2.getWarnings().warning(IRubyWarnings.ID.DEPRECATED_METHOD, "StringScanner#peep is obsolete; use #peek instead");
        }
        return this.peek(context, length2);
    }

    @JRubyMethod(name={"unscan"})
    public IRubyObject unscan(ThreadContext context) {
        this.check(context);
        if (!this.isMatched()) {
            Ruby runtime2 = context.runtime;
            RubyClass errorClass = runtime2.getClass("StringScanner").getClass("Error");
            throw RaiseException.from(runtime2, errorClass, "unscan failed: previous match had failed");
        }
        this.curr = this.prev;
        this.clearMatched();
        return this;
    }

    @JRubyMethod(name={"beginning_of_line?"}, alias={"bol?"})
    public IRubyObject bol_p(ThreadContext context) {
        this.check(context);
        ByteList value2 = this.str.getByteList();
        if (this.curr > value2.getRealSize()) {
            return context.nil;
        }
        if (this.curr == 0) {
            return context.tru;
        }
        return value2.getUnsafeBytes()[value2.getBegin() + this.curr - 1] == 10 ? context.tru : context.fals;
    }

    @JRubyMethod(name={"eos?"})
    public RubyBoolean eos_p(ThreadContext context) {
        this.check(context);
        return this.curr >= this.str.getByteList().getRealSize() ? context.tru : context.fals;
    }

    @JRubyMethod(name={"empty?"})
    public RubyBoolean empty_p(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        if (runtime2.isVerbose()) {
            runtime2.getWarnings().warning(IRubyWarnings.ID.DEPRECATED_METHOD, "StringScanner#empty? is obsolete; use #eos? instead");
        }
        return this.eos_p(context);
    }

    @JRubyMethod(name={"rest?"})
    public RubyBoolean rest_p(ThreadContext context) {
        this.check(context);
        return this.curr >= this.str.getByteList().getRealSize() ? context.fals : context.tru;
    }

    @JRubyMethod(name={"matched?"})
    public RubyBoolean matched_p(ThreadContext context) {
        this.check(context);
        return this.isMatched() ? context.tru : context.fals;
    }

    @JRubyMethod(name={"matched"})
    public IRubyObject matched(ThreadContext context) {
        this.check(context);
        if (!this.isMatched()) {
            return context.nil;
        }
        return this.extractRange(context.runtime, this.adjustRegisterPosition(this.regs.getBeg(0)), this.adjustRegisterPosition(this.regs.getEnd(0)));
    }

    @JRubyMethod(name={"matched_size"})
    public IRubyObject matched_size(ThreadContext context) {
        this.check(context);
        if (!this.isMatched()) {
            return context.nil;
        }
        return RubyFixnum.newFixnum(context.runtime, this.regs.getEnd(0) - this.regs.getBeg(0));
    }

    @JRubyMethod(name={"matchedsize"})
    public IRubyObject matchedsize(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        if (runtime2.isVerbose()) {
            runtime2.getWarnings().warning(IRubyWarnings.ID.DEPRECATED_METHOD, "StringScanner#matchedsize is obsolete; use #matched_size instead");
        }
        return this.matched_size();
    }

    @JRubyMethod(name={"[]"})
    public IRubyObject op_aref(ThreadContext context, IRubyObject idx) {
        this.check(context);
        if (!this.isMatched()) {
            return context.nil;
        }
        if ((idx instanceof RubySymbol || idx instanceof RubyString) && this.pattern == null) {
            return context.nil;
        }
        Ruby runtime2 = context.runtime;
        int i2 = RubyMatchData.backrefNumber(runtime2, this.pattern, this.regs, idx);
        return this.extractRegion(context, i2);
    }

    private IRubyObject extractRegion(ThreadContext context, int i2) {
        int numRegs = this.regs.getNumRegs();
        if (i2 < 0) {
            i2 += numRegs;
        }
        if (i2 < 0 || i2 >= numRegs || this.regs.getBeg(i2) == -1) {
            return context.nil;
        }
        return this.extractRange(context.runtime, this.adjustRegisterPosition(this.regs.getBeg(i2)), this.adjustRegisterPosition(this.regs.getEnd(i2)));
    }

    @JRubyMethod(name={"pre_match"})
    public IRubyObject pre_match(ThreadContext context) {
        this.check(context);
        if (!this.isMatched()) {
            return context.nil;
        }
        return this.extractRange(context.runtime, 0, this.adjustRegisterPosition(this.regs.getBeg(0)));
    }

    @JRubyMethod(name={"post_match"})
    public IRubyObject post_match(ThreadContext context) {
        this.check(context);
        if (!this.isMatched()) {
            return context.nil;
        }
        return this.extractRange(context.runtime, this.adjustRegisterPosition(this.regs.getEnd(0)), this.str.getByteList().getRealSize());
    }

    @JRubyMethod(name={"rest"})
    public IRubyObject rest(ThreadContext context) {
        this.check(context);
        Ruby runtime2 = context.runtime;
        ByteList value2 = this.str.getByteList();
        if (this.curr >= value2.getRealSize()) {
            return RubyString.newEmptyString(runtime2);
        }
        return this.extractRange(runtime2, this.curr, value2.getRealSize());
    }

    @JRubyMethod(name={"rest_size"})
    public RubyFixnum rest_size(ThreadContext context) {
        this.check(context);
        Ruby runtime2 = context.runtime;
        ByteList value2 = this.str.getByteList();
        if (this.curr >= value2.getRealSize()) {
            return RubyFixnum.zero(runtime2);
        }
        return RubyFixnum.newFixnum(runtime2, value2.getRealSize() - this.curr);
    }

    @JRubyMethod(name={"restsize"})
    public RubyFixnum restsize(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        if (runtime2.isVerbose()) {
            runtime2.getWarnings().warning(IRubyWarnings.ID.DEPRECATED_METHOD, "StringScanner#restsize is obsolete; use #rest_size instead");
        }
        return this.rest_size(context);
    }

    @Override
    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        if (this.str == null) {
            return this.inspect("(uninitialized)");
        }
        if (this.curr >= this.str.getByteList().getRealSize()) {
            return this.inspect("fin");
        }
        if (this.curr == 0) {
            return this.inspect(this.curr + "/" + this.str.getByteList().getRealSize() + " @ " + this.inspect2());
        }
        return this.inspect(this.curr + "/" + this.str.getByteList().getRealSize() + " " + this.inspect1() + " @ " + this.inspect2());
    }

    @JRubyMethod(name={"fixed_anchor?"})
    public IRubyObject fixed_anchor_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.fixedAnchor);
    }

    @JRubyMethod(name={"named_captures"})
    public IRubyObject named_captured(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        IRubyObject nil = context.nil;
        RubyHash captures2 = RubyHash.newHash(runtime2);
        if (this.pattern == null) {
            return captures2;
        }
        Iterator<NameEntry> nameEntryIterator = this.pattern.namedBackrefIterator();
        while (nameEntryIterator.hasNext()) {
            NameEntry nameEntry = nameEntryIterator.next();
            IRubyObject value2 = nil;
            for (int i2 : nameEntry.getBackRefs()) {
                value2 = this.extractRegion(context, i2);
            }
            int nameP = nameEntry.nameP;
            captures2.op_aset(context, RubyString.newStringShared(runtime2, nameEntry.name, nameP, nameEntry.nameEnd - nameP), value2);
        }
        return captures2;
    }

    private IRubyObject inspect(String msg) {
        RubyString result2 = this.getRuntime().newString("#<" + this.getMetaClass() + " " + msg + ">");
        return result2;
    }

    private IRubyObject inspect1() {
        Ruby runtime2 = this.getRuntime();
        if (this.curr == 0) {
            return RubyString.newEmptyString(runtime2);
        }
        if (this.curr > 5) {
            return RubyString.newStringNoCopy(runtime2, DOT_BYTES).append(this.str.substr(runtime2, this.curr - 5, 5)).inspect();
        }
        return this.str.substr(runtime2, 0, this.curr).inspect();
    }

    private IRubyObject inspect2() {
        Ruby runtime2 = this.getRuntime();
        if (this.curr >= this.str.getByteList().getRealSize()) {
            return RubyString.newEmptyString(runtime2);
        }
        int len = this.str.getByteList().getRealSize() - this.curr;
        if (len > 5) {
            return ((RubyString)this.str.substr(runtime2, this.curr, 5)).cat(DOT_BYTES).inspect();
        }
        return this.str.substr(runtime2, this.curr, len).inspect();
    }

    @JRubyMethod(name={"size"})
    public IRubyObject size(ThreadContext context) {
        if (!this.isMatched()) {
            return context.nil;
        }
        return context.runtime.newFixnum(this.regs.getNumRegs());
    }

    @JRubyMethod(name={"captures"})
    public IRubyObject captures(ThreadContext context) {
        if (!this.isMatched()) {
            return context.nil;
        }
        Ruby runtime2 = context.runtime;
        int numRegs = this.regs.getNumRegs();
        RubyArray newAry = RubyArray.newArray(runtime2, numRegs);
        for (int i2 = 1; i2 < numRegs; ++i2) {
            IRubyObject str = this.extractRange(runtime2, this.adjustRegisterPosition(this.regs.getBeg(i2)), this.adjustRegisterPosition(this.regs.getEnd(i2)));
            newAry.push(str);
        }
        return newAry;
    }

    @JRubyMethod(name={"values_at"}, rest=true)
    public IRubyObject values_at(ThreadContext context, IRubyObject[] args2) {
        if (!this.isMatched()) {
            return context.nil;
        }
        Ruby runtime2 = context.runtime;
        RubyArray newAry = RubyArray.newArray(runtime2, args2.length);
        for (int i2 = 0; i2 < args2.length; ++i2) {
            newAry.push(this.op_aref(context, args2[i2]));
        }
        return newAry;
    }

    @Deprecated
    public IRubyObject initialize(IRubyObject[] args2, Block unusedBlock) {
        this.str = args2[0].convertToString();
        return this;
    }

    @Override
    @Deprecated
    public IRubyObject initialize_copy(IRubyObject other) {
        return this.initialize_copy(this.getRuntime().getCurrentContext(), other);
    }

    @Deprecated
    public IRubyObject concat(IRubyObject obj) {
        return this.concat(this.getRuntime().getCurrentContext(), obj);
    }

    @Deprecated
    public RubyFixnum pos() {
        return this.pos(this.getRuntime().getCurrentContext());
    }

    @Deprecated
    public IRubyObject set_pos(IRubyObject pos2) {
        return this.set_pos(this.getRuntime().getCurrentContext(), pos2);
    }

    @Deprecated
    public IRubyObject getch19(ThreadContext context) {
        return this.getch(context);
    }

    @Deprecated
    public IRubyObject reset() {
        return this.reset(this.getRuntime().getCurrentContext());
    }

    @Deprecated
    public IRubyObject unscan() {
        return this.unscan(this.getRuntime().getCurrentContext());
    }

    @Deprecated
    public IRubyObject matched_size() {
        return this.matched_size(this.getRuntime().getCurrentContext());
    }

    @Deprecated
    public IRubyObject bol_p() {
        return this.bol_p(this.getRuntime().getCurrentContext());
    }

    @Deprecated
    public RubyFixnum rest_size() {
        return this.rest_size(this.getRuntime().getCurrentContext());
    }

    @Deprecated
    public IRubyObject getchCommon(ThreadContext context, boolean is1_9) {
        return this.getchCommon(context);
    }

    @Deprecated
    @JRubyMethod(name={"must_C_version"}, meta=true)
    public static IRubyObject mustCversion(IRubyObject recv2) {
        return recv2;
    }
}

