/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.util.Arrays;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.ivars.MethodData;
import org.jruby.runtime.ivars.VariableAccessor;

public class AttrWriterMethod
extends JavaMethod.JavaMethodOne {
    private MethodData methodData;
    private final String variableName;
    private VariableAccessor accessor = VariableAccessor.DUMMY_ACCESSOR;

    public AttrWriterMethod(RubyModule implementationClass, Visibility visibility, String variableName) {
        super(implementationClass, visibility, variableName + "=");
        this.variableName = variableName;
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg1) {
        this.verifyAccessor(self2.getMetaClass().getRealClass()).set(self2, arg1);
        return arg1;
    }

    public String getVariableName() {
        return this.variableName;
    }

    private VariableAccessor verifyAccessor(RubyClass cls) {
        VariableAccessor localAccessor = this.accessor;
        if (localAccessor.getClassId() != cls.id) {
            this.accessor = localAccessor = cls.getVariableAccessorForWrite(this.variableName);
        }
        return localAccessor;
    }

    @Override
    public MethodData getMethodData() {
        if (this.methodData == null) {
            this.methodData = new MethodData(this.name, "dummyfile", Arrays.asList(this.variableName));
        }
        return this.methodData;
    }

    @Deprecated
    public AttrWriterMethod(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfiguration, String variableName) {
        this(implementationClass, visibility, variableName);
    }
}

