/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Locale;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComplex;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.ConvertDouble;
import org.jruby.util.Numeric;
import org.jruby.util.Sprintf;

@JRubyClass(name={"Float"}, parent="Numeric")
public class RubyFloat
extends RubyNumeric {
    public static final int ROUNDS = 1;
    public static final int RADIX = 2;
    public static final int MANT_DIG = 53;
    public static final int DIG = 15;
    public static final int MIN_EXP = -1021;
    public static final int MAX_EXP = 1024;
    public static final int MAX_10_EXP = 308;
    public static final int MIN_10_EXP = -307;
    public static final double EPSILON = 2.220446049250313E-16;
    public static final double INFINITY = Double.POSITIVE_INFINITY;
    public static final double NAN = Double.NaN;
    public static final int FLOAT_DIG = 17;
    final double value;
    static final int DBL_MANT_DIG = 53;
    private static final ByteList NAN_BYTELIST = new ByteList("nan".getBytes());
    private static final ByteList NEGATIVE_INFINITY_BYTELIST = new ByteList("-inf".getBytes());
    private static final ByteList INFINITY_BYTELIST = new ByteList("inf".getBytes());

    public static RubyClass createFloatClass(Ruby runtime2) {
        RubyClass floatc = runtime2.defineClass("Float", runtime2.getNumeric(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        floatc.setClassIndex(ClassIndex.FLOAT);
        floatc.setReifiedClass(RubyFloat.class);
        floatc.kindOf = new RubyModule.JavaClassKindOf(RubyFloat.class);
        floatc.getSingletonClass().undefineMethod("new");
        floatc.defineConstant("ROUNDS", RubyFixnum.newFixnum(runtime2, 1L));
        floatc.defineConstant("RADIX", RubyFixnum.newFixnum(runtime2, 2L));
        floatc.defineConstant("MANT_DIG", RubyFixnum.newFixnum(runtime2, 53L));
        floatc.defineConstant("DIG", RubyFixnum.newFixnum(runtime2, 15L));
        floatc.defineConstant("MIN_EXP", RubyFixnum.newFixnum(runtime2, -1021L));
        floatc.defineConstant("MAX_EXP", RubyFixnum.newFixnum(runtime2, 1024L));
        floatc.defineConstant("MIN_10_EXP", RubyFixnum.newFixnum(runtime2, -307L));
        floatc.defineConstant("MAX_10_EXP", RubyFixnum.newFixnum(runtime2, 308L));
        floatc.defineConstant("MIN", new RubyFloat(floatc, Double.MIN_NORMAL));
        floatc.defineConstant("MAX", new RubyFloat(floatc, Double.MAX_VALUE));
        floatc.defineConstant("EPSILON", new RubyFloat(floatc, 2.220446049250313E-16));
        floatc.defineConstant("INFINITY", new RubyFloat(floatc, Double.POSITIVE_INFINITY));
        floatc.defineConstant("NAN", new RubyFloat(floatc, Double.NaN));
        floatc.defineAnnotatedMethods(RubyFloat.class);
        return floatc;
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.FLOAT;
    }

    public RubyFloat(Ruby runtime2) {
        this(runtime2, 0.0);
    }

    public RubyFloat(Ruby runtime2, double value2) {
        super(runtime2.getFloat());
        this.value = value2;
        this.flags |= FROZEN_F;
    }

    private RubyFloat(RubyClass klass, double value2) {
        super(klass);
        this.value = value2;
        this.flags |= FROZEN_F;
    }

    @Override
    public RubyClass getSingletonClass() {
        throw this.getRuntime().newTypeError("can't define singleton");
    }

    @Override
    public Class<?> getJavaClass() {
        return Double.TYPE;
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public double getDoubleValue() {
        return this.value;
    }

    @Override
    public long getLongValue() {
        return (long)this.value;
    }

    @Override
    public int getIntValue() {
        return (int)this.value;
    }

    @Override
    public BigInteger getBigIntegerValue() {
        return RubyBignum.toBigInteger(this.value);
    }

    @Override
    public RubyFloat convertToFloat() {
        return this;
    }

    @Override
    public RubyInteger convertToInteger() {
        return this.toInteger(this.metaClass.runtime);
    }

    private RubyInteger toInteger(Ruby runtime2) {
        if (this.value > 0.0) {
            return RubyFloat.dbl2ival(runtime2, Math.floor(this.value));
        }
        return RubyFloat.dbl2ival(runtime2, Math.ceil(this.value));
    }

    public int signum() {
        return (int)Math.signum(this.value);
    }

    @Override
    @JRubyMethod(name={"negative?"})
    public IRubyObject isNegative(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.isNegative());
    }

    @Override
    @JRubyMethod(name={"positive?"})
    public IRubyObject isPositive(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.isPositive());
    }

    @Override
    public boolean isNegative() {
        return this.signum() < 0;
    }

    @Override
    public boolean isPositive() {
        return this.signum() > 0;
    }

    public static RubyFloat newFloat(Ruby runtime2, double value2) {
        return new RubyFloat(runtime2, value2);
    }

    @Deprecated
    public static IRubyObject induced_from(ThreadContext context, IRubyObject recv2, IRubyObject number) {
        if (number instanceof RubyFixnum || number instanceof RubyBignum || number instanceof RubyRational) {
            return number.callMethod(context, "to_f");
        }
        if (number instanceof RubyFloat) {
            return number;
        }
        throw context.runtime.newTypeError("failed to convert " + number.getMetaClass() + " into Float");
    }

    @Override
    @JRubyMethod(name={"to_s", "inspect"})
    public IRubyObject to_s() {
        ASCIIEncoding ascii;
        Ruby runtime2 = this.metaClass.runtime;
        if (Double.isInfinite(this.value)) {
            return RubyString.newString(runtime2, this.value < 0.0 ? "-Infinity" : "Infinity");
        }
        if (Double.isNaN(this.value)) {
            return RubyString.newString(runtime2, "NaN");
        }
        ByteList buf = new ByteList();
        Sprintf.sprintf(buf, Locale.US, (CharSequence)"%#.20g", this);
        int e = buf.indexOf(101);
        if (e == -1) {
            e = buf.getRealSize();
        }
        if (!(ascii = ASCIIEncoding.INSTANCE).isDigit(buf.get(e - 1))) {
            buf.setRealSize(0);
            Sprintf.sprintf(buf, Locale.US, (CharSequence)"%#.14e", this);
            e = buf.indexOf(101);
            if (e == -1) {
                e = buf.getRealSize();
            }
        }
        int p2 = e;
        while (buf.get(p2 - 1) == 48 && ascii.isDigit(buf.get(p2 - 2))) {
            --p2;
        }
        System.arraycopy(buf.getUnsafeBytes(), e, buf.getUnsafeBytes(), p2, buf.getRealSize() - e);
        buf.setRealSize(p2 + buf.getRealSize() - e);
        buf.setEncoding(USASCIIEncoding.INSTANCE);
        return runtime2.newString(buf);
    }

    @Override
    @JRubyMethod(name={"coerce"}, required=1)
    public IRubyObject coerce(IRubyObject other) {
        Ruby runtime2 = this.metaClass.runtime;
        return runtime2.newArray((IRubyObject)RubyKernel.new_float(runtime2, other), (IRubyObject)this);
    }

    @Override
    @JRubyMethod(name={"-@"})
    public IRubyObject op_uminus(ThreadContext context) {
        return RubyFloat.newFloat(context.runtime, -this.value);
    }

    @Deprecated
    public IRubyObject op_uminus() {
        return RubyFloat.newFloat(this.getRuntime(), -this.value);
    }

    @Override
    @JRubyMethod(name={"+"}, required=1)
    public IRubyObject op_plus(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().getClassIndex()) {
            case INTEGER: 
            case FLOAT: {
                return RubyFloat.newFloat(context.runtime, this.value + ((RubyNumeric)other).getDoubleValue());
            }
        }
        return this.coerceBin(context, RubyFloat.sites((ThreadContext)context).op_plus, other);
    }

    public IRubyObject op_plus(ThreadContext context, double other) {
        return RubyFloat.newFloat(context.runtime, this.value + other);
    }

    @JRubyMethod(name={"-"}, required=1)
    public IRubyObject op_minus(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().getClassIndex()) {
            case INTEGER: 
            case FLOAT: {
                return RubyFloat.newFloat(context.runtime, this.value - ((RubyNumeric)other).getDoubleValue());
            }
        }
        return this.coerceBin(context, RubyFloat.sites((ThreadContext)context).op_minus, other);
    }

    public IRubyObject op_minus(ThreadContext context, double other) {
        return RubyFloat.newFloat(context.runtime, this.value - other);
    }

    @JRubyMethod(name={"*"}, required=1)
    public IRubyObject op_mul(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().getClassIndex()) {
            case INTEGER: 
            case FLOAT: {
                return RubyFloat.newFloat(context.runtime, this.value * ((RubyNumeric)other).getDoubleValue());
            }
        }
        return this.coerceBin(context, RubyFloat.sites((ThreadContext)context).op_times, other);
    }

    public IRubyObject op_mul(ThreadContext context, double other) {
        return RubyFloat.newFloat(context.runtime, this.value * other);
    }

    @JRubyMethod(name={"/"}, required=1)
    public IRubyObject op_div(ThreadContext context, IRubyObject other) {
        switch (RubyFloat.getMetaClass(other).getClassIndex()) {
            case INTEGER: 
            case FLOAT: {
                try {
                    return RubyFloat.newFloat(context.runtime, this.value / ((RubyNumeric)other).getDoubleValue());
                }
                catch (NumberFormatException nfe) {
                    throw context.runtime.newFloatDomainError(other.toString());
                }
            }
        }
        return this.coerceBin(context, RubyFloat.sites((ThreadContext)context).op_quo, other);
    }

    public IRubyObject op_div(ThreadContext context, double other) {
        return RubyFloat.newFloat(context.runtime, this.value / other);
    }

    @Override
    @JRubyMethod(name={"quo", "fdiv"})
    public IRubyObject quo(ThreadContext context, IRubyObject other) {
        return RubyFloat.numFuncall(context, this, RubyFloat.sites((ThreadContext)context).op_quo, other);
    }

    @JRubyMethod(name={"%", "modulo"}, required=1)
    public IRubyObject op_mod(ThreadContext context, IRubyObject other) {
        switch (RubyFloat.getMetaClass(other).getClassIndex()) {
            case INTEGER: 
            case FLOAT: {
                return this.op_mod(context, ((RubyNumeric)other).getDoubleValue());
            }
        }
        return this.coerceBin(context, RubyFloat.sites((ThreadContext)context).op_mod, other);
    }

    public IRubyObject op_mod(ThreadContext context, double other) {
        if (other == 0.0) {
            throw context.runtime.newZeroDivisionError();
        }
        double x = this.value;
        double mod = Math.IEEEremainder(x, other);
        if (other * mod < 0.0) {
            mod += other;
        }
        return RubyFloat.newFloat(context.runtime, mod);
    }

    @Deprecated
    public final IRubyObject op_mod19(ThreadContext context, IRubyObject other) {
        return this.op_mod(context, other);
    }

    @Override
    @JRubyMethod(name={"divmod"}, required=1)
    public IRubyObject divmod(ThreadContext context, IRubyObject other) {
        switch (RubyFloat.getMetaClass(other).getClassIndex()) {
            case INTEGER: 
            case FLOAT: {
                double y = ((RubyNumeric)other).getDoubleValue();
                if (y == 0.0) {
                    throw context.runtime.newZeroDivisionError();
                }
                double x = this.value;
                double mod = Math.IEEEremainder(x, y);
                if (Double.isNaN(mod)) {
                    throw context.runtime.newFloatDomainError("NaN");
                }
                double div2 = Math.floor(x / y);
                if (y * mod < 0.0) {
                    mod += y;
                }
                Ruby runtime2 = context.runtime;
                RubyInteger car = RubyFloat.dbl2ival(runtime2, div2);
                RubyFloat cdr = RubyFloat.newFloat(runtime2, mod);
                return RubyArray.newArray(runtime2, car, cdr);
            }
        }
        return this.coerceBin(context, RubyFloat.sites((ThreadContext)context).divmod, other);
    }

    @JRubyMethod(name={"**"}, required=1)
    public IRubyObject op_pow(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().getClassIndex()) {
            case INTEGER: 
            case FLOAT: {
                double d_other = ((RubyNumeric)other).getDoubleValue();
                if (this.value < 0.0 && d_other != (double)Math.round(d_other)) {
                    RubyComplex complex = RubyComplex.newComplexRaw(context.runtime, this);
                    return RubyFloat.sites((ThreadContext)context).op_exp.call(context, (IRubyObject)complex, (IRubyObject)complex, other);
                }
                return RubyFloat.newFloat(context.runtime, Math.pow(this.value, d_other));
            }
        }
        return this.coerceBin(context, RubyFloat.sites((ThreadContext)context).op_exp, other);
    }

    public IRubyObject op_pow(ThreadContext context, double other) {
        return RubyFloat.newFloat(context.runtime, Math.pow(this.value, other));
    }

    @Deprecated
    public IRubyObject op_pow19(ThreadContext context, IRubyObject other) {
        return this.op_pow(context, other);
    }

    @Override
    @JRubyMethod(name={"==", "==="}, required=1)
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        if (Double.isNaN(this.value)) {
            return context.fals;
        }
        switch (other.getMetaClass().getClassIndex()) {
            case INTEGER: 
            case FLOAT: {
                return RubyBoolean.newBoolean(context, this.value == ((RubyNumeric)other).getDoubleValue());
            }
        }
        return super.op_num_equal(context, other);
    }

    public IRubyObject op_equal(ThreadContext context, double other) {
        if (Double.isNaN(this.value)) {
            return context.fals;
        }
        return RubyBoolean.newBoolean(context, this.value == other);
    }

    public boolean fastEqual(RubyFloat other) {
        return Double.isNaN(this.value) ? false : this.value == other.value;
    }

    @Override
    public final int compareTo(IRubyObject other) {
        switch (other.getMetaClass().getClassIndex()) {
            case INTEGER: 
            case FLOAT: {
                return Double.compare(this.value, ((RubyNumeric)other).getDoubleValue());
            }
        }
        ThreadContext context = this.metaClass.runtime.getCurrentContext();
        return (int)this.coerceCmp(context, RubyFloat.sites((ThreadContext)context).op_cmp, other).convertToInteger().getLongValue();
    }

    @Override
    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        Ruby runtime2 = context.runtime;
        switch (other.getMetaClass().getClassIndex()) {
            case INTEGER: {
                if (Double.isInfinite(this.value)) {
                    return this.value > 0.0 ? RubyFixnum.one(runtime2) : RubyFixnum.minus_one(runtime2);
                }
            }
            case FLOAT: {
                double b2 = ((RubyNumeric)other).getDoubleValue();
                return RubyFloat.dbl_cmp(runtime2, this.value, b2);
            }
        }
        JavaSites.FloatSites sites = RubyFloat.sites(context);
        if (Double.isInfinite(this.value) && sites.respond_to_infinite.respondsTo(context, other, other, true)) {
            IRubyObject infinite = sites.infinite.call(context, other, other);
            if (infinite.isNil()) {
                return this.value > 0.0 ? RubyFixnum.one(runtime2) : RubyFixnum.minus_one(runtime2);
            }
            long sign2 = RubyFixnum.fix2long(infinite);
            if (sign2 > 0L) {
                return this.value > 0.0 ? RubyFixnum.zero(runtime2) : RubyFixnum.minus_one(runtime2);
            }
            return this.value < 0.0 ? RubyFixnum.zero(runtime2) : RubyFixnum.one(runtime2);
        }
        return this.coerceCmp(context, sites.op_cmp, other);
    }

    public IRubyObject op_cmp(ThreadContext context, double other) {
        return RubyFloat.dbl_cmp(context.runtime, this.value, other);
    }

    @JRubyMethod(name={">"}, required=1)
    public IRubyObject op_gt(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().getClassIndex()) {
            case INTEGER: 
            case FLOAT: {
                double b2 = ((RubyNumeric)other).getDoubleValue();
                return RubyBoolean.newBoolean(context, !Double.isNaN(b2) && this.value > b2);
            }
        }
        return this.coerceRelOp(context, RubyFloat.sites((ThreadContext)context).op_gt, other);
    }

    public IRubyObject op_gt(ThreadContext context, double other) {
        return RubyBoolean.newBoolean(context, !Double.isNaN(other) && this.value > other);
    }

    @JRubyMethod(name={">="}, required=1)
    public IRubyObject op_ge(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().getClassIndex()) {
            case INTEGER: 
            case FLOAT: {
                double b2 = ((RubyNumeric)other).getDoubleValue();
                return RubyBoolean.newBoolean(context, !Double.isNaN(b2) && this.value >= b2);
            }
        }
        return this.coerceRelOp(context, RubyFloat.sites((ThreadContext)context).op_ge, other);
    }

    public IRubyObject op_ge(ThreadContext context, double other) {
        return RubyBoolean.newBoolean(context, !Double.isNaN(other) && this.value >= other);
    }

    @JRubyMethod(name={"<"}, required=1)
    public IRubyObject op_lt(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().getClassIndex()) {
            case INTEGER: 
            case FLOAT: {
                double b2 = ((RubyNumeric)other).getDoubleValue();
                return RubyBoolean.newBoolean(context, !Double.isNaN(b2) && this.value < b2);
            }
        }
        return this.coerceRelOp(context, RubyFloat.sites((ThreadContext)context).op_lt, other);
    }

    public IRubyObject op_lt(ThreadContext context, double other) {
        return RubyBoolean.newBoolean(context, !Double.isNaN(other) && this.value < other);
    }

    @JRubyMethod(name={"<="}, required=1)
    public IRubyObject op_le(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().getClassIndex()) {
            case INTEGER: 
            case FLOAT: {
                double b2 = ((RubyNumeric)other).getDoubleValue();
                return RubyBoolean.newBoolean(context, !Double.isNaN(b2) && this.value <= b2);
            }
        }
        return this.coerceRelOp(context, RubyFloat.sites((ThreadContext)context).op_le, other);
    }

    public IRubyObject op_le(ThreadContext context, double other) {
        return RubyBoolean.newBoolean(context, !Double.isNaN(other) && this.value <= other);
    }

    @Override
    @JRubyMethod(name={"eql?"}, required=1)
    public IRubyObject eql_p(IRubyObject other) {
        return this.metaClass.runtime.newBoolean(this.equals(other));
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof RubyFloat && this.equals((RubyFloat)other);
    }

    private boolean equals(RubyFloat that) {
        if (Double.isNaN(this.value) || Double.isNaN(that.value)) {
            return false;
        }
        double val1 = this.value == -0.0 ? 0.0 : this.value;
        double val2 = that.value == -0.0 ? 0.0 : that.value;
        return Double.doubleToLongBits(val1) == Double.doubleToLongBits(val2);
    }

    @Override
    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        return this.metaClass.runtime.newFixnum(this.hashCode());
    }

    @Override
    public final int hashCode() {
        double val = this.value == 0.0 ? -0.0 : this.value;
        long l = Double.doubleToLongBits(val);
        return (int)(l ^ l >>> 32);
    }

    @JRubyMethod(name={"to_f"})
    public IRubyObject to_f() {
        return this;
    }

    @Override
    @JRubyMethod(name={"abs"})
    public IRubyObject abs(ThreadContext context) {
        if (Double.doubleToLongBits(this.value) < 0L) {
            return RubyFloat.newFloat(context.runtime, Math.abs(this.value));
        }
        return this;
    }

    @Override
    @JRubyMethod(name={"magnitude"})
    public IRubyObject magnitude(ThreadContext context) {
        return this.abs(context);
    }

    @Override
    @JRubyMethod(name={"zero?"})
    public IRubyObject zero_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.value == 0.0);
    }

    @Override
    public final boolean isZero() {
        return this.value == 0.0;
    }

    @Override
    public IRubyObject nonzero_p(ThreadContext context) {
        return this.isZero() ? context.nil : this;
    }

    @Override
    @JRubyMethod(name={"truncate", "to_i", "to_int"})
    public IRubyObject truncate(ThreadContext context) {
        return this.toInteger(context.runtime);
    }

    @JRubyMethod(name={"truncate", "to_i", "to_int"})
    public IRubyObject truncate(ThreadContext context, IRubyObject n) {
        if (this.value > 0.0) {
            return this.floor(context, n);
        }
        return this.ceil(context, n);
    }

    @Override
    @JRubyMethod(name={"numerator"})
    public IRubyObject numerator(ThreadContext context) {
        if (Double.isInfinite(this.value) || Double.isNaN(this.value)) {
            return this;
        }
        return super.numerator(context);
    }

    @Override
    @JRubyMethod(name={"denominator"})
    public IRubyObject denominator(ThreadContext context) {
        if (Double.isInfinite(this.value) || Double.isNaN(this.value)) {
            return RubyFixnum.one(context.runtime);
        }
        return super.denominator(context);
    }

    @JRubyMethod(name={"to_r"})
    public IRubyObject to_r(ThreadContext context) {
        long[] exp2 = new long[1];
        double f = Numeric.frexp(this.value, exp2);
        f = Numeric.ldexp(f, 53L);
        long n = exp2[0] - 53L;
        Ruby runtime2 = context.runtime;
        RubyInteger rf = RubyNumeric.dbl2ival(runtime2, f);
        RubyFixnum rn = RubyFixnum.newFixnum(runtime2, n);
        return Numeric.f_mul(context, (IRubyObject)rf, Numeric.f_expt(context, RubyFixnum.two(runtime2), rn));
    }

    @JRubyMethod(name={"rationalize"}, optional=1)
    public IRubyObject rationalize(ThreadContext context, IRubyObject[] args2) {
        IRubyObject b2;
        IRubyObject a;
        if (Numeric.f_negative_p(context, this)) {
            return Numeric.f_negate(context, Numeric.f_abs(context, this).rationalize(context, args2));
        }
        Ruby runtime2 = context.runtime;
        if (args2.length != 0) {
            IRubyObject eps = Numeric.f_abs(context, args2[0]);
            a = Numeric.f_sub(context, this, eps);
            b2 = Numeric.f_add(context, this, eps);
        } else {
            long[] exp2 = new long[1];
            double f = Numeric.frexp(this.value, exp2);
            f = Numeric.ldexp(f, 53L);
            long n = exp2[0] - 53L;
            RubyInteger rf = RubyBignum.newBignorm(runtime2, f);
            RubyFixnum rn = RubyFixnum.newFixnum(runtime2, n);
            if (rf.isZero() || RubyFloat.fix2int(rn) >= 0) {
                return RubyRational.newRationalRaw(runtime2, rf.op_lshift(context, rn));
            }
            RubyFixnum one = RubyFixnum.one(runtime2);
            RubyInteger two_times_f = (RubyInteger)rf.op_mul(context, 2L);
            RubyInteger den = (RubyInteger)one.op_lshift(context, RubyFixnum.one(runtime2).op_minus(context, n));
            a = RubyRational.newRationalRaw(runtime2, two_times_f.op_minus(context, 1L), den);
            b2 = RubyRational.newRationalRaw(runtime2, two_times_f.op_plus(context, 1L), den);
        }
        if (RubyFloat.sites((ThreadContext)context).op_equal.call(context, a, a, b2).isTrue()) {
            return Numeric.f_to_r(context, this);
        }
        IRubyObject[] ans = Numeric.nurat_rationalize_internal(context, a, b2);
        return RubyRational.newRationalRaw(runtime2, ans[0], ans[1]);
    }

    @Override
    @JRubyMethod(name={"floor"})
    public IRubyObject floor(ThreadContext context) {
        return RubyFloat.dbl2ival(context.runtime, Math.floor(this.value));
    }

    @JRubyMethod(name={"floor"})
    public IRubyObject floor(ThreadContext context, IRubyObject digits2) {
        int ndigits = RubyFloat.num2int(digits2);
        if (ndigits < 0) {
            return ((RubyInteger)this.truncate(context)).floor(context, digits2);
        }
        Ruby runtime2 = context.runtime;
        double number = this.value;
        if (number == 0.0) {
            return ndigits > 0 ? this : RubyFixnum.zero(runtime2);
        }
        if (ndigits > 0) {
            RubyNumeric[] num = new RubyNumeric[]{this};
            long[] binexp = new long[]{0L};
            Numeric.frexp(number, binexp);
            if (RubyFloat.floatRoundOverflow(ndigits, binexp)) {
                return num[0];
            }
            if (number > 0.0 && RubyFloat.floatRoundUnderflow(ndigits, binexp)) {
                return RubyFloat.newFloat(runtime2, 0.0);
            }
            double f = Math.pow(10.0, ndigits);
            f = Math.floor(number * f) / f;
            return RubyFloat.dbl2num(runtime2, f);
        }
        RubyInteger num = RubyFloat.dbl2ival(runtime2, Math.floor(number));
        if (ndigits < 0) {
            num = (RubyInteger)num.floor(context, digits2);
        }
        return num;
    }

    private static boolean floatRoundOverflow(int ndigits, long[] binexp) {
        return (long)ndigits >= 17L - (binexp[0] > 0L ? binexp[0] / 4L : binexp[0] / 3L - 1L);
    }

    private static boolean floatRoundUnderflow(int ndigits, long[] binexp) {
        return (long)ndigits < -(binexp[0] > 0L ? binexp[0] / 3L + 1L : binexp[0] / 4L);
    }

    @Override
    @JRubyMethod(name={"ceil"})
    public IRubyObject ceil(ThreadContext context) {
        return RubyFloat.dbl2ival(context.runtime, Math.ceil(this.value));
    }

    @JRubyMethod(name={"ceil"})
    public IRubyObject ceil(ThreadContext context, IRubyObject digits2) {
        Ruby runtime2 = context.runtime;
        int ndigits = RubyFloat.num2int(digits2);
        double number = this.value;
        if (number == 0.0) {
            return ndigits > 0 ? this : RubyFixnum.zero(runtime2);
        }
        if (ndigits > 0) {
            long[] binexp = new long[]{0L};
            Numeric.frexp(number, binexp);
            if (RubyFloat.floatRoundOverflow(ndigits, binexp)) {
                return this;
            }
            if (number < 0.0 && RubyFloat.floatRoundUnderflow(ndigits, binexp)) {
                return RubyFloat.newFloat(runtime2, 0.0);
            }
            double f = Math.pow(10.0, ndigits);
            f = Math.ceil(number * f) / f;
            return RubyFloat.newFloat(runtime2, f);
        }
        IRubyObject num = RubyFloat.dbl2ival(runtime2, Math.ceil(number));
        if (ndigits < 0) {
            num = num.ceil(context, digits2);
        }
        return num;
    }

    @Override
    @JRubyMethod(name={"round"})
    public IRubyObject round(ThreadContext context) {
        return this.roundShared(context, 0, RoundingMode.HALF_UP);
    }

    @JRubyMethod(name={"round"})
    public IRubyObject round(ThreadContext context, IRubyObject arg0) {
        Ruby runtime2 = context.runtime;
        int digits2 = 0;
        IRubyObject opts = ArgsUtil.getOptionsArg(runtime2, arg0);
        if (opts.isNil()) {
            digits2 = RubyFloat.num2int(arg0);
        }
        RoundingMode roundingMode = RubyFloat.getRoundingMode(context, opts);
        return this.roundShared(context, digits2, roundingMode);
    }

    @JRubyMethod(name={"round"})
    public IRubyObject round(ThreadContext context, IRubyObject _digits, IRubyObject _opts) {
        Ruby runtime2 = context.runtime;
        IRubyObject opts = ArgsUtil.getOptionsArg(runtime2, _opts);
        int digits2 = RubyFloat.num2int(_digits);
        RoundingMode roundingMode = RubyFloat.getRoundingMode(context, opts);
        return this.roundShared(context, digits2, roundingMode);
    }

    public IRubyObject roundShared(ThreadContext context, int ndigits, RoundingMode mode2) {
        Ruby runtime2 = context.runtime;
        double number = this.value;
        if (number == 0.0) {
            return ndigits > 0 ? this : RubyFixnum.zero(runtime2);
        }
        if (ndigits < 0) {
            return ((RubyInteger)this.to_int(context)).roundShared(context, ndigits, mode2);
        }
        if (ndigits == 0) {
            double x = RubyFloat.doRound(context, mode2, number, 1.0);
            return RubyFloat.dbl2ival(runtime2, x);
        }
        if (Double.isFinite(this.value)) {
            long[] binexp = new long[]{0L};
            Numeric.frexp(number, binexp);
            if (RubyFloat.floatRoundOverflow(ndigits, binexp)) {
                return this;
            }
            if (RubyFloat.floatRoundUnderflow(ndigits, binexp)) {
                return RubyFloat.newFloat(runtime2, 0.0);
            }
            double f = Math.pow(10.0, ndigits);
            double x = RubyFloat.doRound(context, mode2, number, f);
            return RubyFloat.newFloat(runtime2, x / f);
        }
        return this;
    }

    private static double doRound(ThreadContext context, RoundingMode roundingMode, double number, double scale) {
        switch (roundingMode) {
            case HALF_UP: {
                return RubyFloat.roundHalfUp(number, scale);
            }
            case HALF_DOWN: {
                return RubyFloat.roundHalfDown(number, scale);
            }
            case HALF_EVEN: {
                return RubyFloat.roundHalfEven(number, scale);
            }
        }
        throw context.runtime.newArgumentError("invalid rounding mode: " + (Object)((Object)roundingMode));
    }

    private static double roundHalfUp(double x, double s2) {
        double xs = x * s2;
        int signum = x >= 0.0 ? 1 : -1;
        double f = RubyFloat.roundHalfUp(xs *= (double)signum);
        f *= (double)signum;
        if (s2 == 1.0) {
            return f;
        }
        if (x > 0.0) {
            if ((f + 0.5) / s2 <= x) {
                f += 1.0;
            }
            x = f;
        } else {
            if ((f - 0.5) / s2 >= x) {
                f -= 1.0;
            }
            x = f;
        }
        return x;
    }

    private static double roundHalfDown(double x, double s2) {
        double xs = x * s2;
        int signum = x >= 0.0 ? 1 : -1;
        double f = RubyFloat.roundHalfUp(xs *= (double)signum);
        f *= (double)signum;
        if (x > 0.0) {
            if ((f - 0.5) / s2 >= x) {
                f -= 1.0;
            }
            x = f;
        } else {
            if ((f + 0.5) / s2 <= x) {
                f += 1.0;
            }
            x = f;
        }
        return x;
    }

    private static double roundHalfUp(double n) {
        double f = n;
        if (f >= 0.0) {
            if (n - (f = Math.floor(f)) >= 0.5) {
                f += 1.0;
            }
        } else if ((f = Math.ceil(f)) - n >= 0.5) {
            f -= 1.0;
        }
        return f;
    }

    private static double roundHalfEven(double x, double s2) {
        double xs = x * s2;
        if (x > 0.0) {
            double f = Math.floor(xs);
            double d = xs - f;
            d = d > 0.5 ? 1.0 : (d == 0.5 || (f + 0.5) / s2 <= x ? f % 2.0 : 0.0);
            x = f + d;
        } else if (x < 0.0) {
            double f = Math.ceil(xs);
            double d = f - xs;
            d = d > 0.5 ? 1.0 : (d == 0.5 || (f - 0.5) / s2 >= x ? -f % 2.0 : 0.0);
            x = f - d;
        }
        return x;
    }

    @JRubyMethod(name={"nan?"})
    public IRubyObject nan_p() {
        return RubyBoolean.newBoolean(this.metaClass.runtime, this.isNaN());
    }

    public boolean isNaN() {
        return Double.isNaN(this.value);
    }

    @JRubyMethod(name={"infinite?"})
    public IRubyObject infinite_p() {
        if (Double.isInfinite(this.value)) {
            return RubyFixnum.newFixnum(this.metaClass.runtime, this.value < 0.0 ? -1L : 1L);
        }
        return this.metaClass.runtime.getNil();
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.value);
    }

    @JRubyMethod(name={"finite?"})
    public IRubyObject finite_p() {
        Ruby runtime2 = this.metaClass.runtime;
        if (Double.isInfinite(this.value) || Double.isNaN(this.value)) {
            return runtime2.getFalse();
        }
        return runtime2.getTrue();
    }

    private ByteList marshalDump() {
        if (Double.isInfinite(this.value)) {
            return this.value < 0.0 ? NEGATIVE_INFINITY_BYTELIST : INFINITY_BYTELIST;
        }
        if (Double.isNaN(this.value)) {
            return NAN_BYTELIST;
        }
        ByteList byteList = new ByteList();
        Sprintf.sprintf(byteList, Locale.US, (CharSequence)"%.17g", RubyArray.newArray(this.getRuntime(), this));
        return byteList;
    }

    public static void marshalTo(RubyFloat aFloat, MarshalStream output) throws IOException {
        output.registerLinkTarget(aFloat);
        output.writeString(aFloat.marshalDump());
    }

    public static RubyFloat unmarshalFrom(UnmarshalStream input) throws IOException {
        ByteList value2 = input.unmarshalString();
        RubyFloat result2 = value2.equals(NAN_BYTELIST) ? RubyFloat.newFloat(input.getRuntime(), Double.NaN) : (value2.equals(NEGATIVE_INFINITY_BYTELIST) ? RubyFloat.newFloat(input.getRuntime(), Double.NEGATIVE_INFINITY) : (value2.equals(INFINITY_BYTELIST) ? RubyFloat.newFloat(input.getRuntime(), Double.POSITIVE_INFINITY) : RubyFloat.newFloat(input.getRuntime(), ConvertDouble.byteListToDouble19(value2, false))));
        input.registerLinkTarget(result2);
        return result2;
    }

    @JRubyMethod(name={"next_float"})
    public IRubyObject next_float() {
        return RubyFloat.newFloat(this.metaClass.runtime, Math.nextAfter(this.value, Double.POSITIVE_INFINITY));
    }

    @JRubyMethod(name={"prev_float"})
    public IRubyObject prev_float() {
        return RubyFloat.newFloat(this.metaClass.runtime, Math.nextAfter(this.value, Double.NEGATIVE_INFINITY));
    }

    @Deprecated
    public IRubyObject zero_p() {
        return this.zero_p(this.getRuntime().getCurrentContext());
    }

    @Deprecated
    public IRubyObject floor(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.floor(context);
            }
            case 1: {
                return this.floor(context, args2[0]);
            }
        }
        throw context.runtime.newArgumentError("floor", args2.length, 1);
    }

    @Deprecated
    public IRubyObject round(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.round(context);
            }
            case 1: {
                return this.round(context, args2[0]);
            }
            case 2: {
                return this.round(context, args2[0], args2[1]);
            }
        }
        throw context.runtime.newArgumentError("round", args2.length, 2);
    }

    private static JavaSites.FloatSites sites(ThreadContext context) {
        return context.sites.Float;
    }
}

