/*
 * Decompiled with CFR 0.152.
 */
package com.headius.invokebinder.transform;

import com.headius.invokebinder.transform.Transform;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;

public class Varargs
extends Transform {
    private final MethodType source;
    private int index;
    private final Class<?> arrayType;

    public Varargs(MethodType source2, int index2, Class<?> arrayType) {
        this.source = source2;
        this.index = index2;
        this.arrayType = arrayType;
    }

    @Override
    public MethodHandle up(MethodHandle target) {
        return target.asVarargsCollector(this.arrayType).asType(this.source);
    }

    @Override
    public MethodType down(MethodType type2) {
        this.assertTypesAreCompatible();
        return type2.dropParameterTypes(this.index, this.source.parameterCount()).appendParameterTypes(this.arrayType);
    }

    private void assertTypesAreCompatible() {
        Class<?> componentType = this.arrayType.getComponentType();
        for (int i2 = this.index; i2 < this.source.parameterCount(); ++i2) {
            TypeDescriptor.OfField in = this.source.parameterType(i2);
            assert (componentType.isAssignableFrom((Class<?>)in)) : "incoming type " + ((Class)in).getName() + " not compatible with " + componentType.getName() + "[]";
        }
    }

    @Override
    public String toString() {
        return "varargs at " + this.index + " into " + this.arrayType.getName();
    }

    @Override
    public String toJava(MethodType incoming) {
        StringBuilder builder = new StringBuilder("handle = handle.asVarargsCollector(");
        Varargs.buildClassArgument(builder, this.arrayType);
        builder.append(").asType(");
        builder.append(Varargs.generateMethodType(this.source));
        builder.append(");");
        return builder.toString();
    }
}

