/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.transformations.inlining;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jruby.ir.IRScope;
import org.jruby.ir.Tuple;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.instructions.ToAryInstr;
import org.jruby.ir.instructions.YieldInstr;
import org.jruby.ir.operands.Array;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Splat;
import org.jruby.ir.operands.TemporaryLocalVariable;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.representations.CFG;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.util.ByteList;

public class InlineCloneInfo
extends CloneInfo {
    private static Integer globalInlineCount = 0;
    private CFG hostCFG;
    private ByteList inlineVarPrefix;
    private Variable callReceiver;
    private CallBase call;
    private Operand[] callArgs;
    private Variable argsArray;
    private boolean canMapArgsStatically;
    private Map<BasicBlock, BasicBlock> bbRenameMap = new HashMap<BasicBlock, BasicBlock>();
    private boolean isClosure;
    private Operand yieldArg;
    private Variable yieldResult;
    private List yieldSites = new ArrayList();
    private IRScope scopeBeingInlined;

    public InlineCloneInfo(CFG cfg, IRScope scope, IRScope scopeBeingInlined) {
        super(scope);
        this.isClosure = true;
        this.hostCFG = cfg;
        this.scopeBeingInlined = scopeBeingInlined;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InlineCloneInfo(CallBase call2, CFG c, Variable callReceiver, IRScope scopeBeingInlined) {
        super(c.getScope());
        this.isClosure = false;
        this.hostCFG = c;
        this.call = call2;
        this.callArgs = call2.getCallArgs();
        this.callReceiver = callReceiver;
        this.canMapArgsStatically = !InlineCloneInfo.containsSplat(this.callArgs);
        this.argsArray = this.canMapArgsStatically ? null : this.getHostScope().createTemporaryVariable();
        this.scopeBeingInlined = scopeBeingInlined;
        Integer n = globalInlineCount;
        synchronized (n) {
            this.inlineVarPrefix = new ByteList(("%in" + globalInlineCount + "_").getBytes());
            Integer n2 = globalInlineCount;
            Integer n3 = globalInlineCount = Integer.valueOf(globalInlineCount + 1);
        }
    }

    public boolean isClosure() {
        return this.isClosure;
    }

    public InlineCloneInfo cloneForInliningClosure(IRScope scopeBeingInlined) {
        InlineCloneInfo clone2 = new InlineCloneInfo(this.hostCFG, this.hostCFG.getScope(), scopeBeingInlined);
        clone2.call = this.call;
        clone2.callArgs = this.callArgs;
        clone2.callReceiver = this.callReceiver;
        return clone2;
    }

    public Operand getArg(int index2) {
        return index2 < this.getArgsCount() ? (this.isClosure ? ((Array)this.yieldArg).get(index2) : this.callArgs[index2]) : null;
    }

    public Operand getArg(int argIndex, boolean restOfArgArray) {
        if (!restOfArgArray) {
            return this.getArg(argIndex);
        }
        if (this.isClosure) {
            throw new RuntimeException("Cannot get rest yield arg at inline time!");
        }
        if (argIndex >= this.callArgs.length) {
            return new Array();
        }
        Operand[] tmp = new Operand[this.callArgs.length - argIndex];
        System.arraycopy(this.callArgs, argIndex, tmp, 0, this.callArgs.length - argIndex);
        return new Array(tmp);
    }

    public boolean canMapArgsStatically() {
        return this.canMapArgsStatically;
    }

    public Operand getArgs() {
        return this.isClosure ? this.yieldArg : this.argsArray;
    }

    public BasicBlock getRenamedBB(BasicBlock bb) {
        return this.bbRenameMap.get(bb);
    }

    public int getArgsCount() {
        return this.canMapArgsStatically ? (this.isClosure ? ((Array)this.yieldArg).size() : this.callArgs.length) : -1;
    }

    public Operand getCallClosure() {
        return this.call.getClosureArg(this.scope.getManager().getNil());
    }

    public Variable getCallResultVariable() {
        return this.call instanceof ResultInstr ? ((ResultInstr)((Object)this.call)).getResult() : null;
    }

    public BasicBlock getOrCreateRenamedBB(BasicBlock bb) {
        BasicBlock renamedBB = this.getRenamedBB(bb);
        if (renamedBB == null) {
            renamedBB = new BasicBlock(this.hostCFG, this.getRenamedLabel(bb.getLabel()));
            if (bb.isRescueEntry()) {
                renamedBB.markRescueEntryBB();
            }
            this.bbRenameMap.put(bb, renamedBB);
        }
        return renamedBB;
    }

    public IRScope getHostScope() {
        return this.getScope();
    }

    @Override
    protected Label getRenamedLabelSimple(Label l) {
        return this.getHostScope().getNewLabel();
    }

    @Override
    protected Variable getRenamedSelfVariable(Variable self2) {
        return this.callReceiver;
    }

    @Override
    protected Variable getRenamedVariableSimple(Variable v) {
        if (this.isClosure) {
            if (v instanceof LocalVariable) {
                LocalVariable lv = (LocalVariable)v;
                int depth = lv.getScopeDepth();
                return this.getHostScope().getLocalVariable(lv.getName(), depth > 1 ? depth - 1 : 0);
            }
            return this.getHostScope().createTemporaryVariable();
        }
        return this.getHostScope().getNewInlineVariable(this.inlineVarPrefix, v);
    }

    public IRScope getScopeBeingInlined() {
        return this.scopeBeingInlined;
    }

    public Variable getYieldResult() {
        return this.yieldResult;
    }

    public List getYieldSites() {
        return this.yieldSites;
    }

    public void recordYieldSite(BasicBlock bb, YieldInstr i2) {
        this.yieldSites.add(new Tuple<BasicBlock, YieldInstr>(bb, i2));
    }

    public void setupYieldArgsAndYieldResult(YieldInstr yi, BasicBlock yieldBB, int blockArityValue) {
        Operand yieldInstrArg = yi.getYieldArg();
        if (yieldInstrArg == UndefinedValue.UNDEFINED || blockArityValue == 0) {
            this.yieldArg = new Array();
        } else if (yieldInstrArg instanceof Array) {
            this.yieldArg = yieldInstrArg;
            if (((Array)yieldInstrArg).size() == blockArityValue) {
                this.canMapArgsStatically = true;
            }
        } else {
            IRScope callerScope = this.getHostScope();
            TemporaryLocalVariable yieldArgArray = callerScope.createTemporaryVariable();
            yieldBB.addInstr(new ToAryInstr(yieldArgArray, yieldInstrArg));
            this.yieldArg = yieldArgArray;
        }
        this.yieldResult = yi.getResult();
    }

    private static boolean containsSplat(Operand[] args2) {
        for (int i2 = 0; i2 < args2.length; ++i2) {
            if (!(args2[i2] instanceof Splat)) continue;
            return true;
        }
        return false;
    }
}

