/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.Iterator;
import org.jruby.MetaClass;
import org.jruby.RubyModule;
import org.jruby.ast.util.SexpMaker;
import org.jruby.compiler.JITCompiler;
import org.jruby.compiler.MethodJITClassGenerator;
import org.jruby.internal.runtime.methods.CompiledIRMethod;
import org.jruby.internal.runtime.methods.MixedModeIRMethod;
import org.jruby.ir.targets.JVMVisitor;
import org.jruby.ir.targets.JVMVisitorMethodContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.OneShotClassLoader;
import org.jruby.util.collections.IntHashMap;

class MethodJITTask
implements Runnable {
    private JITCompiler jitCompiler;
    private final String className;
    private final MixedModeIRMethod method;
    private final String methodName;

    public MethodJITTask(JITCompiler jitCompiler, MixedModeIRMethod method, String className) {
        this.jitCompiler = jitCompiler;
        this.method = method;
        this.className = className;
        this.methodName = method.getName();
    }

    @Override
    public void run() {
        try {
            if (this.jitCompiler.config.getExcludedMethods().size() > 0) {
                IRubyObject possibleRealClass;
                String excludeModuleName = this.className;
                if (this.method.getImplementationClass().getMethodLocation().isSingleton() && (possibleRealClass = ((MetaClass)this.method.getImplementationClass()).getAttached()) instanceof RubyModule) {
                    excludeModuleName = "Meta:" + ((RubyModule)possibleRealClass).getName();
                }
                if (this.jitCompiler.config.getExcludedMethods().contains(excludeModuleName) || this.jitCompiler.config.getExcludedMethods().contains(excludeModuleName + '#' + this.methodName) || this.jitCompiler.config.getExcludedMethods().contains(this.methodName)) {
                    this.method.setCallCount(-1);
                    if (this.jitCompiler.config.isJitLogging()) {
                        JITCompiler.log(this.method.getImplementationClass(), this.method.getFile(), this.method.getLine(), this.methodName, "skipping method: " + excludeModuleName + '#' + this.methodName, new String[0]);
                    }
                    return;
                }
            }
            String key2 = SexpMaker.sha1(this.method.getIRScope());
            JVMVisitor visitor = new JVMVisitor();
            MethodJITClassGenerator generator = new MethodJITClassGenerator(this.className, this.methodName, key2, this.jitCompiler.runtime, this.method, visitor);
            JVMVisitorMethodContext context = new JVMVisitorMethodContext();
            generator.compile(context);
            Class sourceClass = visitor.defineFromBytecode(this.method.getIRScope(), generator.bytecode(), new OneShotClassLoader(this.jitCompiler.runtime.getJRubyClassLoader()));
            if (sourceClass == null) {
                this.jitCompiler.counts.failCount.incrementAndGet();
                return;
            }
            generator.updateCounters(this.jitCompiler.counts, this.method.ensureInstrsReady());
            long methodCount = this.jitCompiler.counts.successCount.incrementAndGet();
            if (this.jitCompiler.config.getJitLogEvery() > 0 && methodCount % (long)this.jitCompiler.config.getJitLogEvery() == 0L) {
                JITCompiler.log(this.method.getImplementationClass(), this.method.getFile(), this.method.getLine(), this.methodName, "live compiled methods: " + methodCount, new String[0]);
            }
            if (this.jitCompiler.config.isJitLogging()) {
                JITCompiler.log(this.method.getImplementationClass(), this.method.getFile(), this.method.getLine(), this.className + '.' + this.methodName, "done jitting", new String[0]);
            }
            String variableName = context.getVariableName();
            MethodHandle variable = JITCompiler.PUBLIC_LOOKUP.findStatic(sourceClass, variableName, context.getNativeSignature(-1));
            IntHashMap<MethodType> signatures = context.getNativeSignaturesExceptVariable();
            if (signatures.size() == 0) {
                this.method.completeBuild(new CompiledIRMethod(variable, this.method.getIRScope(), this.method.getVisibility(), this.method.getImplementationClass(), this.method.getIRScope().receivesKeywordArgs()));
            } else {
                Iterator<IntHashMap.Entry<MethodType>> i$ = signatures.entrySet().iterator();
                if (i$.hasNext()) {
                    IntHashMap.Entry<MethodType> entry = i$.next();
                    this.method.completeBuild(new CompiledIRMethod(variable, JITCompiler.PUBLIC_LOOKUP.findStatic(sourceClass, context.getSpecificName(), entry.getValue()), entry.getKey(), this.method.getIRScope(), this.method.getVisibility(), this.method.getImplementationClass(), this.method.getIRScope().receivesKeywordArgs()));
                }
            }
        }
        catch (Throwable t) {
            if (this.jitCompiler.config.isJitLogging()) {
                JITCompiler.log(this.method.getImplementationClass(), this.method.getFile(), this.method.getLine(), this.className + '.' + this.methodName, "Could not compile; passes run: " + this.method.getIRScope().getExecutedPasses(), t.getMessage());
                if (this.jitCompiler.config.isJitLoggingVerbose()) {
                    t.printStackTrace();
                }
            }
            this.jitCompiler.counts.failCount.incrementAndGet();
        }
    }
}

