/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.management;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.SoftReference;
import org.jruby.Ruby;
import org.jruby.RubyException;
import org.jruby.RubyThread;
import org.jruby.exceptions.RaiseException;
import org.jruby.management.RuntimeMBean;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.backtrace.TraceType;

public class Runtime
implements RuntimeMBean {
    private final SoftReference<Ruby> ruby;

    public Runtime(Ruby ruby2) {
        this.ruby = new SoftReference<Ruby>(ruby2);
    }

    @Override
    public int getExceptionCount() {
        return this.ruby.get().getExceptionCount();
    }

    @Override
    public int getBacktraceCount() {
        return this.ruby.get().getBacktraceCount();
    }

    @Override
    public int getCallerCount() {
        return this.ruby.get().getCallerCount();
    }

    @Override
    public String threadDump() {
        return this.dumpThreads(TraceType.Gather.NORMAL);
    }

    @Override
    public String rawThreadDump() {
        return this.dumpThreads(TraceType.Gather.RAW);
    }

    @Override
    public String fullThreadDump() {
        return this.dumpThreads(TraceType.Gather.FULL);
    }

    public String dumpThreads(TraceType.Gather gather) {
        Ruby ruby2 = this.ruby.get();
        RubyThread[] thrs = ruby2.getThreadService().getActiveRubyThreads();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("All threads known to Ruby instance " + ruby2.hashCode());
        pw.println();
        for (RubyThread th : thrs) {
            Runtime.dumpThread(ruby2, th, gather, pw);
        }
        return sw.toString();
    }

    private static void dumpThread(Ruby ruby2, RubyThread th, TraceType.Gather gather, PrintWriter pw) {
        pw.println("Thread: " + th.getNativeThread().getName());
        pw.println("Stack:");
        ThreadContext tc = th.getContext();
        if (tc != null) {
            RubyException exc = new RubyException(ruby2, ruby2.getRuntimeError(), "thread dump");
            exc.setBacktraceData(gather.getBacktraceData(tc, th.getNativeThread().getStackTrace(), true));
            pw.println(TraceType.Format.MRI.printBacktrace(exc, false));
        } else {
            pw.println("    [no longer alive]");
        }
        pw.println();
    }

    @Override
    public String executeRuby(final String code) {
        final String[] result2 = new String[1];
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    result2[0] = ((Ruby)Runtime.this.ruby.get()).evalScriptlet(code).toString();
                }
                catch (RaiseException re) {
                    result2[0] = ((Ruby)Runtime.this.ruby.get()).getInstanceConfig().getTraceType().printBacktrace(re.getException(), false);
                }
                catch (Throwable t) {
                    StringWriter sw = new StringWriter();
                    t.printStackTrace(new PrintWriter(sw));
                    result2[0] = sw.toString();
                }
            }
        };
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return result2[0];
    }
}

