/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.Type;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"FFI::CallbackInfo"}, parent="FFI::Type")
public class CallbackInfo
extends Type {
    public static final String CLASS_NAME = "CallbackInfo";
    protected final Arity arity;
    protected final Type[] parameterTypes;
    protected final Type returnType;
    protected final boolean stdcall;

    public static RubyClass createCallbackInfoClass(Ruby runtime, RubyModule module) {
        RubyClass Type2 = module.getClass("Type");
        RubyClass result2 = module.defineClassUnder(CLASS_NAME, Type2, ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        result2.defineAnnotatedMethods(CallbackInfo.class);
        result2.defineAnnotatedConstants(CallbackInfo.class);
        Type2.setConstant("Function", result2);
        return result2;
    }

    public CallbackInfo(Ruby runtime, RubyClass klazz, Type returnType, Type[] paramTypes, boolean stdcall) {
        super(runtime, klazz, NativeType.POINTER);
        this.arity = Arity.fixed(paramTypes.length);
        this.parameterTypes = paramTypes;
        this.returnType = returnType;
        this.stdcall = stdcall;
    }

    @JRubyMethod(name={"new"}, meta=true, required=2, optional=1)
    public static final IRubyObject newCallbackInfo(ThreadContext context, IRubyObject klass, IRubyObject[] args2) {
        IRubyObject returnType = args2[0];
        IRubyObject paramTypes = args2[1];
        if (!(returnType instanceof Type)) {
            throw context.runtime.newTypeError("wrong argument type " + returnType.getMetaClass().getName() + " (expected FFI::Type)");
        }
        if (!(paramTypes instanceof RubyArray)) {
            throw context.runtime.newTypeError("wrong argument type " + paramTypes.getMetaClass().getName() + " (expected Array)");
        }
        Type[] nativeParamTypes = new Type[((RubyArray)paramTypes).size()];
        for (int i2 = 0; i2 < nativeParamTypes.length; ++i2) {
            IRubyObject obj = ((RubyArray)paramTypes).entry(i2);
            if (!(obj instanceof Type)) {
                throw context.runtime.newTypeError("wrong argument type " + obj.getMetaClass().getName() + " (expected array of FFI::Type)");
            }
            nativeParamTypes[i2] = (Type)obj;
        }
        boolean stdcall = false;
        if (args2.length > 2) {
            if (!(args2[2] instanceof RubyHash)) {
                throw context.runtime.newTypeError("wrong argument type " + args2[2].getMetaClass().getName() + " (expected Enums or Hash)");
            }
            RubyHash hash2 = (RubyHash)args2[2];
            stdcall = "stdcall".equals(hash2.get(context.runtime.newSymbol("convention")));
        }
        try {
            return new CallbackInfo(context.runtime, (RubyClass)klass, (Type)returnType, nativeParamTypes, stdcall);
        }
        catch (UnsatisfiedLinkError ex) {
            return context.runtime.getNil();
        }
    }

    public final Arity getArity() {
        return this.arity;
    }

    public final Type getReturnType() {
        return this.returnType;
    }

    public final Type[] getParameterTypes() {
        return this.parameterTypes;
    }

    public final boolean isStdcall() {
        return this.stdcall;
    }

    @JRubyMethod(name={"to_s"})
    public final IRubyObject to_s(ThreadContext context) {
        StringBuilder sb = new StringBuilder(64);
        sb.append("#<FFI::CallbackInfo [ ");
        for (int i2 = 0; i2 < this.parameterTypes.length; ++i2) {
            sb.append(this.parameterTypes[i2].toString().toLowerCase());
            if (i2 >= this.parameterTypes.length - 1) continue;
            sb.append(", ");
        }
        sb.append(" ], ").append(this.returnType.toString().toLowerCase()).append('>');
        return context.runtime.newString(sb.toString());
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("CallbackInfo[parameters=[");
        for (int i2 = 0; i2 < this.parameterTypes.length; ++i2) {
            sb.append(this.parameterTypes[i2].toString().toLowerCase());
            if (i2 >= this.parameterTypes.length - 1) continue;
            sb.append(", ");
        }
        sb.append("] return=" + this.returnType.toString().toLowerCase() + "]");
        return sb.toString();
    }

    @JRubyMethod
    public final IRubyObject result_type(ThreadContext context) {
        return this.returnType;
    }

    @JRubyMethod
    public final IRubyObject param_types(ThreadContext context) {
        return RubyArray.newArray(context.runtime, this.parameterTypes);
    }
}

