/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.objectweb.asm;

import org.jruby.org.objectweb.asm.AnnotationVisitor;
import org.jruby.org.objectweb.asm.Attribute;
import org.jruby.org.objectweb.asm.FieldVisitor;
import org.jruby.org.objectweb.asm.MethodVisitor;
import org.jruby.org.objectweb.asm.ModuleVisitor;
import org.jruby.org.objectweb.asm.TypePath;

public abstract class ClassVisitor {
    protected final int api;
    protected ClassVisitor cv;

    public ClassVisitor(int api) {
        this(api, null);
    }

    public ClassVisitor(int api, ClassVisitor cv) {
        if (api < 262144 || api > 393216) {
            throw new IllegalArgumentException();
        }
        this.api = api;
        this.cv = cv;
    }

    public void visit(int version, int access, String name2, String signature, String superName, String[] interfaces2) {
        if (this.cv != null) {
            this.cv.visit(version, access, name2, signature, superName, interfaces2);
        }
    }

    public void visitSource(String source2, String debug) {
        if (this.cv != null) {
            this.cv.visitSource(source2, debug);
        }
    }

    public ModuleVisitor visitModule(String name2, int access, String version) {
        if (this.api < 393216) {
            throw new RuntimeException();
        }
        if (this.cv != null) {
            return this.cv.visitModule(name2, access, version);
        }
        return null;
    }

    public void visitOuterClass(String owner2, String name2, String desc) {
        if (this.cv != null) {
            this.cv.visitOuterClass(owner2, name2, desc);
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (this.cv != null) {
            return this.cv.visitAnnotation(desc, visible);
        }
        return null;
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        if (this.api < 327680) {
            throw new RuntimeException();
        }
        if (this.cv != null) {
            return this.cv.visitTypeAnnotation(typeRef, typePath, desc, visible);
        }
        return null;
    }

    public void visitAttribute(Attribute attr2) {
        if (this.cv != null) {
            this.cv.visitAttribute(attr2);
        }
    }

    public void visitInnerClass(String name2, String outerName, String innerName, int access) {
        if (this.cv != null) {
            this.cv.visitInnerClass(name2, outerName, innerName, access);
        }
    }

    public FieldVisitor visitField(int access, String name2, String desc, String signature, Object value2) {
        if (this.cv != null) {
            return this.cv.visitField(access, name2, desc, signature, value2);
        }
        return null;
    }

    public MethodVisitor visitMethod(int access, String name2, String desc, String signature, String[] exceptions) {
        if (this.cv != null) {
            return this.cv.visitMethod(access, name2, desc, signature, exceptions);
        }
        return null;
    }

    public void visitEnd() {
        if (this.cv != null) {
            this.cv.visitEnd();
        }
    }
}

