/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.ImmutableLiteral;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.runtime.ThreadContext;

public class Float
extends ImmutableLiteral {
    public final double value;

    public Float(double value2) {
        this.value = value2;
    }

    @Override
    public OperandType getOperandType() {
        return OperandType.FLOAT;
    }

    @Override
    public Object createCacheObject(ThreadContext context) {
        return context.runtime.newFloat(this.value);
    }

    public String toString() {
        return "Float:" + this.value;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.Float(this);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.value);
    }

    public static Float decode(IRReaderDecoder d) {
        return new Float(d.decodeDouble());
    }

    public double getValue() {
        return this.value;
    }
}

