/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.jruby.MetaClass;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.NullMethod;
import org.jruby.internal.runtime.methods.UndefinedMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.ivars.MethodData;
import org.jruby.util.CodegenUtils;

public abstract class DynamicMethod {
    protected RubyModule implementationClass;
    protected RubyModule protectedClass;
    protected Visibility visibility;
    protected CallConfiguration callConfig;
    protected long serialNumber;
    protected boolean builtin = false;
    protected NativeCall nativeCall;
    protected NativeCall[] nativeCalls = new NativeCall[10];
    protected String name;
    protected boolean notImplemented = false;
    protected Object handle;

    protected DynamicMethod(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
        assert (implementationClass != null);
        this.init(implementationClass, visibility, callConfig);
    }

    protected DynamicMethod(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, String name2) {
        this(implementationClass, visibility, callConfig);
        this.name = name2;
    }

    protected DynamicMethod() {
    }

    protected void init(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
        this.visibility = visibility;
        this.implementationClass = implementationClass;
        this.protectedClass = DynamicMethod.calculateProtectedClass(implementationClass);
        this.callConfig = callConfig;
        this.serialNumber = implementationClass.getRuntime().getNextDynamicMethodSerial();
    }

    public long getSerialNumber() {
        return this.serialNumber;
    }

    public boolean isBuiltin() {
        return this.builtin;
    }

    public void setIsBuiltin(boolean isBuiltin) {
        this.builtin = isBuiltin;
    }

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject[] var5, Block var6);

    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2) {
        return this.call(context, self2, clazz, name2, args2, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2) {
        return this.call(context, self2, klazz, name2, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, Block block) {
        return this.call(context, self2, klazz, name2, IRubyObject.NULL_ARRAY, block);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg0) {
        return this.call(context, self2, klazz, name2, arg0, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg0, Block block) {
        return this.call(context, self2, klazz, name2, new IRubyObject[]{arg0}, block);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg0, IRubyObject arg1) {
        return this.call(context, self2, klazz, name2, arg0, arg1, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.call(context, self2, klazz, name2, new IRubyObject[]{arg0, arg1}, block);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return this.call(context, self2, klazz, name2, arg0, arg1, arg2, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return this.call(context, self2, klazz, name2, new IRubyObject[]{arg0, arg1, arg2}, block);
    }

    public abstract DynamicMethod dup();

    public boolean isCallableFrom(IRubyObject caller, CallType callType) {
        switch (this.visibility) {
            case PUBLIC: {
                return true;
            }
            case PRIVATE: {
                return callType != CallType.NORMAL;
            }
            case PROTECTED: {
                return this.protectedAccessOk(caller);
            }
        }
        return true;
    }

    private boolean protectedAccessOk(IRubyObject caller) {
        return this.getProtectedClass().isInstance(caller);
    }

    protected static RubyModule calculateProtectedClass(RubyModule cls) {
        if (cls.isSingleton()) {
            cls = cls.getSuperClass();
        }
        while (cls.isIncluded()) {
            cls = cls.getMetaClass();
        }
        if (cls instanceof MetaClass) {
            cls = ((MetaClass)cls).getRealClass();
        }
        return cls;
    }

    protected RubyModule getProtectedClass() {
        return this.protectedClass;
    }

    public RubyModule getImplementationClass() {
        return this.implementationClass;
    }

    public boolean isImplementedBy(RubyModule other) {
        return this.implementationClass == other;
    }

    public void setImplementationClass(RubyModule implClass) {
        this.implementationClass = implClass;
        this.protectedClass = DynamicMethod.calculateProtectedClass(implClass);
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public final boolean isUndefined() {
        return this == UndefinedMethod.INSTANCE;
    }

    public final boolean isNull() {
        return this == NullMethod.INSTANCE;
    }

    public Arity getArity() {
        return Arity.optional();
    }

    public DynamicMethod getRealMethod() {
        return this;
    }

    public CallConfiguration getCallConfig() {
        return this.callConfig;
    }

    public void setCallConfig(CallConfiguration callConfig) {
        this.callConfig = callConfig;
    }

    public void setNativeCall(Class nativeTarget, String nativeName, Class nativeReturn, Class[] nativeSignature, boolean statik, boolean java2) {
        this.nativeCall = new NativeCall(nativeTarget, nativeName, nativeReturn, nativeSignature, statik, java2);
        Arrays.fill(this.nativeCalls, this.nativeCall);
    }

    public void setNativeCall(Class nativeTarget, String nativeName, Class nativeReturn, Class[] nativeSignature, boolean statik) {
        this.setNativeCall(nativeTarget, nativeName, nativeReturn, nativeSignature, statik, false);
    }

    public NativeCall getNativeCall() {
        return this.nativeCall;
    }

    public NativeCall getNativeCall(int args2, boolean block) {
        if (args2 == -1 || args2 > 3) {
            args2 = 4;
        }
        if (block) {
            args2 += 5;
        }
        return this.nativeCalls[args2];
    }

    public void setNativeCall(int args2, boolean block, NativeCall nativeCall) {
        if (args2 == -1 || args2 > 3) {
            args2 = 4;
        }
        if (block) {
            args2 += 5;
        }
        this.nativeCalls[args2] = nativeCall;
    }

    public boolean isNative() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name2) {
        this.name = name2;
    }

    public Object getHandle() {
        return this.handle;
    }

    public void setHandle(Object handle) {
        this.handle = handle;
    }

    public boolean isNotImplemented() {
        return this.notImplemented;
    }

    public MethodData getMethodData() {
        return MethodData.NULL;
    }

    public void setNotImplemented(boolean setNotImplemented) {
        this.notImplemented = setNotImplemented;
    }

    public static class NativeCall {
        private final Class nativeTarget;
        private final String nativeName;
        private final Class nativeReturn;
        private final Class[] nativeSignature;
        private final boolean statik;
        private final boolean java;

        public NativeCall(Class nativeTarget, String nativeName, Class nativeReturn, Class[] nativeSignature, boolean statik) {
            this(nativeTarget, nativeName, nativeReturn, nativeSignature, statik, false);
        }

        public NativeCall(Class nativeTarget, String nativeName, Class nativeReturn, Class[] nativeSignature, boolean statik, boolean java2) {
            this.nativeTarget = nativeTarget;
            this.nativeName = nativeName;
            this.nativeReturn = nativeReturn;
            this.nativeSignature = nativeSignature;
            this.statik = statik;
            this.java = java2;
        }

        public Class getNativeTarget() {
            return this.nativeTarget;
        }

        public String getNativeName() {
            return this.nativeName;
        }

        public Class getNativeReturn() {
            return this.nativeReturn;
        }

        public Class[] getNativeSignature() {
            return this.nativeSignature;
        }

        public boolean isStatic() {
            return this.statik;
        }

        public boolean isJava() {
            return this.java;
        }

        public boolean hasContext() {
            return this.nativeSignature.length > 0 && this.nativeSignature[0] == ThreadContext.class;
        }

        public boolean hasBlock() {
            return this.nativeSignature.length > 0 && this.nativeSignature[this.nativeSignature.length - 1] == Block.class;
        }

        public Method getMethod() {
            try {
                return this.nativeTarget.getDeclaredMethod(this.nativeName, this.nativeSignature);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return "" + (this.statik ? "static " : "") + this.nativeReturn.getSimpleName() + " " + this.nativeTarget.getSimpleName() + "." + this.nativeName + CodegenUtils.prettyShortParams(this.nativeSignature);
        }
    }
}

