/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.jruby;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.ext.jruby.JRubyExecutionContextLocal;
import org.jruby.ext.jruby.JRubyFiberLocal;
import org.jruby.ext.jruby.JRubyThreadLocal;
import org.jruby.ext.jruby.JRubyUtilLibrary;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;

@JRubyModule(name={"JRuby"})
public class JRubyLibrary
implements Library {
    @Override
    public void load(Ruby runtime, boolean wrap2) {
        ThreadContext context = runtime.getCurrentContext();
        runtime.getLoadService().require("java");
        runtime.getLoadService().loadFromClassLoader(runtime.getJRubyClassLoader(), "jruby/jruby.rb", false);
        RubyModule jrubyModule = runtime.getOrCreateModule("JRuby");
        jrubyModule.defineAnnotatedMethods(JRubyLibrary.class);
        jrubyModule.defineAnnotatedMethods(JRubyUtilLibrary.class);
        RubyClass threadLocalClass = jrubyModule.defineClassUnder("ThreadLocal", runtime.getObject(), JRubyThreadLocal.ALLOCATOR);
        threadLocalClass.defineAnnotatedMethods(JRubyExecutionContextLocal.class);
        RubyClass fiberLocalClass = jrubyModule.defineClassUnder("FiberLocal", runtime.getObject(), JRubyFiberLocal.ALLOCATOR);
        fiberLocalClass.defineAnnotatedMethods(JRubyExecutionContextLocal.class);
        RubyModule config = jrubyModule.defineModuleUnder("CONFIG");
        config.getSingletonClass().defineAnnotatedMethods(JRubyConfig.class);
    }

    @JRubyMethod(module=true)
    public static IRubyObject reference(ThreadContext context, IRubyObject recv2, IRubyObject obj) {
        Ruby runtime = context.runtime;
        return Java.getInstance(runtime, obj, false);
    }

    @JRubyMethod(module=true)
    public static IRubyObject reference0(ThreadContext context, IRubyObject recv2, IRubyObject obj) {
        Ruby runtime = context.runtime;
        return Java.getInstance(runtime, obj);
    }

    @JRubyMethod(module=true)
    public static IRubyObject dereference(ThreadContext context, IRubyObject recv2, IRubyObject obj) {
        Object unwrapped;
        if (obj instanceof JavaProxy) {
            unwrapped = ((JavaProxy)obj).getObject();
        } else if (obj.dataGetStruct() instanceof JavaObject) {
            unwrapped = JavaUtil.unwrapJavaObject(obj);
        } else {
            throw context.runtime.newTypeError("got " + obj + ", expected wrapped Java object");
        }
        if (!(unwrapped instanceof IRubyObject)) {
            throw context.runtime.newTypeError("got " + obj + ", expected Java-wrapped Ruby object");
        }
        return (IRubyObject)unwrapped;
    }

    @JRubyMethod(module=true)
    public static IRubyObject identity_hash(ThreadContext context, IRubyObject recv2, IRubyObject obj) {
        return context.runtime.newFixnum(System.identityHashCode(obj));
    }

    public static class MethodExtensions {
    }

    public static class JRubyConfig {
        @JRubyMethod(name={"rubygems_disabled?"})
        public static IRubyObject rubygems_disabled_p(ThreadContext context, IRubyObject self2) {
            return context.runtime.newBoolean(context.runtime.getInstanceConfig().isDisableGems());
        }
    }
}

