/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.jruby.RubyString;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public abstract class IOChannel
implements Channel {
    private final IRubyObject io;
    private final CallSite closeAdapter = MethodIndex.getFunctionalCallSite("close");

    protected IOChannel(IRubyObject io2) {
        this.io = io2;
    }

    @Override
    public void close() throws IOException {
        if (this.io.respondsTo("close")) {
            this.closeAdapter.call(this.io.getRuntime().getCurrentContext(), this.io, this.io);
        }
    }

    @Override
    public boolean isOpen() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected int read(CallSite read2, ByteBuffer dst) throws IOException {
        IRubyObject readValue = read2.call(this.io.getRuntime().getCurrentContext(), this.io, this.io, (IRubyObject)this.io.getRuntime().newFixnum(dst.remaining()));
        int returnValue = -1;
        if (!readValue.isNil()) {
            ByteList str = ((RubyString)readValue).getByteList();
            dst.put(str.getUnsafeBytes(), str.getBegin(), str.getRealSize());
            returnValue = str.getRealSize();
        }
        return returnValue;
    }

    protected int write(CallSite write2, ByteBuffer src) throws IOException {
        ByteList buffer = new ByteList(src.array(), src.position(), src.remaining(), false);
        IRubyObject written = write2.call(this.io.getRuntime().getCurrentContext(), this.io, this.io, (IRubyObject)RubyString.newStringLight(this.io.getRuntime(), buffer));
        return (int)written.convertToInteger().getLongValue();
    }

    protected CallSite initReadSite() {
        if (this.io.respondsTo("read")) {
            return MethodIndex.getFunctionalCallSite("read");
        }
        throw new IllegalArgumentException(this.io.getMetaClass() + "not coercible to " + this.getClass().getSimpleName() + ": no `read' method");
    }

    protected CallSite initWriteSite() {
        if (this.io.respondsTo("write")) {
            return MethodIndex.getFunctionalCallSite("write");
        }
        if (this.io.respondsTo("<<")) {
            return MethodIndex.getFunctionalCallSite("<<");
        }
        throw new IllegalArgumentException(this.io.getMetaClass() + "not coercible to " + this.getClass().getSimpleName() + ": no `write' method");
    }

    public static class IOReadableWritableByteChannel
    extends IOChannel
    implements ReadableByteChannel,
    WritableByteChannel {
        private final CallSite write;
        private final CallSite read = this.initReadSite();

        public IOReadableWritableByteChannel(IRubyObject io2) {
            super(io2);
            this.write = this.initWriteSite();
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            return this.read(this.read, dst);
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            return this.write(this.write, src);
        }
    }

    public static class IOWritableByteChannel
    extends IOChannel
    implements WritableByteChannel {
        private final CallSite write = this.initWriteSite();

        public IOWritableByteChannel(IRubyObject io2) {
            super(io2);
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            return this.write(this.write, src);
        }
    }

    public static class IOReadableByteChannel
    extends IOChannel
    implements ReadableByteChannel {
        private final CallSite read = this.initReadSite();

        public IOReadableByteChannel(IRubyObject io2) {
            super(io2);
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            return this.read(this.read, dst);
        }
    }
}

