/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.backtrace;

import org.jruby.lexer.yacc.ISourcePosition;

public class BacktraceElement {
    public String method;
    public String filename;
    public int line;

    public BacktraceElement() {
    }

    public BacktraceElement(String method, String filename2, int line) {
        this.method = method;
        this.filename = filename2;
        this.line = line;
    }

    public String toString() {
        return this.method + " at " + this.filename + ":" + this.line;
    }

    public BacktraceElement clone() {
        return new BacktraceElement(this.method, this.filename, this.line);
    }

    public static void update(BacktraceElement backtrace2, String method, ISourcePosition position) {
        backtrace2.method = method;
        backtrace2.filename = position.getFile();
        backtrace2.line = position.getLine();
    }

    public static void update(BacktraceElement backtrace2, String method, String file2, int line) {
        backtrace2.method = method;
        backtrace2.filename = file2;
        backtrace2.line = line;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename2) {
        this.filename = filename2;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }
}

