/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import org.jruby.ir.operands.TemporaryLocalVariable;
import org.jruby.ir.operands.TemporaryVariableType;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.SimpleCloneInfo;

public class TemporaryClosureVariable
extends TemporaryLocalVariable {
    private final int closureId;

    public TemporaryClosureVariable(int closureId, int offset2) {
        super("%cl_" + closureId + "_" + offset2, offset2);
        this.closureId = closureId;
    }

    public int getClosureId() {
        return this.closureId;
    }

    @Override
    public TemporaryVariableType getType() {
        return TemporaryVariableType.CLOSURE;
    }

    @Override
    public Variable clone(SimpleCloneInfo ii) {
        return this;
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.closureId);
    }

    public static TemporaryClosureVariable decode(IRReaderDecoder d) {
        int offset2 = d.decodeInt();
        int closureId = d.decodeInt();
        return new TemporaryClosureVariable(closureId, offset2);
    }

    @Override
    public String getPrefix() {
        return "%cl_" + this.closureId + "_";
    }
}

