/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.osgi.internal;

import java.net.URL;
import java.util.StringTokenizer;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.embed.osgi.internal.OSGiBundleLibrary;
import org.jruby.embed.osgi.internal.OSGiLoadService19;
import org.jruby.embed.osgi.utils.OSGiFileLocator;
import org.jruby.runtime.load.Library;
import org.jruby.runtime.load.LoadService;
import org.jruby.runtime.load.LoadServiceResource;
import org.osgi.framework.Bundle;

public class OSGiLoadService
extends LoadService {
    public static final String OSGI_BUNDLE_CLASSPATH_SCHEME = "osgibundle:/";
    public static RubyInstanceConfig.LoadServiceCreator OSGI_DEFAULT = new RubyInstanceConfig.LoadServiceCreator(){

        @Override
        public LoadService create(Ruby runtime) {
            return new OSGiLoadService19(runtime);
        }
    };

    public OSGiLoadService(Ruby runtime) {
        super(runtime);
    }

    @Override
    protected LoadServiceResource findFileInClasspath(String name2) {
        if (name2.startsWith(OSGI_BUNDLE_CLASSPATH_SCHEME)) {
            URL url;
            name2 = this.cleanupFindName(name2);
            StringTokenizer tokenizer = new StringTokenizer(name2, "/", false);
            tokenizer.nextToken();
            String symname = tokenizer.nextToken();
            StringBuilder sb = new StringBuilder();
            if (!tokenizer.hasMoreTokens()) {
                sb.append('/');
            } else {
                while (tokenizer.hasMoreTokens()) {
                    sb.append('/');
                    sb.append(tokenizer.nextToken());
                }
            }
            Bundle bundle = OSGiFileLocator.getBundle(symname);
            if (bundle != null && (url = bundle.getEntry(sb.toString())) != null) {
                return new LoadServiceResource(OSGiFileLocator.getLocalURL(url), name2);
            }
        }
        return super.findFileInClasspath(name2);
    }

    @Override
    protected Library createLibrary(LoadService.SearchState state2, LoadServiceResource resource2) {
        if (resource2 == null) {
            return null;
        }
        String file2 = state2.loadName;
        if (file2.startsWith(OSGI_BUNDLE_CLASSPATH_SCHEME)) {
            file2 = this.cleanupFindName(file2);
            StringTokenizer tokenizer = new StringTokenizer(file2, "/", false);
            tokenizer.nextToken();
            String symname = tokenizer.nextToken();
            Bundle bundle = OSGiFileLocator.getBundle(symname);
            if (bundle != null) {
                return new OSGiBundleLibrary(bundle);
            }
        }
        return super.createLibrary(state2, resource2);
    }

    private String cleanupFindName(String name2) {
        if (name2.endsWith(".jar")) {
            return name2.substring(0, name2.length() - ".jar".length());
        }
        if (name2.endsWith(".class")) {
            return name2.substring(0, name2.length() - ".class".length());
        }
        return name2;
    }
}

