/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.dirgra;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jruby.dirgra.Edge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdgeTypeIterator<T>
implements Iterator<Edge<T>> {
    private Iterator<Edge<T>> internalIterator;
    private Object type;
    private Edge nextEdge = null;
    private boolean negate;

    public EdgeTypeIterator(Collection<Edge<T>> edges, Object type2, boolean negate2) {
        this.internalIterator = edges.iterator();
        this.type = type2;
        this.negate = negate2;
    }

    @Override
    public boolean hasNext() {
        if (this.nextEdge != null) {
            return true;
        }
        while (this.internalIterator.hasNext()) {
            Edge<T> edge = this.internalIterator.next();
            Object edgeType = edge.getType();
            if (this.negate) {
                if ((edgeType == null || edgeType.equals(this.type)) && (edgeType != null || edgeType == this.type)) continue;
                this.nextEdge = edge;
                return true;
            }
            if ((edgeType == null || !edgeType.equals(this.type)) && (edgeType != null || edgeType != this.type)) continue;
            this.nextEdge = edge;
            return true;
        }
        return false;
    }

    @Override
    public Edge<T> next() {
        if (this.hasNext()) {
            Edge tmp = this.nextEdge;
            this.nextEdge = null;
            return tmp;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported");
    }
}

