/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import java.io.File;
import java.io.IOException;
import java.nio.channels.Channel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import jnr.constants.platform.Errno;
import jnr.constants.platform.OpenFlags;
import jnr.posix.SpawnAttribute;
import jnr.posix.SpawnFileAction;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyFile;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyNumeric;
import org.jruby.RubyProcess;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.platform.Platform;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.ShellLauncher;
import org.jruby.util.StringSupport;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.EncodingUtils;
import org.jruby.util.io.FilenoUtil;
import org.jruby.util.io.IOEncodable;
import org.jruby.util.io.OpenFile;
import org.jruby.util.io.POSIXProcess;
import org.jruby.util.io.PosixShim;

public class PopenExecutor {
    private Errno errno = null;
    private static final int ST_CONTINUE = 0;
    private static final int ST_STOP = 1;
    private static final String[] posix_sh_cmds = new String[]{"!", ".", ":", "break", "case", "continue", "do", "done", "elif", "else", "esac", "eval", "exec", "exit", "export", "fi", "for", "if", "in", "readonly", "return", "set", "shift", "then", "times", "trap", "unset", "until", "while"};
    private static final byte[] DUMMY_ARRAY = new byte[0];
    private static final Comparator<run_exec_dup2_fd_pair> intcmp = new Comparator<run_exec_dup2_fd_pair>(){

        @Override
        public int compare(run_exec_dup2_fd_pair o1, run_exec_dup2_fd_pair o2) {
            return Integer.compare(o1.oldfd, o2.oldfd);
        }
    };
    private static final Comparator<run_exec_dup2_fd_pair> intrcmp = new Comparator<run_exec_dup2_fd_pair>(){

        @Override
        public int compare(run_exec_dup2_fd_pair o1, run_exec_dup2_fd_pair o2) {
            return Integer.compare(o2.oldfd, o1.oldfd);
        }
    };

    public static IRubyObject checkPipeCommand(ThreadContext context, IRubyObject filenameOrCommand) {
        RubyString filenameStr = filenameOrCommand.convertToString();
        ByteList filenameByteList = filenameStr.getByteList();
        int[] chlen = new int[]{0};
        if (EncodingUtils.encAscget(filenameByteList.getUnsafeBytes(), filenameByteList.getBegin(), filenameByteList.getBegin() + filenameByteList.getRealSize(), chlen, filenameByteList.getEncoding()) == 124) {
            return filenameStr.makeShared19(context.runtime, chlen[0], filenameByteList.length() - 1).infectBy(filenameOrCommand);
        }
        return context.nil;
    }

    public static RubyFixnum spawn(ThreadContext context, IRubyObject[] argv) {
        Ruby runtime = context.runtime;
        long pid2 = 0L;
        String[] errmsg = new String[]{null};
        ExecArg eargp = PopenExecutor.execargNew(context, argv, true);
        PopenExecutor.execargFixup(context, runtime, eargp);
        RubyString fail_str = eargp.use_shell ? eargp.command_name : eargp.command_name;
        PopenExecutor executor = new PopenExecutor();
        pid2 = executor.spawnProcess(context, runtime, eargp, errmsg);
        if (pid2 == -1L) {
            if (errmsg[0] == null) {
                throw runtime.newErrnoFromErrno(executor.errno, ((Object)fail_str).toString());
            }
            throw runtime.newErrnoFromErrno(executor.errno, errmsg[0]);
        }
        return runtime.newFixnum(pid2);
    }

    public long spawnInternal(ThreadContext context, IRubyObject[] argv, String[] errmsg) {
        ExecArg eargp = PopenExecutor.execargNew(context, argv, true);
        PopenExecutor.execargFixup(context, context.runtime, eargp);
        long ret = this.spawnProcess(context, context.runtime, eargp, errmsg);
        return ret;
    }

    long spawnProcess(ThreadContext context, Ruby runtime, ExecArg eargp, String[] errmsg) {
        long pid2;
        String[] argv;
        RubyString prog;
        ExecArg sarg = new ExecArg();
        RubyString rubyString = prog = eargp.use_shell ? eargp.command_name : eargp.command_name;
        if (eargp.chdir_given()) {
            prog = (RubyString)prog.strDup(runtime).prepend(context, RubyString.newString(runtime, "cd '" + eargp.chdir_dir + "'; "));
            eargp.chdir_dir = null;
            eargp.chdir_given_clear();
        }
        if (this.execargRunOptions(context, runtime, eargp, sarg, errmsg) < 0) {
            return -1L;
        }
        if (prog != null && !eargp.use_shell && (argv = eargp.argv_str.argv).length > 0) {
            argv[0] = prog.toString();
        }
        if (eargp.use_shell) {
            pid2 = this.procSpawnSh(runtime, prog.toString(), eargp);
        } else {
            argv = eargp.argv_str.argv;
            pid2 = this.procSpawnCmd(runtime, argv, prog.toString(), eargp);
        }
        if (pid2 == -1L) {
            context.setLastExitStatus(new RubyProcess.RubyStatus(runtime, runtime.getProcStatus(), 32512L, 0L));
            this.errno = Errno.valueOf(runtime.getPosix().errno());
        }
        this.execargRunOptions(context, runtime, sarg, null, errmsg);
        return pid2;
    }

    long procSpawnCmdInternal(Ruby runtime, String[] argv, String prog, ExecArg eargp) {
        if (prog == null) {
            prog = argv[0];
        }
        if ((prog = PopenExecutor.dlnFindExeR(runtime, prog, null)) == null) {
            this.errno = Errno.ENOENT;
            return -1L;
        }
        if (prog == null || prog.length() == 0) {
            this.errno = Errno.ENOENT;
            return -1L;
        }
        long status2 = runtime.getPosix().posix_spawnp(prog, eargp.fileActions, eargp.attributes, Arrays.asList(argv), (Collection<? extends CharSequence>)(eargp.envp_str == null ? Collections.EMPTY_LIST : Arrays.asList(eargp.envp_str)));
        if (status2 == -1L) {
            if (runtime.getPosix().errno() == Errno.ENOEXEC.intValue()) {
                String[] newArgv = new String[argv.length + 1];
                newArgv[1] = prog;
                newArgv[0] = "sh";
                status2 = runtime.getPosix().posix_spawnp("/bin/sh", eargp.fileActions, eargp.attributes, Arrays.asList(argv), (Collection<? extends CharSequence>)(eargp.envp_str == null ? Collections.EMPTY_LIST : Arrays.asList(eargp.envp_str)));
                if (status2 == -1L) {
                    this.errno = Errno.ENOEXEC;
                }
            } else {
                this.errno = Errno.valueOf(runtime.getPosix().errno());
            }
        }
        return status2;
    }

    long procSpawnCmd(Ruby runtime, String[] argv, String prog, ExecArg eargp) {
        long pid2 = -1L;
        if (argv.length > 0 && argv[0] != null) {
            pid2 = this.procSpawnCmdInternal(runtime, argv, prog, eargp);
        }
        return pid2;
    }

    long procSpawnSh(Ruby runtime, String str, ExecArg eargp) {
        String shell = PopenExecutor.dlnFindExeR(runtime, "sh", null);
        long status2 = runtime.getPosix().posix_spawnp(shell != null ? shell : "/bin/sh", eargp.fileActions, eargp.attributes, Arrays.asList("sh", "-c", str), (Collection<? extends CharSequence>)(eargp.envp_str == null ? Collections.EMPTY_LIST : Arrays.asList(eargp.envp_str)));
        if (status2 == -1L) {
            this.errno = Errno.valueOf(runtime.getPosix().errno());
        }
        return status2;
    }

    public static IRubyObject pipeOpen(ThreadContext context, IRubyObject prog, String modestr, int fmode, IOEncodable convconfig) {
        IRubyObject[] argv = new IRubyObject[]{prog};
        ExecArg execArg = null;
        if (!PopenExecutor.isPopenFork(context.runtime, (RubyString)prog)) {
            execArg = PopenExecutor.execargNew(context, argv, true);
        }
        return new PopenExecutor().pipeOpen(context, execArg, modestr, fmode, convconfig);
    }

    public static IRubyObject popen(ThreadContext context, IRubyObject[] argv, RubyClass klass, Block block) {
        ExecArg eargp;
        IRubyObject pname;
        Ruby runtime = context.runtime;
        IRubyObject opt = context.nil;
        IRubyObject env = context.nil;
        Object pmode = EncodingUtils.vmodeVperm(null, null);
        int[] oflags_p = new int[]{0};
        int[] fmode_p = new int[]{0};
        IOEncodable.ConvConfig convconfig = new IOEncodable.ConvConfig();
        int argc = argv.length;
        if (argc > 1 && !(opt = TypeConverter.checkHashType(runtime, argv[argc - 1])).isNil()) {
            --argc;
        }
        if (argc > 1 && !(env = TypeConverter.checkHashType(runtime, argv[0])).isNil()) {
            argv = Arrays.copyOfRange(argv, 1, --argc + 1);
        }
        switch (argc) {
            case 2: {
                EncodingUtils.vmode(pmode, argv[1]);
            }
            case 1: {
                pname = argv[0];
                break;
            }
            default: {
                int ex = opt.isNil() ? 0 : 1;
                Arity.raiseArgumentError(runtime, argc + ex, 1 + ex, 2 + ex);
                return null;
            }
        }
        IRubyObject tmp = TypeConverter.checkArrayType(runtime, pname);
        if (!tmp.isNil()) {
            tmp = ((RubyArray)tmp).aryDup();
            eargp = PopenExecutor.execargNew(context, ((RubyArray)tmp).toJavaArray(), false);
            ((RubyArray)tmp).clear();
        } else {
            pname = pname.convertToString();
            eargp = null;
            if (!PopenExecutor.isPopenFork(runtime, (RubyString)pname)) {
                IRubyObject[] pname_p = new IRubyObject[]{pname};
                eargp = PopenExecutor.execargNew(context, pname_p, true);
                pname = pname_p[0];
            }
        }
        if (eargp != null) {
            if (!opt.isNil()) {
                opt = PopenExecutor.execargExtractOptions(context, runtime, eargp, (RubyHash)opt);
            }
            if (!env.isNil()) {
                PopenExecutor.execargSetenv(context, runtime, eargp, env);
            }
        }
        EncodingUtils.extractModeEncoding(context, convconfig, pmode, opt, oflags_p, fmode_p);
        String modestr = OpenFile.ioOflagsModestr(runtime, oflags_p[0]);
        IRubyObject port = new PopenExecutor().pipeOpen(context, eargp, modestr, fmode_p[0], convconfig);
        ((RubyBasicObject)port).setMetaClass(klass);
        return RubyIO.ensureYieldClose(context, port, block);
    }

    static void execargSetenv(ThreadContext context, Ruby runtime, ExecArg eargp, IRubyObject env) {
        eargp.env_modification = !env.isNil() ? PopenExecutor.checkExecEnv(context, (RubyHash)env) : null;
    }

    public static RubyArray checkExecEnv(ThreadContext context, RubyHash hash2) {
        Ruby runtime = context.runtime;
        RubyArray env = runtime.newArray();
        for (Map.Entry entry : hash2.directEntrySet()) {
            IRubyObject key2 = (IRubyObject)entry.getKey();
            IRubyObject val = (IRubyObject)entry.getValue();
            String k = StringSupport.checkEmbeddedNulls(runtime, key2).toString();
            if (k.indexOf(61) != -1) {
                throw runtime.newArgumentError("environment name contains a equal : " + k);
            }
            if (!val.isNil()) {
                val = StringSupport.checkEmbeddedNulls(runtime, val);
            }
            key2 = key2.convertToString().export(context);
            if (!val.isNil()) {
                val = val.convertToString().export(context);
            }
            env.push(runtime.newArray(key2, val));
        }
        return env;
    }

    static IRubyObject execargExtractOptions(ThreadContext context, Ruby runtime, ExecArg eargp, RubyHash opthash) {
        return PopenExecutor.handleOptionsCommon(context, runtime, eargp, opthash, false);
    }

    static void checkExecOptions(ThreadContext context, Ruby runtime, RubyHash opthash, ExecArg eargp) {
        PopenExecutor.handleOptionsCommon(context, runtime, eargp, opthash, true);
    }

    static IRubyObject handleOptionsCommon(ThreadContext context, Ruby runtime, ExecArg eargp, RubyHash opthash, boolean raise2) {
        if (opthash.isEmpty()) {
            return null;
        }
        IRubyObject nonopts = null;
        for (Map.Entry entry : opthash.directEntrySet()) {
            IRubyObject val;
            IRubyObject key2 = (IRubyObject)entry.getKey();
            if (PopenExecutor.execargAddopt(context, runtime, eargp, key2, val = (IRubyObject)entry.getValue()) == 0) continue;
            if (raise2) {
                if (key2 instanceof RubySymbol) {
                    throw runtime.newArgumentError("wrong exec option symbol: " + key2);
                }
                throw runtime.newArgumentError("wrong exec option");
            }
            if (nonopts == null) {
                nonopts = RubyHash.newHash(runtime);
            }
            ((RubyHash)nonopts).op_aset(context, key2, val);
        }
        return nonopts != null ? nonopts : context.nil;
    }

    static boolean isPopenFork(Ruby runtime, RubyString prog) {
        if (prog.size() == 1 && prog.getByteList().get(0) == 45) {
            throw runtime.newNotImplementedError("fork() function is unimplemented on JRuby");
        }
        return false;
    }

    private long DO_SPAWN(Ruby runtime, ExecArg eargp, String cmd, String[] args2, String[] envp) {
        if (eargp.use_shell) {
            return this.procSpawnSh(runtime, eargp, cmd, envp);
        }
        if (cmd == null || cmd.length() == 0) {
            this.errno = Errno.ENOENT;
            return -1L;
        }
        long ret = runtime.getPosix().posix_spawnp(cmd, eargp.fileActions, eargp.attributes, args2 == null ? Collections.EMPTY_LIST : Arrays.asList(args2), envp == null ? Collections.EMPTY_LIST : Arrays.asList(envp));
        if (ret == -1L) {
            this.errno = Errno.valueOf(runtime.getPosix().errno());
        }
        return ret;
    }

    private long procSpawnSh(Ruby runtime, ExecArg eargp, String str, String[] envp) {
        int s2;
        char[] sChars = str.toCharArray();
        for (s2 = 0; s2 < sChars.length && (sChars[s2] == ' ' || sChars[s2] == '\t' || sChars[s2] == '\n'); ++s2) {
        }
        if (s2 >= sChars.length) {
            this.errno = Errno.ENOENT;
            return -1L;
        }
        if (Platform.IS_WINDOWS) {
            return -1L;
        }
        long ret = runtime.getPosix().posix_spawnp("/bin/sh", eargp.fileActions, eargp.attributes, Arrays.asList("sh", "-c", str), envp == null ? Collections.EMPTY_LIST : Arrays.asList(envp));
        if (ret == -1L) {
            this.errno = Errno.valueOf(runtime.getPosix().errno());
        }
        return ret;
    }

    private static String[] ARGVSTR2ARGV(byte[][] argv_str) {
        String[] argv = new String[argv_str.length];
        for (int i2 = 0; i2 < argv_str.length; ++i2) {
            if (argv_str[i2] == null) continue;
            argv[i2] = new String(argv_str[i2]);
        }
        return argv;
    }

    private IRubyObject pipeOpen(ThreadContext context, ExecArg eargp, String modestr, int fmode, IOEncodable convconfig) {
        Channel fd;
        Ruby runtime = context.runtime;
        RubyString prog = eargp != null ? (eargp.use_shell ? eargp.command_name : eargp.command_name) : null;
        long pid2 = 0L;
        PosixShim posix = new PosixShim(runtime);
        Errno e = null;
        String[] args2 = null;
        String[] envp = null;
        ExecArg sargp = new ExecArg();
        Channel write_fd = null;
        String cmd = null;
        if (prog != null) {
            cmd = StringSupport.checkEmbeddedNulls(runtime, prog).toString();
        }
        if (eargp.chdir_given()) {
            cmd = "cd '" + eargp.chdir_dir + "'; " + cmd;
            eargp.chdir_dir = null;
            eargp.chdir_given_clear();
        }
        if (eargp != null && !eargp.use_shell) {
            args2 = eargp.argv_str.argv;
        }
        Channel[] mainPipe = null;
        Channel[] secondPipe = null;
        switch (fmode & 3) {
            case 3: {
                secondPipe = posix.pipe();
                if (secondPipe == null) {
                    throw runtime.newErrnoFromErrno(posix.errno, ((Object)prog).toString());
                }
                mainPipe = posix.pipe();
                if (mainPipe == null) {
                    e = posix.errno;
                    try {
                        secondPipe[1].close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    try {
                        secondPipe[0].close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    posix.errno = e;
                    throw runtime.newErrnoFromErrno(posix.errno, ((Object)prog).toString());
                }
                if (eargp == null) break;
                this.prepareStdioRedirects(runtime, mainPipe, secondPipe, eargp);
                break;
            }
            case 1: {
                mainPipe = posix.pipe();
                if (mainPipe == null) {
                    throw runtime.newErrnoFromErrno(posix.errno, ((Object)prog).toString());
                }
                if (eargp == null) break;
                this.prepareStdioRedirects(runtime, mainPipe, null, eargp);
                break;
            }
            case 2: {
                mainPipe = posix.pipe();
                if (mainPipe == null) {
                    throw runtime.newErrnoFromErrno(posix.errno, ((Object)prog).toString());
                }
                if (eargp == null) break;
                this.prepareStdioRedirects(runtime, null, mainPipe, eargp);
                break;
            }
            default: {
                throw runtime.newSystemCallError(((Object)prog).toString());
            }
        }
        if (eargp != null) {
            PopenExecutor.execargFixup(context, runtime, eargp);
            this.execargRunOptions(context, runtime, eargp, sargp, null);
            if (eargp.envp_str != null) {
                envp = eargp.envp_str;
            }
            block30: while ((pid2 = this.DO_SPAWN(runtime, eargp, cmd, args2, envp)) == -1L) {
                e = this.errno;
                switch (e) {
                    case EAGAIN: 
                    case EWOULDBLOCK: {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ie) {}
                        continue block30;
                    }
                }
                break;
            }
        } else {
            throw runtime.newNotImplementedError("spawn without exec args (probably a bug)");
        }
        if (pid2 == -1L) {
            try {
                mainPipe[1].close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            try {
                mainPipe[0].close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            if ((fmode & 3) == 3) {
                try {
                    mainPipe[1].close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                try {
                    mainPipe[0].close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            this.errno = e;
            throw runtime.newErrnoFromErrno(this.errno, ((Object)prog).toString());
        }
        if ((fmode & 1) != 0 && (fmode & 2) != 0) {
            try {
                mainPipe[1].close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            fd = mainPipe[0];
            try {
                secondPipe[0].close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            write_fd = secondPipe[1];
        } else if ((fmode & 1) != 0) {
            try {
                mainPipe[1].close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            fd = mainPipe[0];
        } else {
            try {
                mainPipe[0].close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            fd = mainPipe[1];
        }
        IRubyObject port = runtime.getIO().allocate();
        OpenFile fptr = ((RubyIO)port).MakeOpenFile();
        fptr.setChannel(fd);
        fptr.setMode(fmode | 0x28);
        if (convconfig != null) {
            fptr.encs.copy(convconfig);
            if (Platform.IS_WINDOWS && (fptr.encs.ecflags & EncodingUtils.ECONV_DEFAULT_NEWLINE_DECORATOR) != 0) {
                fptr.encs.ecflags |= 0x100;
            }
        } else {
            if (fptr.NEED_NEWLINE_DECORATOR_ON_READ()) {
                fptr.encs.ecflags |= 0x100;
            }
            if (EncodingUtils.TEXTMODE_NEWLINE_DECORATOR_ON_WRITE != 0 && fptr.NEED_NEWLINE_DECORATOR_ON_WRITE()) {
                fptr.encs.ecflags |= EncodingUtils.TEXTMODE_NEWLINE_DECORATOR_ON_WRITE;
            }
        }
        long finalPid = pid2;
        fptr.setPid(pid2);
        fptr.setProcess(new POSIXProcess(runtime, finalPid));
        if (write_fd != null) {
            IRubyObject write_port = runtime.getIO().allocate();
            OpenFile write_fptr = ((RubyIO)write_port).MakeOpenFile();
            write_fptr.setChannel(write_fd);
            write_fptr.setMode(fmode & 0xFFFFFFFE | 8 | 0x20);
            fptr.setMode(fptr.getMode() & 0xFFFFFFFD);
            fptr.tiedIOForWriting = (RubyIO)write_port;
            ((RubyIO)port).setInstanceVariable("@tied_io_for_writing", write_port);
        }
        return port;
    }

    private void prepareStdioRedirects(Ruby runtime, Channel[] readPipe, Channel[] writePipe, ExecArg eargp) {
        if (readPipe != null) {
            int readPipeWriteFD = FilenoUtil.filenoFrom(readPipe[1]);
            eargp.fd_dup2 = PopenExecutor.checkExecRedirect1(runtime, eargp.fd_dup2, runtime.newFixnum(1), runtime.newFixnum(readPipeWriteFD));
            int readPipeReadFD = FilenoUtil.filenoFrom(readPipe[0]);
            eargp.fileActions.add(SpawnFileAction.close(readPipeReadFD));
        }
        if (writePipe != null) {
            int writePipeReadFD = FilenoUtil.filenoFrom(writePipe[0]);
            eargp.fd_dup2 = PopenExecutor.checkExecRedirect1(runtime, eargp.fd_dup2, runtime.newFixnum(0), runtime.newFixnum(writePipeReadFD));
            int writePipeWriteFD = FilenoUtil.filenoFrom(writePipe[1]);
            eargp.fileActions.add(SpawnFileAction.close(writePipeWriteFD));
        }
    }

    static int run_exec_pgroup(Ruby runtime, ExecArg eargp, ExecArg sargp, String[] errmsg) {
        int ret = 0;
        long pgroup = eargp.pgroup_pgid;
        if (pgroup == -1L) {
            pgroup = runtime.getPosix().getpgrp();
        }
        if (pgroup == 0L) {
            return ret;
        }
        eargp.attributes.add(SpawnAttribute.pgroup(pgroup));
        return ret;
    }

    static int run_exec_rlimit(Ruby runtime, RubyArray ary, ExecArg sargp, String[] errmsg) {
        throw runtime.newNotImplementedError("changing rlimit in child is not supported");
    }

    static void saveEnv(ThreadContext context, Ruby runtime, ExecArg sargp) {
    }

    static int run_exec_dup2(Ruby runtime, RubyArray ary, ExecArg eargp, ExecArg sargp, String[] errmsg) {
        int ret;
        int i2;
        int extra_fd = -1;
        run_exec_dup2_fd_pair[] pairs = eargp.dup2_tmpbuf;
        int n = ary.size();
        for (i2 = 0; i2 < n; ++i2) {
            IRubyObject elt = ary.eltOk(i2);
            pairs[i2].oldfd = RubyNumeric.fix2int(((RubyArray)elt).eltOk(1L));
            pairs[i2].newfd = RubyNumeric.fix2int(((RubyArray)elt).eltOk(0L));
            pairs[i2].older_index = -1;
        }
        if (sargp == null) {
            Arrays.sort(pairs, intcmp);
        } else {
            Arrays.sort(pairs, intrcmp);
        }
        for (i2 = 0; i2 < n; ++i2) {
            int found;
            int newfd = pairs[i2].newfd;
            run_exec_dup2_fd_pair key2 = new run_exec_dup2_fd_pair();
            key2.oldfd = newfd;
            pairs[i2].num_newer = 0;
            if (found == -1) continue;
            for (found = Arrays.binarySearch(pairs, key2, intcmp); found > 0 && pairs[found - 1].oldfd == newfd; --found) {
            }
            while (found < n && pairs[found].oldfd == newfd) {
                ++pairs[i2].num_newer;
                pairs[found].older_index = i2;
                ++found;
            }
        }
        for (i2 = 0; i2 < n; ++i2) {
            int j = i2;
            while (j != -1 && pairs[j].oldfd != -1 && pairs[j].num_newer == 0) {
                if (PopenExecutor.saveRedirectFd(runtime, pairs[j].newfd, sargp, errmsg) < 0) {
                    return -1;
                }
                PopenExecutor.redirectDup2(eargp, pairs[j].oldfd, pairs[j].newfd);
                pairs[j].oldfd = -1;
                j = pairs[j].older_index;
                if (j == -1) continue;
                --pairs[j].num_newer;
            }
        }
        for (i2 = 0; i2 < n; ++i2) {
            if (pairs[i2].oldfd == -1) continue;
            throw runtime.newNotImplementedError("cyclic redirects in child are not supported");
        }
        if (extra_fd != -1 && (ret = PopenExecutor.redirectClose(runtime, eargp, extra_fd, sargp != null)) == -1) {
            if (errmsg != null) {
                errmsg[0] = "close";
            }
            return -1;
        }
        return 0;
    }

    static int redirectDup(Ruby runtime, int oldfd) {
        int ret = runtime.getPosix().dup(oldfd);
        return ret;
    }

    static void redirectDup2(ExecArg eargp, int oldfd, int newfd) {
        eargp.fileActions.add(SpawnFileAction.dup(oldfd, newfd));
    }

    static int redirectClose(Ruby runtime, ExecArg eargp, int fd, boolean forChild) {
        if (forChild) {
            eargp.fileActions.add(SpawnFileAction.close(fd));
            return 0;
        }
        return runtime.getPosix().close(fd);
    }

    static void redirectOpen(ExecArg eargp, int fd, String pathname2, int flags2, int perm) {
        eargp.fileActions.add(SpawnFileAction.open(pathname2, fd, flags2, perm));
    }

    static int saveRedirectFd(Ruby runtime, int fd, ExecArg sargp, String[] errmsg) {
        return 0;
    }

    int execargRunOptions(ThreadContext context, Ruby runtime, ExecArg eargp, ExecArg sargp, String[] errmsg) {
        if (sargp != null) {
            sargp.redirect_fds = context.nil;
        }
        if (eargp.pgroup_given() && PopenExecutor.run_exec_pgroup(runtime, eargp, sargp, errmsg) == -1) {
            return -1;
        }
        IRubyObject obj = eargp.rlimit_limits;
        if (obj != null) {
            throw runtime.newNotImplementedError("setting rlimit in child is unsupported");
        }
        boolean clearEnv = false;
        if (eargp.unsetenv_others_given() && eargp.unsetenv_others_do()) {
            throw runtime.newNotImplementedError("clearing env in child is not supported");
        }
        RubyArray env = eargp.env_modification;
        if (env != null) {
            eargp.envp_str = ShellLauncher.getModifiedEnv(runtime, env, clearEnv);
        }
        if (eargp.umask_given()) {
            throw runtime.newNotImplementedError("setting umask in child is unsupported");
        }
        obj = eargp.fd_dup2;
        if (obj != null && PopenExecutor.run_exec_dup2(runtime, (RubyArray)obj, eargp, sargp, errmsg) == -1) {
            return -1;
        }
        obj = eargp.fd_close;
        if (obj != null) {
            if (sargp != null) {
                runtime.getWarnings().warn("cannot close fd before spawn");
            } else if (PopenExecutor.run_exec_close(runtime, (RubyArray)obj, eargp, errmsg) == -1) {
                return -1;
            }
        }
        if ((obj = eargp.fd_open) != null && PopenExecutor.run_exec_open(runtime, (RubyArray)obj, eargp, sargp, errmsg) == -1) {
            return -1;
        }
        obj = eargp.fd_dup2_child;
        if (obj != null && PopenExecutor.run_exec_dup2_child(runtime, (RubyArray)obj, eargp, sargp, errmsg) == -1) {
            return -1;
        }
        if (eargp.chdir_given()) {
            throw new RuntimeException("BUG: chdir not supported in posix_spawn; should have been made into chdir");
        }
        if (eargp.gid_given()) {
            throw runtime.newNotImplementedError("setgid in the child is not supported");
        }
        if (eargp.uid_given()) {
            throw runtime.newNotImplementedError("setuid in the child is not supported");
        }
        return 0;
    }

    static int run_exec_close(Ruby runtime, RubyArray ary, ExecArg eargp, String[] errmsg) {
        for (long i2 = 0L; i2 < (long)ary.size(); ++i2) {
            RubyArray elt = (RubyArray)ary.eltOk(i2);
            int fd = RubyNumeric.fix2int(elt.eltOk(0L));
            int ret = PopenExecutor.redirectClose(runtime, eargp, fd, true);
            if (ret != -1) continue;
            if (errmsg != null) {
                errmsg[0] = "close";
            }
            return -1;
        }
        return 0;
    }

    static int run_exec_open(Ruby runtime, RubyArray ary, ExecArg eargp, ExecArg sargp, String[] errmsg) {
        int i2 = 0;
        while (i2 < ary.size()) {
            RubyArray elt = (RubyArray)ary.eltOk(i2);
            RubyArray param = (RubyArray)elt.eltOk(1L);
            String path2 = param.eltOk(0L).toString();
            int flags2 = RubyNumeric.num2int(param.eltOk(1L));
            int perm = RubyNumeric.num2int(param.eltOk(2L));
            boolean need_close = true;
            elt = (RubyArray)ary.eltOk(i2);
            int fd = RubyNumeric.fix2int(elt.eltOk(0L));
            PopenExecutor.redirectOpen(eargp, fd, path2, flags2, perm);
        }
        return 0;
    }

    static int run_exec_dup2_child(Ruby runtime, RubyArray ary, ExecArg eargp, ExecArg sargp, String[] errmsg) {
        for (long i2 = 0L; i2 < (long)ary.size(); ++i2) {
            RubyArray elt = (RubyArray)ary.eltOk(i2);
            int newfd = RubyNumeric.fix2int(elt.eltOk(0L));
            int oldfd = RubyNumeric.fix2int(elt.eltOk(1L));
            PopenExecutor.redirectDup2(eargp, oldfd, newfd);
        }
        return 0;
    }

    static int runExecDup2TmpbufSize(int n) {
        return n;
    }

    static void execargFixup(ThreadContext context, Ruby runtime, ExecArg eargp) {
        IRubyObject envtbl;
        eargp.redirect_fds = PopenExecutor.checkExecFds(context, runtime, eargp);
        IRubyObject ary = eargp.fd_dup2;
        if (ary != null) {
            int len = PopenExecutor.runExecDup2TmpbufSize(((RubyArray)ary).size());
            run_exec_dup2_fd_pair[] tmpbuf = new run_exec_dup2_fd_pair[len];
            for (int i2 = 0; i2 < tmpbuf.length; ++i2) {
                tmpbuf[i2] = new run_exec_dup2_fd_pair();
            }
            eargp.dup2_tmpbuf = tmpbuf;
        }
        boolean unsetenv_others = eargp.unsetenv_others_given() && eargp.unsetenv_others_do();
        RubyArray envopts = eargp.env_modification;
        if (unsetenv_others || envopts != null) {
            if (unsetenv_others) {
                envtbl = RubyHash.newHash(runtime);
            } else {
                envtbl = runtime.getObject().getConstant("ENV");
                envtbl = TypeConverter.convertToType(envtbl, runtime.getHash(), "to_hash").dup();
            }
            if (envopts != null) {
                IRubyObject stenv = envtbl;
                for (long i3 = 0L; i3 < (long)envopts.size(); ++i3) {
                    IRubyObject pair = envopts.eltOk(i3);
                    IRubyObject key2 = ((RubyArray)pair).eltOk(0L);
                    IRubyObject val = ((RubyArray)pair).eltOk(1L);
                    if (val.isNil()) {
                        IRubyObject stkey = key2;
                        ((RubyHash)stenv).fastDelete(stkey);
                        continue;
                    }
                    ((RubyHash)stenv).op_aset(context, key2, val);
                }
            }
        } else {
            envtbl = runtime.getObject().getConstant("ENV");
            envtbl = TypeConverter.convertToType(envtbl, runtime.getHash(), "to_hash");
        }
        PopenExecutor.buildEnvp(runtime, eargp, envtbl);
    }

    private static void buildEnvp(Ruby runtime, ExecArg eargp, IRubyObject envtbl) {
        ArrayList<String> envp_buf = new ArrayList<String>();
        for (Map.Entry entry : ((RubyHash)envtbl).directEntrySet()) {
            IRubyObject key2 = (IRubyObject)entry.getKey();
            IRubyObject val = (IRubyObject)entry.getValue();
            envp_buf.add(StringSupport.checkEmbeddedNulls(runtime, key2).toString() + "=" + StringSupport.checkEmbeddedNulls(runtime, val));
        }
        String[] envp_str = new String[envp_buf.size()];
        envp_buf.toArray(envp_str);
        eargp.envp_str = envp_str;
        eargp.envp_buf = envp_buf;
    }

    static int checkExecFds1(ThreadContext context, Ruby runtime, ExecArg eargp, RubyHash h, int maxhint, IRubyObject ary) {
        if (ary != null) {
            for (long i2 = 0L; i2 < (long)((RubyArray)ary).size(); ++i2) {
                IRubyObject elt = ((RubyArray)ary).eltOk(i2);
                int fd = RubyNumeric.fix2int(((RubyArray)elt).eltOk(0L));
                if (h.fastARef(runtime.newFixnum(fd)) != null) {
                    throw runtime.newArgumentError("fd " + fd + " specified twice");
                }
                if (ary == eargp.fd_open || ary == eargp.fd_dup2) {
                    h.op_aset(context, runtime.newFixnum(fd), runtime.getTrue());
                } else if (ary == eargp.fd_dup2_child) {
                    h.op_aset(context, runtime.newFixnum(fd), ((RubyArray)elt).eltOk(1L));
                } else {
                    h.op_aset(context, runtime.newFixnum(fd), runtime.newFixnum(-1));
                }
                if (maxhint < fd) {
                    maxhint = fd;
                }
                if (ary != eargp.fd_dup2 && ary != eargp.fd_dup2_child || maxhint >= (fd = RubyNumeric.fix2int(((RubyArray)elt).eltOk(1L)))) continue;
                maxhint = fd;
            }
        }
        return maxhint;
    }

    static IRubyObject checkExecFds(ThreadContext context, Ruby runtime, ExecArg eargp) {
        RubyHash h = RubyHash.newHash(runtime);
        int maxhint = -1;
        maxhint = PopenExecutor.checkExecFds1(context, runtime, eargp, h, maxhint, eargp.fd_dup2);
        maxhint = PopenExecutor.checkExecFds1(context, runtime, eargp, h, maxhint, eargp.fd_close);
        maxhint = PopenExecutor.checkExecFds1(context, runtime, eargp, h, maxhint, eargp.fd_open);
        maxhint = PopenExecutor.checkExecFds1(context, runtime, eargp, h, maxhint, eargp.fd_dup2_child);
        if (eargp.fd_dup2_child != null) {
            IRubyObject ary = eargp.fd_dup2_child;
            for (long i2 = 0L; i2 < (long)((RubyArray)ary).size(); ++i2) {
                IRubyObject val2;
                int oldfd;
                IRubyObject elt = ((RubyArray)ary).eltOk(i2);
                int newfd = RubyNumeric.fix2int(((RubyArray)elt).eltOk(0L));
                int lastfd = oldfd = RubyNumeric.fix2int(((RubyArray)elt).eltOk(1L));
                IRubyObject val = h.fastARef(runtime.newFixnum(lastfd));
                long depth = 0L;
                while (val instanceof RubyFixnum && 0 <= ((RubyFixnum)val).getIntValue()) {
                    lastfd = RubyNumeric.fix2int(val);
                    val = h.fastARef(val);
                    if ((long)((RubyArray)ary).size() < depth) {
                        throw runtime.newArgumentError("cyclic child fd redirection from " + oldfd);
                    }
                    ++depth;
                }
                if (val != runtime.getTrue()) {
                    throw runtime.newArgumentError("child fd " + oldfd + " is not redirected");
                }
                if (oldfd == lastfd) continue;
                ((RubyArray)elt).store(1L, runtime.newFixnum(lastfd));
                h.op_aset(context, runtime.newFixnum(newfd), runtime.newFixnum(lastfd));
                val = runtime.newFixnum(oldfd);
                while ((val2 = h.fastARef(val)) instanceof RubyFixnum) {
                    h.op_aset(context, val, runtime.newFixnum(lastfd));
                    val = val2;
                }
            }
        }
        eargp.close_others_maxhint = maxhint;
        return h;
    }

    static int execargAddopt(ThreadContext context, Ruby runtime, ExecArg eargp, IRubyObject key2, IRubyObject val) {
        boolean redirect = false;
        switch (key2.getMetaClass().getRealClass().getClassIndex()) {
            case SYMBOL: {
                String id2 = key2.toString();
                if (id2.equals("pgroup")) {
                    long pgroup;
                    if (eargp.pgroup_given()) {
                        throw runtime.newArgumentError("pgroup option specified twice");
                    }
                    if (val == null || val.isNil()) {
                        pgroup = -1L;
                    } else if (val == runtime.getTrue()) {
                        pgroup = 0L;
                    } else {
                        pgroup = val.convertToInteger().getLongValue();
                        if (pgroup < 0L) {
                            throw runtime.newArgumentError("negative process group ID : " + pgroup);
                        }
                    }
                    eargp.pgroup_given_set();
                    eargp.pgroup_pgid = pgroup;
                    break;
                }
                if (id2.startsWith("rlimit_")) {
                    // empty if block
                }
                if (id2.equals("unsetenv_others")) {
                    if (eargp.unsetenv_others_given()) {
                        throw runtime.newArgumentError("unsetenv_others option specified twice");
                    }
                    eargp.unsetenv_others_given_set();
                    if (!val.isNil()) {
                        eargp.unsetenv_others_do_set();
                        break;
                    }
                    eargp.unsetenv_others_do_clear();
                    break;
                }
                if (id2.equals("chdir")) {
                    if (eargp.chdir_given()) {
                        throw runtime.newArgumentError("chdir option specified twice");
                    }
                    RubyString valTmp = RubyFile.get_path(context, val);
                    eargp.chdir_given_set();
                    eargp.chdir_dir = valTmp.toString();
                    break;
                }
                if (id2.equals("umask")) {
                    int cmask = val.convertToInteger().getIntValue();
                    if (eargp.umask_given()) {
                        throw runtime.newArgumentError("umask option specified twice");
                    }
                    eargp.umask_given_set();
                    eargp.umask_mask = cmask;
                    break;
                }
                if (id2.equals("close_others")) {
                    if (eargp.close_others_given()) {
                        throw runtime.newArgumentError("close_others option specified twice");
                    }
                    eargp.close_others_given_set();
                    if (!val.isNil()) {
                        eargp.close_others_do_set();
                        break;
                    }
                    eargp.close_others_do_clear();
                    break;
                }
                if (id2.equals("in")) {
                    key2 = RubyFixnum.zero(runtime);
                    PopenExecutor.checkExecRedirect(context, runtime, key2, val, eargp);
                    break;
                }
                if (id2.equals("out")) {
                    key2 = RubyFixnum.one(runtime);
                    PopenExecutor.checkExecRedirect(context, runtime, key2, val, eargp);
                    break;
                }
                if (id2.equals("err")) {
                    key2 = RubyFixnum.two(runtime);
                    PopenExecutor.checkExecRedirect(context, runtime, key2, val, eargp);
                    break;
                }
                if (id2.equals("uid")) {
                    // empty if block
                }
                if (id2.equals("gid")) {
                    // empty if block
                }
                return 1;
            }
            case FIXNUM: 
            case FILE: 
            case IO: 
            case ARRAY: {
                PopenExecutor.checkExecRedirect(context, runtime, key2, val, eargp);
                break;
            }
            default: {
                return 1;
            }
        }
        return 0;
    }

    static void checkExecRedirect(ThreadContext context, Ruby runtime, IRubyObject key2, IRubyObject val, ExecArg eargp) {
        switch (val.getMetaClass().getRealClass().getClassIndex()) {
            case SYMBOL: {
                String id2 = val.toString();
                if (id2.equals("close")) {
                    IRubyObject param = context.nil;
                    eargp.fd_close = PopenExecutor.checkExecRedirect1(runtime, eargp.fd_close, key2, param);
                    break;
                }
                if (id2.equals("in")) {
                    RubyFixnum param = runtime.newFixnum(0);
                    eargp.fd_dup2 = PopenExecutor.checkExecRedirect1(runtime, eargp.fd_dup2, key2, param);
                    break;
                }
                if (id2.equals("out")) {
                    RubyFixnum param = runtime.newFixnum(1);
                    eargp.fd_dup2 = PopenExecutor.checkExecRedirect1(runtime, eargp.fd_dup2, key2, param);
                    break;
                }
                if (id2.equals("err")) {
                    RubyFixnum param = runtime.newFixnum(2);
                    eargp.fd_dup2 = PopenExecutor.checkExecRedirect1(runtime, eargp.fd_dup2, key2, param);
                    break;
                }
                throw runtime.newArgumentError("wrong exec redirect symbol: " + id2);
            }
            case FILE: 
            case IO: {
                val = PopenExecutor.checkExecRedirectFd(runtime, val, false);
            }
            case FIXNUM: {
                IRubyObject param = val;
                eargp.fd_dup2 = PopenExecutor.checkExecRedirect1(runtime, eargp.fd_dup2, key2, param);
                break;
            }
            case ARRAY: {
                IRubyObject path2 = ((RubyArray)val).eltOk(0L);
                if (((RubyArray)val).size() == 2 && path2 instanceof RubySymbol && path2.toString().equals("child")) {
                    IRubyObject param = PopenExecutor.checkExecRedirectFd(runtime, ((RubyArray)val).eltOk(1L), false);
                    eargp.fd_dup2_child = PopenExecutor.checkExecRedirect1(runtime, eargp.fd_dup2_child, key2, param);
                    break;
                }
                path2 = RubyFile.get_path(context, path2);
                IRubyObject flags2 = ((RubyArray)val).eltOk(1L);
                int intFlags = flags2.isNil() ? OpenFlags.O_RDONLY.intValue() : (flags2 instanceof RubyString ? OpenFile.ioModestrOflags(runtime, flags2.toString()) : flags2.convertToInteger().getIntValue());
                flags2 = runtime.newFixnum(intFlags);
                IRubyObject perm = ((RubyArray)val).eltOk(2L);
                perm = perm.isNil() ? runtime.newFixnum(420) : perm.convertToInteger();
                RubyArray param = runtime.newArray(((RubyString)path2).strDup(runtime).export(context), flags2, perm);
                eargp.fd_open = PopenExecutor.checkExecRedirect1(runtime, eargp.fd_open, key2, param);
                break;
            }
            case STRING: {
                IRubyObject path2 = val;
                path2 = RubyFile.get_path(context, path2);
                if (key2 instanceof RubyIO) {
                    key2 = PopenExecutor.checkExecRedirectFd(runtime, key2, true);
                }
                RubyFixnum flags3 = key2 instanceof RubyFixnum && (((RubyFixnum)key2).getIntValue() == 1 || ((RubyFixnum)key2).getIntValue() == 2) ? runtime.newFixnum(OpenFlags.O_WRONLY.intValue() | OpenFlags.O_CREAT.intValue() | OpenFlags.O_TRUNC.intValue()) : runtime.newFixnum(OpenFlags.O_RDONLY.intValue());
                RubyFixnum perm = runtime.newFixnum(420);
                RubyArray param = runtime.newArray(((RubyString)path2).strDup(runtime).export(context), flags3, perm);
                eargp.fd_open = PopenExecutor.checkExecRedirect1(runtime, eargp.fd_open, key2, param);
                break;
            }
            default: {
                IRubyObject tmp = val;
                val = TypeConverter.ioCheckIO(runtime, tmp);
                if (!val.isNil()) {
                    IRubyObject param = val = PopenExecutor.checkExecRedirectFd(runtime, val, false);
                    eargp.fd_dup2 = PopenExecutor.checkExecRedirect1(runtime, eargp.fd_dup2, key2, param);
                }
                throw runtime.newArgumentError("wrong exec redirect action");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static IRubyObject checkExecRedirectFd(Ruby runtime, IRubyObject v, boolean iskey) {
        int fd;
        if (v instanceof RubyFixnum) {
            fd = RubyNumeric.fix2int(v);
        } else if (v instanceof RubySymbol) {
            String id2 = v.toString();
            if (id2.equals("in")) {
                fd = 0;
            } else if (id2.equals("out")) {
                fd = 1;
            } else {
                if (!id2.equals("err")) throw runtime.newArgumentError("wrong exec redirect");
                fd = 2;
            }
        } else {
            IRubyObject tmp = TypeConverter.convertToTypeWithCheck(v, runtime.getIO(), "to_io");
            if (tmp.isNil()) throw runtime.newArgumentError("wrong exec redirect");
            OpenFile fptr = ((RubyIO)tmp).getOpenFileChecked();
            if (fptr.tiedIOForWriting != null) {
                throw runtime.newArgumentError("duplex IO redirection");
            }
            fd = fptr.fd().bestFileno();
        }
        if (fd < 0) {
            throw runtime.newArgumentError("negative file descriptor");
        }
        if (!Platform.IS_WINDOWS || fd < 3 || !iskey) return runtime.newFixnum(fd);
        throw runtime.newArgumentError("wrong file descriptor (" + fd + ")");
    }

    static IRubyObject checkExecRedirect1(Ruby runtime, IRubyObject ary, IRubyObject key2, IRubyObject param) {
        if (ary == null) {
            ary = runtime.newArray();
        }
        if (!(key2 instanceof RubyArray)) {
            IRubyObject fd = PopenExecutor.checkExecRedirectFd(runtime, key2, !param.isNil());
            ((RubyArray)ary).push(runtime.newArray(fd, param));
        } else {
            int n = 0;
            for (int i2 = 0; i2 < ((RubyArray)key2).size(); ++i2) {
                IRubyObject v = ((RubyArray)key2).eltOk(i2);
                IRubyObject fd = PopenExecutor.checkExecRedirectFd(runtime, v, !param.isNil());
                ((RubyArray)ary).push(runtime.newArray(fd, param));
                ++n;
            }
        }
        return ary;
    }

    public static ExecArg execargNew(ThreadContext context, IRubyObject[] argv, boolean accept_shell) {
        ExecArg eargp = new ExecArg();
        PopenExecutor.execargInit(context, argv, accept_shell, eargp);
        return eargp;
    }

    private static RubyString execargInit(ThreadContext context, IRubyObject[] argv, boolean accept_shell, ExecArg eargp) {
        IRubyObject[] env_opt = new IRubyObject[]{context.nil, context.nil};
        IRubyObject[][] argv_p = new IRubyObject[][]{argv};
        RubyString prog = PopenExecutor.execGetargs(context, argv_p, accept_shell, env_opt);
        PopenExecutor.execFillarg(context, prog, argv_p[0], env_opt[0], env_opt[1], eargp);
        RubyString ret = eargp.use_shell ? eargp.command_name : eargp.command_name;
        return ret;
    }

    private static RubyString execGetargs(ThreadContext context, IRubyObject[][] argv_p, boolean accept_shell, IRubyObject[] env_opt) {
        IRubyObject hash2;
        Ruby runtime = context.runtime;
        int beg = 0;
        int end2 = argv_p[0].length;
        if (end2 >= 1 && !(hash2 = TypeConverter.checkHashType(runtime, argv_p[0][end2 - 1])).isNil()) {
            env_opt[1] = hash2;
            --end2;
        }
        if (end2 >= 1 && !(hash2 = TypeConverter.checkHashType(runtime, argv_p[0][0])).isNil()) {
            env_opt[0] = hash2;
            ++beg;
        }
        argv_p[0] = Arrays.copyOfRange(argv_p[0], beg, end2);
        RubyString prog = PopenExecutor.checkArgv(context, argv_p[0]);
        if (prog == null) {
            prog = (RubyString)argv_p[0][0];
            if (accept_shell && end2 - beg == 1) {
                argv_p[0] = IRubyObject.NULL_ARRAY;
            }
        }
        return prog;
    }

    public static RubyString checkArgv(ThreadContext context, IRubyObject[] argv) {
        Ruby runtime = context.runtime;
        Arity.checkArgumentCount(runtime, argv, 1, Integer.MAX_VALUE);
        RubyString prog = null;
        IRubyObject tmp = TypeConverter.checkArrayType(runtime, argv[0]);
        if (!tmp.isNil()) {
            if (((RubyArray)tmp).size() != 2) {
                throw runtime.newArgumentError("wrong first argument");
            }
            prog = ((RubyArray)tmp).eltOk(0L).convertToString();
            argv[0] = ((RubyArray)tmp).eltOk(1L);
            StringSupport.checkEmbeddedNulls(runtime, prog);
            prog = prog.strDup(runtime);
            prog.setFrozen(true);
        }
        for (int i2 = 0; i2 < argv.length; ++i2) {
            argv[i2] = argv[i2].convertToString();
            argv[i2] = ((RubyString)argv[i2]).newFrozen();
            StringSupport.checkEmbeddedNulls(runtime, argv[i2]);
        }
        return prog;
    }

    private static void execFillarg(ThreadContext context, RubyString prog, IRubyObject[] argv, IRubyObject env, IRubyObject opthash, ExecArg eargp) {
        Ruby runtime = context.runtime;
        int argc = argv.length;
        if (!opthash.isNil()) {
            PopenExecutor.checkExecOptions(context, runtime, (RubyHash)opthash, eargp);
        }
        if (!runtime.getCurrentDirectory().equals(runtime.getPosix().getcwd()) && !eargp.chdir_given()) {
            eargp.chdir_given_set();
            eargp.chdir_dir = runtime.getCurrentDirectory();
        }
        if (eargp.chdir_given() && argc > 1) {
            RubyArray array = RubyArray.newArrayNoCopy(runtime, argv);
            prog = (RubyString)array.join(context, RubyString.newString(runtime, " "));
        }
        if (!env.isNil()) {
            eargp.env_modification = PopenExecutor.checkExecEnv(context, (RubyHash)env);
        }
        prog = prog.export(context);
        eargp.use_shell = argc == 0 || eargp.chdir_given();
        eargp.command_name = eargp.use_shell ? prog : prog;
        if (!Platform.IS_WINDOWS && eargp.use_shell) {
            int p2;
            ByteList first2 = new ByteList(DUMMY_ARRAY, false);
            boolean has_meta = false;
            ByteList progByteList = prog.getByteList();
            byte[] pBytes = progByteList.unsafeBytes();
            for (p2 = 0; p2 < progByteList.length(); ++p2) {
                if (progByteList.get(p2) == 32 || progByteList.get(p2) == 9) {
                    if (first2.unsafeBytes() != DUMMY_ARRAY && first2.length() == 0) {
                        first2.setRealSize(p2 - first2.begin());
                    }
                } else if (first2.unsafeBytes() == DUMMY_ARRAY) {
                    first2.setUnsafeBytes(pBytes);
                    first2.setBegin(p2 + progByteList.begin());
                }
                if (!has_meta && "*?{}[]<>()~&|\\$;'`\"\n#".indexOf(progByteList.get(p2) & 0xFF) != -1) {
                    has_meta = true;
                }
                if (first2.length() == 0) {
                    if (progByteList.get(p2) == 61) {
                        has_meta = true;
                    } else if (progByteList.get(p2) == 47) {
                        first2.setRealSize(256);
                    }
                }
                if (has_meta) break;
            }
            if (!has_meta && first2.getUnsafeBytes() != DUMMY_ARRAY) {
                if (first2.length() == 0) {
                    first2.setRealSize(p2 - first2.getBegin());
                }
                if (first2.length() > 0 && first2.length() <= posix_sh_cmds[0].length() && Arrays.binarySearch(posix_sh_cmds, first2.toString(), new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        int ret = o1.compareTo(o2);
                        if (ret == 0 && o1.length() > o2.length()) {
                            return -1;
                        }
                        return ret;
                    }
                }) != -1) {
                    has_meta = true;
                }
            }
            if (!has_meta && !eargp.chdir_given()) {
                eargp.use_shell = false;
            }
            if (!eargp.use_shell) {
                ArrayList<byte[]> argv_buf = new ArrayList<byte[]>();
                pBytes = prog.getByteList().unsafeBytes();
                p2 = prog.getByteList().begin();
                int pEnd = prog.getByteList().length() + p2;
                while (p2 < pEnd) {
                    while (p2 < pEnd && (pBytes[p2] == 32 || pBytes[p2] == 9)) {
                        ++p2;
                    }
                    if (p2 >= pEnd) continue;
                    int w = p2;
                    while (p2 < pEnd && pBytes[p2] != 32 && pBytes[p2] != 9) {
                        ++p2;
                    }
                    argv_buf.add(Arrays.copyOfRange(pBytes, w, p2));
                    eargp.argv_buf = argv_buf;
                }
                eargp.command_name = argv_buf.size() > 0 ? RubyString.newStringNoCopy(runtime, (byte[])argv_buf.get(0)) : RubyString.newEmptyString(runtime);
            }
        }
        if (!eargp.use_shell) {
            String abspath = PopenExecutor.dlnFindExeR(runtime, eargp.command_name.toString(), null);
            eargp.command_abspath = abspath != null ? StringSupport.checkEmbeddedNulls(runtime, RubyString.newString(runtime, abspath)) : null;
        }
        if (!eargp.use_shell && eargp.argv_buf == null) {
            ArrayList<byte[]> argv_buf = new ArrayList<byte[]>();
            for (int i2 = 0; i2 < argc; ++i2) {
                IRubyObject arg2 = argv[i2];
                RubyString argStr = StringSupport.checkEmbeddedNulls(runtime, arg2);
                argStr = argStr.export(context);
                argv_buf.add(argStr.getBytes());
            }
            eargp.argv_buf = argv_buf;
        }
        if (!eargp.use_shell) {
            ArgvStr argv_str = new ArgvStr();
            argv_str.argv = new String[eargp.argv_buf.size()];
            int i3 = 0;
            for (byte[] bytes2 : eargp.argv_buf) {
                argv_str.argv[i3++] = new String(bytes2);
            }
            eargp.argv_str = argv_str;
        }
    }

    private static String dlnFindExeR(Ruby runtime, String fname, String path2) {
        if (path2 != null) {
            throw new RuntimeException("BUG: dln_find_exe_r with path is not supported yet");
        }
        File exePath = ShellLauncher.findPathExecutable(runtime, fname);
        return exePath != null ? exePath.getAbsolutePath() : null;
    }

    public static class ExecArg {
        boolean use_shell;
        RubyString command_name;
        RubyString command_abspath;
        ArgvStr argv_str;
        List<byte[]> argv_buf;
        IRubyObject redirect_fds;
        String[] envp_str;
        List<String> envp_buf;
        run_exec_dup2_fd_pair[] dup2_tmpbuf;
        int flags;
        long pgroup_pgid = -1L;
        IRubyObject rlimit_limits;
        int umask_mask;
        int uid;
        int gid;
        IRubyObject fd_dup2;
        IRubyObject fd_close;
        IRubyObject fd_open;
        IRubyObject fd_dup2_child;
        int close_others_maxhint;
        RubyArray env_modification;
        String chdir_dir;
        List<SpawnFileAction> fileActions = new ArrayList<SpawnFileAction>();
        List<SpawnAttribute> attributes = new ArrayList<SpawnAttribute>();

        boolean pgroup_given() {
            return (this.flags & 1) != 0;
        }

        boolean umask_given() {
            return (this.flags & 2) != 0;
        }

        boolean unsetenv_others_given() {
            return (this.flags & 4) != 0;
        }

        boolean unsetenv_others_do() {
            return (this.flags & 8) != 0;
        }

        boolean close_others_given() {
            return (this.flags & 0x10) != 0;
        }

        boolean close_others_do() {
            return (this.flags & 0x20) != 0;
        }

        boolean chdir_given() {
            return (this.flags & 0x40) != 0;
        }

        boolean new_pgroup_given() {
            return (this.flags & 0x80) != 0;
        }

        boolean new_pgroup_flag() {
            return (this.flags & 0x100) != 0;
        }

        boolean uid_given() {
            return (this.flags & 0x200) != 0;
        }

        boolean gid_given() {
            return (this.flags & 0x400) != 0;
        }

        void pgroup_given_set() {
            this.flags |= 1;
        }

        void umask_given_set() {
            this.flags |= 2;
        }

        void unsetenv_others_given_set() {
            this.flags |= 4;
        }

        void unsetenv_others_do_set() {
            this.flags |= 8;
        }

        void close_others_given_set() {
            this.flags |= 0x10;
        }

        void close_others_do_set() {
            this.flags |= 0x20;
        }

        void chdir_given_set() {
            this.flags |= 0x40;
        }

        void new_pgroup_given_set() {
            this.flags |= 0x80;
        }

        void new_pgroup_flag_set() {
            this.flags |= 0x100;
        }

        void uid_given_set() {
            this.flags |= 0x200;
        }

        void gid_given_set() {
            this.flags |= 0x400;
        }

        void pgroup_given_clear() {
            this.flags &= 0xFFFFFFFE;
        }

        void umask_given_clear() {
            this.flags &= 0xFFFFFFFD;
        }

        void unsetenv_others_given_clear() {
            this.flags &= 0xFFFFFFFB;
        }

        void unsetenv_others_do_clear() {
            this.flags &= 0xFFFFFFF7;
        }

        void close_others_given_clear() {
            this.flags &= 0xFFFFFFEF;
        }

        void close_others_do_clear() {
            this.flags &= 0xFFFFFFDF;
        }

        void chdir_given_clear() {
            this.flags &= 0xFFFFFFBF;
        }

        void new_pgroup_given_clear() {
            this.flags &= 0xFFFFFF7F;
        }

        void new_pgroup_flag_clear() {
            this.flags &= 0xFFFFFEFF;
        }

        void uid_given_clear() {
            this.flags &= 0xFFFFFDFF;
        }

        void gid_given_clear() {
            this.flags &= 0xFFFFFBFF;
        }
    }

    private static class ArgvStr {
        String[] argv;

        private ArgvStr() {
        }
    }

    private static class run_exec_dup2_fd_pair {
        int oldfd;
        int newfd;
        int older_index;
        int num_newer;

        private run_exec_dup2_fd_pair() {
        }
    }

    private static class PopenArg {
        ExecArg eargp;
        int modef;

        private PopenArg() {
        }
    }
}

