/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.RubyRegexp;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultBaseInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class Match2Instr
extends ResultBaseInstr
implements FixedArityInstr {
    public Match2Instr(Variable result2, Operand receiver2, Operand arg2) {
        super(Operation.MATCH2, result2, new Operand[]{receiver2, arg2});
        assert (result2 != null) : "Match2Instr result is null";
    }

    public Operand getReceiver() {
        return this.operands[0];
    }

    public Operand getArg() {
        return this.operands[1];
    }

    @Override
    public boolean computeScopeFlags(IRScope scope) {
        scope.getFlags().add(IRFlags.USES_BACKREF_OR_LASTLINE);
        return true;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new Match2Instr((Variable)this.result.cloneForInlining(ii), this.getReceiver().cloneForInlining(ii), this.getArg().cloneForInlining(ii));
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getReceiver());
        e.encode(this.getArg());
    }

    public static Match2Instr decode(IRReaderDecoder d) {
        return new Match2Instr(d.decodeVariable(), d.decodeOperand(), d.decodeOperand());
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        RubyRegexp regexp2 = (RubyRegexp)this.getReceiver().retrieve(context, self2, currScope, currDynScope, temp);
        IRubyObject argValue = (IRubyObject)this.getArg().retrieve(context, self2, currScope, currDynScope, temp);
        return regexp2.op_match19(context, argValue);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.Match2Instr(this);
    }
}

