/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.common.RubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.invokedynamic.MethodNames;

@JRubyModule(name={"Comparable"})
public class RubyComparable {
    public static RubyModule createComparable(Ruby runtime) {
        RubyModule comparableModule = runtime.defineModule("Comparable");
        runtime.setComparable(comparableModule);
        comparableModule.defineAnnotatedMethods(RubyComparable.class);
        return comparableModule;
    }

    public static int cmpint(ThreadContext context, IRubyObject val, IRubyObject a, IRubyObject b2) {
        if (val.isNil()) {
            RubyComparable.cmperr(a, b2);
        }
        if (val instanceof RubyFixnum) {
            int asInt = RubyNumeric.fix2int((RubyFixnum)val);
            if (asInt > 0) {
                return 1;
            }
            if (asInt < 0) {
                return -1;
            }
            return 0;
        }
        if (val instanceof RubyBignum) {
            return ((RubyBignum)val).getValue().signum() == -1 ? -1 : 1;
        }
        RubyFixnum zero = RubyFixnum.zero(context.runtime);
        if (val.callMethod(context, ">", zero).isTrue()) {
            return 1;
        }
        if (val.callMethod(context, "<", zero).isTrue()) {
            return -1;
        }
        return 0;
    }

    public static IRubyObject cmperr(IRubyObject recv2, IRubyObject other) {
        IRubyObject target = other.isImmediate() || !other.isNil() && !other.isTrue() && other != recv2.getRuntime().getFalse() ? other.inspect() : other.getType();
        throw recv2.getRuntime().newArgumentError("comparison of " + recv2.getType() + " with " + target + " failed");
    }

    public static IRubyObject invcmp(final ThreadContext context, final IRubyObject recv2, final IRubyObject other) {
        Ruby runtime = context.runtime;
        IRubyObject result2 = runtime.execRecursiveOuter(new Ruby.RecursiveFunction(){

            @Override
            public IRubyObject call(IRubyObject obj, boolean recur) {
                if (recur || !other.respondsTo("<=>")) {
                    return context.runtime.getNil();
                }
                return Helpers.invokedynamic(context, other, MethodNames.OP_CMP, recv2);
            }
        }, recv2);
        if (result2.isNil()) {
            return result2;
        }
        return RubyFixnum.newFixnum(runtime, -RubyComparable.cmpint(context, result2, recv2, other));
    }

    public static IRubyObject op_equal(ThreadContext context, IRubyObject recv2, IRubyObject other) {
        return RubyComparable.op_equal19(context, recv2, other);
    }

    @JRubyMethod(name={"=="}, required=1)
    public static IRubyObject op_equal19(ThreadContext context, IRubyObject recv2, IRubyObject other) {
        return RubyComparable.callCmpMethod(context, recv2, other, context.runtime.getFalse());
    }

    private static IRubyObject callCmpMethod(ThreadContext context, IRubyObject recv2, IRubyObject other, IRubyObject returnValueOnError) {
        Ruby runtime = context.runtime;
        if (recv2 == other) {
            return runtime.getTrue();
        }
        IRubyObject savedError = runtime.getGlobalVariables().get("$!");
        try {
            IRubyObject result2 = Helpers.invokedynamic(context, recv2, MethodNames.OP_CMP, other);
            if (result2.isNil()) {
                return returnValueOnError;
            }
            return RubyBoolean.newBoolean(runtime, RubyComparable.cmpint(context, result2, recv2, other) == 0);
        }
        catch (RaiseException e) {
            if (e.getException().kind_of_p(context, runtime.getStandardError()).isTrue()) {
                RubyComparable.cmpFailed(context);
                runtime.getGlobalVariables().set("$!", savedError);
                return returnValueOnError;
            }
            throw e;
        }
    }

    private static void cmpFailed(ThreadContext context) {
        RubyWarnings warnings = context.runtime.getWarnings();
        warnings.warn("Comparable#== will no more rescue exceptions of #<=> in the next release.");
        warnings.warn("Return nil in #<=> if the comparison is inappropriate or avoid such comparison.");
    }

    @JRubyMethod(name={">"}, required=1)
    public static RubyBoolean op_gt(ThreadContext context, IRubyObject recv2, IRubyObject other) {
        IRubyObject result2 = Helpers.invokedynamic(context, recv2, MethodNames.OP_CMP, other);
        if (result2.isNil()) {
            RubyComparable.cmperr(recv2, other);
        }
        return RubyBoolean.newBoolean(context.runtime, RubyComparable.cmpint(context, result2, recv2, other) > 0);
    }

    @JRubyMethod(name={">="}, required=1)
    public static RubyBoolean op_ge(ThreadContext context, IRubyObject recv2, IRubyObject other) {
        IRubyObject result2 = Helpers.invokedynamic(context, recv2, MethodNames.OP_CMP, other);
        if (result2.isNil()) {
            RubyComparable.cmperr(recv2, other);
        }
        return RubyBoolean.newBoolean(context.runtime, RubyComparable.cmpint(context, result2, recv2, other) >= 0);
    }

    @JRubyMethod(name={"<"}, required=1)
    public static RubyBoolean op_lt(ThreadContext context, IRubyObject recv2, IRubyObject other) {
        IRubyObject result2 = Helpers.invokedynamic(context, recv2, MethodNames.OP_CMP, other);
        if (result2.isNil()) {
            RubyComparable.cmperr(recv2, other);
        }
        return RubyBoolean.newBoolean(context.runtime, RubyComparable.cmpint(context, result2, recv2, other) < 0);
    }

    @JRubyMethod(name={"<="}, required=1)
    public static RubyBoolean op_le(ThreadContext context, IRubyObject recv2, IRubyObject other) {
        IRubyObject result2 = Helpers.invokedynamic(context, recv2, MethodNames.OP_CMP, other);
        if (result2.isNil()) {
            RubyComparable.cmperr(recv2, other);
        }
        return RubyBoolean.newBoolean(context.runtime, RubyComparable.cmpint(context, result2, recv2, other) <= 0);
    }

    @JRubyMethod(name={"between?"}, required=2)
    public static RubyBoolean between_p(ThreadContext context, IRubyObject recv2, IRubyObject first2, IRubyObject second) {
        return context.runtime.newBoolean(RubyComparable.op_lt(context, recv2, first2).isFalse() && RubyComparable.op_gt(context, recv2, second).isFalse());
    }
}

