/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyKernel;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"Binding"})
public class RubyBinding
extends RubyObject {
    private Binding binding;
    private static ObjectAllocator BINDING_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            RubyBinding instance = new RubyBinding(runtime, klass);
            return instance;
        }
    };

    public RubyBinding(Ruby runtime, RubyClass rubyClass, Binding binding2) {
        super(runtime, rubyClass);
        this.binding = binding2;
    }

    private RubyBinding(Ruby runtime, RubyClass rubyClass) {
        super(runtime, rubyClass);
    }

    public static RubyClass createBindingClass(Ruby runtime) {
        RubyClass bindingClass = runtime.defineClass("Binding", runtime.getObject(), BINDING_ALLOCATOR);
        runtime.setBinding(bindingClass);
        bindingClass.setClassIndex(ClassIndex.BINDING);
        bindingClass.setReifiedClass(RubyBinding.class);
        bindingClass.defineAnnotatedMethods(RubyBinding.class);
        bindingClass.getSingletonClass().undefineMethod("new");
        return bindingClass;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public static RubyBinding newBinding(Ruby runtime, Binding binding2) {
        return new RubyBinding(runtime, runtime.getBinding(), binding2);
    }

    @Deprecated
    public static RubyBinding newBinding(Ruby runtime) {
        return RubyBinding.newBinding(runtime, runtime.getCurrentContext().currentBinding());
    }

    @Deprecated
    public static RubyBinding newBinding(Ruby runtime, IRubyObject self2) {
        return RubyBinding.newBinding(runtime, runtime.getCurrentContext().currentBinding(self2));
    }

    @Override
    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context) {
        this.binding = context.currentBinding();
        return this;
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject other) {
        RubyBinding otherBinding = (RubyBinding)other;
        this.binding = otherBinding.binding.clone();
        return this;
    }

    @JRubyMethod(name={"eval"}, required=1, optional=2)
    public IRubyObject eval(ThreadContext context, IRubyObject[] args2) {
        IRubyObject[] newArgs = new IRubyObject[args2.length + 1];
        newArgs[0] = args2[0];
        newArgs[1] = this;
        if (args2.length > 1) {
            newArgs[2] = args2[1];
            if (args2.length > 2) {
                newArgs[3] = args2[2];
            }
        }
        return RubyKernel.eval(context, this, newArgs, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"receiver"})
    public IRubyObject receiver(ThreadContext context) {
        return this.binding.getSelf();
    }
}

