/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.util.Arrays;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.DataType;
import org.jruby.util.ByteList;

public class TypeConverter {
    private static final List<String> IMPLICIT_CONVERSIONS = Arrays.asList("to_int", "to_ary", "to_str", "to_sym", "to_hash", "to_proc", "to_io");

    public static IRubyObject convertToType(IRubyObject obj, RubyClass target, String convertMethod, boolean raise2) {
        if (!obj.respondsTo(convertMethod)) {
            if (IMPLICIT_CONVERSIONS.contains(convertMethod)) {
                return TypeConverter.handleImplicitlyUncoercibleObject(raise2, obj, target);
            }
            return TypeConverter.handleUncoercibleObject(raise2, obj, target);
        }
        return obj.callMethod(obj.getRuntime().getCurrentContext(), convertMethod);
    }

    public static IRubyObject convertToType19(IRubyObject obj, RubyClass target, String convertMethod, boolean raise2) {
        IRubyObject r = obj.checkCallMethod(obj.getRuntime().getCurrentContext(), convertMethod);
        return r == null ? TypeConverter.handleUncoercibleObject(raise2, obj, target) : r;
    }

    public static IRubyObject convertToType(IRubyObject obj, RubyClass target, String convertMethod) {
        if (target.isInstance(obj)) {
            return obj;
        }
        IRubyObject val = TypeConverter.convertToType(obj, target, convertMethod, true);
        if (!target.isInstance(val)) {
            throw obj.getRuntime().newTypeError(obj.getMetaClass() + "#" + convertMethod + " should return " + target.getName());
        }
        return val;
    }

    public static IRubyObject convertToType19(IRubyObject obj, RubyClass target, String convertMethod) {
        if (target.isInstance(obj)) {
            return obj;
        }
        IRubyObject val = TypeConverter.convertToType19(obj, target, convertMethod, true);
        if (!target.isInstance(val)) {
            String cname = obj.getMetaClass().toString();
            throw obj.getRuntime().newTypeError("can't convert " + cname + " to " + target.getName() + " (" + cname + "#" + convertMethod + " gives " + val.getMetaClass() + ")");
        }
        return val;
    }

    public static RubyNumeric toFloat(Ruby runtime, IRubyObject obj) {
        RubyClass floatClass = runtime.getFloat();
        if (floatClass.isInstance(obj)) {
            return (RubyNumeric)obj;
        }
        if (!runtime.getNumeric().isInstance(obj)) {
            throw runtime.newTypeError(obj, "Float");
        }
        return (RubyNumeric)TypeConverter.convertToType19(obj, floatClass, "to_f", true);
    }

    public static IRubyObject checkData(IRubyObject obj) {
        if (obj instanceof DataType) {
            return obj;
        }
        throw obj.getRuntime().newTypeError("wrong argument type " + TypeConverter.typeAsString(obj) + " (expected Data)");
    }

    private static String typeAsString(IRubyObject obj) {
        if (obj.isNil()) {
            return "nil";
        }
        if (obj instanceof RubyBoolean) {
            return obj.isTrue() ? "true" : "false";
        }
        return obj.getMetaClass().getRealClass().getName();
    }

    public static String convertToIdentifier(IRubyObject obj) {
        if (obj instanceof RubyString) {
            return new String(ByteList.plain(((RubyString)obj).getByteList()), RubyEncoding.ISO).intern();
        }
        return obj.asJavaString().intern();
    }

    public static IRubyObject convertToTypeWithCheck(IRubyObject obj, RubyClass target, String convertMethod) {
        if (target.isInstance(obj)) {
            return obj;
        }
        IRubyObject val = TypeConverter.convertToType(obj, target, convertMethod, false);
        if (val.isNil()) {
            return val;
        }
        if (!target.isInstance(val)) {
            throw obj.getRuntime().newTypeError(obj.getMetaClass() + "#" + convertMethod + " should return " + target.getName());
        }
        return val;
    }

    public static IRubyObject convertToTypeWithCheck19(IRubyObject obj, RubyClass target, String convertMethod) {
        if (target.isInstance(obj)) {
            return obj;
        }
        IRubyObject val = TypeConverter.convertToType19(obj, target, convertMethod, false);
        if (val.isNil()) {
            return val;
        }
        if (!target.isInstance(val)) {
            String cname = obj.getMetaClass().getName();
            throw obj.getRuntime().newTypeError("can't convert " + cname + " to " + target.getName() + " (" + cname + "#" + convertMethod + " gives " + val.getMetaClass().getName() + ")");
        }
        return val;
    }

    public static IRubyObject convertToTypeOrRaise(IRubyObject obj, RubyClass target, String convertMethod) {
        if (target.isInstance(obj)) {
            return obj;
        }
        IRubyObject val = TypeConverter.convertToType(obj, target, convertMethod, true);
        if (val.isNil()) {
            return val;
        }
        if (!target.isInstance(val)) {
            throw obj.getRuntime().newTypeError(obj.getMetaClass() + "#" + convertMethod + " should return " + target.getName());
        }
        return val;
    }

    public static IRubyObject checkIntegerType(Ruby runtime, IRubyObject obj, String method) {
        if (obj instanceof RubyFixnum) {
            return obj;
        }
        IRubyObject conv = TypeConverter.convertToType(obj, runtime.getInteger(), method, false);
        return conv instanceof RubyInteger ? conv : runtime.getNil();
    }

    public static IRubyObject checkFloatType(Ruby runtime, IRubyObject obj) {
        if (obj instanceof RubyFloat) {
            return obj;
        }
        if (!(obj instanceof RubyNumeric)) {
            return runtime.getNil();
        }
        return TypeConverter.convertToTypeWithCheck(obj, runtime.getFloat(), "to_f");
    }

    public static IRubyObject checkHashType(Ruby runtime, IRubyObject obj) {
        if (obj instanceof RubyHash) {
            return obj;
        }
        return TypeConverter.convertToTypeWithCheck(obj, runtime.getHash(), "to_hash");
    }

    public static IRubyObject checkStringType(Ruby runtime, IRubyObject obj) {
        if (obj instanceof RubyString) {
            return obj;
        }
        return TypeConverter.convertToTypeWithCheck(obj, runtime.getString(), "to_str");
    }

    public static IRubyObject checkArrayType(Ruby runtime, IRubyObject obj) {
        if (obj instanceof RubyArray) {
            return obj;
        }
        return TypeConverter.convertToTypeWithCheck(obj, runtime.getArray(), "to_ary");
    }

    public static IRubyObject ioCheckIO(Ruby runtime, IRubyObject obj) {
        if (obj instanceof RubyIO) {
            return obj;
        }
        return TypeConverter.convertToTypeWithCheck(obj, runtime.getIO(), "to_io");
    }

    public static RubyIO ioGetIO(Ruby runtime, IRubyObject obj) {
        return (RubyIO)TypeConverter.convertToType(obj, runtime.getIO(), "to_io");
    }

    public static IRubyObject checkArrayType(IRubyObject self2) {
        return TypeConverter.convertToTypeWithCheck19(self2, self2.getRuntime().getArray(), "to_ary");
    }

    public static IRubyObject handleUncoercibleObject(boolean raise2, IRubyObject obj, RubyClass target) throws RaiseException {
        if (raise2) {
            throw obj.getRuntime().newTypeError("can't convert " + TypeConverter.typeAsString(obj) + " into " + target);
        }
        return obj.getRuntime().getNil();
    }

    public static IRubyObject handleImplicitlyUncoercibleObject(boolean raise2, IRubyObject obj, RubyClass target) throws RaiseException {
        if (raise2) {
            throw obj.getRuntime().newTypeError("no implicit conversion of " + TypeConverter.typeAsString(obj) + " into " + target);
        }
        return obj.getRuntime().getNil();
    }

    public static void checkType(ThreadContext context, IRubyObject x, RubyModule t) {
        if (x == RubyBasicObject.UNDEF) {
            throw context.runtime.newRuntimeError("bug: undef leaked to the Ruby space");
        }
        ClassIndex xt = x.getMetaClass().getNativeClassIndex();
        if (xt != t.getClassIndex()) {
            String tname = t.getBaseName();
            if (tname != null) {
                throw context.runtime.newArgumentError("wrong argument type " + (Object)((Object)xt) + " (expected " + (Object)((Object)t.getClassIndex()));
            }
            throw context.runtime.newRuntimeError("bug: unknown type " + (Object)((Object)t.getClassIndex()) + " (" + (Object)((Object)xt) + " given)");
        }
    }

    public static IRubyObject convertToInteger(ThreadContext context, IRubyObject val, int base) {
        IRubyObject tmp;
        Ruby runtime;
        block11: {
            runtime = context.runtime;
            do {
                if (val instanceof RubyFloat) {
                    double value2;
                    if (base != 0) {
                        TypeConverter.raiseIntegerBaseError(context);
                    }
                    if ((value2 = ((RubyFloat)val).getValue()) <= 9.223372036854776E18 || value2 >= -9.223372036854776E18) {
                        return RubyNumeric.dbl2num(context.runtime, value2);
                    }
                } else {
                    if (val instanceof RubyFixnum || val instanceof RubyBignum) {
                        if (base != 0) {
                            TypeConverter.raiseIntegerBaseError(context);
                        }
                        return val;
                    }
                    if (val instanceof RubyString) {
                        return RubyNumeric.str2inum(context.runtime, (RubyString)val, base, true);
                    }
                    if (val instanceof RubyNil) {
                        if (base != 0) {
                            TypeConverter.raiseIntegerBaseError(context);
                        }
                        throw context.runtime.newTypeError("can't convert nil into Integer");
                    }
                }
                if (base == 0) break block11;
            } while (!(tmp = TypeConverter.checkStringType(context.runtime, val)).isNil());
            TypeConverter.raiseIntegerBaseError(context);
        }
        if ((tmp = TypeConverter.convertToType19(val, runtime.getString(), "to_int", false)).isNil()) {
            return val.convertToInteger("to_i");
        }
        return tmp;
    }

    public static RubyArray rb_Array(ThreadContext context, IRubyObject val) {
        IRubyObject tmp = TypeConverter.checkArrayType(val);
        if (tmp.isNil() && (tmp = TypeConverter.convertToTypeWithCheck19(val, context.runtime.getArray(), "to_a")).isNil()) {
            return context.runtime.newArray(val);
        }
        return (RubyArray)tmp;
    }

    public static RubyArray to_ary(ThreadContext context, IRubyObject ary) {
        return (RubyArray)TypeConverter.convertToType19(ary, context.runtime.getArray(), "to_ary");
    }

    private static void raiseIntegerBaseError(ThreadContext context) {
        throw context.runtime.newArgumentError("base specified for non string value");
    }

    @Deprecated
    public static IRubyObject convertToType(IRubyObject obj, RubyClass target, int convertMethodIndex, String convertMethod, boolean raise2) {
        if (!obj.respondsTo(convertMethod)) {
            return TypeConverter.handleUncoercibleObject(raise2, obj, target);
        }
        return obj.callMethod(obj.getRuntime().getCurrentContext(), convertMethod);
    }

    @Deprecated
    public static IRubyObject convertToType(IRubyObject obj, RubyClass target, int convertMethodIndex, String convertMethod) {
        if (target.isInstance(obj)) {
            return obj;
        }
        IRubyObject val = TypeConverter.convertToType(obj, target, convertMethod, true);
        if (!target.isInstance(val)) {
            throw obj.getRuntime().newTypeError(obj.getMetaClass() + "#" + convertMethod + " should return " + target.getName());
        }
        return val;
    }

    @Deprecated
    public static IRubyObject convertToTypeWithCheck(IRubyObject obj, RubyClass target, int convertMethodIndex, String convertMethod) {
        if (target.isInstance(obj)) {
            return obj;
        }
        IRubyObject val = TypeConverter.convertToType(obj, target, convertMethod, false);
        if (val.isNil()) {
            return val;
        }
        if (!target.isInstance(val)) {
            throw obj.getRuntime().newTypeError(obj.getMetaClass() + "#" + convertMethod + " should return " + target.getName());
        }
        return val;
    }
}

