/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.translator;

import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.Node;
import org.jruby.ast.SuperNode;
import org.jruby.ast.UnnamedRestArgNode;
import org.jruby.ast.ZSuperNode;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyRootNode;
import org.jruby.truffle.nodes.cast.ArrayCastNode;
import org.jruby.truffle.nodes.cast.ArrayCastNodeFactory;
import org.jruby.truffle.nodes.cast.BooleanCastNodeFactory;
import org.jruby.truffle.nodes.control.IfNode;
import org.jruby.truffle.nodes.control.SequenceNode;
import org.jruby.truffle.nodes.literal.ObjectLiteralNode;
import org.jruby.truffle.nodes.methods.BlockDefinitionNode;
import org.jruby.truffle.nodes.methods.CatchBreakAsProcErrorNode;
import org.jruby.truffle.nodes.methods.CatchBreakAsReturnNode;
import org.jruby.truffle.nodes.methods.CatchNextNode;
import org.jruby.truffle.nodes.methods.CatchRetryAsErrorNode;
import org.jruby.truffle.nodes.methods.CatchReturnNode;
import org.jruby.truffle.nodes.methods.CatchReturnPlaceholderNode;
import org.jruby.truffle.nodes.methods.ExceptionTranslatingNode;
import org.jruby.truffle.nodes.methods.MethodDefinitionNode;
import org.jruby.truffle.nodes.methods.RedoableNode;
import org.jruby.truffle.nodes.methods.arguments.CheckArityNode;
import org.jruby.truffle.nodes.methods.arguments.MissingArgumentBehaviour;
import org.jruby.truffle.nodes.methods.arguments.ReadPreArgumentNode;
import org.jruby.truffle.nodes.methods.arguments.ShouldDestructureNode;
import org.jruby.truffle.nodes.methods.locals.FlipFlopStateNode;
import org.jruby.truffle.nodes.methods.locals.WriteLocalVariableNode;
import org.jruby.truffle.nodes.methods.locals.WriteLocalVariableNodeFactory;
import org.jruby.truffle.nodes.respondto.RespondToNode;
import org.jruby.truffle.nodes.supercall.GeneralSuperCallNode;
import org.jruby.truffle.nodes.supercall.GeneralSuperReCallNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.methods.Arity;
import org.jruby.truffle.runtime.methods.SharedMethodInfo;
import org.jruby.truffle.translator.BehaveAsBlockNode;
import org.jruby.truffle.translator.BehaveAsProcNode;
import org.jruby.truffle.translator.BodyTranslator;
import org.jruby.truffle.translator.LoadArgumentsTranslator;
import org.jruby.truffle.translator.ParameterCollector;
import org.jruby.truffle.translator.TranslatorEnvironment;

class MethodTranslator
extends BodyTranslator {
    private boolean isBlock;

    public MethodTranslator(RubyNode currentNode, RubyContext context, BodyTranslator parent, TranslatorEnvironment environment, boolean isBlock, Source source2) {
        super(currentNode, context, parent, environment, source2, false);
        this.isBlock = isBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyNode compileFunctionNode(SourceSection sourceSection, String methodName, ArgsNode argsNode, Node bodyNode, SharedMethodInfo sharedMethodInfo) {
        RubyNode prelude;
        RubyNode body;
        if (PRINT_PARSE_TREE_METHOD_NAMES.contains(methodName)) {
            System.err.println(methodName);
            System.err.println(sharedMethodInfo.getParseTree().toString(true, 0));
        }
        ParameterCollector parameterCollector = new ParameterCollector();
        argsNode.accept(parameterCollector);
        for (String parameter : parameterCollector.getParameters()) {
            this.environment.declareVar(parameter);
        }
        Arity arity2 = MethodTranslator.getArity(argsNode);
        Arity arityForCheck = this.isBlock && argsNode.childNodes().size() == 2 && argsNode.getRestArgNode() instanceof UnnamedRestArgNode ? new Arity(arity2.getRequired(), 0, false, false) : arity2;
        if (bodyNode != null) {
            this.parentSourceSection = sourceSection;
            try {
                body = bodyNode.accept(this);
            }
            finally {
                this.parentSourceSection = null;
            }
        } else {
            body = new ObjectLiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject());
        }
        LoadArgumentsTranslator loadArgumentsTranslator = new LoadArgumentsTranslator(this.currentNode, this.context, this.source, this.isBlock, this);
        RubyNode loadArguments = argsNode.accept(loadArgumentsTranslator);
        if (this.isBlock) {
            RubyNode preludeBuilder;
            boolean shouldConsiderDestructuringArrayArg = true;
            if (argsNode.getPreCount() == 0 && argsNode.getOptionalArgsCount() == 0 && argsNode.getPostCount() == 0 && argsNode.getRestArgNode() == null) {
                shouldConsiderDestructuringArrayArg = false;
            }
            if (argsNode.getPreCount() + argsNode.getPostCount() == 1 && argsNode.getOptionalArgsCount() == 0 && argsNode.getRestArgNode() == null) {
                shouldConsiderDestructuringArrayArg = false;
            }
            if (argsNode.getPreCount() == 0 && argsNode.getRestArgNode() != null) {
                shouldConsiderDestructuringArrayArg = false;
            }
            if (shouldConsiderDestructuringArrayArg) {
                ReadPreArgumentNode readArrayNode = new ReadPreArgumentNode(this.context, sourceSection, 0, MissingArgumentBehaviour.RUNTIME_ERROR);
                ArrayCastNode castArrayNode = ArrayCastNodeFactory.create(this.context, sourceSection, readArrayNode);
                FrameSlot arraySlot = this.environment.declareVar(this.environment.allocateLocalTemp("destructure"));
                WriteLocalVariableNode writeArrayNode = WriteLocalVariableNodeFactory.create(this.context, sourceSection, arraySlot, castArrayNode);
                LoadArgumentsTranslator destructureArgumentsTranslator = new LoadArgumentsTranslator(this.currentNode, this.context, this.source, this.isBlock, this);
                destructureArgumentsTranslator.pushArraySlot(arraySlot);
                RubyNode newDestructureArguments = argsNode.accept(destructureArgumentsTranslator);
                preludeBuilder = new BehaveAsBlockNode(this.context, sourceSection, new IfNode(this.context, sourceSection, BooleanCastNodeFactory.create(this.context, sourceSection, new ShouldDestructureNode(this.context, sourceSection, arity2, new RespondToNode(this.context, sourceSection, readArrayNode, "to_ary"))), SequenceNode.sequence(this.context, sourceSection, writeArrayNode, newDestructureArguments), NodeUtil.cloneNode(loadArguments)), NodeUtil.cloneNode(loadArguments));
            } else {
                preludeBuilder = loadArguments;
            }
            prelude = SequenceNode.sequence(this.context, sourceSection, new BehaveAsBlockNode(this.context, sourceSection, new ObjectLiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject()), new CheckArityNode(this.context, sourceSection, arityForCheck, parameterCollector.getKeywords(), argsNode.getKeyRest() != null)), preludeBuilder);
        } else {
            prelude = SequenceNode.sequence(this.context, sourceSection, new CheckArityNode(this.context, sourceSection, arityForCheck, parameterCollector.getKeywords(), argsNode.getKeyRest() != null), loadArguments);
        }
        body = SequenceNode.sequence(this.context, sourceSection, prelude, body);
        if (this.environment.getFlipFlopStates().size() > 0) {
            body = SequenceNode.sequence(this.context, sourceSection, this.initFlipFlopStates(sourceSection), body);
        }
        if (this.isBlock) {
            body = new RedoableNode(this.context, sourceSection, body);
            body = new CatchReturnPlaceholderNode(this.context, sourceSection, body, this.environment.getReturnID());
            body = new BehaveAsProcNode(this.context, sourceSection, new CatchBreakAsProcErrorNode(this.context, sourceSection, body), NodeUtil.cloneNode(body));
        } else {
            body = new CatchBreakAsReturnNode(this.context, sourceSection, body);
            body = new CatchReturnNode(this.context, sourceSection, body, this.environment.getReturnID());
        }
        body = new CatchNextNode(this.context, sourceSection, body);
        body = new CatchRetryAsErrorNode(this.context, sourceSection, body);
        if (!this.isBlock) {
            body = new ExceptionTranslatingNode(this.context, sourceSection, body);
        }
        RubyRootNode rootNode = new RubyRootNode(this.context, sourceSection, this.environment.getFrameDescriptor(), this.environment.getSharedMethodInfo(), body);
        if (PRINT_AST_METHOD_NAMES.contains(methodName)) {
            System.err.println(methodName);
            NodeUtil.printCompactTree(System.err, rootNode);
        }
        if (PRINT_FULL_AST_METHOD_NAMES.contains(methodName)) {
            System.err.println(methodName);
            NodeUtil.printTree(System.err, (com.oracle.truffle.api.nodes.Node)rootNode);
        }
        if (this.isBlock) {
            RubyRootNode newRootNodeForBlocks = rootNode.cloneRubyRootNode();
            for (BehaveAsBlockNode behaveAsBlockNode : NodeUtil.findAllNodeInstances(newRootNodeForBlocks, BehaveAsBlockNode.class)) {
                behaveAsBlockNode.replace(behaveAsBlockNode.getAsBlock());
            }
            for (BehaveAsProcNode behaveAsProcNode : NodeUtil.findAllNodeInstances(newRootNodeForBlocks, BehaveAsProcNode.class)) {
                behaveAsProcNode.replace(behaveAsProcNode.getNotAsProc());
            }
            RubyRootNode newRootNodeForProcs = rootNode.cloneRubyRootNode();
            for (BehaveAsBlockNode behaveAsBlockNode : NodeUtil.findAllNodeInstances(newRootNodeForProcs, BehaveAsBlockNode.class)) {
                behaveAsBlockNode.replace(behaveAsBlockNode.getAsBlock());
            }
            for (BehaveAsProcNode behaveAsProcNode : NodeUtil.findAllNodeInstances(newRootNodeForProcs, BehaveAsProcNode.class)) {
                behaveAsProcNode.replace(behaveAsProcNode.getAsProc());
            }
            RootCallTarget callTargetAsProc = Truffle.getRuntime().createCallTarget(newRootNodeForProcs);
            RootCallTarget callTargetAsBlock = Truffle.getRuntime().createCallTarget(newRootNodeForBlocks);
            RubyRootNode newRootNodeForMethods = rootNode.cloneRubyRootNode();
            for (BehaveAsBlockNode behaveAsBlockNode : NodeUtil.findAllNodeInstances(newRootNodeForMethods, BehaveAsBlockNode.class)) {
                behaveAsBlockNode.replace(behaveAsBlockNode.getNotAsBlock());
            }
            for (BehaveAsProcNode behaveAsProcNode : NodeUtil.findAllNodeInstances(newRootNodeForMethods, BehaveAsProcNode.class)) {
                behaveAsProcNode.replace(behaveAsProcNode.getNotAsProc());
            }
            RubyRootNode newRootNodeWithCatchReturn = new RubyRootNode(this.context, newRootNodeForMethods.getSourceSection(), newRootNodeForMethods.getFrameDescriptor(), newRootNodeForMethods.getSharedMethodInfo(), new CatchBreakAsReturnNode(this.context, sourceSection, new CatchReturnNode(this.context, newRootNodeForMethods.getSourceSection(), newRootNodeForMethods.getBody(), this.getEnvironment().getReturnID())));
            RootCallTarget callTargetAsMethod = Truffle.getRuntime().createCallTarget(newRootNodeWithCatchReturn);
            return new BlockDefinitionNode(this.context, sourceSection, this.environment.getSharedMethodInfo(), this.environment.needsDeclarationFrame(), callTargetAsBlock, callTargetAsProc, callTargetAsMethod);
        }
        return new MethodDefinitionNode(this.context, sourceSection, methodName, this.environment.getSharedMethodInfo(), this.environment.needsDeclarationFrame(), Truffle.getRuntime().createCallTarget(rootNode));
    }

    private static Arity getArity(ArgsNode argsNode) {
        int minimum = argsNode.getRequiredArgsCount();
        int maximum = argsNode.getMaxArgumentsCount();
        return new Arity(minimum, argsNode.getOptionalArgsCount(), maximum == -1, argsNode.hasKwargs());
    }

    @Override
    public RubyNode visitSuperNode(SuperNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        BodyTranslator.ArgumentsAndBlockTranslation argumentsAndBlock = this.translateArgumentsAndBlock(sourceSection, node.getIterNode(), node.getArgsNode(), null, this.environment.getNamedMethodName());
        return new GeneralSuperCallNode(this.context, sourceSection, argumentsAndBlock.getBlock(), argumentsAndBlock.getArguments(), argumentsAndBlock.isSplatted());
    }

    @Override
    public RubyNode visitZSuperNode(ZSuperNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        if (this.environment.isBlock()) {
            this.environment.setNeedsDeclarationFrame();
        }
        return new GeneralSuperReCallNode(this.context, sourceSection, this.environment.isBlock());
    }

    @Override
    protected FlipFlopStateNode createFlipFlopState(SourceSection sourceSection, int depth) {
        if (this.isBlock) {
            this.environment.setNeedsDeclarationFrame();
            return this.parent.createFlipFlopState(sourceSection, depth + 1);
        }
        return super.createFlipFlopState(sourceSection, depth);
    }
}

