/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.subsystems;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.frame.FrameSlot;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyThread;
import org.jruby.truffle.runtime.util.Consumer;

public class ObjectSpaceManager {
    private final RubyContext context;
    private final Map<RubyBasicObject, FinalizerReference> finalizerReferences = new WeakHashMap<RubyBasicObject, FinalizerReference>();
    private final ReferenceQueue<RubyBasicObject> finalizerQueue = new ReferenceQueue();
    private RubyThread finalizerThread;
    private Thread finalizerJavaThread;
    private boolean stop;
    private CountDownLatch finished = new CountDownLatch(1);
    private Map<Long, RubyBasicObject> liveObjects;
    private ObjectGraphVisitor visitor;

    public ObjectSpaceManager(RubyContext context) {
        this.context = context;
    }

    public void defineFinalizer(RubyBasicObject object, RubyProc proc) {
        RubyNode.notDesignedForCompilation();
        FinalizerReference finalizerReference = this.finalizerReferences.get(object);
        if (finalizerReference == null) {
            finalizerReference = new FinalizerReference(object, this.finalizerQueue);
            this.finalizerReferences.put(object, finalizerReference);
        }
        finalizerReference.addFinalizer(proc);
        if (this.finalizerThread == null) {
            this.finalizerThread = new RubyThread(this.context.getCoreLibrary().getThreadClass(), this.context.getThreadManager());
            this.finalizerThread.initialize(this.context, null, new Runnable(){

                @Override
                public void run() {
                    ObjectSpaceManager.this.runFinalizers();
                }
            });
        }
    }

    public void undefineFinalizer(RubyBasicObject object) {
        RubyNode.notDesignedForCompilation();
        FinalizerReference finalizerReference = this.finalizerReferences.get(object);
        if (finalizerReference != null) {
            finalizerReference.clearFinalizers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runFinalizers() {
        while (true) {
            FinalizerReference finalizerReference;
            if ((finalizerReference = (FinalizerReference)this.finalizerQueue.poll()) != null) {
                ObjectSpaceManager.runFinalizers(finalizerReference);
                continue;
            }
            if (this.stop) break;
            RubyThread runningThread = this.context.getThreadManager().leaveGlobalLock();
            this.finalizerJavaThread = Thread.currentThread();
            try {
                finalizerReference = (FinalizerReference)this.finalizerQueue.remove();
            }
            catch (InterruptedException e) {}
            continue;
            finally {
                this.context.getThreadManager().enterGlobalLock(runningThread);
                continue;
            }
            ObjectSpaceManager.runFinalizers(finalizerReference);
        }
        this.finished.countDown();
    }

    private static void runFinalizers(FinalizerReference finalizerReference) {
        try {
            for (RubyProc proc : finalizerReference.getFinalizers()) {
                proc.rootCall(new Object[0]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        RubyNode.notDesignedForCompilation();
        this.context.getThreadManager().enterGlobalLock(this.finalizerThread);
        try {
            if (this.finalizerThread != null) {
                this.stop = true;
                if (this.finalizerJavaThread != null) {
                    this.finalizerJavaThread.interrupt();
                }
                this.context.getThreadManager().leaveGlobalLock();
                try {
                    this.finished.await();
                }
                catch (InterruptedException e) {
                }
                finally {
                    this.context.getThreadManager().enterGlobalLock(this.finalizerThread);
                }
            }
            for (FinalizerReference finalizerReference : this.finalizerReferences.values()) {
                ObjectSpaceManager.runFinalizers(finalizerReference);
            }
        }
        finally {
            this.context.getThreadManager().leaveGlobalLock();
        }
    }

    public Map<Long, RubyBasicObject> collectLiveObjects() {
        RubyNode.notDesignedForCompilation();
        this.liveObjects = new HashMap<Long, RubyBasicObject>();
        this.visitor = new ObjectGraphVisitor(){

            @Override
            public boolean visit(RubyBasicObject object) {
                return ObjectSpaceManager.this.liveObjects.put(object.getObjectID(), object) == null;
            }
        };
        this.context.getSafepointManager().pauseAllThreadsAndExecute(new Consumer<RubyThread>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accept(RubyThread currentThread) {
                Map map = ObjectSpaceManager.this.liveObjects;
                synchronized (map) {
                    ObjectSpaceManager.this.context.getCoreLibrary().getGlobalVariablesObject().visitObjectGraph(ObjectSpaceManager.this.visitor);
                    ObjectSpaceManager.this.context.getCoreLibrary().getMainObject().visitObjectGraph(ObjectSpaceManager.this.visitor);
                    ObjectSpaceManager.this.context.getCoreLibrary().getObjectClass().visitObjectGraph(ObjectSpaceManager.this.visitor);
                    ObjectSpaceManager.this.visitCallStack(ObjectSpaceManager.this.visitor);
                }
            }
        });
        return Collections.unmodifiableMap(this.liveObjects);
    }

    public void visitCallStack(final ObjectGraphVisitor visitor) {
        this.visitFrameInstance(Truffle.getRuntime().getCurrentFrame(), visitor);
        Truffle.getRuntime().iterateFrames(new FrameInstanceVisitor<Object>(){

            @Override
            public Void visitFrame(FrameInstance frameInstance) {
                ObjectSpaceManager.this.visitFrameInstance(frameInstance, visitor);
                return null;
            }
        });
    }

    public void visitFrameInstance(FrameInstance frameInstance, ObjectGraphVisitor visitor) {
        this.visitFrame(frameInstance.getFrame(FrameInstance.FrameAccess.READ_ONLY, true), visitor);
    }

    public void visitFrame(Frame frame, ObjectGraphVisitor visitor) {
        if (frame == null) {
            return;
        }
        for (FrameSlot frameSlot : frame.getFrameDescriptor().getSlots()) {
            Object value2 = frame.getValue(frameSlot);
            if (value2 instanceof Visibility || !(value2 instanceof RubyBasicObject)) continue;
            ((RubyBasicObject)value2).visitObjectGraph(visitor);
        }
    }

    public static interface ObjectGraphVisitor {
        public boolean visit(RubyBasicObject var1);
    }

    private static class FinalizerReference
    extends WeakReference<RubyBasicObject> {
        public List<RubyProc> finalizers = new LinkedList<RubyProc>();

        public FinalizerReference(RubyBasicObject object, ReferenceQueue<? super RubyBasicObject> queue) {
            super(object, queue);
        }

        public void addFinalizer(RubyProc proc) {
            this.finalizers.add(proc);
        }

        public List<RubyProc> getFinalizers() {
            return this.finalizers;
        }

        public void clearFinalizers() {
            this.finalizers = new LinkedList<RubyProc>();
        }
    }
}

