/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import java.util.concurrent.CountDownLatch;
import org.jruby.RubyThread;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.control.ReturnException;
import org.jruby.truffle.runtime.control.ThreadExitException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyException;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.subsystems.ThreadManager;

public class RubyThread
extends RubyBasicObject {
    private final ThreadManager manager;
    private final CountDownLatch finished = new CountDownLatch(1);
    private volatile Thread thread;
    private RubyThread.Status status = RubyThread.Status.RUN;
    private RubyException exception;
    private Object value;
    private RubyBasicObject threadLocals;

    public Object getValue() {
        return this.value;
    }

    public RubyException getException() {
        return this.exception;
    }

    public void shutdown() {
    }

    public RubyThread(RubyClass rubyClass, ThreadManager manager) {
        super(rubyClass);
        this.manager = manager;
        this.threadLocals = new RubyBasicObject(rubyClass.getContext().getCoreLibrary().getObjectClass());
    }

    public void initialize(RubyContext context, RubyNode currentNode, RubyProc block) {
        final RubyProc finalBlock = block;
        this.initialize(context, currentNode, new Runnable(){

            @Override
            public void run() {
                RubyThread.this.value = finalBlock.rootCall(new Object[0]);
            }
        });
    }

    public void initialize(final RubyContext context, final RubyNode currentNode, Runnable runnable) {
        final RubyThread finalThread = this;
        final Runnable finalRunnable = runnable;
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                RubyThread.this.thread = Thread.currentThread();
                finalThread.manager.registerThread(finalThread);
                finalThread.manager.enterGlobalLock(finalThread);
                context.getSafepointManager().enterThread();
                try {
                    finalRunnable.run();
                }
                catch (ThreadExitException e) {
                    return;
                }
                catch (RaiseException e) {
                    RubyThread.this.exception = e.getRubyException();
                }
                catch (ReturnException e) {
                    RubyThread.this.exception = RubyThread.this.getContext().getCoreLibrary().unexpectedReturn(currentNode);
                }
                finally {
                    finalThread.manager.leaveGlobalLock();
                    finalThread.manager.unregisterThread(finalThread);
                    finalThread.finished.countDown();
                    context.getSafepointManager().leaveThread();
                    RubyThread.this.status = RubyThread.Status.DEAD;
                    RubyThread.this.thread = null;
                }
            }
        }).start();
    }

    public void setRootThread(Thread thread2) {
        this.thread = thread2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() {
        RubyThread runningThread = this.getContext().getThreadManager().leaveGlobalLock();
        try {
            while (true) {
                try {
                    this.finished.await();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        finally {
            this.getContext().getThreadManager().enterGlobalLock(runningThread);
        }
        if (this.exception != null) {
            throw new RaiseException(this.exception);
        }
    }

    public void interrupt() {
        Thread t = this.thread;
        if (t != null) {
            t.interrupt();
        }
    }

    public RubyThread.Status getStatus() {
        return this.status;
    }

    public RubyBasicObject getThreadLocals() {
        return this.threadLocals;
    }

    public static class ThreadAllocator
    implements Allocator {
        @Override
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, RubyNode currentNode) {
            return new RubyThread(rubyClass, context.getThreadManager());
        }
    }
}

