/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.backtrace.Backtrace;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyString;

public class RubyException
extends RubyBasicObject {
    private RubyString message;
    private Backtrace backtrace;

    public RubyException(RubyClass rubyClass) {
        super(rubyClass);
        this.message = rubyClass.getContext().makeString("(object uninitialized)");
        this.backtrace = null;
    }

    public RubyException(RubyClass rubyClass, RubyString message2, Backtrace backtrace2) {
        this(rubyClass);
        this.initialize(message2, backtrace2);
    }

    public void initialize(RubyString message2, Backtrace backtrace2) {
        assert (message2 != null);
        assert (backtrace2 != null);
        this.message = message2;
        this.backtrace = backtrace2;
    }

    public RubyString getMessage() {
        return this.message;
    }

    public Backtrace getBacktrace() {
        return this.backtrace;
    }

    public RubyArray asRubyStringArray() {
        String[] lines2 = Backtrace.EXCEPTION_FORMATTER.format(this.getContext(), this, this.backtrace);
        Object[] array = new Object[lines2.length];
        for (int n = 0; n < lines2.length; ++n) {
            array[n] = this.getContext().makeString(lines2[n]);
        }
        return RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), array);
    }

    public static class ExceptionAllocator
    implements Allocator {
        @Override
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, RubyNode currentNode) {
            return new RubyException(rubyClass);
        }
    }
}

