/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.methods.arguments;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyHash;
import org.jruby.truffle.runtime.util.ArrayUtils;

public class ReadRestArgumentNode
extends RubyNode {
    private final int startIndex;
    private final int negativeEndIndex;
    private final boolean keywordArguments;
    private final BranchProfile noArgumentsLeftProfile = BranchProfile.create();
    private final BranchProfile subsetOfArgumentsProfile = BranchProfile.create();

    public ReadRestArgumentNode(RubyContext context, SourceSection sourceSection, int startIndex, int negativeEndIndex, boolean keywordArguments) {
        super(context, sourceSection);
        this.startIndex = startIndex;
        this.negativeEndIndex = negativeEndIndex;
        this.keywordArguments = keywordArguments;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object lastArgument;
        RubyClass arrayClass = this.getContext().getCoreLibrary().getArrayClass();
        int count2 = RubyArguments.getUserArgumentsCount(frame.getArguments());
        int endIndex = count2 + this.negativeEndIndex;
        if (this.keywordArguments && (lastArgument = RubyArguments.getUserArgument(frame.getArguments(), RubyArguments.getUserArgumentsCount(frame.getArguments()) - 1)) instanceof RubyHash) {
            --endIndex;
        }
        int length2 = endIndex - this.startIndex;
        if (this.startIndex == 0) {
            Object[] arguments = RubyArguments.extractUserArguments(frame.getArguments());
            return new RubyArray(arrayClass, arguments, length2);
        }
        if (this.startIndex >= endIndex) {
            this.noArgumentsLeftProfile.enter();
            return new RubyArray(arrayClass);
        }
        this.subsetOfArgumentsProfile.enter();
        Object[] arguments = RubyArguments.extractUserArguments(frame.getArguments());
        return new RubyArray(arrayClass, ArrayUtils.extractRange(arguments, this.startIndex, endIndex), length2);
    }
}

