/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.common.IRubyWarnings;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.signal.ProcSignalHandler;
import sun.misc.Signal;
import sun.misc.SignalHandler;

@CoreClass(name="Signal")
public abstract class SignalNodes {

    @CoreMethod(names={"trap"}, isModuleFunction=true, needsBlock=true, required=1, optional=1)
    public static abstract class SignalNode
    extends CoreMethodNode {
        public SignalNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SignalNode(SignalNode prev) {
            super(prev);
        }

        @Specialization
        public Object trap(RubyString signalName, UndefinedPlaceholder command, RubyProc block) {
            SignalNode.notDesignedForCompilation();
            Signal signal2 = new Signal(signalName.toString());
            ProcSignalHandler newHandler = new ProcSignalHandler(this.getContext(), block);
            SignalHandler oldHandler = Signal.handle(signal2, newHandler);
            if (oldHandler instanceof ProcSignalHandler) {
                return ((ProcSignalHandler)oldHandler).getProc();
            }
            return this.getContext().getCoreLibrary().getNilObject();
        }

        @Specialization
        public Object trap(RubyString signalName, RubyString command, UndefinedPlaceholder block) {
            SignalNode.notDesignedForCompilation();
            this.getContext().getRuntime().getWarnings().warn(IRubyWarnings.ID.TRUFFLE, Truffle.getRuntime().getCallerFrame().getCallNode().getEncapsulatingSourceSection().getSource().getName(), Truffle.getRuntime().getCallerFrame().getCallNode().getEncapsulatingSourceSection().getStartLine(), "Signal#trap with a string command not implemented yet");
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }
}

