/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.IONodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyString;

@GeneratedBy(value=IONodes.class)
public final class IONodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(OpenNodeFactory.getInstance(), ReadLinesNodeFactory.getInstance());
    }

    @GeneratedBy(value=IONodes.ReadLinesNode.class)
    public static final class ReadLinesNodeFactory
    extends NodeFactoryBase<IONodes.ReadLinesNode> {
        private static ReadLinesNodeFactory readLinesNodeFactoryInstance;

        private ReadLinesNodeFactory() {
            super(IONodes.ReadLinesNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public IONodes.ReadLinesNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ReadLinesNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static IONodes.ReadLinesNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ReadLinesUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<IONodes.ReadLinesNode> getInstance() {
            if (readLinesNodeFactoryInstance == null) {
                readLinesNodeFactoryInstance = new ReadLinesNodeFactory();
            }
            return readLinesNodeFactoryInstance;
        }

        @GeneratedBy(value=IONodes.ReadLinesNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ReadLinesPolymorphicNode
        extends ReadLinesBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ReadLinesPolymorphicNode(ReadLinesBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=IONodes.ReadLinesNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ReadLinesRubyStringNode
        extends ReadLinesBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ReadLinesRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            ReadLinesRubyStringNode(ReadLinesBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.readLines(arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.readLines(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static IONodes.ReadLinesNode create0(IONodes.ReadLinesNode current2) {
                return new ReadLinesRubyStringNode((ReadLinesBaseNode)current2);
            }
        }

        @GeneratedBy(value=IONodes.ReadLinesNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ReadLinesUninitializedNode
        extends ReadLinesBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ReadLinesUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ReadLinesUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ReadLinesUninitializedNode(ReadLinesBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ReadLinesBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ReadLinesBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0]}, arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value);
            }

            static IONodes.ReadLinesNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ReadLinesUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=IONodes.ReadLinesNode.class)
        private static abstract class ReadLinesBaseNode
        extends IONodes.ReadLinesNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ReadLinesBaseNode next0;

            ReadLinesBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ReadLinesBaseNode(ReadLinesBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ReadLinesBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ReadLinesBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ReadLinesUninitializedNode(this);
                    ((ReadLinesUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = ReadLinesBaseNode.createInfo0(reason2, arguments0Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new ReadLinesUninitializedNode(this), new ReadLinesPolymorphicNode(this), (ReadLinesBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ReadLinesBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (ReadLinesBaseNode)ReadLinesRubyStringNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ReadLinesBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ReadLinesBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=IONodes.OpenNode.class)
    public static final class OpenNodeFactory
    extends NodeFactoryBase<IONodes.OpenNode> {
        private static OpenNodeFactory openNodeFactoryInstance;

        private OpenNodeFactory() {
            super(IONodes.OpenNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public IONodes.OpenNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return OpenNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static IONodes.OpenNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return OpenUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<IONodes.OpenNode> getInstance() {
            if (openNodeFactoryInstance == null) {
                openNodeFactoryInstance = new OpenNodeFactory();
            }
            return openNodeFactoryInstance;
        }

        @GeneratedBy(value=IONodes.OpenNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class OpenPolymorphicNode
        extends OpenBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            OpenPolymorphicNode(OpenBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=IONodes.OpenNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class OpenRubyStringRubyProcNode
        extends OpenBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(OpenRubyStringRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class, RubyProc.class}, 0, 0);

            OpenRubyStringRubyProcNode(OpenBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments2Value;
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof RubyString");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyProc");
                }
                return super.open(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    RubyProc arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments2Value);
                    return super.open(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static IONodes.OpenNode create0(IONodes.OpenNode current2) {
                return new OpenRubyStringRubyProcNode((OpenBaseNode)current2);
            }
        }

        @GeneratedBy(value=IONodes.OpenNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class OpenUninitializedNode
        extends OpenBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(OpenUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            OpenUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            OpenUninitializedNode(OpenBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                OpenBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    OpenBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static IONodes.OpenNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new OpenUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=IONodes.OpenNode.class)
        private static abstract class OpenBaseNode
        extends IONodes.OpenNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected OpenBaseNode next0;

            OpenBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            OpenBaseNode(OpenBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason2) {
                String message2;
                OpenBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                OpenBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new OpenUninitializedNode(this);
                    ((OpenUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = OpenBaseNode.createInfo0(reason2, arguments0Value, arguments1Value, arguments2Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new OpenUninitializedNode(this), new OpenPolymorphicNode(this), (OpenBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final OpenBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                    return (OpenBaseNode)OpenRubyStringRubyProcNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    OpenBaseNode otherCast = (OpenBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (OpenBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }
}

