/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.ImportGuards;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.RubyRootNode;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.HashCoreMethodNode;
import org.jruby.truffle.nodes.core.HashGuards;
import org.jruby.truffle.nodes.core.YieldingCoreMethodNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.hash.FindEntryNode;
import org.jruby.truffle.nodes.yield.YieldDispatchHeadNode;
import org.jruby.truffle.runtime.DebugOperations;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyHash;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.hash.Entry;
import org.jruby.truffle.runtime.hash.HashOperations;
import org.jruby.truffle.runtime.hash.HashSearchResult;
import org.jruby.truffle.runtime.hash.KeyValue;

@CoreClass(name="Hash")
public abstract class HashNodes {

    @CoreMethod(names={"to_a"})
    public static abstract class ToArrayNode
    extends HashCoreMethodNode {
        public ToArrayNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ToArrayNode(ToArrayNode prev) {
            super(prev);
        }

        @Specialization(guards={"isNull"})
        public RubyArray toArrayNull(RubyHash hash2) {
            ToArrayNode.notDesignedForCompilation();
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), null, 0);
        }

        @Specialization(guards={"!isNull", "!isBuckets"})
        public RubyArray toArrayPackedArray(RubyHash hash2) {
            ToArrayNode.notDesignedForCompilation();
            Object[] store = (Object[])hash2.getStore();
            int size2 = hash2.getSize();
            Object[] pairs = new Object[size2];
            for (int n = 0; n < size2; ++n) {
                pairs[n] = RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), store[n * 2], store[n * 2 + 1]);
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), pairs, size2);
        }

        @Specialization(guards={"isBuckets"})
        public RubyArray toArrayBuckets(RubyHash hash2) {
            ToArrayNode.notDesignedForCompilation();
            int size2 = hash2.getSize();
            Object[] pairs = new Object[size2];
            int n = 0;
            for (KeyValue keyValue : HashOperations.verySlowToKeyValues(hash2)) {
                pairs[n] = RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), keyValue.getValue(), keyValue.getValue());
                ++n;
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), pairs, size2);
        }
    }

    @CoreMethod(names={"values"})
    public static abstract class ValuesNode
    extends HashCoreMethodNode {
        public ValuesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ValuesNode(ValuesNode prev) {
            super(prev);
        }

        @Specialization(guards={"isNull"})
        public RubyArray valuesNull(RubyHash hash2) {
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), null, 0);
        }

        @Specialization(guards={"!isNull", "!isBuckets"})
        public RubyArray valuesPackedArray(RubyHash hash2) {
            Object[] store = (Object[])hash2.getStore();
            Object[] values2 = new Object[hash2.getSize()];
            for (int n = 0; n < values2.length; ++n) {
                values2[n] = store[n * 2 + 1];
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), values2, values2.length);
        }

        @Specialization(guards={"isBuckets"})
        public RubyArray valuesBuckets(RubyHash hash2) {
            ValuesNode.notDesignedForCompilation();
            Object[] values2 = new Object[hash2.getSize()];
            int n = 0;
            for (Entry entry = hash2.getFirstInSequence(); entry != null; entry = entry.getNextInSequence()) {
                values2[n] = entry.getValue();
                ++n;
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), values2, values2.length);
        }
    }

    @CoreMethod(names={"size"})
    public static abstract class SizeNode
    extends HashCoreMethodNode {
        public SizeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SizeNode(SizeNode prev) {
            super(prev);
        }

        @Specialization(guards={"isNull"})
        public int sizeNull(RubyHash hash2) {
            return 0;
        }

        @Specialization(guards={"!isNull"})
        public int sizePackedArray(RubyHash hash2) {
            return hash2.getSize();
        }
    }

    @CoreMethod(names={"default"}, optional=1)
    public static abstract class DefaultNode
    extends HashCoreMethodNode {
        public DefaultNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public DefaultNode(DefaultNode prev) {
            super(prev);
        }

        @Specialization
        public Object defaultElement(VirtualFrame frame, RubyHash hash2, UndefinedPlaceholder undefined) {
            Object ret = hash2.getDefaultValue();
            if (ret != null) {
                return ret;
            }
            return this.getContext().getCoreLibrary().getNilObject();
        }

        @Specialization
        public Object defaultElement(VirtualFrame frame, RubyHash hash2, Object key2) {
            Object ret = hash2.getDefaultValue();
            if (ret != null) {
                return ret;
            }
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"merge"}, required=1)
    public static abstract class MergeNode
    extends HashCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode eqlNode;
        private final BranchProfile nothingFromFirstProfile = BranchProfile.create();
        private final BranchProfile considerNothingFromSecondProfile = BranchProfile.create();
        private final BranchProfile nothingFromSecondProfile = BranchProfile.create();
        private final BranchProfile considerResultIsSmallProfile = BranchProfile.create();
        private final BranchProfile resultIsSmallProfile = BranchProfile.create();
        private final int smallHashSize = HashOperations.SMALL_HASH_SIZE;

        public MergeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.eqlNode = DispatchHeadNodeFactory.createMethodCall(context, false, false, null);
        }

        public MergeNode(MergeNode prev) {
            super(prev);
            this.eqlNode = prev.eqlNode;
        }

        @Specialization(guards={"!isNull", "!isBuckets", "isNull(arguments[1])"})
        public RubyHash mergePackedArrayNull(RubyHash hash2, RubyHash other) {
            Object[] store = (Object[])hash2.getStore();
            Object[] copy = Arrays.copyOf(store, HashOperations.SMALL_HASH_SIZE * 2);
            return new RubyHash(this.getContext().getCoreLibrary().getHashClass(), hash2.getDefaultBlock(), hash2.getDefaultValue(), copy, hash2.getSize(), null);
        }

        @ExplodeLoop
        @Specialization(guards={"!isNull", "!isBuckets", "!isNull(arguments[1])", "!isBuckets(arguments[1])"})
        public RubyHash mergePackedArrayPackedArray(VirtualFrame frame, RubyHash hash2, RubyHash other) {
            Object[] storeA = (Object[])hash2.getStore();
            int storeASize = hash2.getSize();
            Object[] storeB = (Object[])other.getStore();
            int storeBSize = hash2.getSize();
            boolean[] mergeFromA = new boolean[storeASize];
            int mergeFromACount = 0;
            for (int a = 0; a < HashOperations.SMALL_HASH_SIZE; ++a) {
                if (a >= storeASize) continue;
                boolean merge2 = true;
                for (int b2 = 0; b2 < HashOperations.SMALL_HASH_SIZE; ++b2) {
                    if (b2 >= storeBSize || !this.eqlNode.callBoolean(frame, storeA[a * 2], "eql?", null, storeB[b2 * 2])) continue;
                    merge2 = false;
                    break;
                }
                if (merge2) {
                    ++mergeFromACount;
                }
                mergeFromA[a] = merge2;
            }
            if (mergeFromACount == 0) {
                this.nothingFromFirstProfile.enter();
                return new RubyHash(this.getContext().getCoreLibrary().getHashClass(), hash2.getDefaultBlock(), hash2.getDefaultValue(), Arrays.copyOf(storeB, HashOperations.SMALL_HASH_SIZE * 2), storeBSize, null);
            }
            this.considerNothingFromSecondProfile.enter();
            if (mergeFromACount == storeB.length) {
                this.nothingFromSecondProfile.enter();
                return new RubyHash(this.getContext().getCoreLibrary().getHashClass(), hash2.getDefaultBlock(), hash2.getDefaultValue(), Arrays.copyOf(storeB, HashOperations.SMALL_HASH_SIZE * 2), storeBSize, null);
            }
            this.considerResultIsSmallProfile.enter();
            int mergedSize = storeBSize + mergeFromACount;
            if (storeBSize + mergeFromACount <= this.smallHashSize) {
                int n;
                this.resultIsSmallProfile.enter();
                Object[] merged = new Object[HashOperations.SMALL_HASH_SIZE * 2];
                int index2 = 0;
                for (n = 0; n < storeASize; ++n) {
                    if (!mergeFromA[n]) continue;
                    merged[index2] = storeA[n * 2];
                    merged[index2 + 1] = storeA[n * 2 + 1];
                    index2 += 2;
                }
                for (n = 0; n < storeBSize; ++n) {
                    merged[index2] = storeB[n * 2];
                    merged[index2 + 1] = storeB[n * 2 + 1];
                    index2 += 2;
                }
                return new RubyHash(this.getContext().getCoreLibrary().getHashClass(), hash2.getDefaultBlock(), hash2.getDefaultValue(), merged, mergedSize, null);
            }
            CompilerDirectives.transferToInterpreter();
            throw new UnsupportedOperationException();
        }

        @Specialization
        public RubyHash mergeBucketsBuckets(RubyHash hash2, RubyHash other) {
            RubyHash merged = new RubyHash(this.getContext().getCoreLibrary().getHashClass(), null, null, new Entry[HashOperations.capacityGreaterThan(hash2.getSize() + other.getSize())], 0, null);
            int size2 = 0;
            for (KeyValue keyValue : HashOperations.verySlowToKeyValues(hash2)) {
                HashOperations.verySlowSetInBuckets(merged, keyValue.getKey(), keyValue.getValue());
                ++size2;
            }
            for (KeyValue keyValue : HashOperations.verySlowToKeyValues(other)) {
                if (!HashOperations.verySlowSetInBuckets(merged, keyValue.getKey(), keyValue.getValue())) continue;
                ++size2;
            }
            merged.setSize(size2);
            return merged;
        }
    }

    @CoreMethod(names={"map", "collect"}, needsBlock=true)
    @ImportGuards(value={HashGuards.class})
    public static abstract class MapNode
    extends YieldingCoreMethodNode {
        public MapNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public MapNode(MapNode prev) {
            super(prev);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExplodeLoop
        @Specialization(guards={"!isNull", "!isBuckets"})
        public RubyArray mapPackedArray(VirtualFrame frame, RubyHash hash2, RubyProc block) {
            Object[] store = (Object[])hash2.getStore();
            int size2 = hash2.getSize();
            int resultSize = store.length / 2;
            Object[] result2 = new Object[resultSize];
            int count2 = 0;
            try {
                for (int n = 0; n < HashOperations.SMALL_HASH_SIZE; ++n) {
                    if (n >= size2) continue;
                    Object key2 = store[n * 2];
                    Object value2 = store[n * 2 + 1];
                    result2[n] = this.yield(frame, block, key2, value2);
                    if (!CompilerDirectives.inInterpreter()) continue;
                    ++count2;
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    ((RubyRootNode)this.getRootNode()).reportLoopCount(count2);
                }
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), result2, resultSize);
        }

        @Specialization(guards={"isBuckets"})
        public RubyArray mapBuckets(VirtualFrame frame, RubyHash hash2, RubyProc block) {
            MapNode.notDesignedForCompilation();
            RubyArray array = new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), null, 0);
            for (KeyValue keyValue : HashOperations.verySlowToKeyValues(hash2)) {
                array.slowPush(this.yield(frame, block, keyValue.getKey(), keyValue.getValue()));
            }
            return array;
        }
    }

    @CoreMethod(names={"keys"})
    public static abstract class KeysNode
    extends HashCoreMethodNode {
        public KeysNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public KeysNode(KeysNode prev) {
            super(prev);
        }

        @Specialization(guards={"isNull"})
        public RubyArray keysNull(RubyHash hash2) {
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), null, 0);
        }

        @Specialization(guards={"!isNull", "!isBuckets"})
        public RubyArray keysPackedArray(RubyHash hash2) {
            KeysNode.notDesignedForCompilation();
            Object[] store = (Object[])hash2.getStore();
            Object[] keys2 = new Object[hash2.getSize()];
            for (int n = 0; n < keys2.length; ++n) {
                keys2[n] = store[n * 2];
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), keys2, keys2.length);
        }

        @Specialization(guards={"isBuckets"})
        public RubyArray keysBuckets(RubyHash hash2) {
            KeysNode.notDesignedForCompilation();
            Object[] keys2 = new Object[hash2.getSize()];
            int n = 0;
            for (Entry entry = hash2.getFirstInSequence(); entry != null; entry = entry.getNextInSequence()) {
                keys2[n] = entry.getKey();
                ++n;
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), keys2, keys2.length);
        }
    }

    @CoreMethod(names={"has_key?", "key?"}, required=1)
    public static abstract class KeyNode
    extends HashCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode eqlNode;

        public KeyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.eqlNode = DispatchHeadNodeFactory.createMethodCall(context, false, false, null);
        }

        public KeyNode(KeyNode prev) {
            super(prev);
            this.eqlNode = prev.eqlNode;
        }

        @Specialization(guards={"isNull"})
        public boolean keyNull(RubyHash hash2, Object key2) {
            return false;
        }

        @Specialization(guards={"!isNull", "!isBuckets"})
        public boolean keyPackedArray(VirtualFrame frame, RubyHash hash2, Object key2) {
            KeyNode.notDesignedForCompilation();
            int size2 = hash2.getSize();
            Object[] store = (Object[])hash2.getStore();
            for (int n = 0; n < store.length; n += 2) {
                if (n >= size2 || !this.eqlNode.callBoolean(frame, store[n], "eql?", null, key2)) continue;
                return true;
            }
            return false;
        }

        @Specialization(guards={"isBuckets"})
        public boolean keyBuckets(VirtualFrame frame, RubyHash hash2, Object key2) {
            KeyNode.notDesignedForCompilation();
            for (KeyValue keyValue : HashOperations.verySlowToKeyValues(hash2)) {
                if (!this.eqlNode.callBoolean(frame, keyValue.getKey(), "eql?", null, key2)) continue;
                return true;
            }
            return false;
        }
    }

    @CoreMethod(names={"inspect", "to_s"})
    public static abstract class InspectNode
    extends HashCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode inspect;

        public InspectNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.inspect = DispatchHeadNodeFactory.createMethodCall(context);
        }

        public InspectNode(InspectNode prev) {
            super(prev);
            this.inspect = prev.inspect;
        }

        @Specialization(guards={"isNull"})
        public RubyString inspectNull(RubyHash hash2) {
            InspectNode.notDesignedForCompilation();
            return this.getContext().makeString("{}");
        }

        @Specialization
        public RubyString inspectPackedArray(VirtualFrame frame, RubyHash hash2) {
            InspectNode.notDesignedForCompilation();
            StringBuilder builder = new StringBuilder();
            builder.append("{");
            for (KeyValue keyValue : HashOperations.verySlowToKeyValues(hash2)) {
                if (builder.length() > 1) {
                    builder.append(", ");
                }
                builder.append(this.inspect.call(frame, keyValue.getKey(), "inspect", null, new Object[0]));
                builder.append("=>");
                builder.append(this.inspect.call(frame, keyValue.getValue(), "inspect", null, new Object[0]));
            }
            builder.append("}");
            return this.getContext().makeString(builder.toString());
        }
    }

    @CoreMethod(names={"initialize_copy"}, visibility=Visibility.PRIVATE, required=1)
    public static abstract class InitializeCopyNode
    extends HashCoreMethodNode {
        public InitializeCopyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InitializeCopyNode(InitializeCopyNode prev) {
            super(prev);
        }

        @Specialization(guards={"isNull(arguments[1])"})
        public RubyHash dupNull(RubyHash self2, RubyHash from) {
            InitializeCopyNode.notDesignedForCompilation();
            if (self2 == from) {
                return self2;
            }
            self2.setDefaultBlock(from.getDefaultBlock());
            self2.setDefaultValue(from.getDefaultValue());
            self2.setStore(null, 0, null, null);
            return self2;
        }

        @Specialization(guards={"!isNull(arguments[1])", "!isBuckets(arguments[1])"})
        public RubyHash dupPackedArray(RubyHash self2, RubyHash from) {
            InitializeCopyNode.notDesignedForCompilation();
            if (self2 == from) {
                return self2;
            }
            Object[] store = (Object[])from.getStore();
            self2.setStore(Arrays.copyOf(store, HashOperations.SMALL_HASH_SIZE * 2), store.length, null, null);
            self2.setDefaultBlock(from.getDefaultBlock());
            self2.setDefaultValue(from.getDefaultValue());
            return self2;
        }

        @Specialization(guards={"isBuckets(arguments[1])"})
        public RubyHash dupBuckets(RubyHash self2, RubyHash from) {
            InitializeCopyNode.notDesignedForCompilation();
            if (self2 == from) {
                return self2;
            }
            HashOperations.verySlowSetKeyValues(self2, HashOperations.verySlowToKeyValues(from));
            return self2;
        }
    }

    @CoreMethod(names={"initialize"}, needsBlock=true, optional=1)
    public static abstract class InitializeNode
    extends HashCoreMethodNode {
        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InitializeNode(InitializeNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass initialize(RubyHash hash2, UndefinedPlaceholder defaultValue, UndefinedPlaceholder block) {
            InitializeNode.notDesignedForCompilation();
            hash2.setStore(null, 0, null, null);
            hash2.setDefaultBlock(null);
            return this.getContext().getCoreLibrary().getNilObject();
        }

        @Specialization
        public RubyNilClass initialize(RubyHash hash2, UndefinedPlaceholder defaultValue, RubyProc block) {
            InitializeNode.notDesignedForCompilation();
            hash2.setStore(null, 0, null, null);
            hash2.setDefaultBlock(block);
            return this.getContext().getCoreLibrary().getNilObject();
        }

        @Specialization
        public RubyNilClass initialize(RubyHash hash2, Object defaultValue, UndefinedPlaceholder block) {
            InitializeNode.notDesignedForCompilation();
            hash2.setDefaultValue(defaultValue);
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"empty?"})
    public static abstract class EmptyNode
    extends HashCoreMethodNode {
        public EmptyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EmptyNode(EmptyNode prev) {
            super(prev);
        }

        @Specialization(guards={"isNull"})
        public boolean emptyNull(RubyHash hash2) {
            return true;
        }

        @Specialization(guards={"!isNull"})
        public boolean emptyPackedArray(RubyHash hash2) {
            return hash2.getSize() == 0;
        }
    }

    @CoreMethod(names={"each", "each_pair"}, needsBlock=true)
    @ImportGuards(value={HashGuards.class})
    public static abstract class EachNode
    extends YieldingCoreMethodNode {
        public EachNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EachNode(EachNode prev) {
            super(prev);
        }

        @Specialization(guards={"isNull"})
        public RubyHash eachNull(RubyHash hash2, RubyProc block) {
            EachNode.notDesignedForCompilation();
            return hash2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExplodeLoop
        @Specialization(guards={"!isNull", "!isBuckets"})
        public RubyHash eachPackedArray(VirtualFrame frame, RubyHash hash2, RubyProc block) {
            EachNode.notDesignedForCompilation();
            Object[] store = (Object[])hash2.getStore();
            int size2 = hash2.getSize();
            int count2 = 0;
            try {
                for (int n = 0; n < HashOperations.SMALL_HASH_SIZE; ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count2;
                    }
                    if (n >= size2) continue;
                    this.yield(frame, block, RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), store[n * 2], store[n * 2 + 1]));
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    ((RubyRootNode)this.getRootNode()).reportLoopCount(count2);
                }
            }
            return hash2;
        }

        @Specialization(guards={"isBuckets"})
        public RubyHash eachBuckets(VirtualFrame frame, RubyHash hash2, RubyProc block) {
            EachNode.notDesignedForCompilation();
            for (KeyValue keyValue : HashOperations.verySlowToKeyValues(hash2)) {
                this.yield(frame, block, RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), keyValue.getKey(), keyValue.getValue()));
            }
            return hash2;
        }
    }

    @CoreMethod(names={"delete"}, required=1)
    public static abstract class DeleteNode
    extends HashCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode eqlNode;
        @Node.Child
        private FindEntryNode findEntryNode;

        public DeleteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.eqlNode = DispatchHeadNodeFactory.createMethodCall(context, false, false, null);
            this.findEntryNode = new FindEntryNode(context, sourceSection);
        }

        public DeleteNode(DeleteNode prev) {
            super(prev);
            this.eqlNode = prev.eqlNode;
            this.findEntryNode = prev.findEntryNode;
        }

        @Specialization(guards={"isNull"})
        public RubyNilClass deleteNull(RubyHash hash2, Object key2) {
            hash2.checkFrozen(this);
            return this.getContext().getCoreLibrary().getNilObject();
        }

        @Specialization(guards={"!isNull", "!isBuckets"})
        public Object deletePackedArray(VirtualFrame frame, RubyHash hash2, Object key2) {
            hash2.checkFrozen(this);
            Object[] store = (Object[])hash2.getStore();
            int size2 = hash2.getSize();
            for (int n = 0; n < HashOperations.SMALL_HASH_SIZE * 2; n += 2) {
                if (n >= size2 || !this.eqlNode.callBoolean(frame, store[n], "eql?", null, key2)) continue;
                Object value2 = store[n + 1];
                System.arraycopy(store, n + 2, store, n, HashOperations.SMALL_HASH_SIZE * 2 - n - 2);
                hash2.setSize(size2 - 1);
                return value2;
            }
            return this.getContext().getCoreLibrary().getNilObject();
        }

        @Specialization(guards={"isBuckets"})
        public Object delete(VirtualFrame frame, RubyHash hash2, Object key2) {
            DeleteNode.notDesignedForCompilation();
            HashSearchResult hashSearchResult = this.findEntryNode.search(frame, hash2, key2);
            if (hashSearchResult.getEntry() == null) {
                return this.getContext().getCoreLibrary().getNilObject();
            }
            Entry entry = hashSearchResult.getEntry();
            if (entry.getPreviousInSequence() == null) {
                hash2.setFirstInSequence(entry.getNextInSequence());
            } else {
                entry.getPreviousInSequence().setNextInSequence(entry.getNextInSequence());
            }
            if (entry.getNextInSequence() == null) {
                hash2.setLastInSequence(entry.getPreviousInSequence());
            } else {
                entry.getNextInSequence().setPreviousInSequence(entry.getPreviousInSequence());
            }
            if (hashSearchResult.getPreviousEntry() == null) {
                ((Entry[])hash2.getStore())[hashSearchResult.getIndex()] = entry.getNextInLookup();
            } else {
                hashSearchResult.getPreviousEntry().setNextInLookup(entry.getNextInLookup());
            }
            hash2.setSize(hash2.getSize() - 1);
            return entry.getValue();
        }
    }

    @CoreMethod(names={"clear"})
    public static abstract class ClearNode
    extends HashCoreMethodNode {
        public ClearNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ClearNode(ClearNode prev) {
            super(prev);
        }

        @Specialization(guards={"isNull"})
        public RubyHash emptyNull(RubyHash hash2) {
            return hash2;
        }

        @Specialization(guards={"!isNull"})
        public RubyHash empty(RubyHash hash2) {
            hash2.setStore(null, 0, null, null);
            return hash2;
        }
    }

    @CoreMethod(names={"[]="}, required=2)
    public static abstract class SetIndexNode
    extends HashCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode eqlNode;
        private final BranchProfile considerExtendProfile = BranchProfile.create();
        private final BranchProfile extendProfile = BranchProfile.create();

        public SetIndexNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.eqlNode = DispatchHeadNodeFactory.createMethodCall(context, false, false, null);
        }

        public SetIndexNode(SetIndexNode prev) {
            super(prev);
            this.eqlNode = prev.eqlNode;
        }

        @Specialization(guards={"isNull"})
        public Object setNull(RubyHash hash2, Object key2, Object value2) {
            hash2.checkFrozen(this);
            Object[] store = new Object[HashOperations.SMALL_HASH_SIZE * 2];
            store[0] = key2;
            store[1] = value2;
            hash2.setStore(store, 1, null, null);
            return value2;
        }

        @ExplodeLoop
        @Specialization(guards={"!isNull", "!isBuckets"})
        public Object setPackedArray(VirtualFrame frame, RubyHash hash2, Object key2, Object value2) {
            hash2.checkFrozen(this);
            Object[] store = (Object[])hash2.getStore();
            int size2 = hash2.getSize();
            for (int n = 0; n < HashOperations.SMALL_HASH_SIZE; ++n) {
                if (n >= size2 || !this.eqlNode.callBoolean(frame, store[n * 2], "eql?", null, key2)) continue;
                store[n * 2 + 1] = value2;
                return value2;
            }
            this.considerExtendProfile.enter();
            int newSize = size2 + 1;
            if (newSize <= HashOperations.SMALL_HASH_SIZE) {
                this.extendProfile.enter();
                store[size2 * 2] = key2;
                store[size2 * 2 + 1] = value2;
                hash2.setSize(newSize);
                return value2;
            }
            CompilerDirectives.transferToInterpreter();
            List<KeyValue> entries2 = HashOperations.verySlowToKeyValues(hash2);
            hash2.setStore(new Entry[HashOperations.capacityGreaterThan(newSize)], newSize, null, null);
            for (KeyValue keyValue : entries2) {
                HashOperations.verySlowSetInBuckets(hash2, keyValue.getKey(), keyValue.getValue());
            }
            HashOperations.verySlowSetInBuckets(hash2, key2, value2);
            return value2;
        }

        @Specialization(guards={"isBuckets"})
        public Object setBuckets(RubyHash hash2, Object key2, Object value2) {
            SetIndexNode.notDesignedForCompilation();
            if (HashOperations.verySlowSetInBuckets(hash2, key2, value2)) {
                hash2.setSize(hash2.getSize() + 1);
            }
            return value2;
        }
    }

    @CoreMethod(names={"[]"}, required=1)
    public static abstract class GetIndexNode
    extends HashCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode eqlNode;
        @Node.Child
        private YieldDispatchHeadNode yield;
        @Node.Child
        private FindEntryNode findEntryNode;
        private final BranchProfile notInHashProfile = BranchProfile.create();
        private final BranchProfile useDefaultProfile = BranchProfile.create();

        public GetIndexNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.eqlNode = DispatchHeadNodeFactory.createMethodCall(context, false, false, null);
            this.yield = new YieldDispatchHeadNode(context);
            this.findEntryNode = new FindEntryNode(context, sourceSection);
        }

        public GetIndexNode(GetIndexNode prev) {
            super(prev);
            this.eqlNode = prev.eqlNode;
            this.yield = prev.yield;
            this.findEntryNode = prev.findEntryNode;
        }

        @Specialization(guards={"isNull"})
        public Object getNull(VirtualFrame frame, RubyHash hash2, Object key2) {
            GetIndexNode.notDesignedForCompilation();
            if (hash2.getDefaultBlock() != null) {
                return this.yield.dispatch(frame, hash2.getDefaultBlock(), hash2, key2);
            }
            if (hash2.getDefaultValue() != null) {
                return hash2.getDefaultValue();
            }
            return this.getContext().getCoreLibrary().getNilObject();
        }

        @ExplodeLoop
        @Specialization(guards={"!isNull", "!isBuckets"})
        public Object getPackedArray(VirtualFrame frame, RubyHash hash2, Object key2) {
            Object[] store = (Object[])hash2.getStore();
            int size2 = hash2.getSize();
            for (int n = 0; n < HashOperations.SMALL_HASH_SIZE; ++n) {
                if (n >= size2 || !this.eqlNode.callBoolean(frame, store[n * 2], "eql?", null, key2)) continue;
                return store[n * 2 + 1];
            }
            this.notInHashProfile.enter();
            if (hash2.getDefaultBlock() != null) {
                this.useDefaultProfile.enter();
                return this.yield.dispatch(frame, hash2.getDefaultBlock(), hash2, key2);
            }
            if (hash2.getDefaultValue() != null) {
                return hash2.getDefaultValue();
            }
            return this.getContext().getCoreLibrary().getNilObject();
        }

        @Specialization(guards={"isBuckets"})
        public Object getBuckets(VirtualFrame frame, RubyHash hash2, Object key2) {
            GetIndexNode.notDesignedForCompilation();
            HashSearchResult hashSearchResult = this.findEntryNode.search(frame, hash2, key2);
            if (hashSearchResult.getEntry() != null) {
                return hashSearchResult.getEntry().getValue();
            }
            this.notInHashProfile.enter();
            if (hash2.getDefaultBlock() != null) {
                this.useDefaultProfile.enter();
                return this.yield.dispatch(frame, hash2.getDefaultBlock(), hash2, key2);
            }
            if (hash2.getDefaultValue() != null) {
                return hash2.getDefaultValue();
            }
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"[]"}, onSingleton=true, argumentsAsArray=true)
    public static abstract class ConstructNode
    extends HashCoreMethodNode {
        private final BranchProfile singleObject = BranchProfile.create();
        private final BranchProfile singleArray = BranchProfile.create();
        private final BranchProfile objectArray = BranchProfile.create();
        private final BranchProfile smallPackedArray = BranchProfile.create();
        private final BranchProfile largePackedArray = BranchProfile.create();
        private final BranchProfile otherArray = BranchProfile.create();
        private final BranchProfile singleOther = BranchProfile.create();
        private final BranchProfile keyValues = BranchProfile.create();

        public ConstructNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ConstructNode(ConstructNode prev) {
            super(prev);
        }

        @ExplodeLoop
        @Specialization
        public RubyHash construct(Object[] args2) {
            if (args2.length == 1) {
                this.singleObject.enter();
                Object arg2 = args2[0];
                if (arg2 instanceof RubyArray) {
                    this.singleArray.enter();
                    RubyArray array = (RubyArray)arg2;
                    if (array.getStore() instanceof Object[]) {
                        this.objectArray.enter();
                        Object[] store = (Object[])array.getStore();
                        if (store.length <= HashOperations.SMALL_HASH_SIZE) {
                            this.smallPackedArray.enter();
                            int size2 = array.getSize();
                            Object[] newStore = new Object[HashOperations.SMALL_HASH_SIZE * 2];
                            for (int n = 0; n < HashOperations.SMALL_HASH_SIZE; ++n) {
                                if (n >= size2) continue;
                                Object pair = store[n];
                                if (!(pair instanceof RubyArray)) {
                                    CompilerDirectives.transferToInterpreter();
                                    throw new UnsupportedOperationException();
                                }
                                RubyArray pairArray = (RubyArray)pair;
                                if (!(pairArray.getStore() instanceof Object[])) {
                                    CompilerDirectives.transferToInterpreter();
                                    throw new UnsupportedOperationException();
                                }
                                Object[] pairStore = (Object[])pairArray.getStore();
                                newStore[n * 2] = pairStore[0];
                                newStore[n * 2 + 1] = pairStore[1];
                            }
                            return new RubyHash(this.getContext().getCoreLibrary().getHashClass(), null, null, newStore, size2, null);
                        }
                        this.largePackedArray.enter();
                        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
                        int size3 = array.getSize();
                        for (int n = 0; n < size3; ++n) {
                            Object pair = store[n];
                            if (!(pair instanceof RubyArray)) {
                                CompilerDirectives.transferToInterpreter();
                                throw new UnsupportedOperationException();
                            }
                            RubyArray pairArray = (RubyArray)pair;
                            if (!(pairArray.getStore() instanceof Object[])) {
                                CompilerDirectives.transferToInterpreter();
                                throw new UnsupportedOperationException();
                            }
                            Object[] pairStore = (Object[])pairArray.getStore();
                            keyValues.add(new KeyValue(pairStore[0], pairStore[1]));
                        }
                        return HashOperations.verySlowFromEntries(this.getContext(), keyValues);
                    }
                    this.otherArray.enter();
                    throw new UnsupportedOperationException("other array");
                }
                this.singleOther.enter();
                throw new UnsupportedOperationException("single other");
            }
            this.keyValues.enter();
            ArrayList<KeyValue> entries2 = new ArrayList<KeyValue>();
            for (int n = 0; n < args2.length; n += 2) {
                entries2.add(new KeyValue(args2[n], args2[n + 1]));
            }
            return HashOperations.verySlowFromEntries(this.getContext(), entries2);
        }
    }

    @CoreMethod(names={"=="}, required=1)
    public static abstract class EqualNode
    extends HashCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode equalNode;

        public EqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.equalNode = DispatchHeadNodeFactory.createMethodCall(context, false, false, null);
        }

        public EqualNode(EqualNode prev) {
            super(prev);
            this.equalNode = prev.equalNode;
        }

        @Specialization(guards={"isNull", "isNull(arguments[1])"})
        public boolean equalNull(RubyHash a, RubyHash b2) {
            return true;
        }

        @Specialization
        public boolean equal(RubyHash a, RubyHash b2) {
            EqualNode.notDesignedForCompilation();
            List<KeyValue> aEntries = HashOperations.verySlowToKeyValues(a);
            List<KeyValue> bEntries = HashOperations.verySlowToKeyValues(a);
            if (aEntries.size() != bEntries.size()) {
                return false;
            }
            boolean[] bUsed = new boolean[bEntries.size()];
            for (KeyValue aKeyValue : aEntries) {
                boolean found = false;
                for (int n = 0; n < bEntries.size(); ++n) {
                    if (bUsed[n] || !((Boolean)DebugOperations.send(this.getContext(), aKeyValue.getKey(), "eql?", null, bEntries.get(n).getKey())).booleanValue()) continue;
                    bUsed[n] = true;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }

        @Specialization(guards={"!isRubyHash(arguments[1])"})
        public boolean equalNonHash(RubyHash a, Object b2) {
            return false;
        }
    }
}

