/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.EncodingConverterNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyEncodingConverter;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyString;

@GeneratedBy(value=EncodingConverterNodes.class)
public final class EncodingConverterNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(ConvPathNodeFactory.getInstance(), InitializeNodeFactory.getInstance(), SearchConvPathNodeFactory.getInstance());
    }

    @GeneratedBy(value=EncodingConverterNodes.SearchConvPathNode.class)
    public static final class SearchConvPathNodeFactory
    extends NodeFactoryBase<EncodingConverterNodes.SearchConvPathNode> {
        private static SearchConvPathNodeFactory searchConvPathNodeFactoryInstance;

        private SearchConvPathNodeFactory() {
            super(EncodingConverterNodes.SearchConvPathNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public EncodingConverterNodes.SearchConvPathNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SearchConvPathNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static EncodingConverterNodes.SearchConvPathNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SearchConvPathUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<EncodingConverterNodes.SearchConvPathNode> getInstance() {
            if (searchConvPathNodeFactoryInstance == null) {
                searchConvPathNodeFactoryInstance = new SearchConvPathNodeFactory();
            }
            return searchConvPathNodeFactoryInstance;
        }

        @GeneratedBy(value=EncodingConverterNodes.SearchConvPathNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SearchConvPathPolymorphicNode
        extends SearchConvPathBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            SearchConvPathPolymorphicNode(SearchConvPathBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=EncodingConverterNodes.SearchConvPathNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SearchConvPathRubyStringNode
        extends SearchConvPathBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SearchConvPathRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class}, 0, 0);

            SearchConvPathRubyStringNode(SearchConvPathBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.searchConvpath(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.searchConvpath(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static EncodingConverterNodes.SearchConvPathNode create0(EncodingConverterNodes.SearchConvPathNode current2) {
                return new SearchConvPathRubyStringNode((SearchConvPathBaseNode)current2);
            }
        }

        @GeneratedBy(value=EncodingConverterNodes.SearchConvPathNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SearchConvPathUninitializedNode
        extends SearchConvPathBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SearchConvPathUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SearchConvPathUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SearchConvPathUninitializedNode(SearchConvPathBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                SearchConvPathBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SearchConvPathBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static EncodingConverterNodes.SearchConvPathNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SearchConvPathUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=EncodingConverterNodes.SearchConvPathNode.class)
        private static abstract class SearchConvPathBaseNode
        extends EncodingConverterNodes.SearchConvPathNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SearchConvPathBaseNode next0;

            SearchConvPathBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SearchConvPathBaseNode(SearchConvPathBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                SearchConvPathBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SearchConvPathBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new SearchConvPathUninitializedNode(this);
                    ((SearchConvPathUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = SearchConvPathBaseNode.createInfo0(reason2, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new SearchConvPathUninitializedNode(this), new SearchConvPathPolymorphicNode(this), (SearchConvPathBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SearchConvPathBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    return (SearchConvPathBaseNode)SearchConvPathRubyStringNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    SearchConvPathBaseNode otherCast = (SearchConvPathBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (SearchConvPathBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=EncodingConverterNodes.InitializeNode.class)
    public static final class InitializeNodeFactory
    extends NodeFactoryBase<EncodingConverterNodes.InitializeNode> {
        private static InitializeNodeFactory initializeNodeFactoryInstance;

        private InitializeNodeFactory() {
            super(EncodingConverterNodes.InitializeNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public EncodingConverterNodes.InitializeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InitializeNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static EncodingConverterNodes.InitializeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InitializeUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<EncodingConverterNodes.InitializeNode> getInstance() {
            if (initializeNodeFactoryInstance == null) {
                initializeNodeFactoryInstance = new InitializeNodeFactory();
            }
            return initializeNodeFactoryInstance;
        }

        @GeneratedBy(value=EncodingConverterNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InitializePolymorphicNode
        extends InitializeBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            InitializePolymorphicNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=EncodingConverterNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyEncodingConverterRubyStringNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyEncodingConverterRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyEncodingConverter.class, RubyString.class, RubyString.class}, 0, 0);

            InitializeRubyEncodingConverterRubyStringNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments2Value;
                RubyString arguments1Value;
                RubyEncodingConverter arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyEncodingConverter(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyEncodingConverter");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof RubyString");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyString");
                }
                return super.initialize(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyEncodingConverter(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments2Value)) {
                    RubyEncodingConverter arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyEncodingConverter(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    RubyString arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments2Value);
                    return super.initialize(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static EncodingConverterNodes.InitializeNode create0(EncodingConverterNodes.InitializeNode current2) {
                return new InitializeRubyEncodingConverterRubyStringNode((InitializeBaseNode)current2);
            }
        }

        @GeneratedBy(value=EncodingConverterNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InitializeUninitializedNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InitializeUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InitializeUninitializedNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected RubyNilClass executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                InitializeBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InitializeBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static EncodingConverterNodes.InitializeNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InitializeUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=EncodingConverterNodes.InitializeNode.class)
        private static abstract class InitializeBaseNode
        extends EncodingConverterNodes.InitializeNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InitializeBaseNode next0;

            InitializeBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InitializeBaseNode(InitializeBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyNilClass executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final RubyNilClass rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason2) {
                String message2;
                InitializeBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InitializeBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new InitializeUninitializedNode(this);
                    ((InitializeUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = InitializeBaseNode.createInfo0(reason2, arguments0Value, arguments1Value, arguments2Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new InitializeUninitializedNode(this), new InitializePolymorphicNode(this), (InitializeBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InitializeBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyEncodingConverter(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments2Value)) {
                    return (InitializeBaseNode)InitializeRubyEncodingConverterRubyStringNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    InitializeBaseNode otherCast = (InitializeBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (InitializeBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=EncodingConverterNodes.ConvPathNode.class)
    public static final class ConvPathNodeFactory
    extends NodeFactoryBase<EncodingConverterNodes.ConvPathNode> {
        private static ConvPathNodeFactory convPathNodeFactoryInstance;

        private ConvPathNodeFactory() {
            super(EncodingConverterNodes.ConvPathNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public EncodingConverterNodes.ConvPathNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ConvPathNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static EncodingConverterNodes.ConvPathNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ConvPathUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<EncodingConverterNodes.ConvPathNode> getInstance() {
            if (convPathNodeFactoryInstance == null) {
                convPathNodeFactoryInstance = new ConvPathNodeFactory();
            }
            return convPathNodeFactoryInstance;
        }

        @GeneratedBy(value=EncodingConverterNodes.ConvPathNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ConvPathPolymorphicNode
        extends ConvPathBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ConvPathPolymorphicNode(ConvPathBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=EncodingConverterNodes.ConvPathNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ConvPathRubyEncodingConverterNode
        extends ConvPathBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConvPathRubyEncodingConverterNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyEncodingConverter.class}, 0, 0);

            ConvPathRubyEncodingConverterNode(ConvPathBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyEncodingConverter arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyEncodingConverter(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyEncodingConverter");
                }
                return super.convpath(arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyEncodingConverter(arguments0Value)) {
                    RubyEncodingConverter arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyEncodingConverter(arguments0Value);
                    return super.convpath(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static EncodingConverterNodes.ConvPathNode create0(EncodingConverterNodes.ConvPathNode current2) {
                return new ConvPathRubyEncodingConverterNode((ConvPathBaseNode)current2);
            }
        }

        @GeneratedBy(value=EncodingConverterNodes.ConvPathNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ConvPathUninitializedNode
        extends ConvPathBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConvPathUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ConvPathUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ConvPathUninitializedNode(ConvPathBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ConvPathBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ConvPathBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0]}, arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value);
            }

            static EncodingConverterNodes.ConvPathNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ConvPathUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=EncodingConverterNodes.ConvPathNode.class)
        private static abstract class ConvPathBaseNode
        extends EncodingConverterNodes.ConvPathNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ConvPathBaseNode next0;

            ConvPathBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ConvPathBaseNode(ConvPathBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ConvPathBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ConvPathBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ConvPathUninitializedNode(this);
                    ((ConvPathUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = ConvPathBaseNode.createInfo0(reason2, arguments0Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new ConvPathUninitializedNode(this), new ConvPathPolymorphicNode(this), (ConvPathBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ConvPathBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyEncodingConverter(arguments0Value)) {
                    return (ConvPathBaseNode)ConvPathRubyEncodingConverterNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ConvPathBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ConvPathBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }
}

