/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;

public class ArrayPushNode
extends RubyNode {
    @Node.Child
    private RubyNode array;
    @Node.Child
    private RubyNode pushed;

    public ArrayPushNode(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode pushed) {
        super(context, sourceSection);
        this.array = array;
        this.pushed = pushed;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        ArrayPushNode.notDesignedForCompilation();
        Object arrayObject = this.array.execute(frame);
        assert (arrayObject instanceof RubyArray) : this.getSourceSection();
        RubyArray originalArray = (RubyArray)arrayObject;
        RubyArray newArray = new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), originalArray.slowToArray(), originalArray.getSize());
        newArray.slowPush(this.pushed.execute(frame));
        return newArray;
    }
}

